/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.scale;

import it.geosolutions.jaiext.interpolators.InterpolationBicubic;
import it.geosolutions.jaiext.interpolators.InterpolationBilinear;
import it.geosolutions.jaiext.interpolators.InterpolationNearest;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.scale.ScaleDescriptor;
import it.geosolutions.jaiext.testclasses.TestBase;
import java.awt.RenderingHints;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.IOException;
import javax.media.jai.BorderExtender;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import org.geotools.renderedimage.viewer.RenderedImageBrowser;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestScale
extends TestBase {
    protected void testGlobal(boolean useROIAccessor, boolean isBinary, boolean bicubic2Disabled, boolean noDataRangeUsed, boolean roiPresent, TestBase.InterpolationType interpType, TestBase.TestSelection testSelect, TestBase.ScaleType scaleValue) {
        Byte sourceNoDataByte = 100;
        Short sourceNoDataUshort = (short)(Short.MAX_VALUE - 1);
        Short sourceNoDataShort = -255;
        Integer sourceNoDataInt = 0x7FFFFFFE;
        Float sourceNoDataFloat = Float.valueOf(-15.2f);
        Double sourceNoDataDouble = Double.NEGATIVE_INFINITY;
        if (isBinary) {
            sourceNoDataByte = 1;
            sourceNoDataUshort = 1;
            sourceNoDataInt = 1;
        }
        int dataType = 0;
        this.testImage(dataType, sourceNoDataByte, useROIAccessor, isBinary, bicubic2Disabled, noDataRangeUsed, roiPresent, interpType, testSelect, scaleValue);
        dataType = 1;
        this.testImage(dataType, sourceNoDataUshort, useROIAccessor, isBinary, bicubic2Disabled, noDataRangeUsed, roiPresent, interpType, testSelect, scaleValue);
        dataType = 3;
        this.testImage(dataType, sourceNoDataInt, useROIAccessor, isBinary, bicubic2Disabled, noDataRangeUsed, roiPresent, interpType, testSelect, scaleValue);
        if (!isBinary) {
            dataType = 2;
            this.testImage(dataType, sourceNoDataShort, useROIAccessor, isBinary, bicubic2Disabled, noDataRangeUsed, roiPresent, interpType, testSelect, scaleValue);
            dataType = 4;
            this.testImage(dataType, sourceNoDataFloat, useROIAccessor, isBinary, bicubic2Disabled, noDataRangeUsed, roiPresent, interpType, testSelect, scaleValue);
            dataType = 5;
            this.testImage(dataType, sourceNoDataDouble, useROIAccessor, isBinary, bicubic2Disabled, noDataRangeUsed, roiPresent, interpType, testSelect, scaleValue);
        }
    }

    protected <T extends Number> void testImage(int dataType, T noDataValue, boolean useROIAccessor, boolean isBinary, boolean bicubic2Disabled, boolean noDataRangeUsed, boolean roiPresent, TestBase.InterpolationType interpType, TestBase.TestSelection testSelect, TestBase.ScaleType scaleValue) {
        if (scaleValue == TestBase.ScaleType.REDUCTION) {
            this.scaleX = 0.5f;
            this.scaleY = 0.5f;
        } else {
            this.scaleX = 1.5f;
            this.scaleY = 1.5f;
        }
        Range noDataRange = null;
        RenderedImage sourceImage = null;
        this.destinationNoData = isBinary ? 0.0 : 255.0;
        sourceImage = TestScale.createTestImage((int)dataType, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, noDataValue, (boolean)isBinary);
        if (noDataRangeUsed && !isBinary) {
            switch (dataType) {
                case 0: {
                    noDataRange = RangeFactory.create((byte)noDataValue.byteValue(), (boolean)true, (byte)noDataValue.byteValue(), (boolean)true);
                    break;
                }
                case 1: {
                    noDataRange = RangeFactory.create((short)noDataValue.shortValue(), (boolean)true, (short)noDataValue.shortValue(), (boolean)true);
                    break;
                }
                case 2: {
                    noDataRange = RangeFactory.create((short)noDataValue.shortValue(), (boolean)true, (short)noDataValue.shortValue(), (boolean)true);
                    break;
                }
                case 3: {
                    noDataRange = RangeFactory.create((int)noDataValue.intValue(), (boolean)true, (int)noDataValue.intValue(), (boolean)true);
                    break;
                }
                case 4: {
                    noDataRange = RangeFactory.create((float)noDataValue.floatValue(), (boolean)true, (float)noDataValue.floatValue(), (boolean)true, (boolean)true);
                    break;
                }
                case 5: {
                    noDataRange = RangeFactory.create((double)noDataValue.doubleValue(), (boolean)true, (double)noDataValue.doubleValue(), (boolean)true, (boolean)true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong data type");
                }
            }
        }
        ROIShape roi = null;
        if (roiPresent) {
            roi = this.roiCreation();
        }
        RenderingHints hints = null;
        if (useROIAccessor) {
            hints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)0));
        }
        InterpolationNearest interp = null;
        switch (interpType) {
            case NEAREST_INTERP: {
                interp = new InterpolationNearest(noDataRange, useROIAccessor, this.destinationNoData, dataType);
                break;
            }
            case BILINEAR_INTERP: {
                interp = new InterpolationBilinear(8, noDataRange, useROIAccessor, this.destinationNoData, dataType);
                if (hints != null) {
                    hints.add(new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1)));
                    break;
                }
                hints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
                break;
            }
            case BICUBIC_INTERP: {
                interp = new InterpolationBicubic(8, noDataRange, useROIAccessor, this.destinationNoData, dataType, bicubic2Disabled, 8);
                if (hints != null) {
                    hints.add(new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1)));
                    break;
                }
                hints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
                break;
            }
        }
        RenderedOp destinationIMG = ScaleDescriptor.create((RenderedImage)sourceImage, (Float)Float.valueOf(this.scaleX), (Float)Float.valueOf(this.scaleY), (Float)Float.valueOf(this.transX), (Float)Float.valueOf(this.transY), (Interpolation)interp, (ROI)roi, (Boolean)useROIAccessor, (RenderingHints)hints);
        if (INTERACTIVE && dataType == 0 && TEST_SELECTOR.intValue() == testSelect.getType() && INVERSE_SCALE.intValue() == scaleValue.getType()) {
            RenderedImageBrowser.showChain((RenderedImage)destinationIMG, (boolean)false, (boolean)roiPresent);
            try {
                System.in.read();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            ((PlanarImage)destinationIMG).getTiles();
        }
        Raster simpleTile = destinationIMG.getTile(destinationIMG.getMinTileX(), destinationIMG.getMinTileY());
        int tileWidth = simpleTile.getWidth();
        int tileHeight = simpleTile.getHeight();
        switch (dataType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                int j;
                if (isBinary) break;
                int minValue = Integer.MAX_VALUE;
                int maxValue = Integer.MIN_VALUE;
                for (int i = 0; i < tileHeight; ++i) {
                    for (j = 0; j < tileWidth; ++j) {
                        int value = simpleTile.getSample(j, i, 0);
                        if (value > maxValue) {
                            maxValue = value;
                        }
                        if (value >= minValue) continue;
                        minValue = value;
                    }
                }
                Assert.assertFalse((minValue == maxValue ? 1 : 0) != 0);
                Assert.assertFalse((minValue == Integer.MAX_VALUE ? 1 : 0) != 0);
                Assert.assertFalse((maxValue == Integer.MIN_VALUE ? 1 : 0) != 0);
                break;
            }
            case 4: {
                int j;
                float minValuef = Float.MAX_VALUE;
                float maxValuef = -3.4028235E38f;
                for (int i = 0; i < tileHeight; ++i) {
                    for (j = 0; j < tileWidth; ++j) {
                        float valuef = simpleTile.getSample(j, i, 0);
                        if (Float.isNaN(valuef) || valuef == Float.POSITIVE_INFINITY || valuef == Float.POSITIVE_INFINITY) {
                            valuef = 255.0f;
                        }
                        if (valuef > maxValuef) {
                            maxValuef = valuef;
                        }
                        if (!(valuef < minValuef)) continue;
                        minValuef = valuef;
                    }
                }
                Assert.assertFalse(((int)minValuef == (int)maxValuef ? 1 : 0) != 0);
                Assert.assertFalse((minValuef == Float.MAX_VALUE ? 1 : 0) != 0);
                Assert.assertFalse((maxValuef == -3.4028235E38f ? 1 : 0) != 0);
                break;
            }
            case 5: {
                double minValued = Double.MAX_VALUE;
                double maxValued = -1.7976931348623157E308;
                for (int i = 0; i < tileHeight; ++i) {
                    for (int j = 0; j < tileWidth; ++j) {
                        double valued = simpleTile.getSampleDouble(j, i, 0);
                        if (Double.isNaN(valued) || valued == Double.POSITIVE_INFINITY || valued == Double.POSITIVE_INFINITY) {
                            valued = 255.0;
                        }
                        if (valued > maxValued) {
                            maxValued = valued;
                        }
                        if (!(valued < minValued)) continue;
                        minValued = valued;
                    }
                }
                Assert.assertFalse(((int)minValued == (int)maxValued ? 1 : 0) != 0);
                Assert.assertFalse((minValued == Double.MAX_VALUE ? 1 : 0) != 0);
                Assert.assertFalse((maxValued == -1.7976931348623157E308 ? 1 : 0) != 0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong data type");
            }
        }
        PlanarImage planarIMG = (PlanarImage)destinationIMG;
        int imgWidthROI = destinationIMG.getWidth() * 3 / 4 - 1;
        int imgHeightROI = destinationIMG.getHeight() * 3 / 4 - 1;
        int tileInROIx = planarIMG.XToTileX(imgWidthROI);
        int tileInROIy = planarIMG.YToTileY(imgHeightROI);
        Raster testTile = destinationIMG.getTile(tileInROIx, tileInROIy);
        switch (dataType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                if (isBinary) break;
                int value = testTile.getSample(testTile.getMinX() + 2, testTile.getMinY() + 1, 0);
                Assert.assertFalse((value == (int)this.destinationNoData ? 1 : 0) != 0);
                break;
            }
            case 4: {
                float valuef = testTile.getSampleFloat(testTile.getMinX() + 2, testTile.getMinY() + 1, 0);
                Assert.assertFalse(((int)valuef == (int)this.destinationNoData ? 1 : 0) != 0);
                break;
            }
            case 5: {
                double valued = testTile.getSampleDouble(testTile.getMinX() + 2, testTile.getMinY() + 1, 0);
                Assert.assertFalse((valued == this.destinationNoData ? 1 : 0) != 0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong data type");
            }
        }
        Assert.assertEquals((long)((int)((float)DEFAULT_WIDTH * this.scaleX)), (long)destinationIMG.getWidth());
        Assert.assertEquals((long)((int)((float)DEFAULT_HEIGHT * this.scaleY)), (long)destinationIMG.getHeight());
        if (destinationIMG instanceof RenderedOp) {
            destinationIMG.dispose();
        }
    }
}

