/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.scale;

import it.geosolutions.jaiext.scale.JaiI18N;
import it.geosolutions.jaiext.scale.ScalePropertyGenerator;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import java.util.logging.Logger;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PropertyGenerator;
import javax.media.jai.ROI;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;

public class ScaleDescriptor
extends OperationDescriptorImpl {
    private static final Logger LOGGER = Logger.getLogger(ScaleDescriptor.class.toString());
    private static final String[][] resources = new String[][]{{"GlobalName", "ScaleNoData"}, {"LocalName", "ScaleNoData"}, {"Vendor", "it.geosolutions.jaiext.roiaware"}, {"Description", JaiI18N.getString("ScaleDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/ScaleDescriptor.html"}, {"Version", JaiI18N.getString("DescriptorVersion")}, {"arg0Desc", JaiI18N.getString("ScaleDescriptor1")}, {"arg1Desc", JaiI18N.getString("ScaleDescriptor2")}, {"arg2Desc", JaiI18N.getString("ScaleDescriptor3")}, {"arg3Desc", JaiI18N.getString("ScaleDescriptor4")}, {"arg4Desc", JaiI18N.getString("ScaleDescriptor5")}, {"arg5Desc", JaiI18N.getString("ScaleDescriptor6")}, {"arg6Desc", JaiI18N.getString("ScaleDescriptor7")}};
    private static final Class[] paramClasses = new Class[]{Float.class, Float.class, Float.class, Float.class, Interpolation.class, ROI.class, Boolean.class};
    private static final String[] paramNames = new String[]{"xScale", "yScale", "xTrans", "yTrans", "interpolation", "ROI", "useRoiAccessor"};
    private static final Object[] paramDefaults = new Object[]{new Float(1.0f), new Float(1.0f), new Float(0.0f), new Float(0.0f), null, null, false};

    public ScaleDescriptor() {
        super(resources, 1, paramClasses, paramNames, paramDefaults);
    }

    public boolean isRenderableSupported() {
        return false;
    }

    public PropertyGenerator[] getPropertyGenerators() {
        PropertyGenerator[] pg = new PropertyGenerator[]{new ScalePropertyGenerator()};
        return pg;
    }

    protected boolean validateParameters(ParameterBlock args, StringBuffer msg) {
        if (!super.validateParameters(args, msg)) {
            return false;
        }
        float xScale = args.getFloatParameter(0);
        float yScale = args.getFloatParameter(1);
        if (xScale <= 0.0f || yScale <= 0.0f) {
            msg.append(this.getName() + " " + JaiI18N.getString("ScaleDescriptor6"));
            return false;
        }
        return true;
    }

    public Number getParamMinValue(int index) {
        if (index == 0 || index == 1) {
            return new Float(0.0f);
        }
        if (index == 2 || index == 3) {
            return new Float(-3.4028235E38f);
        }
        if (index == 4 || index == 5 || index == 6) {
            return null;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public static RenderedOp create(RenderedImage source0, Float xScale, Float yScale, Float xTrans, Float yTrans, Interpolation interpolation, ROI roi, Boolean useRoiAccessor, RenderingHints hints) {
        ParameterBlockJAI pb = new ParameterBlockJAI("ScaleNoData", "rendered");
        pb.setSource("source0", (Object)source0);
        pb.setParameter("xScale", (Object)xScale);
        pb.setParameter("yScale", (Object)yScale);
        pb.setParameter("xTrans", (Object)xTrans);
        pb.setParameter("yTrans", (Object)yTrans);
        pb.setParameter("interpolation", (Object)interpolation);
        if (roi != null) {
            pb.setParameter("ROI", (Object)roi);
        }
        pb.setParameter("useRoiAccessor", (Object)useRoiAccessor);
        return JAI.create((String)"ScaleNoData", (ParameterBlock)pb, (RenderingHints)hints);
    }

    public static RenderableOp createRenderable(RenderableImage source0, Float xScale, Float yScale, Float xTrans, Float yTrans, Interpolation interpolation, ROI roi, RenderingHints hints) {
        ParameterBlockJAI pb = new ParameterBlockJAI("ScaleNoData", "renderable");
        pb.setSource("source0", (Object)source0);
        pb.setParameter("xScale", (Object)xScale);
        pb.setParameter("yScale", (Object)yScale);
        pb.setParameter("xTrans", (Object)xTrans);
        pb.setParameter("yTrans", (Object)yTrans);
        pb.setParameter("interpolation", (Object)interpolation);
        if (roi != null) {
            pb.setParameter("ROI", (Object)roi);
        }
        return JAI.createRenderable((String)"ScaleNoData", (ParameterBlock)pb, (RenderingHints)hints);
    }
}

