/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.scale;

import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.Rational;
import it.geosolutions.jaiext.interpolators.InterpolationBilinear;
import it.geosolutions.jaiext.interpolators.InterpolationNearest;
import it.geosolutions.jaiext.iterators.RandomIterFactory;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.scale.JaiI18N;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.GeometricOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.IntegerSequence;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.iterator.RandomIter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScaleOpImage
extends GeometricOpImage {
    protected float scaleX;
    protected float scaleY;
    protected float transX;
    protected float transY;
    protected Rational scaleXRational;
    protected Rational scaleYRational;
    protected long scaleXRationalNum;
    protected long scaleXRationalDenom;
    protected long scaleYRationalNum;
    protected long scaleYRationalDenom;
    protected Rational invScaleXRational;
    protected Rational invScaleYRational;
    protected long invScaleXRationalNum;
    protected long invScaleXRationalDenom;
    protected long invScaleYRationalNum;
    protected long invScaleYRationalDenom;
    protected Rational transXRational;
    protected Rational transYRational;
    protected long transXRationalNum;
    protected long transXRationalDenom;
    protected long transYRationalNum;
    protected long transYRationalDenom;
    protected static float rationalTolerance = 1.0E-6f;
    private int lpad;
    private int rpad;
    private int tpad;
    private int bpad;
    protected final ROI srcROI;
    protected final PlanarImage srcROIImage;
    protected final RandomIter roiIter;
    protected final boolean hasROI;
    protected final Rectangle roiBounds;
    protected boolean useRoiAccessor;
    protected long invScaleXInt;
    protected long invScaleXFrac;
    protected long invScaleYInt;
    protected long invScaleYFrac;
    protected Interpolation interpolator = null;
    protected boolean isBinary;
    protected int subsampleBits;
    protected int one;
    protected int interp_width;
    protected int interp_height;
    protected int interp_left;
    protected int interp_top;
    protected int shift;
    protected int shift2;
    protected int round2;
    protected int precisionBits;
    protected int round;
    protected int dataType;
    protected Range noData;
    protected boolean hasNoData = false;
    protected byte destinationNoDataByte = 0;
    protected short destinationNoDataUShort = 0;
    protected short destinationNoDataShort = 0;
    protected int destinationNoDataInt = 0;
    protected float destinationNoDataFloat = 0.0f;
    protected double destinationNoDataDouble = 0.0;
    protected boolean isNegativeInf = false;
    protected boolean isPositiveInf = false;
    protected boolean isRangeNaN = false;
    protected boolean isNearestNew = false;
    protected boolean isBilinearNew = false;
    protected boolean isBicubicNew = false;
    protected boolean caseA;
    protected boolean caseB;
    protected boolean caseC;
    static final BorderExtender roiExtender = BorderExtender.createInstance((int)0);

    private static ImageLayout layoutHelper(RenderedImage source, float scaleX, float scaleY, float transX, float transY, Interpolation interp, ImageLayout il) {
        Rational scaleXRational = Rational.approximate((float)scaleX, (float)rationalTolerance);
        Rational scaleYRational = Rational.approximate((float)scaleY, (float)rationalTolerance);
        long scaleXRationalNum = scaleXRational.num;
        long scaleXRationalDenom = scaleXRational.denom;
        long scaleYRationalNum = scaleYRational.num;
        long scaleYRationalDenom = scaleYRational.denom;
        Rational transXRational = Rational.approximate((float)transX, (float)rationalTolerance);
        Rational transYRational = Rational.approximate((float)transY, (float)rationalTolerance);
        long transXRationalNum = transXRational.num;
        long transXRationalDenom = transXRational.denom;
        long transYRationalNum = transYRational.num;
        long transYRationalDenom = transYRational.denom;
        ImageLayout layout = il == null ? new ImageLayout() : (ImageLayout)il.clone();
        int x0 = source.getMinX();
        int y0 = source.getMinY();
        int w = source.getWidth();
        int h = source.getHeight();
        long dx0Num = x0;
        long dx0Denom = 1L;
        long dy0Num = y0;
        long dy0Denom = 1L;
        long dx1Num = x0 + w;
        long dx1Denom = 1L;
        long dy1Num = y0 + h;
        long dy1Denom = 1L;
        dx0Num *= scaleXRationalNum;
        dx0Denom *= scaleXRationalDenom;
        dy0Num *= scaleYRationalNum;
        dy0Denom *= scaleYRationalDenom;
        dx1Num *= scaleXRationalNum;
        dx1Denom *= scaleXRationalDenom;
        dy1Num *= scaleYRationalNum;
        dy1Denom *= scaleYRationalDenom;
        dx0Num = 2L * dx0Num - dx0Denom;
        dx0Denom *= 2L;
        dy0Num = 2L * dy0Num - dy0Denom;
        dy0Denom *= 2L;
        dx1Num = 2L * dx1Num - 3L * dx1Denom;
        dy1Num = 2L * dy1Num - 3L * dy1Denom;
        dx0Num = dx0Num * transXRationalDenom + transXRationalNum * dx0Denom;
        dy0Num = dy0Num * transYRationalDenom + transYRationalNum * dy0Denom;
        dx1Num = dx1Num * transXRationalDenom + transXRationalNum * (dx1Denom *= 2L);
        dy1Num = dy1Num * transYRationalDenom + transYRationalNum * (dy1Denom *= 2L);
        int l_x0 = Rational.ceil((long)dx0Num, (long)(dx0Denom *= transXRationalDenom));
        int l_y0 = Rational.ceil((long)dy0Num, (long)(dy0Denom *= transYRationalDenom));
        int l_x1 = Rational.ceil((long)dx1Num, (long)(dx1Denom *= transXRationalDenom));
        int l_y1 = Rational.ceil((long)dy1Num, (long)(dy1Denom *= transYRationalDenom));
        layout.setMinX(l_x0);
        layout.setMinY(l_y0);
        int width = l_x1 - l_x0 + 1;
        int height = l_y1 - l_y0 + 1;
        if (width < 1) {
            width = 1;
        }
        if (height < 1) {
            height = 1;
        }
        layout.setWidth(width);
        layout.setHeight(height);
        return layout;
    }

    protected final void preComputePositionsInt(Rectangle destRect, int srcRectX, int srcRectY, int srcPixelStride, int srcScanlineStride, int[] xpos, int[] ypos, int[] xfracvalues, int[] yfracvalues, int roiScanlineStride, int[] yposRoi) {
        int i;
        int dwidth = destRect.width;
        int dheight = destRect.height;
        int dx = destRect.x;
        int dy = destRect.y;
        long syNum = dy;
        long syDenom = 1L;
        syNum = syNum * this.transYRationalDenom - this.transYRationalNum * syDenom;
        syNum = 2L * syNum + (syDenom *= this.transYRationalDenom);
        syDenom *= 2L;
        syNum *= this.invScaleYRationalNum;
        syDenom *= this.invScaleYRationalDenom;
        if (this.isBilinearNew || this.isBicubicNew) {
            syNum = 2L * syNum - syDenom;
            syDenom *= 2L;
        }
        int srcYInt = Rational.floor((long)syNum, (long)syDenom);
        long srcYFrac = syNum % syDenom;
        if (srcYInt < 0) {
            srcYFrac = syDenom + srcYFrac;
        }
        long commonYDenom = syDenom * this.invScaleYRationalDenom;
        srcYFrac *= this.invScaleYRationalDenom;
        long newInvScaleYFrac = this.invScaleYFrac * syDenom;
        long sxNum = dx;
        long sxDenom = 1L;
        sxNum = sxNum * this.transXRationalDenom - this.transXRationalNum * sxDenom;
        sxNum = 2L * sxNum + (sxDenom *= this.transXRationalDenom);
        sxDenom *= 2L;
        sxNum *= this.invScaleXRationalNum;
        sxDenom *= this.invScaleXRationalDenom;
        if (this.isBilinearNew || this.isBicubicNew) {
            sxNum = 2L * sxNum - sxDenom;
            sxDenom *= 2L;
        }
        int srcXInt = Rational.floor((long)sxNum, (long)sxDenom);
        long srcXFrac = sxNum % sxDenom;
        if (srcXInt < 0) {
            srcXFrac = sxDenom + srcXFrac;
        }
        long commonXDenom = sxDenom * this.invScaleXRationalDenom;
        srcXFrac *= this.invScaleXRationalDenom;
        long newInvScaleXFrac = this.invScaleXFrac * sxDenom;
        for (i = 0; i < dwidth; ++i) {
            xpos[i] = this.isBinary ? srcXInt : (srcXInt - srcRectX) * srcPixelStride;
            if (this.isBilinearNew || this.isBicubicNew) {
                xfracvalues[i] = (int)(1.0f * (float)srcXFrac / (float)commonXDenom * (float)this.one);
            }
            srcXInt = (int)((long)srcXInt + this.invScaleXInt);
            if ((srcXFrac += newInvScaleXFrac) < commonXDenom) continue;
            ++srcXInt;
            srcXFrac -= commonXDenom;
        }
        for (i = 0; i < dheight; ++i) {
            ypos[i] = this.isBinary ? srcYInt : (srcYInt - srcRectY) * srcScanlineStride;
            if (this.useRoiAccessor) {
                yposRoi[i] = this.isBinary ? srcYInt : (srcYInt - srcRectY) * roiScanlineStride;
            }
            if (this.isBilinearNew || this.isBicubicNew) {
                yfracvalues[i] = (int)(1.0f * (float)srcYFrac / (float)commonYDenom * (float)this.one);
            }
            srcYInt = (int)((long)srcYInt + this.invScaleYInt);
            if ((srcYFrac += newInvScaleYFrac) < commonYDenom) continue;
            ++srcYInt;
            srcYFrac -= commonYDenom;
        }
    }

    protected final void preComputePositionsFloat(Rectangle destRect, int srcRectX, int srcRectY, int srcPixelStride, int srcScanlineStride, int[] xpos, int[] ypos, float[] xfracvalues, float[] yfracvalues, int roiScanlineStride, int[] yposRoi) {
        int i;
        int dwidth = destRect.width;
        int dheight = destRect.height;
        int dx = destRect.x;
        int dy = destRect.y;
        long syNum = dy;
        long syDenom = 1L;
        syNum = syNum * this.transYRationalDenom - this.transYRationalNum * syDenom;
        syNum = 2L * syNum + (syDenom *= this.transYRationalDenom);
        syDenom *= 2L;
        syNum *= this.invScaleYRationalNum;
        syDenom *= this.invScaleYRationalDenom;
        if (this.isBilinearNew || this.isBicubicNew) {
            syNum = 2L * syNum - syDenom;
            syDenom *= 2L;
        }
        int srcYInt = Rational.floor((long)syNum, (long)syDenom);
        long srcYFrac = syNum % syDenom;
        if (srcYInt < 0) {
            srcYFrac = syDenom + srcYFrac;
        }
        long commonYDenom = syDenom * this.invScaleYRationalDenom;
        srcYFrac *= this.invScaleYRationalDenom;
        long newInvScaleYFrac = this.invScaleYFrac * syDenom;
        long sxNum = dx;
        long sxDenom = 1L;
        sxNum = sxNum * this.transXRationalDenom - this.transXRationalNum * sxDenom;
        sxNum = 2L * sxNum + (sxDenom *= this.transXRationalDenom);
        sxDenom *= 2L;
        sxNum *= this.invScaleXRationalNum;
        sxDenom *= this.invScaleXRationalDenom;
        if (this.isBilinearNew || this.isBicubicNew) {
            sxNum = 2L * sxNum - sxDenom;
            sxDenom *= 2L;
        }
        int srcXInt = Rational.floor((long)sxNum, (long)sxDenom);
        long srcXFrac = sxNum % sxDenom;
        if (srcXInt < 0) {
            srcXFrac = sxDenom + srcXFrac;
        }
        long commonXDenom = sxDenom * this.invScaleXRationalDenom;
        srcXFrac *= this.invScaleXRationalDenom;
        long newInvScaleXFrac = this.invScaleXFrac * sxDenom;
        for (i = 0; i < dwidth; ++i) {
            xpos[i] = (srcXInt - srcRectX) * srcPixelStride;
            if (this.isBilinearNew || this.isBicubicNew) {
                xfracvalues[i] = 1.0f * (float)srcXFrac / (float)commonXDenom;
            }
            srcXInt = (int)((long)srcXInt + this.invScaleXInt);
            if ((srcXFrac += newInvScaleXFrac) < commonXDenom) continue;
            ++srcXInt;
            srcXFrac -= commonXDenom;
        }
        for (i = 0; i < dheight; ++i) {
            ypos[i] = (srcYInt - srcRectY) * srcScanlineStride;
            if (this.useRoiAccessor) {
                yposRoi[i] = (srcYInt - srcRectY) * roiScanlineStride;
            }
            if (this.isBilinearNew || this.isBicubicNew) {
                yfracvalues[i] = 1.0f * (float)srcYFrac / (float)commonYDenom;
            }
            srcYInt = (int)((long)srcYInt + this.invScaleYInt);
            if ((srcYFrac += newInvScaleYFrac) < commonYDenom) continue;
            ++srcYInt;
            srcYFrac -= commonYDenom;
        }
    }

    private static Map<Object, Object> configHelper(RenderedImage source, Map<Object, Object> configuration, Interpolation interp) {
        RenderingHints config = configuration;
        if (ImageUtil.isBinary((SampleModel)source.getSampleModel()) && (interp == null || interp instanceof InterpolationNearest || interp instanceof InterpolationBilinear)) {
            if (configuration == null) {
                config = new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
            } else if (!config.containsKey(JAI.KEY_REPLACE_INDEX_COLOR_MODEL)) {
                RenderingHints hints = new RenderingHints(null);
                hints.putAll((Map<?, ?>)configuration);
                config = hints;
                config.put(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.TRUE);
            }
        }
        return config;
    }

    public ScaleOpImage(RenderedImage source, ImageLayout layout, Map configuration, boolean cobbleSources, BorderExtender extender, Interpolation interp, float scaleX, float scaleY, float transX, float transY, boolean useRoiAccessor) {
        super(ScaleOpImage.vectorize((RenderedImage)source), ScaleOpImage.layoutHelper(source, scaleX, scaleY, transX, transY, interp, layout), ScaleOpImage.configHelper(source, configuration, interp), cobbleSources, extender, interp, null);
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.transX = transX;
        this.transY = transY;
        this.scaleXRational = Rational.approximate((float)scaleX, (float)rationalTolerance);
        this.scaleYRational = Rational.approximate((float)scaleY, (float)rationalTolerance);
        this.scaleXRationalNum = this.scaleXRational.num;
        this.scaleXRationalDenom = this.scaleXRational.denom;
        this.scaleYRationalNum = this.scaleYRational.num;
        this.scaleYRationalDenom = this.scaleYRational.denom;
        this.transXRational = Rational.approximate((float)transX, (float)rationalTolerance);
        this.transYRational = Rational.approximate((float)transY, (float)rationalTolerance);
        this.transXRationalNum = this.transXRational.num;
        this.transXRationalDenom = this.transXRational.denom;
        this.transYRationalNum = this.transYRational.num;
        this.transYRationalDenom = this.transYRational.denom;
        this.invScaleXRational = new Rational(this.scaleXRational);
        this.invScaleXRational.invert();
        this.invScaleYRational = new Rational(this.scaleYRational);
        this.invScaleYRational.invert();
        this.invScaleXRationalNum = this.invScaleXRational.num;
        this.invScaleXRationalDenom = this.invScaleXRational.denom;
        this.invScaleYRationalNum = this.invScaleYRational.num;
        this.invScaleYRationalDenom = this.invScaleYRational.denom;
        this.lpad = interp.getLeftPadding();
        this.rpad = interp.getRightPadding();
        this.tpad = interp.getTopPadding();
        this.bpad = interp.getBottomPadding();
        if (extender == null) {
            int l_y1;
            long dy1Denom;
            long dy1Num;
            long dx1Denom;
            long dx1Num;
            long dy0Denom;
            long dy0Num;
            long dx0Denom;
            long dx0Num;
            int x0 = source.getMinX();
            int y0 = source.getMinY();
            int w = source.getWidth();
            int h = source.getHeight();
            if (interp instanceof InterpolationNearest) {
                dx0Num = x0;
                dx0Denom = 1L;
                dy0Num = y0;
                dy0Denom = 1L;
                dx1Num = x0 + w;
                dx1Denom = 1L;
                dy1Num = y0 + h;
                dy1Denom = 1L;
            } else {
                dx0Num = 2 * x0 + 1;
                dx0Denom = 2L;
                dy0Num = 2 * y0 + 1;
                dy0Denom = 2L;
                dx1Num = 2 * x0 + 2 * w + 1;
                dx1Denom = 2L;
                dy1Num = 2 * y0 + 2 * h + 1;
                dy1Denom = 2L;
                dx0Num += dx0Denom * (long)this.lpad;
                dy0Num += dy0Denom * (long)this.tpad;
                dx1Num -= dx1Denom * (long)this.rpad;
                dy1Num -= dy1Denom * (long)this.bpad;
            }
            dx0Num *= this.scaleXRationalNum;
            dx0Num = dx0Num * this.transXRationalDenom + this.transXRationalNum * (dx0Denom *= this.scaleXRationalDenom);
            dx0Denom *= this.transXRationalDenom;
            dy0Num *= this.scaleYRationalNum;
            dy0Num = dy0Num * this.transYRationalDenom + this.transYRationalNum * (dy0Denom *= this.scaleYRationalDenom);
            dy0Denom *= this.transYRationalDenom;
            dx1Num *= this.scaleXRationalNum;
            dx1Num = dx1Num * this.transXRationalDenom + this.transXRationalNum * (dx1Denom *= this.scaleXRationalDenom);
            dx1Denom *= this.transXRationalDenom;
            dy1Num *= this.scaleYRationalNum;
            dy1Num = dy1Num * this.transYRationalDenom + this.transYRationalNum * (dy1Denom *= this.scaleYRationalDenom);
            dy1Denom *= this.transYRationalDenom;
            dx0Num = 2L * dx0Num - dx0Denom;
            dy0Num = 2L * dy0Num - dy0Denom;
            int l_x0 = Rational.ceil((long)dx0Num, (long)(dx0Denom *= 2L));
            int l_y0 = Rational.ceil((long)dy0Num, (long)(dy0Denom *= 2L));
            dx1Num = 2L * dx1Num - dx1Denom;
            dy1Num = 2L * dy1Num - dy1Denom;
            dy1Denom *= 2L;
            int l_x1 = Rational.floor((long)dx1Num, (long)(dx1Denom *= 2L));
            if ((long)l_x1 * dx1Denom == dx1Num) {
                --l_x1;
            }
            if ((long)(l_y1 = Rational.floor((long)dy1Num, (long)dy1Denom)) * dy1Denom == dy1Num) {
                --l_y1;
            }
            this.computableBounds = new Rectangle(l_x0, l_y0, l_x1 - l_x0 + 1, l_y1 - l_y0 + 1);
        } else {
            this.computableBounds = this.getBounds();
        }
        Object property = source.getProperty("ROI");
        if (property instanceof ROI) {
            this.srcROI = (ROI)property;
            this.srcROIImage = this.srcROI.getAsImage();
            Rectangle rect = new Rectangle(this.srcROIImage.getMinX() - this.lpad, this.srcROIImage.getMinY() - this.tpad, this.srcROIImage.getWidth() + this.lpad + this.rpad, this.srcROIImage.getHeight() + this.tpad + this.bpad);
            Raster data = this.srcROIImage.getExtendedData(rect, BorderExtender.createInstance((int)0));
            this.roiIter = RandomIterFactory.create((Raster)data, (Rectangle)data.getBounds(), (boolean)false, (boolean)true);
            this.hasROI = true;
            this.roiBounds = this.srcROIImage.getBounds();
            this.useRoiAccessor = useRoiAccessor;
        } else {
            this.srcROI = null;
            this.srcROIImage = null;
            this.roiBounds = null;
            this.hasROI = false;
            this.roiIter = null;
        }
    }

    public Point2D mapDestPoint(Point2D destPt, int sourceIndex) {
        if (destPt == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (sourceIndex != 0) {
            throw new IndexOutOfBoundsException(JaiI18N.getString("Generic1"));
        }
        Point2D pt = (Point2D)destPt.clone();
        pt.setLocation((destPt.getX() - (double)this.transX + 0.5) / (double)this.scaleX - 0.5, (destPt.getY() - (double)this.transY + 0.5) / (double)this.scaleY - 0.5);
        return pt;
    }

    public Point2D mapSourcePoint(Point2D sourcePt, int sourceIndex) {
        if (sourcePt == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (sourceIndex != 0) {
            throw new IndexOutOfBoundsException(JaiI18N.getString("Generic1"));
        }
        Point2D pt = (Point2D)sourcePt.clone();
        pt.setLocation((double)this.scaleX * (sourcePt.getX() + 0.5) + (double)this.transX - 0.5, (double)this.scaleY * (sourcePt.getY() + 0.5) + (double)this.transY - 0.5);
        return pt;
    }

    protected Rectangle forwardMapRect(Rectangle sourceRect, int sourceIndex) {
        int l_y1;
        long dy1Denom;
        long dy1Num;
        long dx1Denom;
        long dx1Num;
        long dy0Denom;
        long dy0Num;
        long dx0Denom;
        long dx0Num;
        if (sourceRect == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (sourceIndex != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        int x0 = sourceRect.x;
        int y0 = sourceRect.y;
        int w = sourceRect.width;
        int h = sourceRect.height;
        if (this.interp instanceof InterpolationNearest) {
            dx0Num = x0;
            dx0Denom = 1L;
            dy0Num = y0;
            dy0Denom = 1L;
            dx1Num = x0 + w;
            dx1Denom = 1L;
            dy1Num = y0 + h;
            dy1Denom = 1L;
        } else {
            dx0Num = 2 * x0 + 1;
            dx0Denom = 2L;
            dy0Num = 2 * y0 + 1;
            dy0Denom = 2L;
            dx1Num = 2 * x0 + 2 * w + 1;
            dx1Denom = 2L;
            dy1Num = 2 * y0 + 2 * h + 1;
            dy1Denom = 2L;
        }
        dx0Num *= this.scaleXRationalNum;
        dx0Denom *= this.scaleXRationalDenom;
        dy0Num *= this.scaleYRationalNum;
        dy0Denom *= this.scaleYRationalDenom;
        dx1Num *= this.scaleXRationalNum;
        dx1Denom *= this.scaleXRationalDenom;
        dy1Num *= this.scaleYRationalNum;
        dy1Denom *= this.scaleYRationalDenom;
        dx0Num = dx0Num * this.transXRationalDenom + this.transXRationalNum * dx0Denom;
        dx0Denom *= this.transXRationalDenom;
        dy0Num = dy0Num * this.transYRationalDenom + this.transYRationalNum * dy0Denom;
        dy0Denom *= this.transYRationalDenom;
        dx1Num = dx1Num * this.transXRationalDenom + this.transXRationalNum * dx1Denom;
        dx1Denom *= this.transXRationalDenom;
        dy1Num = dy1Num * this.transYRationalDenom + this.transYRationalNum * dy1Denom;
        dy1Denom *= this.transYRationalDenom;
        dx0Num = 2L * dx0Num - dx0Denom;
        dy0Num = 2L * dy0Num - dy0Denom;
        int l_x0 = Rational.ceil((long)dx0Num, (long)(dx0Denom *= 2L));
        int l_y0 = Rational.ceil((long)dy0Num, (long)(dy0Denom *= 2L));
        dx1Num = 2L * dx1Num - dx1Denom;
        dy1Num = 2L * dy1Num - dy1Denom;
        dy1Denom *= 2L;
        int l_x1 = Rational.floor((long)dx1Num, (long)(dx1Denom *= 2L));
        if ((long)l_x1 * dx1Denom == dx1Num) {
            --l_x1;
        }
        if ((long)(l_y1 = Rational.floor((long)dy1Num, (long)dy1Denom)) * dy1Denom == dy1Num) {
            --l_y1;
        }
        return new Rectangle(l_x0, l_y0, l_x1 - l_x0 + 1, l_y1 - l_y0 + 1);
    }

    protected Rectangle backwardMapRect(Rectangle destRect, int sourceIndex) {
        if (destRect == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (sourceIndex != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        int x0 = destRect.x;
        int y0 = destRect.y;
        int w = destRect.width;
        int h = destRect.height;
        long sx0Num = x0 * 2 + 1;
        long sx0Denom = 2L;
        long sy0Num = y0 * 2 + 1;
        long sy0Denom = 2L;
        long sx1Num = 2 * x0 + 2 * w - 1;
        long sx1Denom = 2L;
        long sy1Num = 2 * y0 + 2 * h - 1;
        long sy1Denom = 2L;
        sx0Num = sx0Num * this.transXRationalDenom - this.transXRationalNum * sx0Denom;
        sx0Denom *= this.transXRationalDenom;
        sy0Num = sy0Num * this.transYRationalDenom - this.transYRationalNum * sy0Denom;
        sy0Denom *= this.transYRationalDenom;
        sx1Num = sx1Num * this.transXRationalDenom - this.transXRationalNum * sx1Denom;
        sx1Denom *= this.transXRationalDenom;
        sy1Num = sy1Num * this.transYRationalDenom - this.transYRationalNum * sy1Denom;
        sy1Denom *= this.transYRationalDenom;
        sx0Num *= this.invScaleXRationalNum;
        sx0Denom *= this.invScaleXRationalDenom;
        sy0Num *= this.invScaleYRationalNum;
        sy0Denom *= this.invScaleYRationalDenom;
        sx1Num *= this.invScaleXRationalNum;
        sx1Denom *= this.invScaleXRationalDenom;
        sy1Num *= this.invScaleYRationalNum;
        sy1Denom *= this.invScaleYRationalDenom;
        int s_x0 = 0;
        int s_y0 = 0;
        int s_x1 = 0;
        int s_y1 = 0;
        if (this.interp instanceof InterpolationNearest) {
            s_x0 = Rational.floor((long)sx0Num, (long)sx0Denom);
            s_y0 = Rational.floor((long)sy0Num, (long)sy0Denom);
            s_x1 = Rational.floor((long)sx1Num, (long)sx1Denom);
            s_y1 = Rational.floor((long)sy1Num, (long)sy1Denom);
        } else {
            s_x0 = Rational.floor((long)(2L * sx0Num - sx0Denom), (long)(2L * sx0Denom));
            s_y0 = Rational.floor((long)(2L * sy0Num - sy0Denom), (long)(2L * sy0Denom));
            s_x1 = Rational.floor((long)(2L * sx1Num - sx1Denom), (long)(2L * sx1Denom));
            s_y1 = Rational.floor((long)(2L * sy1Num - sy1Denom), (long)(2L * sy1Denom));
        }
        return new Rectangle(s_x0, s_y0, s_x1 - s_x0 + 1, s_y1 - s_y0 + 1);
    }

    public Raster computeTile(int tileX, int tileY) {
        if (!this.cobbleSources) {
            return super.computeTile(tileX, tileY);
        }
        int orgX = this.tileXToX(tileX);
        int orgY = this.tileYToY(tileY);
        WritableRaster dest = this.createWritableRaster(this.sampleModel, new Point(orgX, orgY));
        Rectangle rect = new Rectangle(orgX, orgY, this.tileWidth, this.tileHeight);
        Rectangle destRect = rect.intersection(this.computableBounds);
        if (destRect.width <= 0 || destRect.height <= 0) {
            return dest;
        }
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        Raster[] sources = new Raster[1];
        Raster[] rois = new Raster[1];
        PlanarImage source0 = this.getSourceImage(0);
        IntegerSequence srcXSplits = new IntegerSequence();
        IntegerSequence srcYSplits = new IntegerSequence();
        source0.getSplits(srcXSplits, srcYSplits, srcRect);
        if (srcXSplits.getNumElements() == 1 && srcYSplits.getNumElements() == 1) {
            if (this.extender == null) {
                sources[0] = source0.getData(srcRect);
                if (this.hasROI && this.useRoiAccessor) {
                    rois[0] = this.srcROIImage.getData(srcRect);
                }
            } else {
                sources[0] = source0.getExtendedData(srcRect, this.extender);
                if (this.hasROI && this.useRoiAccessor) {
                    rois[0] = this.srcROIImage.getExtendedData(srcRect, roiExtender);
                }
            }
            if (this.hasROI && this.useRoiAccessor) {
                this.computeRect(sources, dest, destRect, rois);
            } else {
                this.computeRect(sources, dest, destRect);
            }
        } else {
            int srcTileWidth = source0.getTileWidth();
            int srcTileHeight = source0.getTileHeight();
            srcYSplits.startEnumeration();
            while (srcYSplits.hasMoreElements()) {
                int ysplit = srcYSplits.nextElement();
                srcXSplits.startEnumeration();
                while (srcXSplits.hasMoreElements()) {
                    int xsplit = srcXSplits.nextElement();
                    Rectangle srcTile = new Rectangle(xsplit, ysplit, srcTileWidth, srcTileHeight);
                    Rectangle newSrcRect = srcRect.intersection(srcTile);
                    if (!(this.interp instanceof InterpolationNearest)) {
                        if (newSrcRect.width <= this.interp.getWidth()) {
                            Rectangle wSrcRect = new Rectangle();
                            wSrcRect.x = newSrcRect.x;
                            wSrcRect.y = newSrcRect.y - this.tpad - 1;
                            wSrcRect.width = 2 * (this.lpad + this.rpad + 1);
                            wSrcRect.height = newSrcRect.height + this.bpad + this.tpad + 2;
                            wSrcRect = wSrcRect.intersection(source0.getBounds());
                            Rectangle wDestRect = this.mapSourceRect(wSrcRect, 0);
                            wDestRect = wDestRect.intersection(destRect);
                            if (wDestRect.width > 0 && wDestRect.height > 0) {
                                if (this.extender == null) {
                                    sources[0] = source0.getData(wSrcRect);
                                    if (this.hasROI && this.useRoiAccessor) {
                                        rois[0] = this.srcROIImage.getData(wSrcRect);
                                    }
                                } else {
                                    sources[0] = source0.getExtendedData(wSrcRect, this.extender);
                                    if (this.hasROI && this.useRoiAccessor) {
                                        rois[0] = this.srcROIImage.getExtendedData(wSrcRect, roiExtender);
                                    }
                                }
                                if (this.hasROI && this.useRoiAccessor) {
                                    this.computeRect(sources, dest, wDestRect, rois);
                                } else {
                                    this.computeRect(sources, dest, wDestRect);
                                }
                            }
                        }
                        if (newSrcRect.height <= this.interp.getHeight()) {
                            Rectangle hSrcRect = new Rectangle();
                            hSrcRect.x = newSrcRect.x - this.lpad - 1;
                            hSrcRect.y = newSrcRect.y;
                            hSrcRect.width = newSrcRect.width + this.lpad + this.rpad + 2;
                            hSrcRect.height = 2 * (this.tpad + this.bpad + 1);
                            hSrcRect = hSrcRect.intersection(source0.getBounds());
                            Rectangle hDestRect = this.mapSourceRect(hSrcRect, 0);
                            hDestRect = hDestRect.intersection(destRect);
                            if (hDestRect.width > 0 && hDestRect.height > 0) {
                                if (this.extender == null) {
                                    sources[0] = source0.getData(hSrcRect);
                                    if (this.hasROI && this.useRoiAccessor) {
                                        rois[0] = this.srcROIImage.getData(hSrcRect);
                                    }
                                } else {
                                    sources[0] = source0.getExtendedData(hSrcRect, this.extender);
                                    if (this.hasROI && this.useRoiAccessor) {
                                        rois[0] = this.srcROIImage.getExtendedData(hSrcRect, roiExtender);
                                    }
                                }
                                if (this.hasROI && this.useRoiAccessor) {
                                    this.computeRect(sources, dest, hDestRect, rois);
                                } else {
                                    this.computeRect(sources, dest, hDestRect);
                                }
                            }
                        }
                    }
                    if (newSrcRect.width <= 0 || newSrcRect.height <= 0) continue;
                    Rectangle newDestRect = this.mapSourceRect(newSrcRect, 0);
                    newDestRect = newDestRect.intersection(destRect);
                    if (newDestRect.width > 0 && newDestRect.height > 0) {
                        if (this.extender == null) {
                            sources[0] = source0.getData(newSrcRect);
                            if (this.hasROI && this.useRoiAccessor) {
                                rois[0] = this.srcROIImage.getData(newSrcRect);
                            }
                        } else {
                            sources[0] = source0.getExtendedData(newSrcRect, this.extender);
                            if (this.hasROI && this.useRoiAccessor) {
                                rois[0] = this.srcROIImage.getExtendedData(newSrcRect, roiExtender);
                            }
                        }
                        if (this.hasROI && this.useRoiAccessor) {
                            this.computeRect(sources, dest, newDestRect, rois);
                        } else {
                            this.computeRect(sources, dest, newDestRect);
                        }
                    }
                    if (this.interp instanceof InterpolationNearest) continue;
                    Rectangle RTSrcRect = new Rectangle();
                    RTSrcRect.x = newSrcRect.x + newSrcRect.width - 1 - this.rpad - this.lpad;
                    RTSrcRect.y = newSrcRect.y;
                    RTSrcRect.width = 2 * (this.lpad + this.rpad + 1);
                    RTSrcRect.height = newSrcRect.height;
                    Rectangle RTDestRect = this.mapSourceRect(RTSrcRect, 0);
                    RTDestRect = RTDestRect.intersection(destRect);
                    RTSrcRect = this.mapDestRect(RTDestRect, 0);
                    if (RTDestRect.width > 0 && RTDestRect.height > 0) {
                        if (this.extender == null) {
                            sources[0] = source0.getData(RTSrcRect);
                            if (this.hasROI && this.useRoiAccessor) {
                                rois[0] = this.srcROIImage.getData(RTSrcRect);
                            }
                        } else {
                            sources[0] = source0.getExtendedData(RTSrcRect, this.extender);
                            if (this.hasROI && this.useRoiAccessor) {
                                rois[0] = this.srcROIImage.getExtendedData(RTSrcRect, roiExtender);
                            }
                        }
                        if (this.hasROI && this.useRoiAccessor) {
                            this.computeRect(sources, dest, RTDestRect, rois);
                        } else {
                            this.computeRect(sources, dest, RTDestRect);
                        }
                    }
                    Rectangle BTSrcRect = new Rectangle();
                    BTSrcRect.x = newSrcRect.x;
                    BTSrcRect.y = newSrcRect.y + newSrcRect.height - 1 - this.bpad - this.tpad;
                    BTSrcRect.width = newSrcRect.width;
                    BTSrcRect.height = 2 * (this.tpad + this.bpad + 1);
                    Rectangle BTDestRect = this.mapSourceRect(BTSrcRect, 0);
                    BTDestRect = BTDestRect.intersection(destRect);
                    BTSrcRect = this.mapDestRect(BTDestRect, 0);
                    if (BTDestRect.width > 0 && BTDestRect.height > 0) {
                        if (this.extender == null) {
                            sources[0] = source0.getData(BTSrcRect);
                            if (this.hasROI && this.useRoiAccessor) {
                                rois[0] = this.srcROIImage.getData(BTSrcRect);
                            }
                        } else {
                            sources[0] = source0.getExtendedData(BTSrcRect, this.extender);
                            if (this.hasROI && this.useRoiAccessor) {
                                rois[0] = this.srcROIImage.getExtendedData(BTSrcRect, roiExtender);
                            }
                        }
                        if (this.hasROI && this.useRoiAccessor) {
                            this.computeRect(sources, dest, BTDestRect, rois);
                        } else {
                            this.computeRect(sources, dest, BTDestRect);
                        }
                    }
                    Rectangle LRTSrcRect = new Rectangle();
                    LRTSrcRect.x = newSrcRect.x + newSrcRect.width - 1 - this.rpad - this.lpad;
                    LRTSrcRect.y = newSrcRect.y + newSrcRect.height - 1 - this.bpad - this.tpad;
                    LRTSrcRect.width = 2 * (this.rpad + this.lpad + 1);
                    LRTSrcRect.height = 2 * (this.tpad + this.bpad + 1);
                    Rectangle LRTDestRect = this.mapSourceRect(LRTSrcRect, 0);
                    LRTDestRect = LRTDestRect.intersection(destRect);
                    LRTSrcRect = this.mapDestRect(LRTDestRect, 0);
                    if (LRTDestRect.width <= 0 || LRTDestRect.height <= 0) continue;
                    if (this.extender == null) {
                        sources[0] = source0.getData(LRTSrcRect);
                        if (this.hasROI && this.useRoiAccessor) {
                            rois[0] = this.srcROIImage.getData(LRTSrcRect);
                        }
                    } else {
                        sources[0] = source0.getExtendedData(LRTSrcRect, this.extender);
                        if (this.hasROI && this.useRoiAccessor) {
                            rois[0] = this.srcROIImage.getExtendedData(LRTSrcRect, roiExtender);
                        }
                    }
                    if (this.hasROI && this.useRoiAccessor) {
                        this.computeRect(sources, dest, LRTDestRect, rois);
                        continue;
                    }
                    this.computeRect(sources, dest, LRTDestRect);
                }
            }
        }
        return dest;
    }

    public synchronized void dispose() {
        if (this.srcROIImage != null) {
            this.srcROIImage.dispose();
            this.roiIter.done();
        }
        super.dispose();
    }

    protected abstract void computeRect(Raster[] var1, WritableRaster var2, Rectangle var3, Raster[] var4);
}

