/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.rescale;

import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.rescale.RescalePropertyGenerator;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PropertyGenerator;
import javax.media.jai.ROI;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;

public class RescaleDescriptor
extends OperationDescriptorImpl {
    private static final String[][] resources = new String[][]{{"GlobalName", "Rescaling"}, {"LocalName", "Rescaling"}, {"Vendor", "it.geosolutions.jaiext.roiaware"}, {"Description", "Operation which converts the image dynamic to a new dynamic"}, {"DocURL", "Not Defined"}, {"Version", "1.0"}, {"arg0Desc", "Scale factors used for rescaling values"}, {"arg1Desc", "Offset factors used for rescaling values"}, {"arg2Desc", "ROI object used"}, {"arg3Desc", "No Data Range used"}, {"arg4Desc", "Boolean checking if ROI RasterAccessor is used"}, {"arg5Desc", "Destination No Data value"}};
    private static final Class[] paramClasses = new Class[]{double[].class, double[].class, ROI.class, Range.class, Boolean.class, Double.class};
    private static final String[] paramNames = new String[]{"scale", "offset", "ROI", "noData", "useRoiAccessor", "destNoData"};
    private static final Object[] paramDefaults = new Object[]{new double[]{1.0}, new double[]{0.0}, null, null, false, 0.0};

    public RescaleDescriptor() {
        super(resources, 1, paramClasses, paramNames, paramDefaults);
    }

    public boolean isRenderableSupported() {
        return true;
    }

    public PropertyGenerator[] getPropertyGenerators() {
        PropertyGenerator[] pg = new PropertyGenerator[]{new RescalePropertyGenerator()};
        return pg;
    }

    public static RenderedOp create(RenderedImage source0, double[] scales, double[] offsets, ROI roi, Range rangeND, boolean useRoiAccessor, double destNoData, RenderingHints hints) {
        ParameterBlockJAI pb = new ParameterBlockJAI("Rescaling", "rendered");
        pb.setSource("source0", (Object)source0);
        pb.setParameter("scale", (Object)scales);
        pb.setParameter("offset", (Object)offsets);
        pb.setParameter("ROI", (Object)roi);
        pb.setParameter("noData", (Object)rangeND);
        pb.setParameter("useRoiAccessor", useRoiAccessor);
        pb.setParameter("destNoData", destNoData);
        return JAI.create((String)"Rescaling", (ParameterBlock)pb, (RenderingHints)hints);
    }

    public static RenderableOp createRenderable(RenderableImage source0, double[] scales, double[] offsets, ROI roi, Range rangeND, boolean useRoiAccessor, double destNoData, RenderingHints hints) {
        ParameterBlockJAI pb = new ParameterBlockJAI("Rescaling", "renderable");
        pb.setSource("source0", (Object)source0);
        pb.setParameter("scale", (Object)scales);
        pb.setParameter("offset", (Object)offsets);
        pb.setParameter("ROI", (Object)roi);
        pb.setParameter("noData", (Object)rangeND);
        pb.setParameter("useRoiAccessor", useRoiAccessor);
        pb.setParameter("destNoData", destNoData);
        return JAI.createRenderable((String)"Rescaling", (ParameterBlock)pb, (RenderingHints)hints);
    }
}

