/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.piecewise;

import it.geosolutions.jaiext.algebra.AlgebraDescriptor;
import it.geosolutions.jaiext.algebra.constant.OperationConstDescriptor;
import it.geosolutions.jaiext.bandselect.BandSelectDescriptor;
import it.geosolutions.jaiext.piecewise.DefaultConstantPiecewiseTransformElement;
import it.geosolutions.jaiext.piecewise.DefaultLinearPiecewiseTransform1DElement;
import it.geosolutions.jaiext.piecewise.DefaultPassthroughPiecewiseTransform1DElement;
import it.geosolutions.jaiext.piecewise.DefaultPiecewiseTransform1D;
import it.geosolutions.jaiext.piecewise.DefaultPiecewiseTransform1DElement;
import it.geosolutions.jaiext.piecewise.MathTransformation;
import it.geosolutions.jaiext.piecewise.PiecewiseUtilities;
import it.geosolutions.jaiext.piecewise.Position;
import it.geosolutions.jaiext.piecewise.SingleDimensionTransformation;
import it.geosolutions.jaiext.piecewise.TransformationException;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.stats.Statistics;
import it.geosolutions.jaiext.stats.StatisticsDescriptor;
import it.geosolutions.jaiext.testclasses.TestBase;
import it.geosolutions.jaiext.testclasses.TestData;
import it.geosolutions.rendered.viewer.RenderedImageBrowser;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.IOException;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.FormatDescriptor;
import junit.framework.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestPiecewise
extends TestBase {
    @BeforeClass
    public static void setUp() throws Exception {
        try {
            new ParameterBlockJAI("GenericPiecewise");
        }
        catch (Exception e) {
            Assert.assertTrue((String)"GenericPiecewise not registered", (boolean)false);
        }
        File file = TestData.file(TestPiecewise.class, (String)"test.tif");
        Assert.assertTrue((boolean)file.exists());
    }

    @Test
    public void linearTransform() throws IOException, TransformationException {
        DefaultPiecewiseTransform1DElement e0 = DefaultPiecewiseTransform1DElement.create((CharSequence)"zero", (Range)RangeFactory.create((int)0, (boolean)true, (int)100, (boolean)true), (Range)RangeFactory.create((int)0, (boolean)true, (int)200, (boolean)true));
        Assert.assertTrue((boolean)(e0 instanceof DefaultLinearPiecewiseTransform1DElement));
        Assert.assertEquals((double)((DefaultLinearPiecewiseTransform1DElement)e0).getOutputMinimum(), (double)e0.transform(0.0), (double)0.0);
        Assert.assertEquals((double)((DefaultLinearPiecewiseTransform1DElement)e0).getOutputMaximum(), (double)e0.transform(e0.getInputMaximum()), (double)0.0);
        Assert.assertEquals((double)0.0, (double)((DefaultLinearPiecewiseTransform1DElement)e0).getOffset(), (double)0.0);
        Assert.assertEquals((double)2.0, (double)((DefaultLinearPiecewiseTransform1DElement)e0).getScale(), (double)0.0);
        Assert.assertFalse((boolean)e0.isIdentity());
        Assert.assertEquals((int)1, (int)e0.getSourceDimensions());
        Assert.assertEquals((int)1, (int)e0.getTargetDimensions());
        boolean exceptionThrown = false;
        try {
            Assert.assertEquals((double)e0.transform(Double.POSITIVE_INFINITY), (double)0.0, (double)0.0);
        }
        catch (Exception e) {
            exceptionThrown = true;
        }
        Assert.assertTrue((boolean)exceptionThrown);
        DefaultPiecewiseTransform1D transform = new DefaultPiecewiseTransform1D(new DefaultPiecewiseTransform1DElement[]{e0});
        Assert.assertEquals((double)0.0, (double)transform.transform(0.0), (double)0.0);
        Assert.assertEquals((int)1, (int)transform.getSourceDimensions());
        Assert.assertEquals((int)1, (int)transform.getTargetDimensions());
    }

    @Test
    public void constantTransform() throws IOException, TransformationException {
        DefaultPiecewiseTransform1DElement e0 = DefaultPiecewiseTransform1DElement.create((CharSequence)"zero", (Range)RangeFactory.create((double)Double.NEGATIVE_INFINITY, (boolean)true, (double)Double.POSITIVE_INFINITY, (boolean)true, (boolean)true), (byte)0);
        Assert.assertTrue((boolean)(e0 instanceof DefaultConstantPiecewiseTransformElement));
        Assert.assertEquals((double)0.0, (double)e0.transform(0.0), (double)0.0);
        Assert.assertEquals((double)e0.transform(Double.POSITIVE_INFINITY), (double)0.0, (double)0.0);
        try {
            e0.inverse();
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        DefaultPiecewiseTransform1D transform = new DefaultPiecewiseTransform1D(new DefaultPiecewiseTransform1DElement[]{e0});
        Assert.assertEquals((double)0.0, (double)transform.transform(0.0), (double)0.0);
        Assert.assertEquals((double)transform.transform(Double.POSITIVE_INFINITY), (double)0.0, (double)0.0);
        e0 = DefaultPiecewiseTransform1DElement.create((CharSequence)"zero", (Range)RangeFactory.create((double)Double.NEGATIVE_INFINITY, (boolean)true, (double)Double.POSITIVE_INFINITY, (boolean)true, (boolean)true), (int)0);
        Assert.assertTrue((boolean)(e0 instanceof DefaultConstantPiecewiseTransformElement));
        Assert.assertEquals((double)0.0, (double)e0.transform(0.0), (double)0.0);
        Assert.assertEquals((double)e0.transform(Double.POSITIVE_INFINITY), (double)0.0, (double)0.0);
        DefaultPiecewiseTransform1D transform1 = new DefaultPiecewiseTransform1D(new DefaultPiecewiseTransform1DElement[]{e0});
        Assert.assertEquals((double)0.0, (double)transform1.transform(0.0), (double)0.0);
        Assert.assertEquals((double)transform1.transform(Double.POSITIVE_INFINITY), (double)0.0, (double)0.0);
        Assert.assertFalse((boolean)transform.equals((Object)transform1));
        Assert.assertFalse((boolean)transform1.equals((Object)transform));
        Assert.assertFalse((boolean)transform.equals((Object)transform));
        Assert.assertFalse((boolean)transform1.equals((Object)transform1));
        Assert.assertEquals((int)transform1.hashCode(), (int)transform.hashCode());
        e0 = DefaultPiecewiseTransform1DElement.create((CharSequence)"zero", (Range)RangeFactory.create((double)Double.NEGATIVE_INFINITY, (boolean)true, (double)Double.POSITIVE_INFINITY, (boolean)true, (boolean)true), (double)0.0);
        Assert.assertTrue((boolean)(e0 instanceof DefaultConstantPiecewiseTransformElement));
        Assert.assertEquals((double)0.0, (double)e0.transform(0.0), (double)0.0);
        Assert.assertEquals((double)e0.transform(Double.POSITIVE_INFINITY), (double)0.0, (double)0.0);
        boolean exceptionThrown = false;
        try {
            e0.inverse();
            Assert.assertTrue((boolean)false);
        }
        catch (Exception e) {
            exceptionThrown = true;
        }
        Assert.assertTrue((boolean)exceptionThrown);
        transform = new DefaultPiecewiseTransform1D(new DefaultPiecewiseTransform1DElement[]{e0});
        Assert.assertEquals((double)0.0, (double)transform.transform(0.0), (double)0.0);
        Assert.assertEquals((double)transform.transform(Double.POSITIVE_INFINITY), (double)0.0, (double)0.0);
        e0 = DefaultPiecewiseTransform1DElement.create((CharSequence)"zero", (Range)RangeFactory.create((int)3, (boolean)true, (int)3, (boolean)true), (double)0.0);
        Assert.assertTrue((boolean)(e0 instanceof DefaultConstantPiecewiseTransformElement));
        Assert.assertEquals((double)0.0, (double)e0.transform(3.0), (double)0.0);
        Assert.assertEquals((double)3.0, (double)e0.inverse().transform(new Position(0.0), null).getOrdinatePosition(), (double)0.0);
        transform = new DefaultPiecewiseTransform1D(new DefaultPiecewiseTransform1DElement[]{e0});
        Assert.assertEquals((double)0.0, (double)e0.transform(3.0), (double)0.0);
        Assert.assertEquals((double)transform.transform(3.0), (double)0.0, (double)0.0);
    }

    @Test
    public void piecewiseLogarithm() throws IOException, TransformationException {
        DefaultPiecewiseTransform1DElement zero = DefaultPiecewiseTransform1DElement.create((CharSequence)"zero", (Range)RangeFactory.create((int)0, (boolean)true, (int)0, (boolean)true), (int)0);
        DefaultPiecewiseTransform1DElement mainElement = new DefaultPiecewiseTransform1DElement((CharSequence)"natural logarithm", RangeFactory.create((int)0, (boolean)false, (int)255, (boolean)true), new MathTransformation(){

            public Position transform(Position ptSrc, Position ptDst) {
                return null;
            }

            public double transform(double value) {
                return Math.log(value);
            }

            public boolean isIdentity() {
                return false;
            }

            public MathTransformation inverseTransform() {
                return null;
            }

            public int getTargetDimensions() {
                return 1;
            }

            public int getSourceDimensions() {
                return 1;
            }

            public double derivative(double value) {
                return 1.0 / value;
            }
        });
        DefaultPiecewiseTransform1D transform = new DefaultPiecewiseTransform1D(new DefaultPiecewiseTransform1DElement[]{zero, mainElement});
        Assert.assertEquals((double)0.0, (double)transform.transform(0.0), (double)0.0);
        Assert.assertEquals((double)0.0, (double)transform.transform(1.0), (double)0.0);
        Assert.assertEquals((double)Math.log(255.0), (double)transform.transform(255.0), (double)0.0);
        Assert.assertEquals((double)Math.log(124.0), (double)transform.transform(124.0), (double)0.0);
        try {
            Assert.assertEquals((double)Math.log(255.0), (double)transform.transform(256.0), (double)0.0);
            Assert.assertTrue((boolean)false);
        }
        catch (TransformationException transformationException) {
            // empty catch block
        }
        DefaultPiecewiseTransform1DElement nodata = DefaultPiecewiseTransform1DElement.create((CharSequence)"no-data", (Range)RangeFactory.create((int)-1, (boolean)true, (int)-1, (boolean)true), (double)Double.NaN);
        transform = new DefaultPiecewiseTransform1D(new DefaultPiecewiseTransform1DElement[]{zero, mainElement, nodata});
        Assert.assertEquals((double)0.0, (double)transform.transform(0.0), (double)0.0);
        Assert.assertEquals((double)0.0, (double)transform.transform(1.0), (double)0.0);
        Assert.assertEquals((double)Math.log(255.0), (double)transform.transform(255.0), (double)0.0);
        Assert.assertEquals((double)Math.log(124.0), (double)transform.transform(124.0), (double)0.0);
        try {
            Assert.assertTrue((boolean)Double.isNaN(transform.transform(256.0)));
            Assert.assertTrue((boolean)false);
        }
        catch (TransformationException e) {
            Assert.assertTrue((boolean)true);
        }
        DefaultPiecewiseTransform1DElement overlap = DefaultPiecewiseTransform1DElement.create((CharSequence)"overlap", (Range)RangeFactory.create((int)-100, (boolean)true, (int)12, (boolean)true), (double)Double.NaN);
        try {
            transform = new DefaultPiecewiseTransform1D(new DefaultPiecewiseTransform1DElement[]{zero, mainElement, overlap, nodata});
            Assert.assertTrue((boolean)false);
        }
        catch (Throwable e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void defaultTransform() throws IOException, TransformationException {
        DefaultPiecewiseTransform1DElement t0 = new DefaultPiecewiseTransform1DElement((CharSequence)"t0", RangeFactory.create((double)0.0, (boolean)true, (double)1.0, (boolean)true, (boolean)false), PiecewiseUtilities.createLinearTransform1D((Range)RangeFactory.create((double)0.0, (boolean)true, (double)1.0, (boolean)true, (boolean)false), (Range)RangeFactory.create((int)200, (boolean)true, (int)201, (boolean)true)));
        Assert.assertEquals((double)t0.transform(0.5), (double)200.5, (double)0.0);
        Assert.assertTrue((boolean)t0.contains(0.5));
        Assert.assertTrue((boolean)t0.contains(RangeFactory.create((double)0.1, (boolean)true, (double)0.9, (boolean)true, (boolean)false)));
        Assert.assertFalse((boolean)t0.contains(1.5));
        Assert.assertFalse((boolean)t0.contains(RangeFactory.create((double)0.1, (boolean)true, (double)1.9, (boolean)true, (boolean)false)));
        Assert.assertTrue((boolean)t0.equals((Object)t0));
        Assert.assertEquals((double)t0.inverse().transform(200.5), (double)0.5, (double)0.0);
        t0 = DefaultPiecewiseTransform1DElement.create((CharSequence)"t0", (Range)RangeFactory.create((double)0.0, (boolean)true, (double)1.0, (boolean)true, (boolean)false), (Range)RangeFactory.create((int)200, (boolean)true, (int)201, (boolean)true));
        Assert.assertFalse((boolean)t0.equals((Object)DefaultPiecewiseTransform1DElement.create((CharSequence)"t0", (Range)RangeFactory.create((double)0.0, (boolean)true, (double)1.0, (boolean)true, (boolean)false), (Range)RangeFactory.create((int)200, (boolean)true, (int)202, (boolean)true))));
        Assert.assertEquals((double)t0.transform(0.5), (double)200.5, (double)0.0);
        Assert.assertEquals((double)t0.inverse().transform(200.5), (double)0.5, (double)0.0);
        DefaultPiecewiseTransform1DElement t1 = DefaultPiecewiseTransform1DElement.create((CharSequence)"t1", (Range)RangeFactory.create((double)1.0, (boolean)false, (double)2.0, (boolean)true, (boolean)false), (int)201);
        Assert.assertEquals((double)t1.transform(1.5), (double)201.0, (double)0.0);
        Assert.assertEquals((double)t1.transform(1.6), (double)201.0, (double)0.0);
        Assert.assertFalse((boolean)t0.equals((Object)t1));
        Assert.assertEquals((double)t1.transform(1.8), (double)201.0, (double)0.0);
        t1 = new DefaultConstantPiecewiseTransformElement((CharSequence)"t1", RangeFactory.create((double)1.0, (boolean)false, (double)2.0, (boolean)true, (boolean)false), 201);
        Assert.assertEquals((double)t1.transform(1.5), (double)201.0, (double)0.0);
        Assert.assertEquals((double)t1.transform(1.6), (double)201.0, (double)0.0);
        Assert.assertEquals((double)t1.transform(1.8), (double)201.0, (double)0.0);
        DefaultPiecewiseTransform1D transform = new DefaultPiecewiseTransform1D(new DefaultPiecewiseTransform1DElement[]{t1}, 12.0);
        Assert.assertEquals((String)transform.getName().toString(), (String)t1.getName().toString());
        Assert.assertEquals((double)transform.getApproximateDomainRange().getMin().doubleValue(), (double)1.0, (double)0.0);
        Assert.assertEquals((double)transform.getApproximateDomainRange().getMax().doubleValue(), (double)2.0, (double)0.0);
        Assert.assertEquals((double)transform.transform(1.5), (double)201.0, (double)0.0);
        Assert.assertEquals((double)transform.transform(2.5), (double)0.0, (double)12.0);
        boolean foundException = false;
        try {
            transform = new DefaultPiecewiseTransform1D(new DefaultPiecewiseTransform1DElement[]{DefaultLinearPiecewiseTransform1DElement.create((CharSequence)"", (Range)RangeFactory.create((int)0, (boolean)true, (int)100, (boolean)true), (Range)RangeFactory.create((double)Double.NEGATIVE_INFINITY, (boolean)true, (double)Double.POSITIVE_INFINITY, (boolean)true, (boolean)false))});
        }
        catch (IllegalArgumentException e) {
            foundException = true;
        }
        Assert.assertTrue((boolean)foundException);
    }

    @Test
    public void passthroughTransform() throws IOException, TransformationException {
        DefaultPassthroughPiecewiseTransform1DElement p0 = new DefaultPassthroughPiecewiseTransform1DElement((CharSequence)"p0", RangeFactory.create((double)0.0, (boolean)true, (double)1.0, (boolean)true, (boolean)false));
        Assert.assertEquals((int)p0.getTargetDimensions(), (int)1);
        Assert.assertEquals((int)p0.getSourceDimensions(), (int)1);
        Assert.assertTrue((boolean)p0.isIdentity());
        Assert.assertEquals((Object)p0.inverse(), (Object)SingleDimensionTransformation.IDENTITY);
        Assert.assertEquals((double)p0.transform(0.5), (double)0.5, (double)0.0);
        Assert.assertEquals((double)p0.inverse().transform(0.5), (double)0.5, (double)0.0);
        Assert.assertTrue((p0.transform(0.6) == 0.6 ? 1 : 0) != 0);
        DefaultPiecewiseTransform1D piecewise = new DefaultPiecewiseTransform1D(new DefaultPiecewiseTransform1DElement[]{p0}, 11.0);
        Assert.assertEquals((double)piecewise.getApproximateDomainRange().getMin().doubleValue(), (double)0.0, (double)0.0);
        Assert.assertEquals((double)piecewise.getApproximateDomainRange().getMax().doubleValue(), (double)1.0, (double)0.0);
        Assert.assertEquals((double)piecewise.transform(0.5), (double)0.5, (double)0.0);
        Assert.assertEquals((double)piecewise.transform(1.5), (double)0.0, (double)11.0);
        DefaultPassthroughPiecewiseTransform1DElement p1 = new DefaultPassthroughPiecewiseTransform1DElement((CharSequence)"p1");
        Assert.assertEquals((int)p1.getTargetDimensions(), (int)1);
        Assert.assertEquals((int)p1.getSourceDimensions(), (int)1);
        Assert.assertTrue((boolean)p1.isIdentity());
        Assert.assertEquals((Object)p1.inverse(), (Object)SingleDimensionTransformation.IDENTITY);
        Assert.assertEquals((double)p1.transform(0.5), (double)0.5, (double)0.0);
        Assert.assertEquals((double)p1.transform(111.5), (double)111.5, (double)0.0);
        Assert.assertEquals((double)p1.transform(123.5), (double)123.5, (double)0.0);
        Assert.assertEquals((double)p1.inverse().transform(657.5), (double)657.5, (double)0.0);
        Assert.assertTrue((p1.transform(0.6) == 0.6 ? 1 : 0) != 0);
    }

    @Test
    public void lookupByteData() throws IOException, TransformationException {
        RenderedOp image = JAI.create((String)"ImageRead", (Object)TestData.file((Object)((Object)this), (String)"test.tif"));
        image = BandSelectDescriptor.create((RenderedImage)image, (int[])new int[]{0}, null);
        image = FormatDescriptor.create((RenderedImage)image, (Integer)5, null);
        DefaultPiecewiseTransform1DElement c1 = DefaultLinearPiecewiseTransform1DElement.create((CharSequence)"c1", (Range)RangeFactory.create((int)1, (int)128), (Range)RangeFactory.create((int)1, (int)255));
        DefaultPiecewiseTransform1DElement c0 = DefaultLinearPiecewiseTransform1DElement.create((CharSequence)"c0", (Range)RangeFactory.create((int)129, (int)255), (Range)RangeFactory.create((int)255, (int)255));
        DefaultPiecewiseTransform1DElement nodata = DefaultLinearPiecewiseTransform1DElement.create((CharSequence)"nodata", (Range)RangeFactory.create((int)0, (int)0), (int)0);
        DefaultPiecewiseTransform1D list = new DefaultPiecewiseTransform1D(new DefaultPiecewiseTransform1DElement[]{c0, c1, nodata}, 0.0);
        ParameterBlockJAI pbj = new ParameterBlockJAI("GenericPiecewise");
        pbj.addSource((Object)image);
        pbj.setParameter("Domain1D", (Object)list);
        RenderedOp finalImage = JAI.create((String)"GenericPiecewise", (ParameterBlock)pbj);
        if (INTERACTIVE) {
            RenderedImageBrowser.showChain((RenderedImage)finalImage, (boolean)false, (boolean)false, null);
        } else {
            finalImage.getTiles();
        }
        finalImage.dispose();
        Rectangle roiBounds = new Rectangle(image.getMinX() + 5, image.getMinY() + 5, image.getWidth() / 4, image.getHeight() / 4);
        ROIShape roi = new ROIShape((Shape)roiBounds);
        Range nodataRange = RangeFactory.create((int)12, (int)13);
        pbj = new ParameterBlockJAI("GenericPiecewise");
        pbj.addSource((Object)image);
        pbj.setParameter("Domain1D", (Object)list);
        pbj.setParameter("roi", (Object)roi);
        finalImage = JAI.create((String)"GenericPiecewise", (ParameterBlock)pbj);
        if (INTERACTIVE) {
            RenderedImageBrowser.showChain((RenderedImage)finalImage, (boolean)false, (boolean)false, null);
        } else {
            finalImage.getTiles();
        }
        finalImage.dispose();
        pbj = new ParameterBlockJAI("GenericPiecewise");
        pbj.addSource((Object)image);
        pbj.setParameter("Domain1D", (Object)list);
        pbj.setParameter("nodata", (Object)nodataRange);
        finalImage = JAI.create((String)"GenericPiecewise", (ParameterBlock)pbj);
        if (INTERACTIVE) {
            RenderedImageBrowser.showChain((RenderedImage)finalImage, (boolean)false, (boolean)false, null);
        } else {
            finalImage.getTiles();
        }
        finalImage.dispose();
        pbj = new ParameterBlockJAI("GenericPiecewise");
        pbj.addSource((Object)image);
        pbj.setParameter("Domain1D", (Object)list);
        pbj.setParameter("roi", (Object)roi);
        pbj.setParameter("nodata", (Object)nodataRange);
        finalImage = JAI.create((String)"GenericPiecewise", (ParameterBlock)pbj);
        if (INTERACTIVE) {
            RenderedImageBrowser.showChain((RenderedImage)finalImage, (boolean)false, (boolean)false, null);
        } else {
            finalImage.getTiles();
        }
        finalImage.dispose();
    }

    @Test
    public void logarithmicTransform() throws IOException {
        JAI.getDefaultInstance().getTileScheduler().setParallelism(1);
        RenderedOp image = JAI.create((String)"ImageRead", (Object)TestData.file((Object)((Object)this), (String)"test.tif"));
        image = BandSelectDescriptor.create((RenderedImage)image, (int[])new int[]{0}, null);
        image = FormatDescriptor.create((RenderedImage)image, (Integer)5, null);
        image = AlgebraDescriptor.create((AlgebraDescriptor.Operator)AlgebraDescriptor.Operator.ABSOLUTE, null, null, (double)0.0, null, (RenderedImage[])new RenderedImage[]{image});
        image = OperationConstDescriptor.create((RenderedImage)image, (double[])new double[]{10.0}, (AlgebraDescriptor.Operator)AlgebraDescriptor.Operator.SUM, null, null, (double)0.0, null);
        Statistics.StatsType[] stats = new Statistics.StatsType[]{Statistics.StatsType.EXTREMA};
        image = StatisticsDescriptor.create((RenderedImage)image, (int)1, (int)1, null, null, (boolean)false, (int[])new int[]{0}, (Statistics.StatsType[])stats, null);
        Statistics stat = ((Statistics[][])image.getProperty("JAI-EXT.stats"))[0][0];
        double[] result = (double[])stat.getResult();
        final double minimum = result[0];
        final double maximum = result[1];
        DefaultPiecewiseTransform1DElement mainElement = new DefaultPiecewiseTransform1DElement((CharSequence)"natural logarithm", RangeFactory.create((double)minimum, (boolean)true, (double)maximum, (boolean)true), new MathTransformation(){

            public double derivative(double arg0) {
                return 1.0 / arg0;
            }

            public double transform(double arg0) {
                return minimum + 1.2 * Math.log(arg0 / minimum) * ((maximum - minimum) / Math.log(maximum / minimum));
            }

            public boolean isIdentity() {
                return false;
            }

            public int getSourceDimensions() {
                return 1;
            }

            public int getTargetDimensions() {
                return 1;
            }

            public MathTransformation inverseTransform() {
                throw new UnsupportedOperationException();
            }

            public Position transform(Position ptSrc, Position ptDst) {
                throw new UnsupportedOperationException();
            }
        });
        DefaultPiecewiseTransform1D transform = new DefaultPiecewiseTransform1D(new DefaultPiecewiseTransform1DElement[]{mainElement}, 0.0);
        RenderedOp finalImage = null;
        ParameterBlockJAI pbj = new ParameterBlockJAI("GenericPiecewise");
        pbj.addSource((Object)image);
        pbj.setParameter("Domain1D", (Object)transform);
        pbj.setParameter("bandIndex", (Object)new Integer(0));
        finalImage = JAI.create((String)"GenericPiecewise", (ParameterBlock)pbj, null);
        if (INTERACTIVE) {
            RenderedImageBrowser.showChain((RenderedImage)finalImage, (boolean)false, (boolean)false, null);
        } else {
            finalImage.getTiles();
        }
        finalImage.dispose();
        Rectangle roiBounds = new Rectangle(image.getMinX() + 5, image.getMinY() + 5, image.getWidth() / 4, image.getHeight() / 4);
        ROIShape roi = new ROIShape((Shape)roiBounds);
        pbj = new ParameterBlockJAI("GenericPiecewise");
        pbj.addSource((Object)image);
        pbj.setParameter("Domain1D", (Object)transform);
        pbj.setParameter("bandIndex", (Object)new Integer(0));
        pbj.setParameter("roi", (Object)roi);
        finalImage = JAI.create((String)"GenericPiecewise", (ParameterBlock)pbj, null);
        if (INTERACTIVE) {
            RenderedImageBrowser.showChain((RenderedImage)finalImage, (boolean)false, (boolean)false, null);
        } else {
            finalImage.getTiles();
        }
        finalImage.dispose();
    }
}

