/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.orderdither;

import it.geosolutions.jaiext.iterators.RandomIterFactory;
import it.geosolutions.jaiext.orderdither.OrderedDitherDescriptor;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.testclasses.TestBase;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.RenderedImage;
import java.util.Arrays;
import javax.media.jai.ColorCube;
import javax.media.jai.KernelJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import javax.media.jai.iterator.RandomIter;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class OrderedDitherTest
extends TestBase {
    public static final double TOLERANCE = 0.01;
    private static RenderedImage[] testImages;
    private static Range noDataByte;
    private static Range noDataUShort;
    private static Range noDataShort;
    private static Range noDataInt;
    private static Range noDataFloat;
    private static Range noDataDouble;
    private static ROI roiObject;
    private static double destNoData;

    @BeforeClass
    public static void initialSetup() {
        byte noDataB = 50;
        short noDataS = 50;
        int noDataI = 50;
        float noDataF = 50.0f;
        double noDataD = 50.0;
        testImages = new RenderedImage[7];
        IMAGE_FILLER = true;
        OrderedDitherTest.testImages[0] = OrderedDitherTest.createTestImage((int)0, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataB, (boolean)false, (int)1, (Number)64);
        OrderedDitherTest.testImages[6] = OrderedDitherTest.createTestImage((int)0, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataB, (boolean)false, (int)3, (Number)64);
        OrderedDitherTest.testImages[1] = OrderedDitherTest.createTestImage((int)1, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataS, (boolean)false, (int)1, (Number)8191);
        OrderedDitherTest.testImages[2] = OrderedDitherTest.createTestImage((int)2, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataS, (boolean)false, (int)1, (Number)-49);
        OrderedDitherTest.testImages[3] = OrderedDitherTest.createTestImage((int)3, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataI, (boolean)false, (int)1, (Number)105);
        OrderedDitherTest.testImages[4] = OrderedDitherTest.createTestImage((int)4, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)Float.valueOf(noDataF), (boolean)false, (int)1, (Number)Float.valueOf(635.0f));
        OrderedDitherTest.testImages[5] = OrderedDitherTest.createTestImage((int)5, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataD, (boolean)false, (int)1, (Number)468);
        IMAGE_FILLER = false;
        boolean minIncluded = true;
        boolean maxIncluded = true;
        noDataByte = RangeFactory.create((byte)noDataB, (boolean)minIncluded, (byte)noDataB, (boolean)maxIncluded);
        noDataUShort = RangeFactory.createU((short)noDataS, (boolean)minIncluded, (short)noDataS, (boolean)maxIncluded);
        noDataShort = RangeFactory.create((short)noDataS, (boolean)minIncluded, (short)noDataS, (boolean)maxIncluded);
        noDataInt = RangeFactory.create((int)noDataI, (boolean)minIncluded, (int)noDataI, (boolean)maxIncluded);
        noDataFloat = RangeFactory.create((float)noDataF, (boolean)minIncluded, (float)noDataF, (boolean)maxIncluded, (boolean)true);
        noDataDouble = RangeFactory.create((double)noDataD, (boolean)minIncluded, (double)noDataD, (boolean)maxIncluded, (boolean)true);
        Rectangle roiBounds = new Rectangle(5, 5, DEFAULT_WIDTH / 4, DEFAULT_HEIGHT / 4);
        roiObject = new ROIShape((Shape)roiBounds);
        destNoData = 10.0;
    }

    @Test
    public void testValidData() {
        boolean roiUsed = false;
        boolean noDataUsed = false;
        for (int i = 0; i < 6; ++i) {
            if (i == 0) {
                this.testType(testImages[i], noDataUsed, roiUsed, true, true);
                this.testType(testImages[i], noDataUsed, roiUsed, true, false);
            }
            this.testType(testImages[i], noDataUsed, roiUsed, false, false);
        }
    }

    @Test
    public void testRoi() {
        boolean roiUsed = true;
        boolean noDataUsed = false;
        for (int i = 0; i < 6; ++i) {
            if (i == 0) {
                this.testType(testImages[i], noDataUsed, roiUsed, true, true);
                this.testType(testImages[i], noDataUsed, roiUsed, true, false);
            }
            this.testType(testImages[i], noDataUsed, roiUsed, false, false);
        }
    }

    @Test
    public void testNoData() {
        boolean roiUsed = false;
        boolean noDataUsed = true;
        for (int i = 0; i < 6; ++i) {
            if (i == 0) {
                this.testType(testImages[i], noDataUsed, roiUsed, true, true);
                this.testType(testImages[i], noDataUsed, roiUsed, true, false);
            }
            this.testType(testImages[i], noDataUsed, roiUsed, false, false);
        }
    }

    @Test
    public void testRoiNoData() {
        boolean roiUsed = true;
        boolean noDataUsed = true;
        for (int i = 0; i < 6; ++i) {
            if (i == 0) {
                this.testType(testImages[i], noDataUsed, roiUsed, true, true);
                this.testType(testImages[i], noDataUsed, roiUsed, true, false);
            }
            this.testType(testImages[i], noDataUsed, roiUsed, false, false);
        }
    }

    private void testType(RenderedImage src, boolean nodataUsed, boolean roiUsed, boolean byteOptimized, boolean opt3p3) {
        Range noData;
        int dataType;
        block13: {
            block12: {
                if (byteOptimized && opt3p3) {
                    src = testImages[6];
                }
                dataType = src.getSampleModel().getDataType();
                if (!nodataUsed) break block12;
                switch (dataType) {
                    case 0: {
                        noData = noDataByte;
                        break block13;
                    }
                    case 1: {
                        noData = noDataUShort;
                        break block13;
                    }
                    case 2: {
                        noData = noDataShort;
                        break block13;
                    }
                    case 3: {
                        noData = noDataInt;
                        break block13;
                    }
                    case 4: {
                        noData = noDataFloat;
                        break block13;
                    }
                    case 5: {
                        noData = noDataDouble;
                        break block13;
                    }
                    default: {
                        throw new IllegalArgumentException("Wrong data type");
                    }
                }
            }
            noData = null;
        }
        Object roi = roiUsed ? roiObject : null;
        ColorCube colorMap = byteOptimized && opt3p3 ? ColorCube.BYTE_855 : ColorCube.createColorCube((int)dataType, (int[])new int[]{8});
        int numBands = src.getSampleModel().getNumBands();
        KernelJAI[] k = new KernelJAI[numBands];
        if (byteOptimized) {
            int width = 8;
            int height = 8;
            float[] data = new float[width * height];
            Arrays.fill(data, 0.5f);
            k[0] = new KernelJAI(width, height, data);
            if (opt3p3) {
                k[1] = new KernelJAI(width, height, data);
                k[2] = new KernelJAI(width, height, data);
            }
        } else {
            int width = 64;
            int height = 64;
            float[] data = new float[width * height];
            Arrays.fill(data, 0.5f);
            k[0] = new KernelJAI(width, height, data);
        }
        RenderedOp orderedDither = OrderedDitherDescriptor.create((RenderedImage)src, (ColorCube)colorMap, (KernelJAI[])k, null, (ROI)roi, (Range)noData, (Double)(destNoData + (double)colorMap.getAdjustedOffset()));
        this.checkNoDataROI(orderedDither, src, (ROI)roi, noData, colorMap);
        orderedDither.dispose();
    }

    private void checkNoDataROI(RenderedOp finalimage, RenderedImage image, ROI roi, Range nodata, ColorCube colorCube) {
        boolean nodataExists;
        Assert.assertEquals((long)finalimage.getMinX(), (long)image.getMinX());
        Assert.assertEquals((long)finalimage.getMinY(), (long)image.getMinY());
        Assert.assertEquals((long)finalimage.getWidth(), (long)image.getWidth());
        Assert.assertEquals((long)finalimage.getHeight(), (long)image.getHeight());
        boolean roiExists = roi != null;
        boolean bl = nodataExists = nodata != null;
        if (!nodataExists && !roiExists) {
            finalimage.getTiles();
        }
        if (nodataExists) {
            nodata = RangeFactory.convertToDoubleRange((Range)nodata);
        }
        RandomIter roiIter = null;
        Rectangle roiBounds = null;
        if (roiExists) {
            PlanarImage roiIMG = roi.getAsImage();
            roiIter = RandomIterFactory.create((RenderedImage)roiIMG, (Rectangle)finalimage.getBounds(), (boolean)true, (boolean)true);
            roiBounds = roi.getBounds();
        }
        RandomIter sourceIter = RandomIterFactory.create((RenderedImage)image, null, (boolean)true, (boolean)true);
        RandomIter destIter = RandomIterFactory.create((RenderedImage)finalimage, null, (boolean)true, (boolean)true);
        int w = image.getWidth();
        int h = image.getHeight();
        int minX = image.getMinX();
        int minY = image.getMinY();
        int maxX = minX + w;
        int maxY = minY + h;
        double noDataValue = destNoData + (double)colorCube.getAdjustedOffset();
        for (int y = minY; y < maxY; ++y) {
            for (int x = minX; x < maxX; ++x) {
                double src = sourceIter.getSampleDouble(x, y, 0);
                double dest = destIter.getSampleDouble(x, y, 0);
                boolean valid = true;
                if (roiExists && (!roiBounds.contains(x, y) || roiIter.getSample(x, y, 0) <= 0)) {
                    valid = false;
                }
                if (nodataExists && nodata.contains(src)) {
                    valid = false;
                }
                if (valid) continue;
                Assert.assertEquals((double)noDataValue, (double)dest, (double)0.01);
            }
        }
    }
}

