/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.mosaic;

import it.geosolutions.jaiext.mosaic.RasterAccessorExt;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.range.RangeInt;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import javax.media.jai.RasterFormatTag;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class RasterAccessorExtTest {
    @Test
    public void testExpandOpenRange() {
        BufferedImage byteGray = new BufferedImage(10, 10, 10);
        BufferedImage ushortGray = new BufferedImage(10, 10, 11);
        RasterFormatTag[] tags = RasterAccessorExt.findCompatibleTags((RenderedImage[])new RenderedImage[]{byteGray}, (RenderedImage)ushortGray);
        Range range = RangeFactory.create((float)Float.NEGATIVE_INFINITY, (boolean)false, (float)1.0f, (boolean)false);
        Range expanded = RasterAccessorExt.expandNoData((Range)range, (RasterFormatTag)tags[0], (RenderedImage)byteGray, (RenderedImage)ushortGray);
        Assert.assertThat((Object)expanded, (Matcher)CoreMatchers.instanceOf(RangeInt.class));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)expanded.getMin().intValue());
        Assert.assertFalse((boolean)expanded.isMinIncluded());
        Assert.assertEquals((long)257L, (long)expanded.getMax().intValue());
        Assert.assertFalse((boolean)expanded.isMaxIncluded());
    }

    @Test
    public void testPreserveScanlineStride() {
        BufferedImage byteGray = new BufferedImage(10, 10, 10);
        BufferedImage rgb = new BufferedImage(10, 10, 5);
        BufferedImage subimage = byteGray.getSubimage(5, 5, 5, 5);
        RasterFormatTag[] tags = RasterAccessorExt.findCompatibleTags((RenderedImage[])new RenderedImage[]{subimage}, (RenderedImage)rgb);
        Raster raster = subimage.getData();
        RasterAccessorExt ra = new RasterAccessorExt(raster, raster.getBounds(), tags[0], subimage.getColorModel(), 3, 0);
        Assert.assertEquals((long)10L, (long)ra.getScanlineStride());
    }
}

