/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.mosaic;

import it.geosolutions.jaiext.mosaic.MosaicDescriptor;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.testclasses.TestBase;
import it.geosolutions.rendered.viewer.RenderedImageBrowser;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.io.IOException;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.MosaicType;
import javax.media.jai.operator.NullDescriptor;
import javax.media.jai.operator.TranslateDescriptor;
import org.junit.Assert;
import org.junit.Test;

public class MosaicTestImage
extends TestBase {
    private static final boolean INTERACTIVE = Boolean.getBoolean("JAI.Ext.Interactive");
    private static final boolean OLD_DESCRIPTOR = Boolean.getBoolean("JAI.Ext.OldDescriptor");

    public static RenderedImage getSyntheticByte(byte value) {
        float width = 256.0f;
        float height = 256.0f;
        ParameterBlock pb = new ParameterBlock();
        Byte[] array = new Byte[]{value};
        pb.add(256.0f);
        pb.add(256.0f);
        pb.add(array);
        return JAI.create((String)"constant", (ParameterBlock)pb);
    }

    @Test
    public void testOldMosaicOperation() {
        if (!OLD_DESCRIPTOR) {
            this.testSimpleMosaicOperation(OLD_DESCRIPTOR);
        }
    }

    @Test
    public void testNewMosaicOperation() {
        if (OLD_DESCRIPTOR) {
            this.testSimpleMosaicOperation(!OLD_DESCRIPTOR);
        }
    }

    public void testSimpleMosaicOperation(boolean oldDescriptor) {
        RenderedImage image1 = MosaicTestImage.getSyntheticByte((byte)99);
        RenderedImage image2 = MosaicTestImage.getSyntheticByte((byte)50);
        int width = image1.getWidth();
        ImageLayout layout = new ImageLayout(0, 0, image1.getWidth() + image2.getWidth(), image1.getHeight());
        RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        double[] background = new double[]{0.0};
        double[][] threshold = new double[][]{{0.0}, {0.0}};
        RenderedOp image3 = TranslateDescriptor.create((RenderedImage)image1, (Float)Float.valueOf((float)width * 0.1f), (Float)Float.valueOf(0.0f), null, (RenderingHints)hints);
        RenderedOp image4 = NullDescriptor.create((RenderedImage)image2, (RenderingHints)hints);
        RenderedImage[] sources = new RenderedImage[]{image4, image3};
        RenderedOp image5 = !oldDescriptor ? MosaicDescriptor.create((RenderedImage[])sources, (MosaicType)javax.media.jai.operator.MosaicDescriptor.MOSAIC_TYPE_OVERLAY, null, null, (double[][])null, (double[])background, null, (RenderingHints)hints) : javax.media.jai.operator.MosaicDescriptor.create((RenderedImage[])sources, (MosaicType)javax.media.jai.operator.MosaicDescriptor.MOSAIC_TYPE_OVERLAY, null, null, (double[][])threshold, (double[])background, (RenderingHints)hints);
        if (INTERACTIVE) {
            RenderedImageBrowser.showChain((RenderedImage)image5, (boolean)false, (boolean)false);
            try {
                System.out.println("Press a Key when done");
                System.in.read();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (image5 instanceof RenderedOp) {
            image5.dispose();
        }
    }

    @Test
    public void testAggregatedNoData() {
        int w = 32;
        int h = 64;
        int halfValue = 128;
        int quarterValue = 64;
        int[] topLeftAreaPixels = new int[]{64, 128, 0};
        int[] bottomLeftAreaPixels = new int[]{0, 0, 0};
        BufferedImage image1 = new BufferedImage(32, 64, 5);
        WritableRaster raster = image1.getRaster();
        this.fillRaster(raster, 0, 32, 32, 32, bottomLeftAreaPixels);
        this.fillRaster(raster, 0, 0, 32, 32, topLeftAreaPixels);
        int[] topRightAreaPixels = new int[]{128, 0, 0};
        int[] bottomRightAreaPixels = new int[]{0, 64, 128};
        BufferedImage bi2 = new BufferedImage(32, 64, 5);
        WritableRaster raster2 = bi2.getRaster();
        this.fillRaster(raster2, 0, 0, 32, 32, topRightAreaPixels);
        this.fillRaster(raster2, 0, 32, 32, 32, bottomRightAreaPixels);
        RenderedOp image2 = TranslateDescriptor.create((RenderedImage)bi2, (Float)Float.valueOf(32.0f), (Float)Float.valueOf(0.0f), null, null);
        RenderedImage[] sources = new RenderedImage[]{image1, image2};
        double[] background = new double[]{255.0, 255.0, 255.0};
        Range noDataByte = RangeFactory.create((int)0, (int)0);
        Range[] noData = new Range[]{noDataByte, noDataByte};
        RenderedOp mosaic = MosaicDescriptor.create((RenderedImage[])sources, (MosaicType)javax.media.jai.operator.MosaicDescriptor.MOSAIC_TYPE_OVERLAY, null, null, (double[][])null, (double[])background, (Range[])noData, null);
        int[] destPixel = new int[3];
        if (INTERACTIVE) {
            RenderedImageBrowser.showChain((RenderedImage)mosaic, (boolean)false, (boolean)false);
            try {
                System.out.println("Press a Key when done");
                System.in.read();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Raster rasterDest = mosaic.getData();
        for (int k = 0; k < 3; ++k) {
            rasterDest.getPixel(0, 32, destPixel);
            Assert.assertTrue(((int)background[k] == destPixel[k] ? 1 : 0) != 0);
        }
        this.checkRasterArea(rasterDest, 0, 0, 32, 32, topLeftAreaPixels, destPixel);
        this.checkRasterArea(rasterDest, 32, 32, 32, 32, bottomRightAreaPixels, destPixel);
        this.checkRasterArea(rasterDest, 32, 0, 32, 32, topRightAreaPixels, destPixel);
    }

    private void checkRasterArea(Raster rasterDest, int x, int y, int w, int h, int[] expectedPixel, int[] destPixel) {
        for (int j = y; j < y + h; ++j) {
            for (int i = x; i < x + w; ++i) {
                rasterDest.getPixel(i, j, destPixel);
                Assert.assertArrayEquals((int[])expectedPixel, (int[])destPixel);
            }
        }
    }

    private void fillRaster(WritableRaster raster, int x, int y, int w, int h, int[] pixel) {
        for (int j = y; j < y + h; ++j) {
            for (int i = x; i < x + w; ++i) {
                raster.setPixel(i, j, pixel);
            }
        }
    }
}

