/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.mosaic;

import it.geosolutions.jaiext.JAIExt;
import it.geosolutions.jaiext.mosaic.MosaicDescriptor;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.testclasses.TestBase;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.function.BiFunction;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;
import javax.media.jai.TiledImage;
import javax.media.jai.operator.BandSelectDescriptor;
import javax.media.jai.operator.MosaicType;
import javax.media.jai.operator.TranslateDescriptor;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class HererogeneousMosaicTest {
    @BeforeClass
    public static void setupJaiExt() {
        JAIExt.initJAIEXT();
    }

    @Test
    public void testBGRIndexed() {
        BufferedImage redIndexed = this.buildIndexed(Color.RED);
        RenderedOp redIndexedTranslated = TranslateDescriptor.create((RenderedImage)redIndexed, (Float)Float.valueOf(50.0f), (Float)Float.valueOf(0.0f), (Interpolation)new InterpolationNearest(), null);
        BufferedImage whiteAbgr = this.buildBGR(Color.WHITE);
        RenderedOp mosaic = MosaicDescriptor.create((RenderedImage[])new RenderedImage[]{whiteAbgr, redIndexedTranslated}, (MosaicType)javax.media.jai.operator.MosaicDescriptor.MOSAIC_TYPE_OVERLAY, null, null, (double[][])null, null, null, null);
        this.checkMixedWhiteRed(mosaic);
    }

    @Test
    public void testIndexedBinary() {
        BufferedImage redIndexed = this.buildIndexed(Color.RED);
        RenderedOp redIndexedTranslated = TranslateDescriptor.create((RenderedImage)redIndexed, (Float)Float.valueOf(50.0f), (Float)Float.valueOf(0.0f), (Interpolation)new InterpolationNearest(), null);
        BufferedImage whiteBinary = this.buildBinary(Color.WHITE);
        RenderedOp mosaic = MosaicDescriptor.create((RenderedImage[])new RenderedImage[]{whiteBinary, redIndexedTranslated}, (MosaicType)javax.media.jai.operator.MosaicDescriptor.MOSAIC_TYPE_OVERLAY, null, null, (double[][])null, null, null, null);
        this.checkMixedWhiteRed(mosaic);
    }

    @Test
    public void testBinaryBGR() {
        BufferedImage redIndexed = this.buildIndexed(Color.RED);
        RenderedOp redIndexedTranslated = TranslateDescriptor.create((RenderedImage)redIndexed, (Float)Float.valueOf(50.0f), (Float)Float.valueOf(0.0f), (Interpolation)new InterpolationNearest(), null);
        BufferedImage whiteBinary = this.buildBinary(Color.WHITE);
        RenderedOp mosaic = MosaicDescriptor.create((RenderedImage[])new RenderedImage[]{redIndexedTranslated, whiteBinary}, (MosaicType)javax.media.jai.operator.MosaicDescriptor.MOSAIC_TYPE_OVERLAY, null, null, (double[][])null, null, null, null);
        this.checkMixedRedWhite(mosaic);
    }

    @Test
    public void testIndexedBGR() {
        BufferedImage redIndexed = this.buildIndexed(Color.RED);
        RenderedOp redIndexedTranslated = TranslateDescriptor.create((RenderedImage)redIndexed, (Float)Float.valueOf(50.0f), (Float)Float.valueOf(0.0f), (Interpolation)new InterpolationNearest(), null);
        BufferedImage whiteAbgr = this.buildBGR(Color.WHITE);
        RenderedOp mosaic = MosaicDescriptor.create((RenderedImage[])new RenderedImage[]{redIndexedTranslated, whiteAbgr}, (MosaicType)javax.media.jai.operator.MosaicDescriptor.MOSAIC_TYPE_OVERLAY, null, null, (double[][])null, null, null, null);
        this.checkMixedRedWhite(mosaic);
    }

    @Test
    public void testBinaryIndexed() {
        BufferedImage redIndexed = this.buildIndexed(Color.RED);
        RenderedOp redIndexedTranslated = TranslateDescriptor.create((RenderedImage)redIndexed, (Float)Float.valueOf(50.0f), (Float)Float.valueOf(0.0f), (Interpolation)new InterpolationNearest(), null);
        BufferedImage whiteBinary = this.buildBinary(Color.WHITE);
        RenderedOp mosaic = MosaicDescriptor.create((RenderedImage[])new RenderedImage[]{redIndexedTranslated, whiteBinary}, (MosaicType)javax.media.jai.operator.MosaicDescriptor.MOSAIC_TYPE_OVERLAY, null, null, (double[][])null, null, null, null);
        this.checkMixedRedWhite(mosaic);
    }

    @Test
    public void testRGBGray() {
        BufferedImage blueRgb = this.buildBGR(Color.BLUE);
        RenderedOp blueRgbTranslated = TranslateDescriptor.create((RenderedImage)blueRgb, (Float)Float.valueOf(50.0f), (Float)Float.valueOf(0.0f), (Interpolation)new InterpolationNearest(), null);
        BufferedImage gray = this.buildByteGray(Color.GRAY);
        RenderedOp mosaic = MosaicDescriptor.create((RenderedImage[])new RenderedImage[]{blueRgbTranslated, gray}, (MosaicType)javax.media.jai.operator.MosaicDescriptor.MOSAIC_TYPE_OVERLAY, null, null, (double[][])null, null, null, null);
        this.assertRGB(mosaic, false);
        this.assertExtent(mosaic, 0, 0, 150, 100);
        int[] pixel = new int[3];
        mosaic.getData().getPixel(10, 10, pixel);
        Assert.assertArrayEquals((int[])new int[]{128, 128, 128}, (int[])pixel);
        mosaic.getData().getPixel(60, 10, pixel);
        Assert.assertArrayEquals((int[])new int[]{0, 0, 255}, (int[])pixel);
    }

    @Test
    public void testIndexedGray() {
        BufferedImage blueIndexed = this.buildIndexed(Color.BLUE);
        RenderedOp blueIndexedTranslated = TranslateDescriptor.create((RenderedImage)blueIndexed, (Float)Float.valueOf(50.0f), (Float)Float.valueOf(0.0f), (Interpolation)new InterpolationNearest(), null);
        BufferedImage gray = this.buildByteGray(Color.GRAY);
        RenderedOp mosaic = MosaicDescriptor.create((RenderedImage[])new RenderedImage[]{blueIndexedTranslated, gray}, (MosaicType)javax.media.jai.operator.MosaicDescriptor.MOSAIC_TYPE_OVERLAY, null, null, (double[][])null, null, null, null);
        this.assertRGB(mosaic, false);
        this.assertExtent(mosaic, 0, 0, 150, 100);
        int[] pixel = new int[3];
        mosaic.getData().getPixel(10, 10, pixel);
        Assert.assertArrayEquals((int[])new int[]{128, 128, 128}, (int[])pixel);
        mosaic.getData().getPixel(60, 10, pixel);
        Assert.assertArrayEquals((int[])new int[]{0, 0, 255}, (int[])pixel);
    }

    @Test
    public void testGrayIndexed() {
        BufferedImage blueIndexed = this.buildIndexed(Color.BLUE);
        RenderedOp blueIndexedTranslated = TranslateDescriptor.create((RenderedImage)blueIndexed, (Float)Float.valueOf(50.0f), (Float)Float.valueOf(0.0f), (Interpolation)new InterpolationNearest(), null);
        BufferedImage gray = this.buildByteGray(Color.GRAY);
        RenderedOp mosaic = MosaicDescriptor.create((RenderedImage[])new RenderedImage[]{gray, blueIndexedTranslated}, (MosaicType)javax.media.jai.operator.MosaicDescriptor.MOSAIC_TYPE_OVERLAY, null, null, (double[][])null, null, null, null);
        this.assertRGB(mosaic, false);
        this.assertExtent(mosaic, 0, 0, 150, 100);
        int[] pixel = new int[3];
        mosaic.getData().getPixel(10, 10, pixel);
        Assert.assertArrayEquals((int[])new int[]{128, 128, 128}, (int[])pixel);
        mosaic.getData().getPixel(120, 10, pixel);
        Assert.assertArrayEquals((int[])new int[]{0, 0, 255}, (int[])pixel);
    }

    @Test
    public void testGrayRGB() {
        BufferedImage blueRgb = this.buildBGR(Color.BLUE);
        RenderedOp blueRgbTranslated = TranslateDescriptor.create((RenderedImage)blueRgb, (Float)Float.valueOf(50.0f), (Float)Float.valueOf(0.0f), (Interpolation)new InterpolationNearest(), null);
        BufferedImage gray = this.buildByteGray(Color.GRAY);
        RenderedOp mosaic = MosaicDescriptor.create((RenderedImage[])new RenderedImage[]{gray, blueRgbTranslated}, (MosaicType)javax.media.jai.operator.MosaicDescriptor.MOSAIC_TYPE_OVERLAY, null, null, (double[][])null, null, null, null);
        this.assertRGB(mosaic, false);
        this.assertExtent(mosaic, 0, 0, 150, 100);
        int[] pixel = new int[3];
        mosaic.getData().getPixel(10, 10, pixel);
        Assert.assertArrayEquals((int[])new int[]{128, 128, 128}, (int[])pixel);
        mosaic.getData().getPixel(120, 10, pixel);
        Assert.assertArrayEquals((int[])new int[]{0, 0, 255}, (int[])pixel);
    }

    @Test
    public void testGrayAlphaRGBA() {
        BufferedImage blueArgb = this.buildABGR(Color.BLUE);
        RenderedOp blueRgbTranslated = TranslateDescriptor.create((RenderedImage)blueArgb, (Float)Float.valueOf(50.0f), (Float)Float.valueOf(0.0f), (Interpolation)new InterpolationNearest(), null);
        RenderedImage grayAlpha = this.buildByteGrayAlpha(Color.GRAY);
        RenderedOp mosaic = MosaicDescriptor.create((RenderedImage[])new RenderedImage[]{grayAlpha, blueRgbTranslated}, (MosaicType)javax.media.jai.operator.MosaicDescriptor.MOSAIC_TYPE_OVERLAY, (PlanarImage[])new PlanarImage[]{this.getAlpha(grayAlpha), this.getAlpha((RenderedImage)blueRgbTranslated)}, null, (double[][])null, null, null, null);
        this.assertRGB(mosaic, true);
        this.assertExtent(mosaic, 0, 0, 150, 100);
        int[] pixel = new int[4];
        mosaic.getData().getPixel(10, 10, pixel);
        Assert.assertArrayEquals((int[])new int[]{55, 55, 55, 255}, (int[])pixel);
        mosaic.getData().getPixel(120, 10, pixel);
        Assert.assertArrayEquals((int[])new int[]{0, 0, 255, 255}, (int[])pixel);
    }

    @Test
    public void testGrayRGBA() {
        BufferedImage blueArgb = this.buildABGR(Color.BLUE);
        RenderedOp blueRgbTranslated = TranslateDescriptor.create((RenderedImage)blueArgb, (Float)Float.valueOf(50.0f), (Float)Float.valueOf(0.0f), (Interpolation)new InterpolationNearest(), null);
        BufferedImage grayAlpha = this.buildByteGray(Color.GRAY);
        RenderedOp mosaic = MosaicDescriptor.create((RenderedImage[])new RenderedImage[]{grayAlpha, blueRgbTranslated}, (MosaicType)javax.media.jai.operator.MosaicDescriptor.MOSAIC_TYPE_OVERLAY, (PlanarImage[])new PlanarImage[]{this.getAlpha(grayAlpha), this.getAlpha((RenderedImage)blueRgbTranslated)}, null, (double[][])null, null, null, null);
        this.assertRGB(mosaic, true);
        this.assertExtent(mosaic, 0, 0, 150, 100);
        int[] pixel = new int[4];
        mosaic.getData().getPixel(10, 10, pixel);
        Assert.assertArrayEquals((int[])new int[]{128, 128, 128, 255}, (int[])pixel);
        mosaic.getData().getPixel(120, 10, pixel);
        Assert.assertArrayEquals((int[])new int[]{0, 0, 255, 255}, (int[])pixel);
    }

    @Test
    public void testBGROpaqueAlpha() {
        BufferedImage blueArgb = this.buildABGR(Color.BLUE);
        RenderedOp blueRgbTranslated = TranslateDescriptor.create((RenderedImage)blueArgb, (Float)Float.valueOf(50.0f), (Float)Float.valueOf(0.0f), (Interpolation)new InterpolationNearest(), null);
        BufferedImage redRGB = this.buildBGR(Color.RED);
        RenderedOp mosaic = MosaicDescriptor.create((RenderedImage[])new RenderedImage[]{redRGB, blueRgbTranslated}, (MosaicType)javax.media.jai.operator.MosaicDescriptor.MOSAIC_TYPE_OVERLAY, (PlanarImage[])new PlanarImage[]{this.getAlpha(redRGB), this.getAlpha((RenderedImage)blueRgbTranslated)}, null, (double[][])null, null, null, null);
        this.assertRGB(mosaic, true);
        this.assertExtent(mosaic, 0, 0, 150, 100);
        int[] pixel = new int[4];
        mosaic.getData().getPixel(10, 10, pixel);
        Assert.assertArrayEquals((int[])new int[]{255, 0, 0, 255}, (int[])pixel);
        mosaic.getData().getPixel(120, 10, pixel);
        Assert.assertArrayEquals((int[])new int[]{0, 0, 255, 255}, (int[])pixel);
    }

    private PlanarImage getAlpha(RenderedImage image) {
        if (image.getColorModel().hasAlpha()) {
            int[] retained = new int[]{image.getSampleModel().getNumBands() - 1};
            return BandSelectDescriptor.create((RenderedImage)image, (int[])retained, null);
        }
        return null;
    }

    @Test
    public void testGrayByteShort() {
        BufferedImage white = this.buildByteGray(Color.WHITE);
        RenderedOp whiteTranslated = TranslateDescriptor.create((RenderedImage)white, (Float)Float.valueOf(50.0f), (Float)Float.valueOf(0.0f), (Interpolation)new InterpolationNearest(), null);
        BufferedImage ushortGray = this.buildUShortGray(Color.GRAY);
        RenderedOp mosaic = MosaicDescriptor.create((RenderedImage[])new RenderedImage[]{whiteTranslated, ushortGray}, (MosaicType)javax.media.jai.operator.MosaicDescriptor.MOSAIC_TYPE_OVERLAY, null, null, (double[][])null, null, null, null);
        this.assertGray(mosaic, 1);
        this.assertExtent(mosaic, 0, 0, 150, 100);
        int[] pixel = new int[1];
        mosaic.getData().getPixel(10, 10, pixel);
        Assert.assertArrayEquals((int[])new int[]{32896}, (int[])pixel);
        mosaic.getData().getPixel(120, 10, pixel);
        Assert.assertArrayEquals((int[])new int[]{65535}, (int[])pixel);
    }

    @Test
    public void testGrayShortRGB() {
        BufferedImage gray = this.buildUShortGray(Color.GRAY);
        RenderedOp grayTranslated = TranslateDescriptor.create((RenderedImage)gray, (Float)Float.valueOf(50.0f), (Float)Float.valueOf(0.0f), (Interpolation)new InterpolationNearest(), null);
        BufferedImage blue = this.buildBGR(Color.BLUE);
        RenderedOp mosaic = MosaicDescriptor.create((RenderedImage[])new RenderedImage[]{grayTranslated, blue}, (MosaicType)javax.media.jai.operator.MosaicDescriptor.MOSAIC_TYPE_OVERLAY, null, null, (double[][])null, null, null, null);
        this.assertRGB(mosaic, false);
        this.assertExtent(mosaic, 0, 0, 150, 100);
        int[] pixel = new int[3];
        mosaic.getData().getPixel(10, 10, pixel);
        Assert.assertArrayEquals((int[])new int[]{0, 0, 255}, (int[])pixel);
        mosaic.getData().getPixel(120, 10, pixel);
        Assert.assertArrayEquals((int[])new int[]{128, 128, 128}, (int[])pixel);
    }

    @Test
    public void testEteroPalettes() {
        BufferedImage blueIndexed = this.buildIndexed(Color.BLUE, Color.BLUE, Color.GREEN, Color.WHITE);
        BufferedImage whiteIndexed = this.buildIndexed(Color.WHITE, Color.GRAY, Color.GREEN, Color.WHITE);
        RenderedOp blueIndexedTranslated = TranslateDescriptor.create((RenderedImage)blueIndexed, (Float)Float.valueOf(50.0f), (Float)Float.valueOf(0.0f), (Interpolation)new InterpolationNearest(), null);
        RenderedOp mosaic = MosaicDescriptor.create((RenderedImage[])new RenderedImage[]{whiteIndexed, blueIndexedTranslated}, (MosaicType)javax.media.jai.operator.MosaicDescriptor.MOSAIC_TYPE_OVERLAY, null, null, (double[][])null, null, null, null);
        this.assertRGB(mosaic, false);
        this.assertExtent(mosaic, 0, 0, 150, 100);
        int[] pixel = new int[3];
        mosaic.getData().getPixel(10, 10, pixel);
        Assert.assertArrayEquals((int[])new int[]{255, 255, 255}, (int[])pixel);
        mosaic.getData().getPixel(120, 10, pixel);
        Assert.assertArrayEquals((int[])new int[]{0, 0, 255}, (int[])pixel);
    }

    @Test
    public void testGrayFloatDouble() {
        this.assertFloatDouble((zeroFloatTranslated, oneDouble) -> MosaicDescriptor.create((RenderedImage[])new RenderedImage[]{zeroFloatTranslated, oneDouble}, (MosaicType)javax.media.jai.operator.MosaicDescriptor.MOSAIC_TYPE_OVERLAY, null, null, (double[][])null, null, null, null));
    }

    @Test
    public void testGrayDoubleFloat() {
        this.assertFloatDouble((zeroFloatTranslated, oneDouble) -> MosaicDescriptor.create((RenderedImage[])new RenderedImage[]{oneDouble, zeroFloatTranslated}, (MosaicType)javax.media.jai.operator.MosaicDescriptor.MOSAIC_TYPE_OVERLAY, null, null, (double[][])null, null, null, null));
    }

    private void assertFloatDouble(BiFunction<RenderedOp, RenderedImage, RenderedOp> mosaicImages) {
        RenderedImage zeroFloat = TestBase.createTestImage((int)4, (int)100, (int)100, null, (boolean)false, (int)1, (Number)Float.valueOf(0.0f));
        RenderedOp zeroFloatTranslated = TranslateDescriptor.create((RenderedImage)zeroFloat, (Float)Float.valueOf(50.0f), (Float)Float.valueOf(0.0f), (Interpolation)new InterpolationNearest(), null);
        RenderedImage oneDouble = TestBase.createTestImage((int)5, (int)100, (int)100, null, (boolean)false, (int)1, (Number)1.0);
        RenderedOp mosaic = mosaicImages.apply(zeroFloatTranslated, oneDouble);
        this.assertGray(mosaic, 5);
        this.assertExtent(mosaic, 0, 0, 150, 100);
        double[] pixel = new double[1];
        mosaic.getData().getPixel(10, 10, pixel);
        Assert.assertArrayEquals((double[])new double[]{1.0}, (double[])pixel, (double)0.0);
        mosaic.getData().getPixel(120, 10, pixel);
        Assert.assertArrayEquals((double[])new double[]{0.0}, (double[])pixel, (double)0.0);
    }

    @Test
    public void testSamePalettes() {
        BufferedImage blueIndexed = this.buildIndexed(Color.BLUE, Color.BLUE, Color.GREEN, Color.WHITE);
        BufferedImage greenIndexed = this.buildIndexed(Color.GREEN, Color.BLUE, Color.GREEN, Color.WHITE);
        RenderedOp blueIndexedTranslated = TranslateDescriptor.create((RenderedImage)blueIndexed, (Float)Float.valueOf(50.0f), (Float)Float.valueOf(0.0f), (Interpolation)new InterpolationNearest(), null);
        RenderedOp mosaic = MosaicDescriptor.create((RenderedImage[])new RenderedImage[]{greenIndexed, blueIndexedTranslated}, (MosaicType)javax.media.jai.operator.MosaicDescriptor.MOSAIC_TYPE_OVERLAY, null, null, (double[][])null, null, null, null);
        this.assertByteIndexed(mosaic);
        this.assertExtent(mosaic, 0, 0, 150, 100);
        int[] pixel = new int[1];
        mosaic.getData().getPixel(10, 10, pixel);
        Assert.assertArrayEquals((int[])new int[]{1}, (int[])pixel);
        mosaic.getData().getPixel(120, 10, pixel);
        Assert.assertArrayEquals((int[])new int[]{0}, (int[])pixel);
    }

    @Test
    public void testIndexedNoDataRBG() {
        IndexColorModel icm = this.buildIndexColorModel(Color.BLUE, Color.RED);
        BufferedImage bi = new BufferedImage(100, 100, 13, icm);
        Graphics2D gr = bi.createGraphics();
        gr.setColor(Color.BLUE);
        gr.fillRect(0, 0, 50, 100);
        gr.setColor(Color.RED);
        gr.fillRect(50, 0, 50, 100);
        gr.dispose();
        BufferedImage biROI = new BufferedImage(100, 100, 12);
        gr = biROI.createGraphics();
        gr.setColor(Color.BLACK);
        gr.fillRect(0, 0, 100, 50);
        gr.setColor(Color.WHITE);
        gr.fillRect(0, 50, 100, 50);
        gr.dispose();
        BufferedImage yellow = this.buildBGR(Color.YELLOW);
        RenderedOp mosaic = MosaicDescriptor.create((RenderedImage[])new RenderedImage[]{bi, yellow}, (MosaicType)javax.media.jai.operator.MosaicDescriptor.MOSAIC_TYPE_OVERLAY, null, (ROI[])new ROI[]{new ROI((RenderedImage)biROI), null}, (double[][])null, null, (Range[])new Range[]{RangeFactory.create((byte)0, (byte)0), null}, null);
        this.assertRGB(mosaic, false);
        int[] pixel = new int[3];
        mosaic.getData().getPixel(10, 10, pixel);
        Assert.assertArrayEquals((int[])new int[]{255, 255, 0}, (int[])pixel);
        mosaic.getData().getPixel(75, 10, pixel);
        Assert.assertArrayEquals((int[])new int[]{255, 255, 0}, (int[])pixel);
        mosaic.getData().getPixel(25, 75, pixel);
        Assert.assertArrayEquals((int[])new int[]{255, 255, 0}, (int[])pixel);
        mosaic.getData().getPixel(75, 75, pixel);
        Assert.assertArrayEquals((int[])new int[]{255, 0, 0}, (int[])pixel);
    }

    @Test
    public void testTwoIndexedNoSameNoData() {
        IndexColorModel icm = this.buildIndexColorModel(Color.BLUE, Color.RED);
        BufferedImage splitVertical = new BufferedImage(100, 100, 13, icm);
        Graphics2D gr = splitVertical.createGraphics();
        gr.setColor(Color.BLUE);
        gr.fillRect(0, 0, 50, 100);
        gr.setColor(Color.RED);
        gr.fillRect(50, 0, 50, 100);
        gr.dispose();
        BufferedImage splitHorizontal = new BufferedImage(100, 100, 13, icm);
        gr = splitHorizontal.createGraphics();
        gr.setColor(Color.BLUE);
        gr.fillRect(0, 0, 100, 50);
        gr.setColor(Color.RED);
        gr.fillRect(0, 50, 100, 50);
        gr.dispose();
        Range noDataBlue = RangeFactory.create((byte)0, (byte)0);
        Range noDataRed = RangeFactory.create((byte)1, (byte)1);
        RenderedOp mosaic = MosaicDescriptor.create((RenderedImage[])new RenderedImage[]{splitVertical, splitHorizontal}, (MosaicType)javax.media.jai.operator.MosaicDescriptor.MOSAIC_TYPE_OVERLAY, null, null, (double[][])null, (double[])new double[]{0.0, 0.0, 0.0}, (Range[])new Range[]{noDataBlue, noDataRed}, null);
        this.assertRGB(mosaic, false);
        int[] pixel = new int[3];
        mosaic.getData().getPixel(10, 10, pixel);
        Assert.assertArrayEquals((int[])new int[]{0, 0, 255}, (int[])pixel);
        mosaic.getData().getPixel(75, 10, pixel);
        Assert.assertArrayEquals((int[])new int[]{255, 0, 0}, (int[])pixel);
        mosaic.getData().getPixel(25, 75, pixel);
        Assert.assertArrayEquals((int[])new int[]{0, 0, 0}, (int[])pixel);
        mosaic.getData().getPixel(75, 75, pixel);
        Assert.assertArrayEquals((int[])new int[]{255, 0, 0}, (int[])pixel);
    }

    @Test
    public void testTwoIndexedSameNoData() {
        IndexColorModel icm = this.buildIndexColorModel(Color.BLUE, Color.RED);
        BufferedImage splitVertical = new BufferedImage(100, 100, 13, icm);
        Graphics2D gr = splitVertical.createGraphics();
        gr.setColor(Color.BLUE);
        gr.fillRect(0, 0, 50, 100);
        gr.setColor(Color.RED);
        gr.fillRect(50, 0, 50, 100);
        gr.dispose();
        BufferedImage splitHorizontal = new BufferedImage(100, 100, 13, icm);
        gr = splitHorizontal.createGraphics();
        gr.setColor(Color.BLUE);
        gr.fillRect(0, 0, 100, 50);
        gr.setColor(Color.RED);
        gr.fillRect(0, 50, 100, 50);
        gr.dispose();
        Range noDataBlue = RangeFactory.create((byte)0, (byte)0);
        RenderedOp mosaic = MosaicDescriptor.create((RenderedImage[])new RenderedImage[]{splitVertical, splitHorizontal}, (MosaicType)javax.media.jai.operator.MosaicDescriptor.MOSAIC_TYPE_OVERLAY, null, null, (double[][])null, null, (Range[])new Range[]{noDataBlue, noDataBlue}, null);
        this.assertByteIndexed(mosaic);
        int[] pixel = new int[1];
        mosaic.getData().getPixel(10, 10, pixel);
        Assert.assertArrayEquals((int[])new int[]{0}, (int[])pixel);
        mosaic.getData().getPixel(75, 10, pixel);
        Assert.assertArrayEquals((int[])new int[]{1}, (int[])pixel);
        mosaic.getData().getPixel(25, 75, pixel);
        Assert.assertArrayEquals((int[])new int[]{1}, (int[])pixel);
        mosaic.getData().getPixel(75, 75, pixel);
        Assert.assertArrayEquals((int[])new int[]{1}, (int[])pixel);
    }

    @Test
    public void testGrayExpandNoData() {
        BufferedImage im8bit = new BufferedImage(100, 100, 10);
        WritableRaster raster8bit = im8bit.getRaster();
        int[] fill = new int[5000];
        Arrays.fill(fill, 10);
        raster8bit.setSamples(0, 0, 50, 100, 0, fill);
        Arrays.fill(fill, 50);
        raster8bit.setSamples(50, 0, 50, 100, 0, fill);
        BufferedImage im16bit = new BufferedImage(100, 100, 11);
        WritableRaster raster16bit = im16bit.getRaster();
        Arrays.fill(fill, 1000);
        raster16bit.setSamples(0, 0, 100, 50, 0, fill);
        Arrays.fill(fill, 30000);
        raster16bit.setSamples(0, 50, 100, 50, 0, fill);
        Range noData10 = RangeFactory.create((byte)10, (byte)10);
        Range noData1000 = RangeFactory.create((int)1000, (int)1000);
        RenderedOp mosaic = MosaicDescriptor.create((RenderedImage[])new RenderedImage[]{im8bit, im16bit}, (MosaicType)javax.media.jai.operator.MosaicDescriptor.MOSAIC_TYPE_OVERLAY, null, null, (double[][])null, (double[])new double[]{0.0}, (Range[])new Range[]{noData10, noData1000}, null);
        this.assertGray(mosaic, 1);
        int[] pixel = new int[1];
        mosaic.getData().getPixel(10, 10, pixel);
        Assert.assertArrayEquals((int[])new int[]{0}, (int[])pixel);
        mosaic.getData().getPixel(75, 10, pixel);
        Assert.assertArrayEquals((int[])new int[]{12850}, (int[])pixel);
        mosaic.getData().getPixel(25, 75, pixel);
        Assert.assertArrayEquals((int[])new int[]{30000}, (int[])pixel);
        mosaic.getData().getPixel(75, 75, pixel);
        Assert.assertArrayEquals((int[])new int[]{12850}, (int[])pixel);
    }

    @Test
    public void testGray8BitIntoRGB() {
        BufferedImage im8bit = new BufferedImage(100, 100, 10);
        WritableRaster raster8bit = im8bit.getRaster();
        int[] fill = new int[5000];
        Arrays.fill(fill, 10);
        raster8bit.setSamples(0, 0, 50, 100, 0, fill);
        Arrays.fill(fill, 50);
        raster8bit.setSamples(50, 0, 50, 100, 0, fill);
        BufferedImage yellow = this.buildBGR(Color.YELLOW);
        Range noData10 = RangeFactory.create((byte)10, (byte)10);
        RenderedOp mosaic = MosaicDescriptor.create((RenderedImage[])new RenderedImage[]{im8bit, yellow}, (MosaicType)javax.media.jai.operator.MosaicDescriptor.MOSAIC_TYPE_OVERLAY, null, null, (double[][])null, (double[])new double[]{0.0}, (Range[])new Range[]{noData10, null}, null);
        this.assertRGB(mosaic, false);
        int[] pixel = new int[3];
        mosaic.getData().getPixel(10, 10, pixel);
        Assert.assertArrayEquals((int[])new int[]{255, 255, 0}, (int[])pixel);
        mosaic.getData().getPixel(75, 10, pixel);
        Assert.assertArrayEquals((int[])new int[]{50, 50, 50}, (int[])pixel);
        mosaic.getData().getPixel(25, 75, pixel);
        Assert.assertArrayEquals((int[])new int[]{255, 255, 0}, (int[])pixel);
        mosaic.getData().getPixel(75, 75, pixel);
        Assert.assertArrayEquals((int[])new int[]{50, 50, 50}, (int[])pixel);
    }

    @Test
    public void testGray16BitIntoRGB() {
        BufferedImage im16bit = new BufferedImage(100, 100, 11);
        WritableRaster raster16bit = im16bit.getRaster();
        int[] fill = new int[5000];
        Arrays.fill(fill, 1000);
        raster16bit.setSamples(0, 0, 100, 50, 0, fill);
        Arrays.fill(fill, 30000);
        raster16bit.setSamples(0, 50, 100, 50, 0, fill);
        BufferedImage yellow = this.buildBGR(Color.YELLOW);
        Range noData1000 = RangeFactory.create((int)1000, (int)1000);
        RenderedOp mosaic = MosaicDescriptor.create((RenderedImage[])new RenderedImage[]{im16bit, yellow}, (MosaicType)javax.media.jai.operator.MosaicDescriptor.MOSAIC_TYPE_OVERLAY, null, null, (double[][])null, (double[])new double[]{0.0}, (Range[])new Range[]{noData1000, null}, null);
        this.assertRGB(mosaic, false);
        int[] pixel = new int[3];
        mosaic.getData().getPixel(10, 10, pixel);
        Assert.assertArrayEquals((int[])new int[]{255, 255, 0}, (int[])pixel);
        mosaic.getData().getPixel(75, 10, pixel);
        Assert.assertArrayEquals((int[])new int[]{255, 255, 0}, (int[])pixel);
        mosaic.getData().getPixel(25, 75, pixel);
        Assert.assertArrayEquals((int[])new int[]{117, 117, 117}, (int[])pixel);
        mosaic.getData().getPixel(75, 75, pixel);
        Assert.assertArrayEquals((int[])new int[]{117, 117, 117}, (int[])pixel);
    }

    private void assertExtent(RenderedOp mosaic, int minX, int minY, int maxX, int maxY) {
        Assert.assertEquals((long)minX, (long)mosaic.getMinX());
        Assert.assertEquals((long)minY, (long)mosaic.getMinY());
        Assert.assertEquals((long)maxX, (long)mosaic.getMaxX());
        Assert.assertEquals((long)maxY, (long)mosaic.getMaxY());
    }

    private void assertRGB(RenderedOp mosaic, boolean alpha) {
        SampleModel sm = mosaic.getSampleModel();
        Assert.assertEquals((long)(alpha ? 4L : 3L), (long)sm.getNumBands());
        Assert.assertEquals((long)0L, (long)sm.getDataType());
        ColorModel cm = mosaic.getColorModel();
        Assert.assertEquals((long)3L, (long)cm.getNumColorComponents());
        Assert.assertThat((Object)cm, (Matcher)CoreMatchers.instanceOf(ComponentColorModel.class));
        Assert.assertEquals((Object)alpha, (Object)cm.hasAlpha());
    }

    private void assertGray(RenderedOp mosaic, int dataType) {
        SampleModel sm = mosaic.getSampleModel();
        Assert.assertEquals((long)1L, (long)sm.getNumBands());
        Assert.assertEquals((long)dataType, (long)sm.getDataType());
        ColorModel cm = mosaic.getColorModel();
        Assert.assertThat((Object)cm, (Matcher)CoreMatchers.instanceOf(ComponentColorModel.class));
    }

    private void assertByteIndexed(RenderedOp mosaic) {
        SampleModel sm = mosaic.getSampleModel();
        Assert.assertEquals((long)1L, (long)sm.getNumBands());
        Assert.assertEquals((long)0L, (long)sm.getDataType());
        ColorModel cm = mosaic.getColorModel();
        Assert.assertEquals((long)3L, (long)cm.getNumColorComponents());
        Assert.assertThat((Object)cm, (Matcher)CoreMatchers.instanceOf(IndexColorModel.class));
    }

    private void checkMixedWhiteRed(RenderedOp mosaic) {
        this.assertRGB(mosaic, false);
        this.assertExtent(mosaic, 0, 0, 150, 100);
        int[] pixel = new int[3];
        mosaic.getData().getPixel(10, 10, pixel);
        Assert.assertArrayEquals((int[])new int[]{255, 255, 255}, (int[])pixel);
        mosaic.getData().getPixel(115, 10, pixel);
        Assert.assertArrayEquals((int[])new int[]{255, 0, 0}, (int[])pixel);
    }

    private void checkMixedRedWhite(RenderedOp mosaic) {
        this.assertRGB(mosaic, false);
        this.assertExtent(mosaic, 0, 0, 150, 100);
        int[] pixel = new int[3];
        mosaic.getData().getPixel(10, 10, pixel);
        Assert.assertArrayEquals((int[])new int[]{255, 255, 255}, (int[])pixel);
        mosaic.getData().getPixel(60, 10, pixel);
        Assert.assertArrayEquals((int[])new int[]{255, 0, 0}, (int[])pixel);
    }

    private BufferedImage buildIndexed(Color color) {
        BufferedImage bi = new BufferedImage(100, 100, 13);
        Graphics2D gr = bi.createGraphics();
        gr.setColor(color);
        gr.fillRect(0, 0, 100, 100);
        gr.dispose();
        return bi;
    }

    private BufferedImage buildIndexed(Color color, Color ... palette) {
        IndexColorModel icm = this.buildIndexColorModel(palette);
        BufferedImage bi = new BufferedImage(100, 100, 13, icm);
        Graphics2D gr = bi.createGraphics();
        gr.setColor(color);
        gr.fillRect(0, 0, 100, 100);
        gr.dispose();
        return bi;
    }

    private IndexColorModel buildIndexColorModel(Color ... palette) {
        int size = palette.length;
        byte[] r = new byte[size];
        byte[] g = new byte[size];
        byte[] b = new byte[size];
        for (int i = 0; i < size; ++i) {
            Color c = palette[i];
            r[i] = (byte)(c.getRed() & 0xFF);
            g[i] = (byte)(c.getGreen() & 0xFF);
            b[i] = (byte)(c.getBlue() & 0xFF);
        }
        IndexColorModel icm = new IndexColorModel(8, size, r, g, b);
        return icm;
    }

    private BufferedImage buildBinary(Color color) {
        BufferedImage bi = new BufferedImage(100, 100, 12);
        Graphics2D gr = bi.createGraphics();
        gr.setColor(color);
        gr.fillRect(0, 0, 100, 100);
        gr.dispose();
        return bi;
    }

    private BufferedImage buildBGR(Color color) {
        BufferedImage bi = new BufferedImage(100, 100, 5);
        Graphics2D gr = bi.createGraphics();
        gr.setColor(color);
        gr.fillRect(0, 0, 100, 100);
        gr.dispose();
        return bi;
    }

    private BufferedImage buildABGR(Color color) {
        BufferedImage bi = new BufferedImage(100, 100, 6);
        Graphics2D gr = bi.createGraphics();
        gr.setColor(color);
        gr.fillRect(0, 0, 100, 100);
        gr.dispose();
        return bi;
    }

    private BufferedImage buildByteGray(Color color) {
        BufferedImage bi = new BufferedImage(100, 100, 10);
        Graphics2D gr = bi.createGraphics();
        gr.setColor(color);
        gr.fillRect(0, 0, 100, 100);
        gr.dispose();
        return bi;
    }

    private RenderedImage buildByteGrayAlpha(Color color) {
        ComponentColorModel colorModel = new ComponentColorModel(ColorSpace.getInstance(1003), true, false, 3, 0);
        SampleModel sampleModel = colorModel.createCompatibleSampleModel(100, 100);
        TiledImage image = new TiledImage(0, 0, 100, 100, 0, 0, sampleModel, (ColorModel)colorModel);
        Graphics2D gr = image.createGraphics();
        gr.setColor(color);
        gr.fillRect(0, 0, 100, 100);
        gr.dispose();
        return image;
    }

    private BufferedImage buildUShortGray(Color color) {
        BufferedImage bi = new BufferedImage(100, 100, 11);
        Graphics2D gr = bi.createGraphics();
        gr.setColor(color);
        gr.fillRect(0, 0, 100, 100);
        gr.dispose();
        return bi;
    }
}

