/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.mosaic;

import it.geosolutions.jaiext.mosaic.ImageMosaicBean;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.Vector;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.MosaicType;

public class MosaicDescriptor
extends OperationDescriptorImpl {
    private static final long serialVersionUID = 2718297230579888333L;
    private static final String[][] resources = new String[][]{{"GlobalName", "MosaicNoData"}, {"LocalName", "MosaicNoData"}, {"Vendor", "it.geosolutions.jaiext.mosaic"}, {"Description", "A different mosaic operation which supports noData and doesn't supports threshold"}, {"DocURL", "wiki github non already available"}, {"Version", "1.0"}, {"arg0Desc", "ImageMosaicBean "}, {"arg1Desc", "Mosaic Type"}, {"arg2Desc", "Destination no data  Values"}};
    private static final Class[] paramClasses = new Class[]{ImageMosaicBean[].class, MosaicType.class, double[].class};
    private static final String[] paramNames = new String[]{"imageMosaicBean", "mosaicType", "destinationNoData"};
    private static final Object[] paramDefaults = new Object[]{null, javax.media.jai.operator.MosaicDescriptor.MOSAIC_TYPE_OVERLAY, new double[]{0.0}};

    public MosaicDescriptor() {
        super(resources, new String[]{"rendered"}, 0, paramNames, paramClasses, paramDefaults, null);
    }

    public boolean isRenderableSupported() {
        return false;
    }

    public boolean validateParameters(ParameterBlock pb) {
        Vector<Object> params = pb.getParameters();
        block4: for (int i = 0; i < params.size(); ++i) {
            switch (i) {
                case 1: {
                    ImageMosaicBean[] bean = (ImageMosaicBean[])pb.getObjectParameter(i);
                    int numSource = pb.getNumSources();
                    if (bean.length == numSource) continue block4;
                    return false;
                }
                case 2: {
                    MosaicType mosaic = (MosaicType)pb.getObjectParameter(i);
                    if (mosaic == javax.media.jai.operator.MosaicDescriptor.MOSAIC_TYPE_BLEND && mosaic == javax.media.jai.operator.MosaicDescriptor.MOSAIC_TYPE_OVERLAY) continue block4;
                    return false;
                }
            }
        }
        return true;
    }

    public static RenderedOp create(RenderedImage[] sources, ImageMosaicBean[] bean, MosaicType mosaicType, double[] destinationNoData, RenderingHints renderingHints) {
        ParameterBlockJAI pb = new ParameterBlockJAI("MosaicNoData", "rendered");
        int numSources = sources.length;
        for (int i = 0; i < numSources; ++i) {
            pb.addSource((Object)sources[i]);
        }
        pb.setParameter("imageMosaicBean", (Object)bean);
        pb.setParameter("mosaicType", (Object)mosaicType);
        pb.setParameter("destinationNoData", (Object)destinationNoData);
        return JAI.create((String)"MosaicNoData", (ParameterBlock)pb, (RenderingHints)renderingHints);
    }
}

