/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.lookup;

import it.geosolutions.jaiext.lookup.LookupTable;
import it.geosolutions.jaiext.testclasses.TestBase;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.RenderedImage;
import javax.media.jai.ROIShape;
import org.junit.BeforeClass;
import org.junit.Test;

public class CoverageTest
extends TestBase {
    private static final int DEFAULT_WIDTH = 256;
    private static final int DEFAULT_HEIGHT = 256;
    private static LookupTable bTobTableNoOffset;
    private static LookupTable bTobTable;
    private static LookupTable bTobTableOffset;
    private static LookupTable bTobTableOffsetArray;
    private static LookupTable bTousTableNoOffset;
    private static LookupTable bTousTable;
    private static LookupTable bTousTableOffset;
    private static LookupTable bTousTableOffsetArray;
    private static LookupTable bTosTableNoOffset;
    private static LookupTable bTosTable;
    private static LookupTable bTosTableOffset;
    private static LookupTable bTosTableOffsetArray;
    private static LookupTable bToiTableNoOffset;
    private static LookupTable bToiTable;
    private static LookupTable bToiTableOffset;
    private static LookupTable bToiTableOffsetArray;
    private static LookupTable bTofTableNoOffset;
    private static LookupTable bTofTable;
    private static LookupTable bTofTableOffset;
    private static LookupTable bTofTableOffsetArray;
    private static LookupTable bTodTableNoOffset;
    private static LookupTable bTodTable;
    private static LookupTable bTodTableOffset;
    private static LookupTable bTodTableOffsetArray;
    private static ROIShape roi;
    private static RenderedImage testImageByte;
    private static double destinationNoDataValue;
    private static byte noDataB;
    private static short noDataUS;
    private static short noDataS;
    private static int noDataI;

    @BeforeClass
    public static void initialSetup() {
        IMAGE_FILLER = false;
        noDataB = (byte)-100;
        noDataUS = (short)100;
        noDataS = (short)-100;
        noDataI = -100;
        testImageByte = CoverageTest.createTestImage((int)0, (int)256, (int)256, (Number)noDataB, (boolean)false);
        Rectangle roiBounds = new Rectangle(0, 0, 64, 64);
        roi = new ROIShape((Shape)roiBounds);
        destinationNoDataValue = 255.0;
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullByteArray1D() {
        this.testNullData(null, null, 0, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullByteArray2D() {
        byte[] testData = new byte[1];
        this.testNullData(testData, null, 0, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullByteArray2DOffset() {
        byte[] testData = new byte[1];
        this.testNullData(testData, null, 1, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullByteArray2DOffsetArray() {
        byte[] testData = new byte[1];
        int[] offsetArray = new int[]{0, 0, 0};
        this.testNullData(testData, null, 0, offsetArray);
    }

    public void testNullData(byte[] data1D, byte[][] data2D, int offset, int[] offsetArray) {
        if (data1D == null && data2D == null) {
            LookupTable table = new LookupTable(data1D);
        } else if (data1D != null && data2D == null && offset != 0) {
            LookupTable table = new LookupTable(data2D, offset);
        } else if (data1D != null && data2D == null && offsetArray != null) {
            LookupTable table = new LookupTable(data2D, offsetArray);
        } else if (data1D != null && data2D == null) {
            LookupTable table = new LookupTable(data2D);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullUShortArray1D() {
        this.testNullDataUShort(null, null, 0, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullUShortArray2D() {
        short[] testData = new short[1];
        this.testNullDataUShort(testData, null, 0, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullUShortArray2DOffset() {
        short[] testData = new short[1];
        this.testNullDataUShort(testData, null, 1, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullUShortArray2DOffsetArray() {
        short[] testData = new short[1];
        int[] offsetArray = new int[]{0, 0, 0};
        this.testNullDataUShort(testData, null, 0, offsetArray);
    }

    public void testNullDataUShort(short[] data1D, short[][] data2D, int offset, int[] offsetArray) {
        if (data1D == null && data2D == null) {
            LookupTable table = new LookupTable(data1D, true);
        } else if (data1D != null && data2D == null && offset != 0) {
            LookupTable table = new LookupTable(data2D, offset, true);
        } else if (data1D != null && data2D == null && offsetArray != null) {
            LookupTable table = new LookupTable(data2D, offsetArray, true);
        } else if (data1D != null && data2D == null) {
            LookupTable table = new LookupTable(data2D, true);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullShortArray1D() {
        this.testNullDataUShort(null, null, 0, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullShortArray2D() {
        short[] testData = new short[1];
        this.testNullDataUShort(testData, null, 0, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullShortArray2DOffset() {
        short[] testData = new short[1];
        this.testNullDataUShort(testData, null, 1, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullShortArray2DOffsetArray() {
        short[] testData = new short[1];
        int[] offsetArray = new int[]{0, 0, 0};
        this.testNullDataUShort(testData, null, 0, offsetArray);
    }

    public void testNullDataShort(short[] data1D, short[][] data2D, int offset, int[] offsetArray) {
        if (data1D == null && data2D == null) {
            LookupTable table = new LookupTable(data1D, false);
        } else if (data1D != null && data2D == null && offset != 0) {
            LookupTable table = new LookupTable(data2D, offset, false);
        } else if (data1D != null && data2D == null && offsetArray != null) {
            LookupTable table = new LookupTable(data2D, offsetArray, false);
        } else if (data1D != null && data2D == null) {
            LookupTable table = new LookupTable(data2D, false);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullIntArray1D() {
        this.testNullDataInt(null, null, 0, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullIntArray2D() {
        int[] testData = new int[1];
        this.testNullDataInt(testData, null, 0, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullIntArray2DOffset() {
        int[] testData = new int[1];
        this.testNullDataInt(testData, null, 1, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullIntArray2DOffsetArray() {
        int[] testData = new int[1];
        int[] offsetArray = new int[]{0, 0, 0};
        this.testNullDataInt(testData, null, 0, offsetArray);
    }

    public void testNullDataInt(int[] data1D, int[][] data2D, int offset, int[] offsetArray) {
        if (data1D == null && data2D == null) {
            LookupTable table = new LookupTable(data1D);
        } else if (data1D != null && data2D == null && offset != 0) {
            LookupTable table = new LookupTable(data2D, offset);
        } else if (data1D != null && data2D == null && offsetArray != null) {
            LookupTable table = new LookupTable(data2D, offsetArray);
        } else if (data1D != null && data2D == null) {
            LookupTable table = new LookupTable(data2D);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullFloatArray1D() {
        this.testNullDataFloat(null, null, 0, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullFloatArray2D() {
        float[] testData = new float[1];
        this.testNullDataFloat(testData, null, 0, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullFloatArray2DOffset() {
        float[] testData = new float[1];
        this.testNullDataFloat(testData, null, 1, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullFloatArray2DOffsetArray() {
        float[] testData = new float[1];
        int[] offsetArray = new int[]{0, 0, 0};
        this.testNullDataFloat(testData, null, 0, offsetArray);
    }

    public void testNullDataFloat(float[] data1D, float[][] data2D, int offset, int[] offsetArray) {
        if (data1D == null && data2D == null) {
            LookupTable table = new LookupTable(data1D);
        } else if (data1D != null && data2D == null && offset != 0) {
            LookupTable table = new LookupTable(data2D, offset);
        } else if (data1D != null && data2D == null && offsetArray != null) {
            LookupTable table = new LookupTable(data2D, offsetArray);
        } else if (data1D != null && data2D == null) {
            LookupTable table = new LookupTable(data2D);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullDoubleArray1D() {
        this.testNullDataDouble(null, null, 0, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullDoubleArray2D() {
        double[] testData = new double[1];
        this.testNullDataDouble(testData, null, 0, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullDoubleArray2DOffset() {
        double[] testData = new double[1];
        this.testNullDataDouble(testData, null, 1, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullDoubleArray2DOffsetArray() {
        double[] testData = new double[1];
        int[] offsetArray = new int[]{0, 0, 0};
        this.testNullDataDouble(testData, null, 0, offsetArray);
    }

    public void testNullDataDouble(double[] data1D, double[][] data2D, int offset, int[] offsetArray) {
        if (data1D == null && data2D == null) {
            LookupTable table = new LookupTable(data1D);
        } else if (data1D != null && data2D == null && offset != 0) {
            LookupTable table = new LookupTable(data2D, offset);
        } else if (data1D != null && data2D == null && offsetArray != null) {
            LookupTable table = new LookupTable(data2D, offsetArray);
        } else if (data1D != null && data2D == null) {
            LookupTable table = new LookupTable(data2D);
        }
    }

    @Test
    public void testConstructors() {
        int byteOffset = 0;
        int[] offsetArray = new int[]{byteOffset, byteOffset, byteOffset};
        int arrayLength = 201;
        byte[] dataByteB = new byte[arrayLength];
        short[] dataByteUS = new short[arrayLength];
        short[] dataByteS = new short[arrayLength];
        int[] dataByteI = new int[arrayLength];
        float[] dataByteF = new float[arrayLength];
        double[] dataByteD = new double[arrayLength];
        byte[][] dataByteB3Bands = new byte[3][arrayLength];
        short[][] dataByteUS3Bands = new short[3][arrayLength];
        short[][] dataByteS3Bands = new short[3][arrayLength];
        int[][] dataByteI3Bands = new int[3][arrayLength];
        float[][] dataByteF3Bands = new float[3][arrayLength];
        double[][] dataByteD3Bands = new double[3][arrayLength];
        for (int b = 0; b < 3; ++b) {
            for (int i = 0; i < arrayLength; ++i) {
                dataByteB[i] = 0;
                dataByteUS[i] = 0;
                dataByteS[i] = 0;
                dataByteI[i] = 0;
                dataByteF[i] = (float)i * 1.0f / (float)arrayLength;
                dataByteD[i] = (double)i * 1.0 / (double)arrayLength * 2.0;
                if (i == (noDataB & 0xFF)) {
                    dataByteB[i] = 50;
                    dataByteUS[i] = 50;
                    dataByteS[i] = 50;
                    dataByteI[i] = 50;
                }
                dataByteB3Bands[b][i] = 0;
                dataByteUS3Bands[b][i] = 0;
                dataByteS3Bands[b][i] = 0;
                dataByteI3Bands[b][i] = 0;
                dataByteF3Bands[b][i] = (float)i * 1.0f / (float)arrayLength;
                dataByteD3Bands[b][i] = (double)i * 1.0 / (double)arrayLength * 2.0;
                if (i != (noDataB & 0xFF)) continue;
                dataByteB3Bands[b][i] = 50;
                dataByteUS3Bands[b][i] = 50;
                dataByteS3Bands[b][i] = 50;
                dataByteI3Bands[b][i] = 50;
            }
        }
        bTobTableNoOffset = new LookupTable(dataByteB);
        bTousTableNoOffset = new LookupTable(dataByteUS, true);
        bTosTableNoOffset = new LookupTable(dataByteS, false);
        bToiTableNoOffset = new LookupTable(dataByteI);
        bTofTableNoOffset = new LookupTable(dataByteF);
        bTodTableNoOffset = new LookupTable(dataByteD);
        bTobTable = new LookupTable(dataByteB3Bands);
        bTousTable = new LookupTable(dataByteUS3Bands, true);
        bTosTable = new LookupTable(dataByteS3Bands, false);
        bToiTable = new LookupTable(dataByteI3Bands);
        bTofTable = new LookupTable(dataByteF3Bands);
        bTodTable = new LookupTable(dataByteD3Bands);
        bTobTableOffset = new LookupTable(dataByteB3Bands, byteOffset);
        bTousTableOffset = new LookupTable(dataByteUS3Bands, byteOffset, true);
        bTosTableOffset = new LookupTable(dataByteS3Bands, byteOffset, false);
        bToiTableOffset = new LookupTable(dataByteI3Bands, byteOffset);
        bTofTableOffset = new LookupTable(dataByteF3Bands, byteOffset);
        bTodTableOffset = new LookupTable(dataByteD3Bands, byteOffset);
        bTobTableOffsetArray = new LookupTable(dataByteB3Bands, offsetArray);
        bTousTableOffsetArray = new LookupTable(dataByteUS3Bands, offsetArray, true);
        bTosTableOffsetArray = new LookupTable(dataByteS3Bands, offsetArray, false);
        bToiTableOffsetArray = new LookupTable(dataByteI3Bands, offsetArray);
        bTofTableOffsetArray = new LookupTable(dataByteF3Bands, offsetArray);
        bTodTableOffsetArray = new LookupTable(dataByteD3Bands, offsetArray);
    }
}

