/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.lookup;

import it.geosolutions.jaiext.JAIExt;
import it.geosolutions.jaiext.lookup.LookupDescriptor;
import it.geosolutions.jaiext.lookup.LookupTable;
import it.geosolutions.jaiext.lookup.LookupTableByte;
import it.geosolutions.jaiext.lookup.LookupTableInt;
import it.geosolutions.jaiext.lookup.LookupTableShort;
import it.geosolutions.jaiext.lookup.LookupTableUShort;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.testclasses.TestBase;
import java.awt.image.RenderedImage;
import javax.media.jai.JAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.RenderedOp;
import org.junit.BeforeClass;
import org.junit.Test;

public class ComparisonTest
extends TestBase {
    private static final Integer BENCHMARK_ITERATION = Integer.getInteger("JAI.Ext.BenchmarkCycles", 1);
    private static final int NOT_BENCHMARK_ITERATION = Integer.getInteger("JAI.Ext.NotBenchmarkCycles", 0);
    private static final boolean OLD_DESCRIPTOR = Boolean.getBoolean("JAI.Ext.OldDescriptor");
    private static final boolean NATIVE_ACCELERATION = Boolean.getBoolean("JAI.Ext.Acceleration");
    private static final boolean RANGE_USED = Boolean.getBoolean("JAI.Ext.RangeUsed");
    private static double destinationNoDataValue;
    private static RenderedImage testImageByte;
    private static RenderedImage testImageUShort;
    private static RenderedImage testImageShort;
    private static RenderedImage testImageInt;
    private static LookupTableByte byteToByteTableNew;
    private static LookupTableUShort ushortToByteTableNew;
    private static LookupTableShort shortToByteTableNew;
    private static LookupTableInt intToByteTableNew;
    private static LookupTableJAI byteToByteTableOld;
    private static LookupTableJAI ushortToByteTableOld;
    private static LookupTableJAI shortToByteTableOld;
    private static LookupTableJAI intToByteTableOld;
    private static Range rangeND;

    @BeforeClass
    public static void initialSetup() {
        IMAGE_FILLER = false;
        byte noDataB = -100;
        short noDataUS = 100;
        short noDataS = -100;
        int noDataI = -100;
        testImageByte = ComparisonTest.createTestImage((int)0, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataB, (boolean)false);
        testImageUShort = ComparisonTest.createTestImage((int)1, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataUS, (boolean)false);
        testImageShort = ComparisonTest.createTestImage((int)2, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataS, (boolean)false);
        testImageInt = ComparisonTest.createTestImage((int)3, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataI, (boolean)false);
        int byteOffset = 0;
        int ushortOffset = 0;
        short shortOffset = noDataS;
        int intOffset = noDataI;
        int arrayLength = 201;
        int startValue = -100;
        byte[] dataByteB = new byte[arrayLength];
        byte[] dataUShortB = new byte[arrayLength];
        byte[] dataShortB = new byte[arrayLength];
        byte[] dataIntB = new byte[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            dataByteB[i] = 0;
            dataUShortB[i] = 0;
            dataShortB[i] = 0;
            dataIntB[i] = 0;
            int value = i + startValue;
            if (value == noDataI) {
                dataShortB[i] = 50;
                dataIntB[i] = 50;
                dataByteB[i] = 50;
            }
            if (i != noDataUS) continue;
            dataUShortB[i] = 50;
        }
        byteToByteTableNew = new LookupTableByte(dataByteB, byteOffset);
        ushortToByteTableNew = new LookupTableUShort(dataUShortB, ushortOffset);
        shortToByteTableNew = new LookupTableShort(dataShortB, (int)shortOffset);
        intToByteTableNew = new LookupTableInt(dataIntB, intOffset);
        byteToByteTableOld = new LookupTableJAI(dataByteB, byteOffset);
        ushortToByteTableOld = new LookupTableJAI(dataUShortB, ushortOffset);
        shortToByteTableOld = new LookupTableJAI(dataShortB, (int)shortOffset);
        intToByteTableOld = new LookupTableJAI(dataIntB, intOffset);
        destinationNoDataValue = 50.0;
        rangeND = null;
        if (RANGE_USED && !OLD_DESCRIPTOR) {
            switch (TEST_SELECTOR) {
                case 0: {
                    rangeND = RangeFactory.create((byte)100, (boolean)true, (byte)100, (boolean)true);
                    break;
                }
                case 1: {
                    rangeND = RangeFactory.createU((short)100, (boolean)true, (short)100, (boolean)true);
                    break;
                }
                case 2: {
                    rangeND = RangeFactory.create((short)100, (boolean)true, (short)100, (boolean)true);
                    break;
                }
                case 3: {
                    rangeND = RangeFactory.create((int)100, (boolean)true, (int)100, (boolean)true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong data type");
                }
            }
        }
        if (OLD_DESCRIPTOR) {
            JAIExt.registerJAIDescriptor((String)"lookup");
        }
    }

    @Test
    public void testNewLookupDescriptorByte() {
        if (TEST_SELECTOR == 0 && !OLD_DESCRIPTOR) {
            this.testLookup(testImageByte, 0, byteToByteTableNew, rangeND, OLD_DESCRIPTOR);
        }
    }

    @Test
    public void testOldLookupDescriptorByte() {
        if (TEST_SELECTOR == 0 && OLD_DESCRIPTOR) {
            this.testLookup(testImageByte, 0, byteToByteTableOld, rangeND, OLD_DESCRIPTOR);
        }
    }

    @Test
    public void testNewLookupDescriptorUShort() {
        if (TEST_SELECTOR == 1 && !OLD_DESCRIPTOR) {
            this.testLookup(testImageUShort, 1, ushortToByteTableNew, rangeND, OLD_DESCRIPTOR);
        }
    }

    @Test
    public void testOldLookupDescriptorUShort() {
        if (TEST_SELECTOR == 1 && OLD_DESCRIPTOR) {
            this.testLookup(testImageUShort, 1, ushortToByteTableOld, rangeND, OLD_DESCRIPTOR);
        }
    }

    @Test
    public void testNewLookupDescriptorShort() {
        if (TEST_SELECTOR == 2 && !OLD_DESCRIPTOR) {
            this.testLookup(testImageShort, 2, shortToByteTableNew, rangeND, OLD_DESCRIPTOR);
        }
    }

    @Test
    public void testOldLookupDescriptorShort() {
        if (TEST_SELECTOR == 2 && OLD_DESCRIPTOR) {
            this.testLookup(testImageShort, 2, shortToByteTableOld, rangeND, OLD_DESCRIPTOR);
        }
    }

    @Test
    public void testNewLookupDescriptorInt() {
        if (TEST_SELECTOR == 3 && !OLD_DESCRIPTOR) {
            this.testLookup(testImageInt, 3, intToByteTableNew, rangeND, OLD_DESCRIPTOR);
        }
    }

    @Test
    public void testOldLookupDescriptorInt() {
        if (TEST_SELECTOR == 3 && OLD_DESCRIPTOR) {
            this.testLookup(testImageInt, 3, intToByteTableOld, rangeND, OLD_DESCRIPTOR);
        }
    }

    public void testLookup(RenderedImage testIMG, int dataType, Object table, Range rangeND, boolean old) {
        String description = "\n ";
        if (old) {
            description = "Old Lookup";
            if (NATIVE_ACCELERATION) {
                description = description + " accelerated ";
                System.setProperty("com.sun.media.jai.disableMediaLib", "false");
            } else {
                System.setProperty("com.sun.media.jai.disableMediaLib", "true");
            }
        } else {
            description = "New Lookup";
            System.setProperty("com.sun.media.jai.disableMediaLib", "true");
        }
        String dataTypeString = "";
        switch (dataType) {
            case 0: {
                dataTypeString = dataTypeString + "Byte";
                break;
            }
            case 1: {
                dataTypeString = dataTypeString + "UShort";
                break;
            }
            case 2: {
                dataTypeString = dataTypeString + "Short";
                break;
            }
            case 3: {
                dataTypeString = dataTypeString + "Integer";
            }
        }
        int totalCycles = BENCHMARK_ITERATION + NOT_BENCHMARK_ITERATION;
        RenderedOp imageLookup = null;
        long mean = 0L;
        long max = Long.MIN_VALUE;
        long min = Long.MAX_VALUE;
        for (int i = 0; i < totalCycles; ++i) {
            imageLookup = old ? javax.media.jai.operator.LookupDescriptor.create((RenderedImage)testIMG, (LookupTableJAI)((LookupTableJAI)table), null) : LookupDescriptor.create((RenderedImage)testIMG, (LookupTable)((LookupTable)table), (double)destinationNoDataValue, null, (Range)rangeND, (boolean)false, null);
            long start = System.nanoTime();
            imageLookup.getTiles();
            long end = System.nanoTime() - start;
            if (i > NOT_BENCHMARK_ITERATION - 1) {
                mean = i == NOT_BENCHMARK_ITERATION ? end : (mean += end);
                if (end > max) {
                    max = end;
                }
                if (end < min) {
                    min = end;
                }
            }
            JAI.getDefaultInstance().getTileCache().flush();
        }
        double meanValue = (double)(mean / (long)BENCHMARK_ITERATION.intValue()) * 1.0E-6;
        double maxD = (double)max * 1.0E-6;
        double minD = (double)min * 1.0E-6;
        System.out.println(dataTypeString);
        System.out.println("\nMean value for " + description + "Descriptor : " + meanValue + " msec.");
        System.out.println("Maximum value for " + description + "Descriptor : " + maxD + " msec.");
        System.out.println("Minimum value for " + description + "Descriptor : " + minD + " msec.");
        if (imageLookup instanceof RenderedOp) {
            imageLookup.dispose();
        }
    }
}

