/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.lookup;

import it.geosolutions.jaiext.range.Range;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.Serializable;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.iterator.RandomIter;

public abstract class LookupTable
extends LookupTableJAI
implements Serializable {
    protected byte destinationNoDataByte;
    protected short destinationNoDataShort;
    protected int destinationNoDataInt;
    protected float destinationNoDataFloat;
    protected double destinationNoDataDouble;
    protected Range noData;
    protected Rectangle roiBounds;
    protected RandomIter roiIter;
    protected boolean useROIAccessor;
    protected PlanarImage srcROIImage;
    protected boolean hasNoData;
    protected boolean hasROI;

    protected LookupTable(byte[] data) {
        super(data);
    }

    protected LookupTable(byte[] data, int offset) {
        super(data, offset);
    }

    public LookupTable(byte[][] data) {
        super(data);
    }

    public LookupTable(byte[][] data, int offset) {
        super(data, offset);
    }

    protected LookupTable(byte[][] data, int[] offsets) {
        super(data, offsets);
    }

    protected LookupTable(short[] data, boolean isUShort) {
        super(data, isUShort);
    }

    protected LookupTable(short[] data, int offset, boolean isUShort) {
        super(data, offset, isUShort);
    }

    protected LookupTable(short[][] data, boolean isUShort) {
        super(data, isUShort);
    }

    protected LookupTable(short[][] data, int offset, boolean isUShort) {
        super(data, offset, isUShort);
    }

    protected LookupTable(short[][] data, int[] offsets, boolean isUShort) {
        super(data, offsets, isUShort);
    }

    protected LookupTable(int[] data) {
        super(data);
    }

    protected LookupTable(int[] data, int offset) {
        super(data, offset);
    }

    protected LookupTable(int[][] data) {
        super(data);
    }

    protected LookupTable(int[][] data, int offset) {
        super(data, offset);
    }

    protected LookupTable(int[][] data, int[] offsets) {
        super(data, offsets);
    }

    protected LookupTable(float[] data) {
        super(data);
    }

    protected LookupTable(float[] data, int offset) {
        super(data, offset);
    }

    protected LookupTable(float[][] data) {
        super(data);
    }

    protected LookupTable(float[][] data, int offset) {
        super(data, offset);
    }

    protected LookupTable(float[][] data, int[] offsets) {
        super(data, offsets);
    }

    protected LookupTable(double[] data) {
        super(data);
    }

    protected LookupTable(double[] data, int offset) {
        super(data, offset);
    }

    protected LookupTable(double[][] data) {
        super(data);
    }

    protected LookupTable(double[][] data, int offset) {
        super(data, offset);
    }

    protected LookupTable(double[][] data, int[] offsets) {
        super(data, offsets);
    }

    public void setDestinationNoData(double destinationNoData) {
        int dataType = this.getDataType();
        switch (dataType) {
            case 0: {
                this.destinationNoDataByte = (byte)((byte)destinationNoData & 0xFF);
                break;
            }
            case 1: {
                this.destinationNoDataShort = (short)((short)destinationNoData & 0xFFFF);
                break;
            }
            case 2: {
                this.destinationNoDataShort = (short)destinationNoData;
                break;
            }
            case 3: {
                this.destinationNoDataInt = (int)destinationNoData;
                break;
            }
            case 4: {
                this.destinationNoDataFloat = (float)destinationNoData;
                break;
            }
            case 5: {
                this.destinationNoDataDouble = destinationNoData;
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong data type");
            }
        }
    }

    public void setNoDataRange(Range noData) {
        this.noData = noData;
        this.hasNoData = true;
    }

    public void unsetNoData() {
        this.noData = null;
        this.hasNoData = false;
    }

    public void setROIparams(Rectangle roiBounds, RandomIter roiIter, PlanarImage srcROIImage, boolean useROIAccessor) {
        this.hasROI = true;
        this.roiBounds = roiBounds;
        this.roiIter = roiIter;
        this.useROIAccessor = useROIAccessor;
        this.srcROIImage = srcROIImage;
    }

    public void unsetROI() {
        this.hasROI = false;
        this.roiBounds = null;
        this.roiIter = null;
        this.srcROIImage = null;
        this.useROIAccessor = false;
    }

    protected abstract void lookup(Raster var1, WritableRaster var2, Rectangle var3, Raster var4);
}

