/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.lookup;

import it.geosolutions.jaiext.lookup.LookupTable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;

public class LookupTableByte
extends LookupTable {
    public LookupTableByte(byte[] data) {
        super(data);
    }

    public LookupTableByte(byte[] data, int offset) {
        super(data, offset);
    }

    public LookupTableByte(byte[][] data) {
        super(data);
    }

    public LookupTableByte(byte[][] data, int offset) {
        super(data, offset);
    }

    public LookupTableByte(byte[][] data, int[] offsets) {
        super(data, offsets);
    }

    public LookupTableByte(short[] data, boolean isUShort) {
        super(data, isUShort);
    }

    public LookupTableByte(short[] data, int offset, boolean isUShort) {
        super(data, offset, isUShort);
    }

    public LookupTableByte(short[][] data, boolean isUShort) {
        super(data, isUShort);
    }

    public LookupTableByte(short[][] data, int offset, boolean isUShort) {
        super(data, offset, isUShort);
    }

    public LookupTableByte(short[][] data, int[] offsets, boolean isUShort) {
        super(data, offsets, isUShort);
    }

    public LookupTableByte(int[] data) {
        super(data);
    }

    public LookupTableByte(int[] data, int offset) {
        super(data, offset);
    }

    public LookupTableByte(int[][] data) {
        super(data);
    }

    public LookupTableByte(int[][] data, int offset) {
        super(data, offset);
    }

    public LookupTableByte(int[][] data, int[] offsets) {
        super(data, offsets);
    }

    public LookupTableByte(float[] data) {
        super(data);
    }

    public LookupTableByte(float[] data, int offset) {
        super(data, offset);
    }

    public LookupTableByte(float[][] data) {
        super(data);
    }

    public LookupTableByte(float[][] data, int offset) {
        super(data, offset);
    }

    public LookupTableByte(float[][] data, int[] offsets) {
        super(data, offsets);
    }

    public LookupTableByte(double[] data) {
        super(data);
    }

    public LookupTableByte(double[] data, int offset) {
        super(data, offset);
    }

    public LookupTableByte(double[][] data) {
        super(data);
    }

    public LookupTableByte(double[][] data, int offset) {
        super(data, offset);
    }

    public LookupTableByte(double[][] data, int[] offsets) {
        super(data, offsets);
    }

    protected void lookup(Raster source, WritableRaster dst, Rectangle rect, Raster roi) {
        SampleModel dstSampleModel;
        if (source == null) {
            throw new IllegalArgumentException("Source data must be present");
        }
        SampleModel srcSampleModel = source.getSampleModel();
        if (!this.isIntegralDataType(srcSampleModel)) {
            throw new IllegalArgumentException("Only integral data type are handled");
        }
        if (srcSampleModel.getDataType() != 0) {
            throw new IllegalArgumentException("Source data type must be equal to the table data type");
        }
        rect = rect == null ? source.getBounds() : rect.intersection(source.getBounds());
        if (dst != null) {
            rect = rect.intersection(dst.getBounds());
        }
        if (dst == null) {
            dstSampleModel = this.getDestSampleModel(srcSampleModel, rect.width, rect.height);
            dst = RasterFactory.createWritableRaster((SampleModel)dstSampleModel, (Point)new Point(rect.x, rect.y));
        } else {
            dstSampleModel = dst.getSampleModel();
            if (dstSampleModel.getTransferType() != this.getDataType() || dstSampleModel.getNumBands() != this.getDestNumBands(srcSampleModel.getNumBands())) {
                throw new IllegalArgumentException("Destination image must have the same data type and band number of the Table");
            }
        }
        int sTagID = RasterAccessor.findCompatibleTag(null, (SampleModel)srcSampleModel);
        int dTagID = RasterAccessor.findCompatibleTag(null, (SampleModel)dstSampleModel);
        RasterFormatTag sTag = new RasterFormatTag(srcSampleModel, sTagID);
        RasterFormatTag dTag = new RasterFormatTag(dstSampleModel, dTagID);
        RasterAccessor s = new RasterAccessor(source, rect, sTag, null);
        RasterAccessor d = new RasterAccessor((Raster)dst, rect, dTag, null);
        RasterAccessor roiAccessor = null;
        if (this.useROIAccessor) {
            Rectangle srcRect = source.getBounds();
            roiAccessor = new RasterAccessor(roi, srcRect, RasterAccessor.findCompatibleTags((RenderedImage[])new RenderedImage[]{this.srcROIImage}, (RenderedImage)this.srcROIImage)[0], this.srcROIImage.getColorModel());
        }
        int srcNumBands = s.getNumBands();
        int tblNumBands = this.getNumBands();
        int tblDataType = this.getDataType();
        int dstWidth = d.getWidth();
        int dstHeight = d.getHeight();
        int dstNumBands = d.getNumBands();
        int dstDataType = d.getDataType();
        int srcLineStride = s.getScanlineStride();
        int srcPixelStride = s.getPixelStride();
        int[] srcBandOffsets = s.getBandOffsets();
        Object bSrcData = s.getByteDataArrays();
        if (srcNumBands < dstNumBands) {
            int offset0 = srcBandOffsets[0];
            srcBandOffsets = new int[dstNumBands];
            for (int i = 0; i < dstNumBands; ++i) {
                srcBandOffsets[i] = offset0;
            }
            byte[] bData0 = bSrcData[0];
            bSrcData = new byte[dstNumBands][];
            for (int i = 0; i < dstNumBands; ++i) {
                bSrcData[i] = bData0;
            }
        }
        int[] tblOffsets = this.getOffsets();
        Object bTblData = this.getByteData();
        Object sTblData = this.getShortData();
        Object iTblData = this.getIntData();
        Object fTblData = this.getFloatData();
        Object dTblData = this.getDoubleData();
        if (tblNumBands < dstNumBands) {
            int offset0 = tblOffsets[0];
            tblOffsets = new int[dstNumBands];
            for (int i = 0; i < dstNumBands; ++i) {
                tblOffsets[i] = offset0;
            }
            switch (tblDataType) {
                case 0: {
                    byte[] bData0 = bTblData[0];
                    bTblData = new byte[dstNumBands][];
                    for (int i = 0; i < dstNumBands; ++i) {
                        bTblData[i] = bData0;
                    }
                    break;
                }
                case 1: 
                case 2: {
                    short[] sData0 = sTblData[0];
                    sTblData = new short[dstNumBands][];
                    for (int i = 0; i < dstNumBands; ++i) {
                        sTblData[i] = sData0;
                    }
                    break;
                }
                case 3: {
                    int[] iData0 = iTblData[0];
                    iTblData = new int[dstNumBands][];
                    for (int i = 0; i < dstNumBands; ++i) {
                        iTblData[i] = iData0;
                    }
                    break;
                }
                case 4: {
                    float[] fData0 = fTblData[0];
                    fTblData = new float[dstNumBands][];
                    for (int i = 0; i < dstNumBands; ++i) {
                        fTblData[i] = fData0;
                    }
                    break;
                }
                case 5: {
                    double[] dData0 = dTblData[0];
                    dTblData = new double[dstNumBands][];
                    for (int i = 0; i < dstNumBands; ++i) {
                        dTblData[i] = dData0;
                    }
                    break;
                }
            }
        }
        int dstLineStride = d.getScanlineStride();
        int dstPixelStride = d.getPixelStride();
        int[] dstBandOffsets = d.getBandOffsets();
        byte[][] bDstData = d.getByteDataArrays();
        short[][] sDstData = d.getShortDataArrays();
        int[][] iDstData = d.getIntDataArrays();
        float[][] fDstData = d.getFloatDataArrays();
        double[][] dDstData = d.getDoubleDataArrays();
        switch (dstDataType) {
            case 0: {
                this.lookup(srcLineStride, srcPixelStride, srcBandOffsets, (byte[][])bSrcData, dstWidth, dstHeight, dstNumBands, dstLineStride, dstPixelStride, dstBandOffsets, bDstData, tblOffsets, (byte[][])bTblData, roiAccessor, rect);
                break;
            }
            case 1: 
            case 2: {
                this.lookup(srcLineStride, srcPixelStride, srcBandOffsets, (byte[][])bSrcData, dstWidth, dstHeight, dstNumBands, dstLineStride, dstPixelStride, dstBandOffsets, sDstData, tblOffsets, (short[][])sTblData, roiAccessor, rect);
                break;
            }
            case 3: {
                this.lookup(srcLineStride, srcPixelStride, srcBandOffsets, (byte[][])bSrcData, dstWidth, dstHeight, dstNumBands, dstLineStride, dstPixelStride, dstBandOffsets, iDstData, tblOffsets, (int[][])iTblData, roiAccessor, rect);
                break;
            }
            case 4: {
                this.lookup(srcLineStride, srcPixelStride, srcBandOffsets, (byte[][])bSrcData, dstWidth, dstHeight, dstNumBands, dstLineStride, dstPixelStride, dstBandOffsets, fDstData, tblOffsets, (float[][])fTblData, roiAccessor, rect);
                break;
            }
            case 5: {
                this.lookup(srcLineStride, srcPixelStride, srcBandOffsets, (byte[][])bSrcData, dstWidth, dstHeight, dstNumBands, dstLineStride, dstPixelStride, dstBandOffsets, dDstData, tblOffsets, (double[][])dTblData, roiAccessor, rect);
            }
        }
        d.copyDataToRaster();
    }

    private void lookup(int srcLineStride, int srcPixelStride, int[] srcBandOffsets, byte[][] bSrcData, int dstWidth, int dstHeight, int dstNumBands, int dstLineStride, int dstPixelStride, int[] dstBandOffsets, byte[][] bDstData, int[] tblOffsets, byte[][] bTblData, RasterAccessor roi, Rectangle destRect) {
        boolean caseC;
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        int roiLineStride = 0;
        byte[] roiDataArray = null;
        int roiDataLength = 0;
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
            roiLineStride = roi.getScanlineStride();
        }
        boolean caseA = !this.hasROI && !this.hasNoData;
        boolean caseB = this.hasROI && !this.hasNoData;
        boolean bl = caseC = !this.hasROI && this.hasNoData;
        if (caseA) {
            for (int b = 0; b < dstNumBands; ++b) {
                byte[] s = bSrcData[b];
                byte[] d = bDstData[b];
                byte[] t = bTblData[b];
                int srcLineOffset = srcBandOffsets[b];
                int dstLineOffset = dstBandOffsets[b];
                int tblOffset = tblOffsets[b];
                for (int h = 0; h < dstHeight; ++h) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        d[dstPixelOffset] = t[(s[srcPixelOffset] & 0xFF) - tblOffset];
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else if (caseB) {
            if (this.useROIAccessor) {
                for (int b = 0; b < dstNumBands; ++b) {
                    byte[] s = bSrcData[b];
                    byte[] d = bDstData[b];
                    byte[] t = bTblData[b];
                    int srcLineOffset = srcBandOffsets[b];
                    int dstLineOffset = dstBandOffsets[b];
                    int tblOffset = tblOffsets[b];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        int posyROI = (y - dst_min_y) * roiLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int posx = (x - dst_min_x) * srcPixelStride;
                            int windex = posx / dstNumBands + posyROI;
                            int w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                            d[dstPixelOffset] = w == 0 ? this.destinationNoDataByte : t[(s[srcPixelOffset] & 0xFF) - tblOffset];
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            } else {
                for (int b = 0; b < dstNumBands; ++b) {
                    byte[] s = bSrcData[b];
                    byte[] d = bDstData[b];
                    byte[] t = bTblData[b];
                    int srcLineOffset = srcBandOffsets[b];
                    int dstLineOffset = dstBandOffsets[b];
                    int tblOffset = tblOffsets[b];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int w;
                            d[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = this.roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataByte : t[(s[srcPixelOffset] & 0xFF) - tblOffset]) : this.destinationNoDataByte;
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            }
        } else if (caseC) {
            for (int b = 0; b < dstNumBands; ++b) {
                byte[] s = bSrcData[b];
                byte[] d = bDstData[b];
                byte[] t = bTblData[b];
                int srcLineOffset = srcBandOffsets[b];
                int dstLineOffset = dstBandOffsets[b];
                int tblOffset = tblOffsets[b];
                for (int y = 0; y < dstHeight; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = 0; x < dstWidth; ++x) {
                        byte value = s[srcPixelOffset];
                        d[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataByte : t[value & 255 - tblOffset];
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else if (this.useROIAccessor) {
            for (int b = 0; b < dstNumBands; ++b) {
                byte[] s = bSrcData[b];
                byte[] d = bDstData[b];
                byte[] t = bTblData[b];
                int srcLineOffset = srcBandOffsets[b];
                int dstLineOffset = dstBandOffsets[b];
                int tblOffset = tblOffsets[b];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    int posyROI = (y - dst_min_y) * roiLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        byte value;
                        int w;
                        int posx = (x - dst_min_x) * srcPixelStride;
                        int windex = posx / dstNumBands + posyROI;
                        int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                        d[dstPixelOffset] = w == 0 ? this.destinationNoDataByte : (this.noData.contains(value = s[srcPixelOffset]) ? this.destinationNoDataByte : t[value & 255 - tblOffset]);
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else {
            for (int b = 0; b < dstNumBands; ++b) {
                byte[] s = bSrcData[b];
                byte[] d = bDstData[b];
                byte[] t = bTblData[b];
                int srcLineOffset = srcBandOffsets[b];
                int dstLineOffset = dstBandOffsets[b];
                int tblOffset = tblOffsets[b];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        byte value;
                        int w;
                        d[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = this.roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataByte : (this.noData.contains(value = s[srcPixelOffset]) ? this.destinationNoDataByte : t[value & 255 - tblOffset])) : this.destinationNoDataByte;
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        }
    }

    private void lookup(int srcLineStride, int srcPixelStride, int[] srcBandOffsets, byte[][] bSrcData, int dstWidth, int dstHeight, int dstNumBands, int dstLineStride, int dstPixelStride, int[] dstBandOffsets, short[][] sDstData, int[] tblOffsets, short[][] sTblData, RasterAccessor roi, Rectangle destRect) {
        boolean caseC;
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        int roiLineStride = 0;
        byte[] roiDataArray = null;
        int roiDataLength = 0;
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
            roiLineStride = roi.getScanlineStride();
        }
        boolean caseA = !this.hasROI && !this.hasNoData;
        boolean caseB = this.hasROI && !this.hasNoData;
        boolean bl = caseC = !this.hasROI && this.hasNoData;
        if (caseA) {
            for (int b = 0; b < dstNumBands; ++b) {
                byte[] s = bSrcData[b];
                short[] d = sDstData[b];
                short[] t = sTblData[b];
                int srcLineOffset = srcBandOffsets[b];
                int dstLineOffset = dstBandOffsets[b];
                int tblOffset = tblOffsets[b];
                for (int h = 0; h < dstHeight; ++h) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        d[dstPixelOffset] = t[(s[srcPixelOffset] & 0xFF) - tblOffset];
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else if (caseB) {
            if (this.useROIAccessor) {
                for (int b = 0; b < dstNumBands; ++b) {
                    byte[] s = bSrcData[b];
                    short[] d = sDstData[b];
                    short[] t = sTblData[b];
                    int srcLineOffset = srcBandOffsets[b];
                    int dstLineOffset = dstBandOffsets[b];
                    int tblOffset = tblOffsets[b];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        int posyROI = (y - dst_min_y) * roiLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int posx = (x - dst_min_x) * srcPixelStride;
                            int windex = posx / dstNumBands + posyROI;
                            int w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                            d[dstPixelOffset] = w == 0 ? this.destinationNoDataShort : t[(s[srcPixelOffset] & 0xFF) - tblOffset];
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            } else {
                for (int b = 0; b < dstNumBands; ++b) {
                    byte[] s = bSrcData[b];
                    short[] d = sDstData[b];
                    short[] t = sTblData[b];
                    int srcLineOffset = srcBandOffsets[b];
                    int dstLineOffset = dstBandOffsets[b];
                    int tblOffset = tblOffsets[b];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int w;
                            d[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = this.roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataShort : t[(s[srcPixelOffset] & 0xFF) - tblOffset]) : this.destinationNoDataShort;
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            }
        } else if (caseC) {
            for (int b = 0; b < dstNumBands; ++b) {
                byte[] s = bSrcData[b];
                short[] d = sDstData[b];
                short[] t = sTblData[b];
                int srcLineOffset = srcBandOffsets[b];
                int dstLineOffset = dstBandOffsets[b];
                int tblOffset = tblOffsets[b];
                for (int y = 0; y < dstHeight; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = 0; x < dstWidth; ++x) {
                        byte value = s[srcPixelOffset];
                        d[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataShort : t[value & 255 - tblOffset];
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else if (this.useROIAccessor) {
            for (int b = 0; b < dstNumBands; ++b) {
                byte[] s = bSrcData[b];
                short[] d = sDstData[b];
                short[] t = sTblData[b];
                int srcLineOffset = srcBandOffsets[b];
                int dstLineOffset = dstBandOffsets[b];
                int tblOffset = tblOffsets[b];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    int posyROI = (y - dst_min_y) * roiLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        byte value;
                        int w;
                        int posx = (x - dst_min_x) * srcPixelStride;
                        int windex = posx / dstNumBands + posyROI;
                        int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                        d[dstPixelOffset] = w == 0 ? this.destinationNoDataShort : (this.noData.contains(value = s[srcPixelOffset]) ? this.destinationNoDataShort : t[value & 255 - tblOffset]);
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else {
            for (int b = 0; b < dstNumBands; ++b) {
                byte[] s = bSrcData[b];
                short[] d = sDstData[b];
                short[] t = sTblData[b];
                int srcLineOffset = srcBandOffsets[b];
                int dstLineOffset = dstBandOffsets[b];
                int tblOffset = tblOffsets[b];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        byte value;
                        int w;
                        d[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = this.roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataShort : (this.noData.contains(value = s[srcPixelOffset]) ? this.destinationNoDataShort : t[value & 255 - tblOffset])) : this.destinationNoDataShort;
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        }
    }

    private void lookup(int srcLineStride, int srcPixelStride, int[] srcBandOffsets, byte[][] bSrcData, int dstWidth, int dstHeight, int dstNumBands, int dstLineStride, int dstPixelStride, int[] dstBandOffsets, int[][] iDstData, int[] tblOffsets, int[][] iTblData, RasterAccessor roi, Rectangle destRect) {
        boolean caseNull;
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        int roiLineStride = 0;
        byte[] roiDataArray = null;
        int roiDataLength = 0;
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
            roiLineStride = roi.getScanlineStride();
        }
        boolean caseA = !this.hasROI && !this.hasNoData;
        boolean caseB = this.hasROI && !this.hasNoData;
        boolean caseC = !this.hasROI && this.hasNoData;
        boolean bl = caseNull = iTblData == null;
        if (caseA) {
            if (caseNull) {
                for (int b = 0; b < dstNumBands; ++b) {
                    byte[] s = bSrcData[b];
                    int[] d = iDstData[b];
                    int srcLineOffset = srcBandOffsets[b];
                    int dstLineOffset = dstBandOffsets[b];
                    for (int h = 0; h < dstHeight; ++h) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int w = 0; w < dstWidth; ++w) {
                            d[dstPixelOffset] = this.getData().getElem(b, s[srcPixelOffset] & 0xFF);
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            } else {
                for (int b = 0; b < dstNumBands; ++b) {
                    byte[] s = bSrcData[b];
                    int[] d = iDstData[b];
                    int[] t = iTblData[b];
                    int srcLineOffset = srcBandOffsets[b];
                    int dstLineOffset = dstBandOffsets[b];
                    int tblOffset = tblOffsets[b];
                    for (int h = 0; h < dstHeight; ++h) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int w = 0; w < dstWidth; ++w) {
                            d[dstPixelOffset] = t[(s[srcPixelOffset] & 0xFF) - tblOffset];
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            }
        } else if (caseB) {
            if (this.useROIAccessor) {
                if (caseNull) {
                    for (int b = 0; b < dstNumBands; ++b) {
                        byte[] s = bSrcData[b];
                        int[] d = iDstData[b];
                        int srcLineOffset = srcBandOffsets[b];
                        int dstLineOffset = dstBandOffsets[b];
                        for (int y = dst_min_y; y < dst_max_y; ++y) {
                            int srcPixelOffset = srcLineOffset;
                            int dstPixelOffset = dstLineOffset;
                            int posyROI = (y - dst_min_y) * roiLineStride;
                            srcLineOffset += srcLineStride;
                            dstLineOffset += dstLineStride;
                            for (int x = dst_min_x; x < dst_max_x; ++x) {
                                int posx = (x - dst_min_x) * srcPixelStride;
                                int windex = posx / dstNumBands + posyROI;
                                int w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                                d[dstPixelOffset] = w == 0 ? this.destinationNoDataInt : this.getData().getElem(b, s[srcPixelOffset] & 0xFF);
                                srcPixelOffset += srcPixelStride;
                                dstPixelOffset += dstPixelStride;
                            }
                        }
                    }
                } else {
                    for (int b = 0; b < dstNumBands; ++b) {
                        byte[] s = bSrcData[b];
                        int[] d = iDstData[b];
                        int[] t = iTblData[b];
                        int srcLineOffset = srcBandOffsets[b];
                        int dstLineOffset = dstBandOffsets[b];
                        int tblOffset = tblOffsets[b];
                        for (int y = dst_min_y; y < dst_max_y; ++y) {
                            int srcPixelOffset = srcLineOffset;
                            int dstPixelOffset = dstLineOffset;
                            srcLineOffset += srcLineStride;
                            dstLineOffset += dstLineStride;
                            int posyROI = (y - dst_min_y) * roiLineStride;
                            for (int x = dst_min_x; x < dst_max_x; ++x) {
                                int posx = (x - dst_min_x) * srcPixelStride;
                                int windex = posx / dstNumBands + posyROI;
                                int w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                                d[dstPixelOffset] = w == 0 ? this.destinationNoDataInt : t[(s[srcPixelOffset] & 0xFF) - tblOffset];
                                srcPixelOffset += srcPixelStride;
                                dstPixelOffset += dstPixelStride;
                            }
                        }
                    }
                }
            } else if (caseNull) {
                for (int b = 0; b < dstNumBands; ++b) {
                    byte[] s = bSrcData[b];
                    int[] d = iDstData[b];
                    int srcLineOffset = srcBandOffsets[b];
                    int dstLineOffset = dstBandOffsets[b];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int w;
                            d[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = this.roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataInt : this.getData().getElem(b, s[srcPixelOffset] & 0xFF)) : this.destinationNoDataInt;
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            } else {
                for (int b = 0; b < dstNumBands; ++b) {
                    byte[] s = bSrcData[b];
                    int[] d = iDstData[b];
                    int[] t = iTblData[b];
                    int srcLineOffset = srcBandOffsets[b];
                    int dstLineOffset = dstBandOffsets[b];
                    int tblOffset = tblOffsets[b];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int w;
                            d[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = this.roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataInt : t[(s[srcPixelOffset] & 0xFF) - tblOffset]) : this.destinationNoDataInt;
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            }
        } else if (caseC) {
            if (caseNull) {
                for (int b = 0; b < dstNumBands; ++b) {
                    byte[] s = bSrcData[b];
                    int[] d = iDstData[b];
                    int srcLineOffset = srcBandOffsets[b];
                    int dstLineOffset = dstBandOffsets[b];
                    for (int y = 0; y < dstHeight; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int x = 0; x < dstWidth; ++x) {
                            byte value = s[srcPixelOffset];
                            d[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataInt : this.getData().getElem(b, s[srcPixelOffset] & 0xFF);
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            } else {
                for (int b = 0; b < dstNumBands; ++b) {
                    byte[] s = bSrcData[b];
                    int[] d = iDstData[b];
                    int[] t = iTblData[b];
                    int srcLineOffset = srcBandOffsets[b];
                    int dstLineOffset = dstBandOffsets[b];
                    int tblOffset = tblOffsets[b];
                    for (int y = 0; y < dstHeight; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int x = 0; x < dstWidth; ++x) {
                            byte value = s[srcPixelOffset];
                            d[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataInt : t[value & 255 - tblOffset];
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            }
        } else if (this.useROIAccessor) {
            if (caseNull) {
                for (int b = 0; b < dstNumBands; ++b) {
                    byte[] s = bSrcData[b];
                    int[] d = iDstData[b];
                    int srcLineOffset = srcBandOffsets[b];
                    int dstLineOffset = dstBandOffsets[b];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        int posyROI = (y - dst_min_y) * roiLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            byte value;
                            int w;
                            int posx = (x - dst_min_x) * srcPixelStride;
                            int windex = posx / dstNumBands + posyROI;
                            int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                            d[dstPixelOffset] = w == 0 ? this.destinationNoDataInt : (this.noData.contains(value = s[srcPixelOffset]) ? this.destinationNoDataInt : this.getData().getElem(b, s[srcPixelOffset] & 0xFF));
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            } else {
                for (int b = 0; b < dstNumBands; ++b) {
                    byte[] s = bSrcData[b];
                    int[] d = iDstData[b];
                    int[] t = iTblData[b];
                    int srcLineOffset = srcBandOffsets[b];
                    int dstLineOffset = dstBandOffsets[b];
                    int tblOffset = tblOffsets[b];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        int posyROI = (y - dst_min_y) * roiLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            byte value;
                            int w;
                            int posx = (x - dst_min_x) * srcPixelStride;
                            int windex = posx / dstNumBands + posyROI;
                            int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                            d[dstPixelOffset] = w == 0 ? this.destinationNoDataInt : (this.noData.contains(value = s[srcPixelOffset]) ? this.destinationNoDataInt : t[value & 255 - tblOffset]);
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            }
        } else if (caseNull) {
            for (int b = 0; b < dstNumBands; ++b) {
                byte[] s = bSrcData[b];
                int[] d = iDstData[b];
                int srcLineOffset = srcBandOffsets[b];
                int dstLineOffset = dstBandOffsets[b];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        byte value;
                        int w;
                        d[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = this.roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataInt : (this.noData.contains(value = s[srcPixelOffset]) ? this.destinationNoDataInt : this.getData().getElem(b, s[srcPixelOffset] & 0xFF))) : this.destinationNoDataInt;
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else {
            for (int b = 0; b < dstNumBands; ++b) {
                byte[] s = bSrcData[b];
                int[] d = iDstData[b];
                int[] t = iTblData[b];
                int srcLineOffset = srcBandOffsets[b];
                int dstLineOffset = dstBandOffsets[b];
                int tblOffset = tblOffsets[b];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        byte value;
                        int w;
                        d[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = this.roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataInt : (this.noData.contains(value = s[srcPixelOffset]) ? this.destinationNoDataInt : t[value & 255 - tblOffset])) : this.destinationNoDataInt;
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        }
    }

    private void lookup(int srcLineStride, int srcPixelStride, int[] srcBandOffsets, byte[][] bSrcData, int dstWidth, int dstHeight, int dstNumBands, int dstLineStride, int dstPixelStride, int[] dstBandOffsets, float[][] fDstData, int[] tblOffsets, float[][] fTblData, RasterAccessor roi, Rectangle destRect) {
        boolean caseC;
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        int roiLineStride = 0;
        byte[] roiDataArray = null;
        int roiDataLength = 0;
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
            roiLineStride = roi.getScanlineStride();
        }
        boolean caseA = !this.hasROI && !this.hasNoData;
        boolean caseB = this.hasROI && !this.hasNoData;
        boolean bl = caseC = !this.hasROI && this.hasNoData;
        if (caseA) {
            for (int b = 0; b < dstNumBands; ++b) {
                byte[] s = bSrcData[b];
                float[] d = fDstData[b];
                float[] t = fTblData[b];
                int srcLineOffset = srcBandOffsets[b];
                int dstLineOffset = dstBandOffsets[b];
                int tblOffset = tblOffsets[b];
                for (int h = 0; h < dstHeight; ++h) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        d[dstPixelOffset] = t[(s[srcPixelOffset] & 0xFF) - tblOffset];
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else if (caseB) {
            if (this.useROIAccessor) {
                for (int b = 0; b < dstNumBands; ++b) {
                    byte[] s = bSrcData[b];
                    float[] d = fDstData[b];
                    float[] t = fTblData[b];
                    int srcLineOffset = srcBandOffsets[b];
                    int dstLineOffset = dstBandOffsets[b];
                    int tblOffset = tblOffsets[b];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        int posyROI = (y - dst_min_y) * roiLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int posx = (x - dst_min_x) * srcPixelStride;
                            int windex = posx / dstNumBands + posyROI;
                            int w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                            d[dstPixelOffset] = w == 0 ? this.destinationNoDataFloat : t[(s[srcPixelOffset] & 0xFF) - tblOffset];
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            } else {
                for (int b = 0; b < dstNumBands; ++b) {
                    byte[] s = bSrcData[b];
                    float[] d = fDstData[b];
                    float[] t = fTblData[b];
                    int srcLineOffset = srcBandOffsets[b];
                    int dstLineOffset = dstBandOffsets[b];
                    int tblOffset = tblOffsets[b];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int w;
                            d[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = this.roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataFloat : t[(s[srcPixelOffset] & 0xFF) - tblOffset]) : this.destinationNoDataFloat;
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            }
        } else if (caseC) {
            for (int b = 0; b < dstNumBands; ++b) {
                byte[] s = bSrcData[b];
                float[] d = fDstData[b];
                float[] t = fTblData[b];
                int srcLineOffset = srcBandOffsets[b];
                int dstLineOffset = dstBandOffsets[b];
                int tblOffset = tblOffsets[b];
                for (int y = 0; y < dstHeight; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = 0; x < dstWidth; ++x) {
                        byte value = s[srcPixelOffset];
                        d[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataFloat : t[value & 255 - tblOffset];
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else if (this.useROIAccessor) {
            for (int b = 0; b < dstNumBands; ++b) {
                byte[] s = bSrcData[b];
                float[] d = fDstData[b];
                float[] t = fTblData[b];
                int srcLineOffset = srcBandOffsets[b];
                int dstLineOffset = dstBandOffsets[b];
                int tblOffset = tblOffsets[b];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    int posyROI = (y - dst_min_y) * roiLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        byte value;
                        int w;
                        int posx = (x - dst_min_x) * srcPixelStride;
                        int windex = posx / dstNumBands + posyROI;
                        int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                        d[dstPixelOffset] = w == 0 ? this.destinationNoDataFloat : (this.noData.contains(value = s[srcPixelOffset]) ? this.destinationNoDataFloat : t[value & 255 - tblOffset]);
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else {
            for (int b = 0; b < dstNumBands; ++b) {
                byte[] s = bSrcData[b];
                float[] d = fDstData[b];
                float[] t = fTblData[b];
                int srcLineOffset = srcBandOffsets[b];
                int dstLineOffset = dstBandOffsets[b];
                int tblOffset = tblOffsets[b];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        byte value;
                        int w;
                        d[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = this.roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataFloat : (this.noData.contains(value = s[srcPixelOffset]) ? this.destinationNoDataFloat : t[value & 255 - tblOffset])) : this.destinationNoDataFloat;
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        }
    }

    private void lookup(int srcLineStride, int srcPixelStride, int[] srcBandOffsets, byte[][] bSrcData, int dstWidth, int dstHeight, int dstNumBands, int dstLineStride, int dstPixelStride, int[] dstBandOffsets, double[][] dDstData, int[] tblOffsets, double[][] dTblData, RasterAccessor roi, Rectangle destRect) {
        boolean caseC;
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        int roiLineStride = 0;
        byte[] roiDataArray = null;
        int roiDataLength = 0;
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
            roiLineStride = roi.getScanlineStride();
        }
        boolean caseA = !this.hasROI && !this.hasNoData;
        boolean caseB = this.hasROI && !this.hasNoData;
        boolean bl = caseC = !this.hasROI && this.hasNoData;
        if (caseA) {
            for (int b = 0; b < dstNumBands; ++b) {
                byte[] s = bSrcData[b];
                double[] d = dDstData[b];
                double[] t = dTblData[b];
                int srcLineOffset = srcBandOffsets[b];
                int dstLineOffset = dstBandOffsets[b];
                int tblOffset = tblOffsets[b];
                for (int h = 0; h < dstHeight; ++h) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        d[dstPixelOffset] = t[(s[srcPixelOffset] & 0xFF) - tblOffset];
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else if (caseB) {
            if (this.useROIAccessor) {
                for (int b = 0; b < dstNumBands; ++b) {
                    byte[] s = bSrcData[b];
                    double[] d = dDstData[b];
                    double[] t = dTblData[b];
                    int srcLineOffset = srcBandOffsets[b];
                    int dstLineOffset = dstBandOffsets[b];
                    int tblOffset = tblOffsets[b];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        int posyROI = (y - dst_min_y) * roiLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int posx = (x - dst_min_x) * srcPixelStride;
                            int windex = posx / dstNumBands + posyROI;
                            int w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                            d[dstPixelOffset] = w == 0 ? this.destinationNoDataDouble : t[(s[srcPixelOffset] & 0xFF) - tblOffset];
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            } else {
                for (int b = 0; b < dstNumBands; ++b) {
                    byte[] s = bSrcData[b];
                    double[] d = dDstData[b];
                    double[] t = dTblData[b];
                    int srcLineOffset = srcBandOffsets[b];
                    int dstLineOffset = dstBandOffsets[b];
                    int tblOffset = tblOffsets[b];
                    for (int y = dst_min_y; y < dst_max_y; ++y) {
                        int srcPixelOffset = srcLineOffset;
                        int dstPixelOffset = dstLineOffset;
                        srcLineOffset += srcLineStride;
                        dstLineOffset += dstLineStride;
                        for (int x = dst_min_x; x < dst_max_x; ++x) {
                            int w;
                            d[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = this.roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataDouble : t[(s[srcPixelOffset] & 0xFF) - tblOffset]) : this.destinationNoDataDouble;
                            srcPixelOffset += srcPixelStride;
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                }
            }
        } else if (caseC) {
            for (int b = 0; b < dstNumBands; ++b) {
                byte[] s = bSrcData[b];
                double[] d = dDstData[b];
                double[] t = dTblData[b];
                int srcLineOffset = srcBandOffsets[b];
                int dstLineOffset = dstBandOffsets[b];
                int tblOffset = tblOffsets[b];
                for (int y = 0; y < dstHeight; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = 0; x < dstWidth; ++x) {
                        byte value = s[srcPixelOffset];
                        d[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataDouble : t[value & 255 - tblOffset];
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else if (this.useROIAccessor) {
            for (int b = 0; b < dstNumBands; ++b) {
                byte[] s = bSrcData[b];
                double[] d = dDstData[b];
                double[] t = dTblData[b];
                int srcLineOffset = srcBandOffsets[b];
                int dstLineOffset = dstBandOffsets[b];
                int tblOffset = tblOffsets[b];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    int posyROI = (y - dst_min_y) * roiLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        byte value;
                        int w;
                        int posx = (x - dst_min_x) * srcPixelStride;
                        int windex = posx / dstNumBands + posyROI;
                        int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                        d[dstPixelOffset] = w == 0 ? this.destinationNoDataDouble : (this.noData.contains(value = s[srcPixelOffset]) ? this.destinationNoDataDouble : t[value & 255 - tblOffset]);
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        } else {
            for (int b = 0; b < dstNumBands; ++b) {
                byte[] s = bSrcData[b];
                double[] d = dDstData[b];
                double[] t = dTblData[b];
                int srcLineOffset = srcBandOffsets[b];
                int dstLineOffset = dstBandOffsets[b];
                int tblOffset = tblOffsets[b];
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int srcPixelOffset = srcLineOffset;
                    int dstPixelOffset = dstLineOffset;
                    srcLineOffset += srcLineStride;
                    dstLineOffset += dstLineStride;
                    for (int x = dst_min_x; x < dst_max_x; ++x) {
                        byte value;
                        int w;
                        d[dstPixelOffset] = this.roiBounds.contains(x, y) ? ((w = this.roiIter.getSample(x, y, 0)) == 0 ? this.destinationNoDataDouble : (this.noData.contains(value = s[srcPixelOffset]) ? this.destinationNoDataDouble : t[value & 255 - tblOffset])) : this.destinationNoDataDouble;
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                }
            }
        }
    }
}

