/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.lookup;

import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import it.geosolutions.jaiext.iterators.RandomIterFactory;
import it.geosolutions.jaiext.lookup.LookupTable;
import it.geosolutions.jaiext.range.Range;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ColormapOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.iterator.RandomIter;

public class LookupOpImage
extends ColormapOpImage {
    private LookupTable lookupTable;
    private PlanarImage srcROIImage;
    private boolean useRoiAccessor;
    private static final BorderExtender roiExtender = BorderExtender.createInstance((int)0);

    public LookupOpImage(RenderedImage source, ImageLayout layout, Map configuration, LookupTable lookupTable, double destinationNoData, ROI roi, Range noData, boolean useRoiAccessor) {
        super(source, layout, configuration, true);
        this.lookupTable = lookupTable;
        SampleModel sModel = source.getSampleModel();
        if (this.sampleModel.getTransferType() != lookupTable.getDataType() || this.sampleModel.getNumBands() != lookupTable.getDestNumBands(sModel.getNumBands())) {
            this.sampleModel = lookupTable.getDestSampleModel(sModel, this.tileWidth, this.tileHeight);
            if (this.colorModel != null && !JDKWorkarounds.areCompatibleDataModels((SampleModel)this.sampleModel, (ColorModel)this.colorModel)) {
                this.colorModel = ImageUtil.getCompatibleColorModel((SampleModel)this.sampleModel, (Map)configuration);
            }
        }
        this.permitInPlaceOperation();
        this.initializeColormapOperation();
        boolean hasNoData = false;
        boolean hasROI = false;
        if (roi != null) {
            ROI srcROI = roi;
            this.srcROIImage = srcROI.getAsImage();
            Rectangle rect = new Rectangle(this.srcROIImage.getBounds());
            Raster data = this.srcROIImage.getData(rect);
            RandomIter roiIter = RandomIterFactory.create((Raster)data, (Rectangle)data.getBounds(), (boolean)false, (boolean)true);
            hasROI = true;
            Rectangle roiBounds = this.srcROIImage.getBounds();
            this.useRoiAccessor = useRoiAccessor;
            lookupTable.setROIparams(roiBounds, roiIter, this.srcROIImage, useRoiAccessor);
        } else {
            this.useRoiAccessor = false;
            lookupTable.unsetROI();
        }
        if (noData != null) {
            hasNoData = true;
            if (noData.getDataType().getDataType() != source.getSampleModel().getDataType()) {
                throw new IllegalArgumentException("Range data type is not the same of the source image");
            }
            lookupTable.setNoDataRange(noData);
        } else {
            lookupTable.unsetNoData();
        }
        if (hasNoData || hasROI) {
            lookupTable.setDestinationNoData(destinationNoData);
        }
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        Raster tile = sources[0];
        Rectangle rect = tile.getBounds();
        if (this.useRoiAccessor) {
            Raster roi = this.srcROIImage.getExtendedData(rect, roiExtender);
            this.lookupTable.lookup(sources[0], dest, destRect, roi);
        } else {
            this.lookupTable.lookup(sources[0], dest, destRect, null);
        }
    }

    protected void transformColormap(byte[][] colormap) {
        for (int b = 0; b < 3; ++b) {
            byte[] map = colormap[b];
            int mapSize = map.length;
            int band = this.lookupTable.getNumBands() < 3 ? 0 : b;
            for (int i = 0; i < mapSize; ++i) {
                int result = this.lookupTable.lookup(band, map[i] & 0xFF);
                map[i] = ImageUtil.clampByte((int)result);
            }
        }
    }
}

