/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.lookup;

import com.sun.media.jai.util.DataBufferUtils;
import it.geosolutions.jaiext.range.Range;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.Serializable;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;
import javax.media.jai.iterator.RandomIter;

public abstract class LookupTable
implements Serializable {
    protected transient DataBuffer data;
    protected int[] tableOffsets;
    protected byte destinationNoDataByte;
    protected short destinationNoDataShort;
    protected int destinationNoDataInt;
    protected float destinationNoDataFloat;
    protected double destinationNoDataDouble;
    protected Range noData;
    protected Rectangle roiBounds;
    protected RandomIter roiIter;
    protected boolean useROIAccessor;
    protected PlanarImage srcROIImage;
    protected boolean hasNoData;
    protected boolean hasROI;

    protected LookupTable(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("Input data cannot be null");
        }
        this.data = new DataBufferByte(data, data.length);
        this.initOffsets(1, 0);
    }

    protected LookupTable(byte[] data, int offset) {
        if (data == null) {
            throw new IllegalArgumentException("Input data cannot be null");
        }
        this.initOffsets(1, offset);
        this.data = new DataBufferByte(data, data.length);
    }

    public LookupTable(byte[][] data) {
        if (data == null) {
            throw new IllegalArgumentException("Input data cannot be null");
        }
        this.initOffsets(data.length, 0);
        this.data = new DataBufferByte(data, data[0].length);
    }

    public LookupTable(byte[][] data, int offset) {
        if (data == null) {
            throw new IllegalArgumentException("Input data cannot be null");
        }
        this.initOffsets(data.length, offset);
        this.data = new DataBufferByte(data, data[0].length);
    }

    protected LookupTable(byte[][] data, int[] offsets) {
        if (data == null) {
            throw new IllegalArgumentException("Input data cannot be null");
        }
        this.initOffsets(data.length, offsets);
        this.data = new DataBufferByte(data, data[0].length);
    }

    protected LookupTable(short[] data, boolean isUShort) {
        if (data == null) {
            throw new IllegalArgumentException("Input data cannot be null");
        }
        this.initOffsets(1, 0);
        this.data = isUShort ? new DataBufferUShort(data, data.length) : new DataBufferShort(data, data.length);
    }

    protected LookupTable(short[] data, int offset, boolean isUShort) {
        if (data == null) {
            throw new IllegalArgumentException("Input data cannot be null");
        }
        this.initOffsets(1, offset);
        this.data = isUShort ? new DataBufferUShort(data, data.length) : new DataBufferShort(data, data.length);
    }

    protected LookupTable(short[][] data, boolean isUShort) {
        if (data == null) {
            throw new IllegalArgumentException("Input data cannot be null");
        }
        this.initOffsets(data.length, 0);
        this.data = isUShort ? new DataBufferUShort(data, data[0].length) : new DataBufferShort(data, data[0].length);
    }

    protected LookupTable(short[][] data, int offset, boolean isUShort) {
        if (data == null) {
            throw new IllegalArgumentException("Input data cannot be null");
        }
        this.initOffsets(data.length, offset);
        this.data = isUShort ? new DataBufferUShort(data, data[0].length) : new DataBufferShort(data, data[0].length);
    }

    protected LookupTable(short[][] data, int[] offsets, boolean isUShort) {
        if (data == null) {
            throw new IllegalArgumentException("Input data cannot be null");
        }
        this.initOffsets(data.length, offsets);
        this.data = isUShort ? new DataBufferUShort(data, data[0].length) : new DataBufferShort(data, data[0].length);
    }

    protected LookupTable(int[] data) {
        if (data == null) {
            throw new IllegalArgumentException("Input data cannot be null");
        }
        this.initOffsets(1, 0);
        this.data = new DataBufferInt(data, data.length);
    }

    protected LookupTable(int[] data, int offset) {
        if (data == null) {
            throw new IllegalArgumentException("Input data cannot be null");
        }
        this.initOffsets(1, offset);
        this.data = new DataBufferInt(data, data.length);
    }

    protected LookupTable(int[][] data) {
        if (data == null) {
            throw new IllegalArgumentException("Input data cannot be null");
        }
        this.initOffsets(data.length, 0);
        this.data = new DataBufferInt(data, data[0].length);
    }

    protected LookupTable(int[][] data, int offset) {
        if (data == null) {
            throw new IllegalArgumentException("Input data cannot be null");
        }
        this.initOffsets(data.length, offset);
        this.data = new DataBufferInt(data, data[0].length);
    }

    protected LookupTable(int[][] data, int[] offsets) {
        if (data == null) {
            throw new IllegalArgumentException("Input data cannot be null");
        }
        this.initOffsets(data.length, offsets);
        this.data = new DataBufferInt(data, data[0].length);
    }

    protected LookupTable(float[] data) {
        if (data == null) {
            throw new IllegalArgumentException("Input data cannot be null");
        }
        this.initOffsets(1, 0);
        this.data = DataBufferUtils.createDataBufferFloat((float[])data, (int)data.length);
    }

    protected LookupTable(float[] data, int offset) {
        if (data == null) {
            throw new IllegalArgumentException("Input data cannot be null");
        }
        this.initOffsets(1, offset);
        this.data = DataBufferUtils.createDataBufferFloat((float[])data, (int)data.length);
    }

    protected LookupTable(float[][] data) {
        if (data == null) {
            throw new IllegalArgumentException("Input data cannot be null");
        }
        this.initOffsets(data.length, 0);
        this.data = DataBufferUtils.createDataBufferFloat((float[][])data, (int)data[0].length);
    }

    protected LookupTable(float[][] data, int offset) {
        if (data == null) {
            throw new IllegalArgumentException("Input data cannot be null");
        }
        this.initOffsets(data.length, offset);
        this.data = DataBufferUtils.createDataBufferFloat((float[][])data, (int)data[0].length);
    }

    protected LookupTable(float[][] data, int[] offsets) {
        if (data == null) {
            throw new IllegalArgumentException("Input data cannot be null");
        }
        this.initOffsets(data.length, offsets);
        this.data = DataBufferUtils.createDataBufferFloat((float[][])data, (int)data[0].length);
    }

    protected LookupTable(double[] data) {
        if (data == null) {
            throw new IllegalArgumentException("Input data cannot be null");
        }
        this.initOffsets(1, 0);
        this.data = DataBufferUtils.createDataBufferDouble((double[])data, (int)data.length);
    }

    protected LookupTable(double[] data, int offset) {
        if (data == null) {
            throw new IllegalArgumentException("Input data cannot be null");
        }
        this.initOffsets(1, offset);
        this.data = DataBufferUtils.createDataBufferDouble((double[])data, (int)data.length);
    }

    protected LookupTable(double[][] data) {
        if (data == null) {
            throw new IllegalArgumentException("Input data cannot be null");
        }
        this.initOffsets(data.length, 0);
        this.data = DataBufferUtils.createDataBufferDouble((double[][])data, (int)data[0].length);
    }

    protected LookupTable(double[][] data, int offset) {
        if (data == null) {
            throw new IllegalArgumentException("Input data cannot be null");
        }
        this.initOffsets(data.length, offset);
        this.data = DataBufferUtils.createDataBufferDouble((double[][])data, (int)data[0].length);
    }

    protected LookupTable(double[][] data, int[] offsets) {
        if (data == null) {
            throw new IllegalArgumentException("Input data cannot be null");
        }
        this.initOffsets(data.length, offsets);
        this.data = DataBufferUtils.createDataBufferDouble((double[][])data, (int)data[0].length);
    }

    public DataBuffer getData() {
        return this.data;
    }

    public byte[][] getByteData() {
        return this.data instanceof DataBufferByte ? ((DataBufferByte)this.data).getBankData() : (byte[][])null;
    }

    public byte[] getByteData(int band) {
        return this.data instanceof DataBufferByte ? ((DataBufferByte)this.data).getData(band) : null;
    }

    public short[][] getShortData() {
        if (this.data instanceof DataBufferUShort) {
            return ((DataBufferUShort)this.data).getBankData();
        }
        if (this.data instanceof DataBufferShort) {
            return ((DataBufferShort)this.data).getBankData();
        }
        return null;
    }

    public short[] getShortData(int band) {
        if (this.data instanceof DataBufferUShort) {
            return ((DataBufferUShort)this.data).getData(band);
        }
        if (this.data instanceof DataBufferShort) {
            return ((DataBufferShort)this.data).getData(band);
        }
        return null;
    }

    public int[][] getIntData() {
        return this.data instanceof DataBufferInt ? ((DataBufferInt)this.data).getBankData() : (int[][])null;
    }

    public int[] getIntData(int band) {
        return this.data instanceof DataBufferInt ? ((DataBufferInt)this.data).getData(band) : null;
    }

    public float[][] getFloatData() {
        return this.data.getDataType() == 4 ? DataBufferUtils.getBankDataFloat((DataBuffer)this.data) : (float[][])null;
    }

    public float[] getFloatData(int band) {
        return this.data.getDataType() == 4 ? DataBufferUtils.getDataFloat((DataBuffer)this.data, (int)band) : null;
    }

    public double[][] getDoubleData() {
        return this.data.getDataType() == 5 ? DataBufferUtils.getBankDataDouble((DataBuffer)this.data) : (double[][])null;
    }

    public double[] getDoubleData(int band) {
        return this.data.getDataType() == 5 ? DataBufferUtils.getDataDouble((DataBuffer)this.data, (int)band) : null;
    }

    public int[] getOffsets() {
        return this.tableOffsets;
    }

    public int getOffset() {
        return this.tableOffsets[0];
    }

    public int getOffset(int band) {
        return this.tableOffsets[band];
    }

    public int getNumBands() {
        return this.data.getNumBanks();
    }

    public int getNumEntries() {
        return this.data.getSize();
    }

    public int getDataType() {
        return this.data.getDataType();
    }

    public int getDestNumBands(int srcNumBands) {
        int tblNumBands = this.getNumBands();
        return srcNumBands == 1 ? tblNumBands : srcNumBands;
    }

    public SampleModel getDestSampleModel(SampleModel srcSampleModel) {
        if (srcSampleModel == null) {
            throw new IllegalArgumentException("Source SampleModel must be not null");
        }
        return this.getDestSampleModel(srcSampleModel, srcSampleModel.getWidth(), srcSampleModel.getHeight());
    }

    public SampleModel getDestSampleModel(SampleModel srcSampleModel, int width, int height) {
        if (srcSampleModel == null) {
            throw new IllegalArgumentException("Source SampleModel must be not null");
        }
        if (!this.isIntegralDataType(srcSampleModel)) {
            return null;
        }
        return RasterFactory.createComponentSampleModel((SampleModel)srcSampleModel, (int)this.getDataType(), (int)width, (int)height, (int)this.getDestNumBands(srcSampleModel.getNumBands()));
    }

    public boolean isIntegralDataType(SampleModel sampleModel) {
        if (sampleModel == null) {
            throw new IllegalArgumentException("SampleModel must be not null");
        }
        return this.isIntegralDataType(sampleModel.getTransferType());
    }

    public boolean isIntegralDataType(int dataType) {
        return dataType == 0 || dataType == 1 || dataType == 2 || dataType == 3;
    }

    public int lookup(int band, int value) {
        return this.data.getElem(band, value - this.tableOffsets[band]);
    }

    public float lookupFloat(int band, int value) {
        return this.data.getElemFloat(band, value - this.tableOffsets[band]);
    }

    public double lookupDouble(int band, int value) {
        return this.data.getElemDouble(band, value - this.tableOffsets[band]);
    }

    protected void initOffsets(int nbands, int offset) {
        this.tableOffsets = new int[nbands];
        for (int i = 0; i < nbands; ++i) {
            this.tableOffsets[i] = offset;
        }
    }

    protected void initOffsets(int nbands, int[] offset) {
        this.tableOffsets = new int[nbands];
        for (int i = 0; i < nbands; ++i) {
            this.tableOffsets[i] = offset[i];
        }
    }

    public void setDestinationNoData(double destinationNoData) {
        int dataType = this.getDataType();
        switch (dataType) {
            case 0: {
                this.destinationNoDataByte = (byte)((byte)destinationNoData & 0xFF);
                break;
            }
            case 1: {
                this.destinationNoDataShort = (short)((short)destinationNoData & 0xFFFF);
                break;
            }
            case 2: {
                this.destinationNoDataShort = (short)destinationNoData;
                break;
            }
            case 3: {
                this.destinationNoDataInt = (int)destinationNoData;
                break;
            }
            case 4: {
                this.destinationNoDataFloat = (float)destinationNoData;
                break;
            }
            case 5: {
                this.destinationNoDataDouble = destinationNoData;
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong data type");
            }
        }
    }

    public void setNoDataRange(Range noData) {
        this.noData = noData;
        this.hasNoData = true;
    }

    public void unsetNoData() {
        this.noData = null;
        this.hasNoData = false;
    }

    public void setROIparams(Rectangle roiBounds, RandomIter roiIter, PlanarImage srcROIImage, boolean useROIAccessor) {
        this.hasROI = true;
        this.roiBounds = roiBounds;
        this.roiIter = roiIter;
        this.useROIAccessor = useROIAccessor;
        this.srcROIImage = srcROIImage;
    }

    public void unsetROI() {
        this.hasROI = false;
        this.roiBounds = null;
        this.roiIter = null;
        this.srcROIImage = null;
        this.useROIAccessor = false;
    }

    protected abstract void lookup(Raster var1, WritableRaster var2, Rectangle var3, Raster var4);
}

