/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.jiffleop;

import com.sun.media.jai.operator.ImageReadDescriptor;
import it.geosolutions.jaiext.jiffle.JiffleException;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;

public class SentinelNDVI {
    public static void main(String[] args) throws IOException, JiffleException {
        String basePath = "/opt/gisData/evo-odas/coverave-view-hetero/multires-s2/S2A_MSIL1C_20170410T103021_N0204_R108_T32UNU_20170410T103020.SAFE/20170410T103021026Z_fullres_CC2.4251_T32UNU_";
        JAI jai = JAI.getDefaultInstance();
        jai.getTileCache().setMemoryCapacity(0x40000000L);
        RenderedOp red = SentinelNDVI.readImage(new File(basePath + "B04.tif"));
        RenderedOp nir = SentinelNDVI.readImage(new File(basePath + "B08.tif"));
        ParameterBlockJAI pb = new ParameterBlockJAI("Jiffle");
        String script = "n = nir; r = red; res = (n - r) / (n + r);";
        pb.setParameter("script", (Object)script);
        pb.setParameter("destName", (Object)"res");
        pb.setParameter("sourceNames", (Object)new String[]{"red", "nir"});
        pb.setParameter("destType", 4);
        pb.addSource((Object)red);
        pb.addSource((Object)nir);
        RenderedOp op = JAI.create((String)"Jiffle", (ParameterBlock)pb);
        double pixels = (double)red.getWidth() * (double)red.getHeight();
        System.out.println("Computing " + NumberFormat.getNumberInstance().format(pixels) + " pixels");
        for (int i = 0; i < 10; ++i) {
            jai.getTileCache().flush();
            long start = System.currentTimeMillis();
            ImageIO.write((RenderedImage)op, "TIF", new File("/tmp/ndvi.tif"));
            long end = System.currentTimeMillis();
            System.out.println("Computing and writing took " + (double)(end - start) / 1000.0 + " secs");
        }
    }

    private static RenderedOp readImage(File file) throws IOException {
        FileImageInputStream stream = new FileImageInputStream(file);
        ImageReader reader = ImageIO.getImageReaders(stream).next();
        return ImageReadDescriptor.create((ImageInputStream)stream, (Integer)0, (Boolean)false, (Boolean)false, (Boolean)false, null, null, null, (ImageReader)reader, null);
    }
}

