/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.jiffleop;

import it.geosolutions.jaiext.jiffle.runtime.BandTransform;
import it.geosolutions.jaiext.jiffle.runtime.CoordinateTransform;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;

public class JiffleDescriptor
extends OperationDescriptorImpl {
    static final int SOURCE_IMAGE_NAMES_ARG = 0;
    static final int DEST_NAME_ARG = 1;
    static final int SCRIPT_ARG = 2;
    static final int DEST_BOUNDS_ARG = 3;
    static final int DEST_TYPE_ARG = 4;
    static final int SRC_COORDINATE_TRANSFORM_ARG = 5;
    static final int SRC_BAND_TRANSFORM_ARG = 6;
    static final int DEST_BANDS_ARG = 7;
    public static final String SOURCE_NAMES = "sourceNames";
    public static final String DEST_NAME = "destName";
    public static final String SCRIPT = "script";
    public static final String DEST_BOUNDS = "destBounds";
    public static final String DEST_TYPE = "destType";
    public static final String SRC_COORDINATE_TRANSFORMS = "srcCoordinateTransforms";
    public static final String SRC_BAND_TRANSFORMS = "srcBandTransforms";
    public static final String DEST_BANDS = "destBands";
    private static final String[] paramNames = new String[]{"sourceNames", "destName", "script", "destBounds", "destType", "srcCoordinateTransforms", "srcBandTransforms", "destBands"};
    private static final Class[] paramClasses = new Class[]{String[].class, String.class, String.class, Rectangle.class, Integer.class, CoordinateTransform[].class, BandTransform[].class, Integer.class};
    private static final Object[] paramDefaults = new Object[]{null, "dest", NO_PARAMETER_DEFAULT, null, 5, null, null, null};

    public JiffleDescriptor() {
        super((String[][])new String[][]{{"GlobalName", "Jiffle"}, {"LocalName", "Jiffle"}, {"Vendor", "it.geosolutions.jaiext"}, {"Description", "Execute a Jiffle script"}, {"DocURL", ""}, {"Version", "1.2.0"}, {"arg0Desc", paramNames[0] + " (String[], default {src, src1, src2, ...}):name of the source rasters"}, {"arg1Desc", paramNames[1] + " (String, default \"dest\"):the destination variable name"}, {"arg2Desc", paramNames[2] + " (String):the Jiffle script"}, {"arg3Desc", paramNames[3] + " (Rectangle, default will use the image layout if provided, or the union of the sources otherwise):the output bounds"}, {"arg4Desc", paramNames[4] + " (Output data type, default is DataBuffer.TYPE_DOUBLE):the output data type, as a DataBuffer.TYPE_* constant"}, {"arg6Desc", paramNames[5] + " (Source coordinate transforms):the world to image source transforms, if needed"}, {"arg7Desc", paramNames[6] + " (Source band transforms):the script to image band transforms, if needed"}, {"arg5Desc", paramNames[7] + " (Number of output bands, by default the code will try to determine it from the script itself):the number of bands in the output image, must be a positive integer"}}, new String[]{"rendered"}, 1, paramNames, paramClasses, paramDefaults, null);
    }

    public int getNumSources() {
        return 0;
    }

    public static RenderedOp create(RenderedImage[] sources, String[] sourceImageNames, String destName, String script, Rectangle destBounds, Integer destType, Integer destBands, CoordinateTransform[] sourceCoordinateTransforms, BandTransform[] sourceBandTransforms, RenderingHints renderingHints) {
        ParameterBlockJAI pb = new ParameterBlockJAI("Jiffle", "rendered");
        int numSources = sources.length;
        for (int i = 0; i < numSources; ++i) {
            pb.addSource((Object)sources[i]);
        }
        pb.setParameter(SOURCE_NAMES, (Object)sourceImageNames);
        pb.setParameter(DEST_NAME, (Object)destName);
        pb.setParameter(SCRIPT, (Object)script);
        pb.setParameter(DEST_BOUNDS, (Object)destBounds);
        pb.setParameter(DEST_TYPE, (Object)destType);
        pb.setParameter(SRC_COORDINATE_TRANSFORMS, (Object)sourceCoordinateTransforms);
        pb.setParameter(SRC_BAND_TRANSFORMS, (Object)sourceBandTransforms);
        pb.setParameter(DEST_BANDS, (Object)destBands);
        return JAI.create((String)"Jiffle", (ParameterBlock)pb, (RenderingHints)renderingHints);
    }

    @Deprecated
    public static RenderedOp create(RenderedImage[] sources, String[] sourceImageNames, String destName, String script, Rectangle destBounds, Integer destType, CoordinateTransform[] sourceCoordinateTransforms, BandTransform[] sourceBandTransforms, RenderingHints renderingHints) {
        return JiffleDescriptor.create(sources, sourceImageNames, destName, script, destBounds, destType, null, sourceCoordinateTransforms, sourceBandTransforms, renderingHints);
    }
}

