/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.jiffleop;

import it.geosolutions.jaiext.jiffle.JiffleBuilder;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.iterator.RectIter;
import javax.media.jai.iterator.RectIterFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NoSourceTest {
    private static final double TOL = 1.0E-8;
    private static final int WIDTH = 10;
    private Dimension savedTileSize;

    @Before
    public void init() {
        this.savedTileSize = JAI.getDefaultTileSize();
        JAI.setDefaultTileSize((Dimension)new Dimension(5, 5));
    }

    @After
    public void reset() {
        JAI.setDefaultTileSize((Dimension)this.savedTileSize);
    }

    @Test
    public void createSequentialImage() throws Exception {
        ParameterBlockJAI pb = new ParameterBlockJAI("Jiffle");
        String script = "dest = y() * width() + x();";
        pb.setParameter("script", (Object)script);
        pb.setParameter("destName", (Object)"dest");
        Rectangle bounds = new Rectangle(0, 0, 10, 10);
        pb.setParameter("destBounds", (Object)bounds);
        RenderedOp op = JAI.create((String)"Jiffle", (ParameterBlock)pb);
        PlanarImage result = op.getRendering();
        this.assertResult((RenderedImage)result, script);
    }

    private void assertResult(RenderedImage resultImage, String script) throws Exception {
        JiffleBuilder builder = new JiffleBuilder();
        builder.script(script).dest("dest", 10, 10).run();
        RenderedImage referenceImage = builder.getImage("dest");
        RectIter resultIter = RectIterFactory.create((RenderedImage)resultImage, null);
        RectIter referenceIter = RectIterFactory.create((RenderedImage)referenceImage, null);
        while (true) {
            Assert.assertEquals((long)resultIter.getSample(), (long)referenceIter.getSample());
            resultIter.nextPixelDone();
            if (!referenceIter.nextPixelDone()) continue;
            resultIter.startPixels();
            resultIter.nextLineDone();
            referenceIter.startPixels();
            if (referenceIter.nextLineDone()) break;
        }
    }
}

