/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.jiffle.demo;

import com.sun.media.jai.operator.ImageReadDescriptor;
import it.geosolutions.jaiext.jiffle.JiffleBuilder;
import it.geosolutions.jaiext.jiffle.JiffleException;
import it.geosolutions.jaiext.jiffle.runtime.JiffleDirectRuntime;
import it.geosolutions.jaiext.utilities.ImageUtilities;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.RenderedOp;
import javax.media.jai.TiledImage;

public class SentinelNDVI {
    public static void main(String[] args) throws IOException, JiffleException {
        String basePath = "/opt/gisData/evo-odas/coverave-view-hetero/multires-s2/S2A_MSIL1C_20170410T103021_N0204_R108_T32UNU_20170410T103020.SAFE/20170410T103021026Z_fullres_CC2.4251_T32UNU_";
        RenderedOp red = SentinelNDVI.readImage(new File(basePath + "B04.tif"));
        RenderedOp nir = SentinelNDVI.readImage(new File(basePath + "B08.tif"));
        TiledImage result = ImageUtilities.createConstantImage((int)red.getWidth(), (int)red.getHeight(), (Number)Float.valueOf(0.0f));
        JiffleBuilder builder = new JiffleBuilder();
        builder.dest("res", (WritableRenderedImage)result).source("red", (RenderedImage)red).source("nir", (RenderedImage)nir);
        builder.script("n = nir; r = red; res = (n - r) / (n + r);");
        JiffleDirectRuntime runtime = builder.getRuntime();
        double pixels = (double)red.getWidth() * (double)red.getHeight();
        System.out.println("Computing " + NumberFormat.getNumberInstance().format(pixels) + " pixels");
        long start = System.currentTimeMillis();
        runtime.evaluateAll(null);
        long end = System.currentTimeMillis();
        System.out.println("Computation of output took " + (double)(end - start) / 1000.0 + " secs");
        System.out.println("Writing output to disk");
        ImageIO.write((RenderedImage)result, "TIF", new File("/tmp/ndvi.tif"));
        System.out.println("Writing complete");
    }

    private static RenderedOp readImage(File file) throws IOException {
        FileImageInputStream stream = new FileImageInputStream(file);
        ImageReader reader = ImageIO.getImageReaders(stream).next();
        return ImageReadDescriptor.create((ImageInputStream)stream, (Integer)0, (Boolean)false, (Boolean)false, (Boolean)false, null, null, null, (ImageReader)reader, null);
    }
}

