/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.jiffle.demo;

import it.geosolutions.jaiext.jiffle.JiffleException;
import it.geosolutions.jaiext.jiffle.demo.ImageChoice;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;

public class JiffleDemoHelper {
    public static String getScript(ImageChoice choice) throws JiffleException {
        File scriptFile = JiffleDemoHelper.getScriptFile(null, choice);
        return JiffleDemoHelper.readScriptFile(scriptFile);
    }

    public static File getScriptFile(String[] args, ImageChoice defaultScript) throws JiffleException {
        String fileName = null;
        File file = null;
        if (args == null || args.length < 1) {
            try {
                fileName = defaultScript.toString() + ".jfl";
                URL url = JiffleDemoHelper.class.getResource("/scripts/" + fileName);
                file = new File(url.toURI());
            }
            catch (URISyntaxException ex) {
                throw new RuntimeException(ex);
            }
        } else {
            fileName = args[0];
            file = new File(fileName);
        }
        if (file.exists()) {
            return file;
        }
        throw new JiffleException("Can't find script file:" + fileName);
    }

    public static String readScriptFile(File scriptFile) throws JiffleException {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(scriptFile));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException ex) {
            throw new JiffleException("Could not read the script file", (Throwable)ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

