/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.jiffle.demo;

import it.geosolutions.jaiext.jiffle.Jiffle;
import it.geosolutions.jaiext.jiffle.demo.ImageChoice;
import it.geosolutions.jaiext.jiffle.demo.JiffleDemoBase;
import it.geosolutions.jaiext.jiffle.demo.JiffleDemoHelper;
import it.geosolutions.jaiext.jiffle.runtime.JiffleDirectRuntime;
import it.geosolutions.jaiext.jiffle.runtime.JiffleEvent;
import it.geosolutions.jaiext.jiffle.runtime.JiffleEventListener;
import it.geosolutions.jaiext.jiffle.runtime.JiffleExecutor;
import it.geosolutions.jaiext.jiffle.runtime.JiffleExecutorResult;
import it.geosolutions.jaiext.jiffle.runtime.JiffleProgressListener;
import it.geosolutions.jaiext.jiffle.runtime.NullProgressListener;
import it.geosolutions.jaiext.swing.ImageFrame;
import it.geosolutions.jaiext.utilities.ImageUtilities;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRenderedImage;
import java.io.File;
import java.util.HashMap;
import javax.media.jai.TiledImage;

public class JiffleExecutorDemo
extends JiffleDemoBase {
    private JiffleExecutor executor = new JiffleExecutor(1);

    public static void main(String[] args) throws Exception {
        JiffleExecutorDemo demo = new JiffleExecutorDemo();
        File f = JiffleDemoHelper.getScriptFile(args, ImageChoice.RIPPLES);
        demo.compileAndRun(f);
    }

    public JiffleExecutorDemo() {
        this.executor.addEventListener(new JiffleEventListener(){

            public void onCompletionEvent(JiffleEvent ev) {
                JiffleExecutorDemo.this.onCompletion(ev);
            }

            public void onFailureEvent(JiffleEvent ev) {
                JiffleExecutorDemo.this.onFailure(ev);
            }
        });
    }

    public void compileAndRun(File scriptFile) throws Exception {
        HashMap<String, Jiffle.ImageRole> imageParams = new HashMap<String, Jiffle.ImageRole>();
        imageParams.put("result", Jiffle.ImageRole.DEST);
        Jiffle jiffle = new Jiffle(scriptFile, imageParams);
        JiffleDirectRuntime runtime = jiffle.getRuntimeInstance();
        TiledImage destImage = ImageUtilities.createConstantImage((int)500, (int)500, (Number)0.0);
        runtime.setDestinationImage("result", (WritableRenderedImage)destImage);
        this.executor.submit(runtime, (JiffleProgressListener)new NullProgressListener());
    }

    private void onCompletion(JiffleEvent ev) {
        JiffleExecutorResult result = ev.getResult();
        RenderedImage img = (RenderedImage)result.getImages().get("result");
        ImageFrame frame = new ImageFrame(img, "Jiffle image demo");
        frame.setVisible(true);
    }

    private void onFailure(JiffleEvent ev) {
        System.err.println("Bummer: script failed to run");
    }
}

