/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.crop;

import com.sun.media.jai.util.SunTileCache;
import it.geosolutions.jaiext.crop.CropDescriptor;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.stats.Statistics;
import it.geosolutions.jaiext.stats.StatisticsDescriptor;
import it.geosolutions.jaiext.testclasses.TestBase;
import it.geosolutions.rendered.viewer.RenderedImageBrowser;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.IOException;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.SubtractDescriptor;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class CropImageTest
extends TestBase {
    private static final byte noDataValue = 50;
    private static RenderedImage source;
    private static double[] destNoData;

    @BeforeClass
    public static void initialSetup() {
        source = CropImageTest.createTestImage((int)0, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)50, (boolean)false);
        destNoData = new double[]{127.0};
    }

    @Test
    public void testCropImagePB() {
        ParameterBlock pb = this.buildParameterBlock(source, false, false, false);
        ParameterBlock pbNew = this.buildParameterBlock(source, true, false, false);
        RenderedOp cropped = JAI.create((String)"crop", (ParameterBlock)pb);
        RenderedOp jaiextCropped = JAI.create((String)"Crop", (ParameterBlock)pbNew);
        this.assertImageEquals(cropped, jaiextCropped);
        if (INTERACTIVE && TEST_SELECTOR == 0) {
            RenderedImageBrowser.showChain((RenderedImage)jaiextCropped, (boolean)false, (boolean)false);
            try {
                System.in.read();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Test
    public void testCropImageROI() {
        ParameterBlock pb = this.buildParameterBlock(source, false, false, false);
        ParameterBlock pbNew = this.buildParameterBlock(source, true, true, false);
        RenderedOp cropped = JAI.create((String)"crop", (ParameterBlock)pb);
        RenderedOp jaiextCropped = JAI.create((String)"Crop", (ParameterBlock)pbNew);
        Rectangle boundOld = cropped.getBounds();
        Rectangle boundNew = jaiextCropped.getBounds();
        boolean contained = boundNew.getMinX() >= boundOld.getMinX() && boundNew.getMinY() >= boundOld.getMinY() && boundNew.getMaxX() <= boundOld.getMaxX() && boundNew.getMaxY() <= boundOld.getMaxY();
        Assert.assertTrue((boolean)contained);
        if (INTERACTIVE && TEST_SELECTOR == 1) {
            RenderedImageBrowser.showChain((RenderedImage)jaiextCropped, (boolean)false, (boolean)true);
            try {
                System.in.read();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Test
    public void testCropImageROINoData() {
        ParameterBlock pb = this.buildParameterBlock(source, false, false, false);
        ParameterBlock pbNew = this.buildParameterBlock(source, true, true, true);
        RenderedOp cropped = JAI.create((String)"crop", (ParameterBlock)pb);
        RenderedOp jaiextCropped = JAI.create((String)"Crop", (ParameterBlock)pbNew);
        Rectangle boundOld = cropped.getBounds();
        Rectangle boundNew = jaiextCropped.getBounds();
        boolean contained = boundNew.getMinX() >= boundOld.getMinX() && boundNew.getMinY() >= boundOld.getMinY() && boundNew.getMaxX() <= boundOld.getMaxX() && boundNew.getMaxY() <= boundOld.getMaxY();
        Assert.assertTrue((boolean)contained);
        int tileMinX = jaiextCropped.getMinTileX();
        int tileMinY = jaiextCropped.getMinTileY();
        Raster tile = jaiextCropped.getTile(tileMinX, tileMinY);
        int tileMinXpix = tile.getMinX();
        int tileMinYpix = tile.getMinY();
        int tileMaxXpix = tile.getWidth() + tileMinXpix;
        int tileMaxYpix = tile.getHeight() + tileMinYpix;
        boolean destinationNoDataFound = false;
        for (int i = tileMinXpix; i < tileMaxXpix; ++i) {
            for (int j = tileMinYpix; j < tileMaxYpix; ++j) {
                int value = tile.getSample(i, j, 0);
                if (value != (int)destNoData[0]) continue;
                destinationNoDataFound = true;
                break;
            }
            if (destinationNoDataFound) break;
        }
        if (INTERACTIVE && TEST_SELECTOR == 2) {
            RenderedImageBrowser.showChain((RenderedImage)jaiextCropped, (boolean)false, (boolean)true);
            try {
                System.in.read();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Test
    public void testTileCache() {
        SunTileCache tc = new SunTileCache();
        RenderingHints hints = new RenderingHints(JAI.KEY_TILE_CACHE, tc);
        ParameterBlock pb = this.buildParameterBlock(source, true, false, false);
        RenderedOp jaiextCropped = JAI.create((String)"Crop", (ParameterBlock)pb, (RenderingHints)hints);
        jaiextCropped.getColorModel();
        Assert.assertSame((Object)tc, (Object)jaiextCropped.getRenderingHint(JAI.KEY_TILE_CACHE));
    }

    @Test
    public void testNullTileCache() {
        RenderingHints hints = new RenderingHints(JAI.KEY_TILE_CACHE, null);
        ParameterBlock pb = this.buildParameterBlock(source, true, false, false);
        RenderedOp jaiCropped = JAI.create((String)"Crop", (ParameterBlock)pb, (RenderingHints)hints);
        jaiCropped.getColorModel();
        Assert.assertNull((Object)jaiCropped.getRenderingHint(JAI.KEY_TILE_CACHE));
    }

    @Test
    public void testNullTileCacheDescriptor() {
        RenderingHints hints = new RenderingHints(JAI.KEY_TILE_CACHE, null);
        RenderedOp cropped = CropDescriptor.create((RenderedImage)source, (Float)Float.valueOf(10.0f), (Float)Float.valueOf(10.0f), (Float)Float.valueOf(20.0f), (Float)Float.valueOf(20.0f), null, null, null, (RenderingHints)hints);
        cropped.getColorModel();
        Assert.assertNull((Object)cropped.getRenderingHint(JAI.KEY_TILE_CACHE));
    }

    private void assertImageEquals(RenderedOp first, RenderedOp second) {
        RenderedOp difference = SubtractDescriptor.create((RenderedImage)first, (RenderedImage)second, null);
        Statistics.StatsType[] statsType = new Statistics.StatsType[]{Statistics.StatsType.EXTREMA};
        RenderedOp stats = StatisticsDescriptor.create((RenderedImage)difference, (int)1, (int)1, null, null, (boolean)false, (int[])new int[]{0, 1, 2}, (Statistics.StatsType[])statsType, null);
        Statistics[][] results = (Statistics[][])stats.getProperty("JAI-EXT.stats");
        for (int i = 0; i < results.length; ++i) {
            double[] data = (double[])results[i][0].getResult();
            Assert.assertEquals((double)data[0], (double)data[1], (double)0.0);
        }
    }

    private ParameterBlock buildParameterBlock(RenderedImage source, boolean newDescriptor, boolean roiUsed, boolean noDataUsed) {
        ParameterBlockJAI pb = newDescriptor ? new ParameterBlockJAI("Crop") : new ParameterBlockJAI("crop");
        pb.setSource("source0", (Object)source);
        pb.setParameter("x", 0.0f);
        pb.setParameter("y", 0.0f);
        pb.setParameter("width", 20.0f);
        pb.setParameter("height", 20.0f);
        if (newDescriptor) {
            if (roiUsed) {
                ROIShape roi = new ROIShape((Shape)new Rectangle(5, 5, 10, 10));
                pb.setParameter("ROI", (Object)roi);
            }
            if (noDataUsed) {
                Range noData = RangeFactory.create((byte)50, (boolean)true, (byte)50, (boolean)true);
                pb.setParameter("NoData", (Object)noData);
                pb.setParameter("destNoData", (Object)destNoData);
            }
        }
        return pb;
    }
}

