/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.crop;

import com.sun.media.jai.opimage.RIFUtil;
import it.geosolutions.jaiext.crop.CropOpImage;
import it.geosolutions.jaiext.mosaic.ImageMosaicBean;
import it.geosolutions.jaiext.mosaic.MosaicOpImage;
import it.geosolutions.jaiext.range.Range;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.operator.MosaicDescriptor;

public class CropCRIF
implements RenderedImageFactory {
    public RenderedImage create(ParameterBlock paramBlock, RenderingHints renderingHints) {
        Rectangle bounds;
        RenderedImage image = (RenderedImage)paramBlock.getSource(0);
        float x = paramBlock.getFloatParameter(0);
        float y = paramBlock.getFloatParameter(1);
        float width = paramBlock.getFloatParameter(2);
        float height = paramBlock.getFloatParameter(3);
        ROI roi = (ROI)paramBlock.getObjectParameter(4);
        Range noData = (Range)paramBlock.getObjectParameter(5);
        double[] destNoData = (double[])paramBlock.getObjectParameter(6);
        HashMap<RenderingHints.Key, Object> tmp = new HashMap<RenderingHints.Key, Object>();
        for (Object key : renderingHints.keySet()) {
            if (key != JAI.KEY_TILE_CACHE && key != JAI.KEY_TILE_SCHEDULER) continue;
            tmp.put((RenderingHints.Key)key, renderingHints.get(key));
        }
        RenderingHints local = new RenderingHints(tmp);
        ImageLayout layout = RIFUtil.getImageLayoutHint((RenderingHints)local);
        Rectangle finalBounds = bounds = new Rectangle2D.Float(x, y, width, height).getBounds();
        if (roi != null) {
            Rectangle roiBounds = roi.getBounds();
            if (finalBounds.contains(roiBounds)) {
                finalBounds = roiBounds;
            } else {
                finalBounds.intersection(roiBounds);
            }
        }
        x = (float)finalBounds.getMinX();
        y = (float)finalBounds.getMinY();
        width = (float)finalBounds.getWidth();
        height = (float)finalBounds.getHeight();
        if (noData != null) {
            roi = new ROIShape((Shape)finalBounds);
            Vector<RenderedImage> listSrc = new Vector<RenderedImage>();
            listSrc.add(image);
            ImageMosaicBean[] bean = new ImageMosaicBean[]{new ImageMosaicBean()};
            bean[0].setImage(image);
            bean[0].setRoi(roi);
            bean[0].setSourceNoData(noData);
            if (layout == null) {
                layout = new ImageLayout();
            }
            layout.setHeight(finalBounds.height);
            layout.setWidth(finalBounds.width);
            layout.setMinX(finalBounds.x);
            layout.setMinY(finalBounds.y);
            image = new MosaicOpImage(listSrc, layout, (Map)local, bean, MosaicDescriptor.MOSAIC_TYPE_OVERLAY, destNoData);
            return image;
        }
        return new CropOpImage(image, x, y, width, height, local);
    }
}

