/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.convolve;

import com.sun.media.jai.util.ImageUtil;
import it.geosolutions.jaiext.convolve.ConvolveOpImage;
import it.geosolutions.jaiext.range.Range;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.KernelJAI;
import javax.media.jai.ROI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.iterator.RandomIter;

public class SeparableConvolveOpImage
extends ConvolveOpImage {
    private float[] hValues;
    private float[] vValues;
    private float[][] hTables;

    public SeparableConvolveOpImage(RenderedImage source, BorderExtender extender, RenderingHints hints, ImageLayout l, KernelJAI kernel, ROI roi, Range noData, double destinationNoData, boolean skipNoData) {
        super(source, extender, hints, l, kernel, roi, noData, destinationNoData, skipNoData);
        this.kernel = kernel;
        this.kw = kernel.getWidth();
        this.kh = kernel.getHeight();
        this.kx = kernel.getXOrigin();
        this.ky = kernel.getYOrigin();
        this.hValues = kernel.getHorizontalKernelData();
        this.vValues = kernel.getVerticalKernelData();
        if (this.sampleModel.getDataType() == 0) {
            this.hTables = new float[this.hValues.length][256];
            for (int i = 0; i < this.hValues.length; ++i) {
                float k = this.hValues[i];
                for (int j = 0; j < 256; ++j) {
                    byte b = (byte)j;
                    float f = j;
                    this.hTables[i][b + 128] = this.hasNoData && noData.contains(b) ? 0.0f : k * f;
                }
            }
        }
    }

    @Override
    protected void byteLoop(RasterAccessor src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int dnumBands = dst.getNumBands();
        byte[][] dstDataArrays = dst.getByteDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        byte[][] srcDataArrays = src.getByteDataArrays();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        float[] tmpBuffer = new float[this.kh * dwidth];
        int tmpBufferSize = this.kh * dwidth;
        int x0 = 0;
        int y0 = 0;
        int srcX = src.getX();
        int srcY = src.getY();
        if (this.caseA || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int k = 0; k < dnumBands; ++k) {
                int srcPixelOffset;
                int j;
                byte[] dstData = dstDataArrays[k];
                byte[] srcData = srcDataArrays[k];
                int srcScanlineOffset = srcBandOffsets[k];
                int dstScanlineOffset = dstBandOffsets[k];
                int revolver = 0;
                int kvRevolver = 0;
                for (j = 0; j < this.kh - 1; ++j) {
                    srcPixelOffset = srcScanlineOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int imageOffset = srcPixelOffset;
                        float f = 0.0f;
                        for (int v = 0; v < this.kw; ++v) {
                            f += this.hTables[v][srcData[imageOffset] + 128];
                            imageOffset += srcPixelStride;
                        }
                        tmpBuffer[revolver + i] = f;
                        srcPixelOffset += srcPixelStride;
                    }
                    revolver += dwidth;
                    srcScanlineOffset += srcScanlineStride;
                }
                for (j = 0; j < dheight; ++j) {
                    srcPixelOffset = srcScanlineOffset;
                    int dstPixelOffset = dstScanlineOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int imageOffset = srcPixelOffset;
                        float f = 0.0f;
                        for (int v = 0; v < this.kw; ++v) {
                            f += this.hTables[v][srcData[imageOffset] + 128];
                            imageOffset += srcPixelStride;
                        }
                        tmpBuffer[revolver + i] = f;
                        f = 0.5f;
                        int b = kvRevolver + i;
                        for (int a = 0; a < this.kh; ++a) {
                            f += tmpBuffer[b] * this.vValues[a];
                            if ((b += dwidth) < tmpBufferSize) continue;
                            b -= tmpBufferSize;
                        }
                        dstData[dstPixelOffset] = ImageUtil.clampRoundByte((float)f);
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                    if ((revolver += dwidth) == tmpBufferSize) {
                        revolver = 0;
                    }
                    if ((kvRevolver += dwidth) == tmpBufferSize) {
                        kvRevolver = 0;
                    }
                    srcScanlineOffset += srcScanlineStride;
                    dstScanlineOffset += dstScanlineStride;
                }
            }
        } else if (this.caseB) {
            for (int k = 0; k < dnumBands; ++k) {
                int srcPixelOffset;
                int j;
                byte[] dstData = dstDataArrays[k];
                byte[] srcData = srcDataArrays[k];
                int srcScanlineOffset = srcBandOffsets[k];
                int dstScanlineOffset = dstBandOffsets[k];
                int revolver = 0;
                int kvRevolver = 0;
                for (j = 0; j < this.kh - 1; ++j) {
                    srcPixelOffset = srcScanlineOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int imageOffset = srcPixelOffset;
                        float f = 0.0f;
                        for (int v = 0; v < this.kw; ++v) {
                            f += this.hTables[v][srcData[imageOffset] + 128];
                            imageOffset += srcPixelStride;
                        }
                        tmpBuffer[revolver + i] = f;
                        srcPixelOffset += srcPixelStride;
                    }
                    revolver += dwidth;
                    srcScanlineOffset += srcScanlineStride;
                }
                for (j = 0; j < dheight; ++j) {
                    srcPixelOffset = srcScanlineOffset;
                    int dstPixelOffset = dstScanlineOffset;
                    y0 = srcY + j;
                    for (int i = 0; i < dwidth; ++i) {
                        x0 = srcX + i;
                        int imageOffset = srcPixelOffset;
                        float f = 0.0f;
                        for (int v = 0; v < this.kw; ++v) {
                            f += this.hTables[v][srcData[imageOffset] + 128];
                            imageOffset += srcPixelStride;
                        }
                        tmpBuffer[revolver + i] = f;
                        if (this.roiBounds.contains(x0, y0) && roiIter.getSample(x0, y0, 0) > 0) {
                            f = 0.5f;
                            int b = kvRevolver + i;
                            for (int a = 0; a < this.kh; ++a) {
                                f += tmpBuffer[b] * this.vValues[a];
                                if ((b += dwidth) < tmpBufferSize) continue;
                                b -= tmpBufferSize;
                            }
                            dstData[dstPixelOffset] = ImageUtil.clampRoundByte((float)f);
                        } else {
                            dstData[dstPixelOffset] = this.destNoDataByte;
                        }
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                    if ((revolver += dwidth) == tmpBufferSize) {
                        revolver = 0;
                    }
                    if ((kvRevolver += dwidth) == tmpBufferSize) {
                        kvRevolver = 0;
                    }
                    srcScanlineOffset += srcScanlineStride;
                    dstScanlineOffset += dstScanlineStride;
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int k = 0; k < dnumBands; ++k) {
                int srcPixelOffset;
                int j;
                byte[] dstData = dstDataArrays[k];
                byte[] srcData = srcDataArrays[k];
                int srcScanlineOffset = srcBandOffsets[k];
                int dstScanlineOffset = dstBandOffsets[k];
                int revolver = 0;
                int kvRevolver = 0;
                for (j = 0; j < this.kh - 1; ++j) {
                    srcPixelOffset = srcScanlineOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int imageOffset = srcPixelOffset;
                        float f = 0.0f;
                        for (int v = 0; v < this.kw; ++v) {
                            f += this.hTables[v][srcData[imageOffset] + 128];
                            imageOffset += srcPixelStride;
                        }
                        tmpBuffer[revolver + i] = f;
                        srcPixelOffset += srcPixelStride;
                    }
                    revolver += dwidth;
                    srcScanlineOffset += srcScanlineStride;
                }
                for (j = 0; j < dheight; ++j) {
                    srcPixelOffset = srcScanlineOffset;
                    int dstPixelOffset = dstScanlineOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int imageOffset = srcPixelOffset;
                        float f = 0.0f;
                        for (int v = 0; v < this.kw; ++v) {
                            f += this.hTables[v][srcData[imageOffset] + 128];
                            imageOffset += srcPixelStride;
                        }
                        tmpBuffer[revolver + i] = f;
                        boolean isValid = true;
                        if (this.skipNoData) {
                            int bandOff = srcBandOffsets[k];
                            for (int kj = 0; kj < this.kh && isValid; ++kj) {
                                int lineOff = (j + kj) * srcScanlineStride + bandOff;
                                for (int ki = 0; ki < this.kw && isValid; ++ki) {
                                    int pixelOff = (i + ki) * srcPixelStride + lineOff;
                                    byte value = srcData[pixelOff];
                                    if (this.lut[value + 128]) continue;
                                    isValid = false;
                                }
                            }
                        }
                        if (isValid) {
                            f = 0.5f;
                            int b = kvRevolver + i;
                            for (int a = 0; a < this.kh; ++a) {
                                f += tmpBuffer[b] * this.vValues[a];
                                if ((b += dwidth) < tmpBufferSize) continue;
                                b -= tmpBufferSize;
                            }
                            dstData[dstPixelOffset] = ImageUtil.clampRoundByte((float)f);
                        } else {
                            dstData[dstPixelOffset] = this.destNoDataByte;
                        }
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                    if ((revolver += dwidth) == tmpBufferSize) {
                        revolver = 0;
                    }
                    if ((kvRevolver += dwidth) == tmpBufferSize) {
                        kvRevolver = 0;
                    }
                    srcScanlineOffset += srcScanlineStride;
                    dstScanlineOffset += dstScanlineStride;
                }
            }
        } else {
            for (int k = 0; k < dnumBands; ++k) {
                int srcPixelOffset;
                int j;
                byte[] dstData = dstDataArrays[k];
                byte[] srcData = srcDataArrays[k];
                int srcScanlineOffset = srcBandOffsets[k];
                int dstScanlineOffset = dstBandOffsets[k];
                int revolver = 0;
                int kvRevolver = 0;
                for (j = 0; j < this.kh - 1; ++j) {
                    srcPixelOffset = srcScanlineOffset;
                    y0 = srcY + j;
                    for (int i = 0; i < dwidth; ++i) {
                        x0 = srcX + i;
                        int imageOffset = srcPixelOffset;
                        float f = 0.0f;
                        for (int v = 0; v < this.kw; ++v) {
                            f += this.hTables[v][srcData[imageOffset] + 128];
                            imageOffset += srcPixelStride;
                        }
                        tmpBuffer[revolver + i] = f;
                        srcPixelOffset += srcPixelStride;
                    }
                    revolver += dwidth;
                    srcScanlineOffset += srcScanlineStride;
                }
                for (j = 0; j < dheight; ++j) {
                    srcPixelOffset = srcScanlineOffset;
                    int dstPixelOffset = dstScanlineOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int imageOffset = srcPixelOffset;
                        float f = 0.0f;
                        for (int v = 0; v < this.kw; ++v) {
                            f += this.hTables[v][srcData[imageOffset] + 128];
                            imageOffset += srcPixelStride;
                        }
                        tmpBuffer[revolver + i] = f;
                        if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) > 0) {
                            // empty if block
                        }
                        boolean isValid = true;
                        if (this.skipNoData) {
                            int bandOff = srcBandOffsets[k];
                            for (int kj = 0; kj < this.kh && isValid; ++kj) {
                                int lineOff = (j + kj) * srcScanlineStride + bandOff;
                                for (int ki = 0; ki < this.kw && isValid; ++ki) {
                                    int pixelOff = (i + ki) * srcPixelStride + lineOff;
                                    byte value = srcData[pixelOff];
                                    if (this.lut[value + 128]) continue;
                                    isValid = false;
                                }
                            }
                        }
                        if (isValid) {
                            f = 0.5f;
                            int b = kvRevolver + i;
                            for (int a = 0; a < this.kh; ++a) {
                                f += tmpBuffer[b] * this.vValues[a];
                                if ((b += dwidth) < tmpBufferSize) continue;
                                b -= tmpBufferSize;
                            }
                            dstData[dstPixelOffset] = ImageUtil.clampRoundByte((float)f);
                        } else {
                            dstData[dstPixelOffset] = this.destNoDataByte;
                        }
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                    if ((revolver += dwidth) == tmpBufferSize) {
                        revolver = 0;
                    }
                    if ((kvRevolver += dwidth) == tmpBufferSize) {
                        kvRevolver = 0;
                    }
                    srcScanlineOffset += srcScanlineStride;
                    dstScanlineOffset += dstScanlineStride;
                }
            }
        }
    }

    @Override
    protected void ushortLoop(RasterAccessor src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
    }

    @Override
    protected void shortLoop(RasterAccessor src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
    }

    @Override
    protected void intLoop(RasterAccessor src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
    }

    @Override
    protected void floatLoop(RasterAccessor src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
    }

    @Override
    protected void doubleLoop(RasterAccessor src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
    }
}

