/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.convolve;

import com.sun.media.jai.util.ImageUtil;
import it.geosolutions.jaiext.border.BorderDescriptor;
import it.geosolutions.jaiext.iterators.RandomIterFactory;
import it.geosolutions.jaiext.range.Range;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.Map;
import javax.media.jai.AreaOpImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.IntegerSequence;
import javax.media.jai.KernelJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.iterator.RandomIter;

public abstract class ConvolveOpImage
extends AreaOpImage {
    public static final boolean ARRAY_CALC = true;
    public static final boolean TILE_CACHED = true;
    protected final boolean hasNoData;
    protected Range noData;
    protected boolean[] lut;
    protected final boolean hasROI;
    protected ROI roi;
    protected final boolean caseA;
    protected final boolean caseB;
    protected final boolean caseC;
    protected final Rectangle roiBounds;
    protected PlanarImage roiImage;
    protected byte destNoDataByte;
    protected short destNoDataShort;
    protected int destNoDataInt;
    protected float destNoDataFloat;
    protected double destNoDataDouble;
    protected boolean skipNoData;
    protected RenderedImage extendedIMG;
    protected Rectangle destBounds;
    protected KernelJAI kernel;
    protected int kw;
    protected int kh;
    protected int kx;
    protected int ky;

    public ConvolveOpImage(RenderedImage source, BorderExtender extender, RenderingHints hints, ImageLayout l, KernelJAI kernel, ROI roi, Range noData, double destinationNoData, boolean skipNoData) {
        super(source, l, (Map)hints, true, extender, kernel.getLeftPadding(), kernel.getRightPadding(), kernel.getTopPadding(), kernel.getBottomPadding());
        this.kernel = kernel;
        this.kw = kernel.getWidth();
        this.kh = kernel.getHeight();
        this.kx = kernel.getXOrigin();
        this.ky = kernel.getYOrigin();
        if (roi != null) {
            this.hasROI = true;
            this.roi = roi;
            this.roiBounds = roi.getBounds();
        } else {
            this.hasROI = false;
            this.roi = null;
            this.roiBounds = null;
        }
        if (noData != null) {
            this.hasNoData = true;
            this.noData = noData;
            this.skipNoData = skipNoData;
        } else {
            this.hasNoData = false;
            this.skipNoData = false;
        }
        int dataType = source.getSampleModel().getDataType();
        this.destNoDataDouble = destinationNoData;
        switch (dataType) {
            case 0: {
                this.destNoDataByte = ImageUtil.clampRoundByte((double)destinationNoData);
                break;
            }
            case 1: {
                this.destNoDataShort = ImageUtil.clampRoundUShort((double)destinationNoData);
                break;
            }
            case 2: {
                this.destNoDataShort = ImageUtil.clampRoundShort((double)destinationNoData);
                break;
            }
            case 3: {
                this.destNoDataInt = ImageUtil.clampRoundInt((double)destinationNoData);
                break;
            }
            case 4: {
                this.destNoDataFloat = ImageUtil.clampFloat((double)destinationNoData);
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong image data type");
            }
        }
        this.caseA = !this.hasNoData && !this.hasROI;
        this.caseB = !this.hasNoData && this.hasROI;
        boolean bl = this.caseC = this.hasNoData && !this.hasROI;
        if (this.hasNoData && dataType == 0) {
            this.initBooleanNoDataTable();
        }
        if (this.extender != null) {
            this.extendedIMG = BorderDescriptor.create((RenderedImage)source, (int)this.leftPadding, (int)this.rightPadding, (int)this.topPadding, (int)this.bottomPadding, (BorderExtender)extender, (Range)noData, (double)destinationNoData, (RenderingHints)hints);
            this.destBounds = this.getBounds();
        } else {
            int x0 = this.getMinX() + this.leftPadding;
            int y0 = this.getMinY() + this.topPadding;
            int w = this.getWidth() - this.leftPadding - this.rightPadding;
            w = Math.max(w, 0);
            int h = this.getHeight() - this.topPadding - this.bottomPadding;
            h = Math.max(h, 0);
            this.destBounds = new Rectangle(x0, y0, w, h);
        }
    }

    private void initBooleanNoDataTable() {
        this.lut = new boolean[256];
        for (int i = 0; i < 256; ++i) {
            boolean result = true;
            if (this.noData.contains((byte)i)) {
                result = false;
            }
            this.lut[i] = result;
        }
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        Raster source = sources[0];
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        RasterAccessor src = new RasterAccessor(source, srcRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor dst = new RasterAccessor((Raster)dest, destRect, formatTags[1], this.getColorModel());
        ROI roiTile = null;
        RandomIter roiIter = null;
        boolean roiContainsTile = false;
        boolean roiDisjointTile = false;
        if (this.hasROI) {
            Rectangle srcRectExpanded = this.mapDestRect(destRect, 0);
            srcRectExpanded.setRect(srcRectExpanded.getMinX() - 1.0, srcRectExpanded.getMinY() - 1.0, srcRectExpanded.getWidth() + 2.0, srcRectExpanded.getHeight() + 2.0);
            roiTile = this.roi.intersect((ROI)new ROIShape((Shape)srcRectExpanded));
            if (!this.roiBounds.intersects(srcRectExpanded)) {
                roiDisjointTile = true;
            } else {
                roiContainsTile = roiTile.contains(srcRectExpanded);
                if (!roiContainsTile) {
                    if (!roiTile.intersects(srcRectExpanded)) {
                        roiDisjointTile = true;
                    } else {
                        PlanarImage roiIMG = this.getImage();
                        roiIter = RandomIterFactory.create((RenderedImage)roiIMG, null, (boolean)true, (boolean)true);
                    }
                }
            }
        }
        if (!this.hasROI || !roiDisjointTile) {
            switch (dst.getDataType()) {
                case 0: {
                    this.byteLoop(src, dst, roiIter, roiContainsTile);
                    break;
                }
                case 1: {
                    this.ushortLoop(src, dst, roiIter, roiContainsTile);
                    break;
                }
                case 2: {
                    this.shortLoop(src, dst, roiIter, roiContainsTile);
                    break;
                }
                case 3: {
                    this.intLoop(src, dst, roiIter, roiContainsTile);
                    break;
                }
                case 4: {
                    this.floatLoop(src, dst, roiIter, roiContainsTile);
                    break;
                }
                case 5: {
                    this.doubleLoop(src, dst, roiIter, roiContainsTile);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong Data Type defined");
                }
            }
            if (dst.isDataCopy()) {
                dst.clampDataArrays();
                dst.copyDataToRaster();
            }
        } else {
            double[] backgroundValues = new double[src.getNumBands()];
            Arrays.fill(backgroundValues, this.destNoDataDouble);
            ImageUtil.fillBackground((WritableRaster)dest, (Rectangle)destRect, (double[])backgroundValues);
        }
    }

    protected abstract void byteLoop(RasterAccessor var1, RasterAccessor var2, RandomIter var3, boolean var4);

    protected abstract void ushortLoop(RasterAccessor var1, RasterAccessor var2, RandomIter var3, boolean var4);

    protected abstract void shortLoop(RasterAccessor var1, RasterAccessor var2, RandomIter var3, boolean var4);

    protected abstract void intLoop(RasterAccessor var1, RasterAccessor var2, RandomIter var3, boolean var4);

    protected abstract void floatLoop(RasterAccessor var1, RasterAccessor var2, RandomIter var3, boolean var4);

    protected abstract void doubleLoop(RasterAccessor var1, RasterAccessor var2, RandomIter var3, boolean var4);

    public Raster computeTile(int tileX, int tileY) {
        if (!this.cobbleSources) {
            return super.computeTile(tileX, tileY);
        }
        Point org = new Point(this.tileXToX(tileX), this.tileYToY(tileY));
        WritableRaster dest = this.createWritableRaster(this.sampleModel, org);
        Rectangle rect = new Rectangle(org.x, org.y, this.sampleModel.getWidth(), this.sampleModel.getHeight());
        Rectangle destRect = rect.intersection(this.destBounds);
        if (destRect.width <= 0 || destRect.height <= 0) {
            return dest;
        }
        PlanarImage s = this.getSourceImage(0);
        destRect = destRect.intersection(s.getBounds());
        Rectangle srcRect = new Rectangle(destRect);
        srcRect.x -= this.getLeftPadding();
        srcRect.width += this.getLeftPadding() + this.getRightPadding();
        srcRect.y -= this.getTopPadding();
        srcRect.height += this.getTopPadding() + this.getBottomPadding();
        IntegerSequence srcXSplits = new IntegerSequence();
        IntegerSequence srcYSplits = new IntegerSequence();
        s.getSplits(srcXSplits, srcYSplits, srcRect);
        IntegerSequence xSplits = new IntegerSequence(destRect.x, destRect.x + destRect.width);
        xSplits.insert(destRect.x);
        xSplits.insert(destRect.x + destRect.width);
        srcXSplits.startEnumeration();
        while (srcXSplits.hasMoreElements()) {
            int xsplit = srcXSplits.nextElement();
            int lsplit = xsplit - this.getLeftPadding();
            int rsplit = xsplit + this.getRightPadding();
            xSplits.insert(lsplit);
            xSplits.insert(rsplit);
        }
        IntegerSequence ySplits = new IntegerSequence(destRect.y, destRect.y + destRect.height);
        ySplits.insert(destRect.y);
        ySplits.insert(destRect.y + destRect.height);
        srcYSplits.startEnumeration();
        while (srcYSplits.hasMoreElements()) {
            int ysplit = srcYSplits.nextElement();
            int tsplit = ysplit - this.getBottomPadding();
            int bsplit = ysplit + this.getTopPadding();
            ySplits.insert(tsplit);
            ySplits.insert(bsplit);
        }
        Raster[] sources = new Raster[1];
        ySplits.startEnumeration();
        int y1 = ySplits.nextElement();
        while (ySplits.hasMoreElements()) {
            int y2 = ySplits.nextElement();
            int h = y2 - y1;
            int py1 = y1 - this.getTopPadding();
            int py2 = y2 + this.getBottomPadding();
            int ph = py2 - py1;
            xSplits.startEnumeration();
            int x1 = xSplits.nextElement();
            while (xSplits.hasMoreElements()) {
                int x2 = xSplits.nextElement();
                int w = x2 - x1;
                int px1 = x1 - this.getLeftPadding();
                int px2 = x2 + this.getRightPadding();
                int pw = px2 - px1;
                Rectangle srcSubRect = new Rectangle(px1, py1, pw, ph);
                sources[0] = this.extender != null ? this.extendedIMG.getData(srcSubRect) : s.getData(srcSubRect);
                Rectangle dstSubRect = new Rectangle(x1, y1, w, h);
                this.computeRect(sources, dest, dstSubRect);
                if (s.overlapsMultipleTiles(srcSubRect)) {
                    this.recycleTile(sources[0]);
                }
                x1 = x2;
            }
            y1 = y2;
        }
        return dest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PlanarImage getImage() {
        PlanarImage img = this.roiImage;
        if (img == null) {
            ConvolveOpImage convolveOpImage = this;
            synchronized (convolveOpImage) {
                img = this.roiImage;
                if (img == null) {
                    this.roiImage = img = this.roi.getAsImage();
                }
            }
        }
        return img;
    }
}

