/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.convolve;

import com.sun.media.jai.util.ImageUtil;
import it.geosolutions.jaiext.convolve.ConvolveOpImage;
import it.geosolutions.jaiext.convolve.JaiI18N;
import it.geosolutions.jaiext.range.Range;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.KernelJAI;
import javax.media.jai.ROI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.iterator.RandomIter;

public class Convolve3x3OpImage
extends ConvolveOpImage {
    float[][] tables = new float[9][256];

    public Convolve3x3OpImage(RenderedImage source, BorderExtender extender, RenderingHints hints, ImageLayout l, KernelJAI kernel, ROI roi, Range noData, double destinationNoData, boolean skipNoData) {
        super(source, extender, hints, l, kernel, roi, noData, destinationNoData, skipNoData);
        this.kernel = kernel;
        if (kernel.getWidth() != 3 || kernel.getHeight() != 3 || kernel.getXOrigin() != 1 || kernel.getYOrigin() != 1) {
            throw new RuntimeException(JaiI18N.getString("Convolve3x3OpImage0"));
        }
        if (this.sampleModel.getDataType() == 0) {
            float[] kdata = kernel.getKernelData();
            float k0 = kdata[0];
            float k1 = kdata[1];
            float k2 = kdata[2];
            float k3 = kdata[3];
            float k4 = kdata[4];
            float k5 = kdata[5];
            float k6 = kdata[6];
            float k7 = kdata[7];
            float k8 = kdata[8];
            for (int j = 0; j < 256; ++j) {
                byte b = (byte)j;
                float f = j;
                this.tables[0][b + 128] = this.hasNoData && noData.contains(b) ? 0.5f : k0 * f + 0.5f;
                this.tables[1][b + 128] = this.hasNoData && noData.contains(b) ? 0.0f : k1 * f;
                this.tables[2][b + 128] = this.hasNoData && noData.contains(b) ? 0.0f : k2 * f;
                this.tables[3][b + 128] = this.hasNoData && noData.contains(b) ? 0.0f : k3 * f;
                this.tables[4][b + 128] = this.hasNoData && noData.contains(b) ? 0.0f : k4 * f;
                this.tables[5][b + 128] = this.hasNoData && noData.contains(b) ? 0.0f : k5 * f;
                this.tables[6][b + 128] = this.hasNoData && noData.contains(b) ? 0.0f : k6 * f;
                this.tables[7][b + 128] = this.hasNoData && noData.contains(b) ? 0.0f : k7 * f;
                this.tables[8][b + 128] = this.hasNoData && noData.contains(b) ? 0.0f : k8 * f;
            }
        }
    }

    protected void byteLoop(RasterAccessor src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int srcScanlineStride;
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int dnumBands = dst.getNumBands();
        float[] t0 = this.tables[0];
        float[] t1 = this.tables[1];
        float[] t2 = this.tables[2];
        float[] t3 = this.tables[3];
        float[] t4 = this.tables[4];
        float[] t5 = this.tables[5];
        float[] t6 = this.tables[6];
        float[] t7 = this.tables[7];
        float[] t8 = this.tables[8];
        byte[][] dstDataArrays = dst.getByteDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        byte[][] srcDataArrays = src.getByteDataArrays();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int centerScanlineOffset = srcScanlineStride = src.getScanlineStride();
        int bottomScanlineOffset = srcScanlineStride * 2;
        int middlePixelOffset = dnumBands;
        int rightPixelOffset = dnumBands * 2;
        int x0 = 0;
        int y0 = 0;
        int srcX = src.getX();
        int srcY = src.getY();
        if (this.hasROI) {
            for (int k = 0; k < dnumBands; ++k) {
                byte[] dstData = dstDataArrays[k];
                byte[] srcData = srcDataArrays[k];
                int srcScanlineOffset = srcBandOffsets[k];
                int dstScanlineOffset = dstBandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int srcPixelOffset = srcScanlineOffset;
                    int dstPixelOffset = dstScanlineOffset;
                    y0 = srcY + j;
                    for (int i = 0; i < dwidth; ++i) {
                        x0 = srcX + i;
                        boolean inROI = false;
                        for (int y = 0; y < this.kh && !inROI; ++y) {
                            int yI = y0 + y;
                            for (int x = 0; x < this.kw && !inROI; ++x) {
                                int xI = x0 + x;
                                if (!this.roiBounds.contains(xI, yI) || roiIter.getSample(xI, yI, 0) <= 0) continue;
                                inROI = true;
                            }
                        }
                        byte b0 = srcData[srcPixelOffset];
                        byte b1 = srcData[srcPixelOffset + middlePixelOffset];
                        byte b2 = srcData[srcPixelOffset + rightPixelOffset];
                        byte b3 = srcData[srcPixelOffset + centerScanlineOffset];
                        byte b4 = srcData[srcPixelOffset + centerScanlineOffset + middlePixelOffset];
                        byte b5 = srcData[srcPixelOffset + centerScanlineOffset + rightPixelOffset];
                        byte b6 = srcData[srcPixelOffset + bottomScanlineOffset];
                        byte b7 = srcData[srcPixelOffset + bottomScanlineOffset + middlePixelOffset];
                        byte b8 = srcData[srcPixelOffset + bottomScanlineOffset + rightPixelOffset];
                        float f = t0[128 + b0] + t1[128 + b1] + t2[128 + b2] + t3[128 + b3] + t4[128 + b4] + t5[128 + b5] + t6[128 + b6] + t7[128 + b7] + t8[128 + b8];
                        boolean isValid = true;
                        if (this.skipNoData) {
                            isValid = this.lut[b0] && this.lut[b1] && this.lut[b2] && this.lut[b3] && this.lut[b4] && this.lut[b5] && this.lut[b6] && this.lut[b7] && this.lut[b8];
                        }
                        dstData[dstPixelOffset] = isValid && inROI ? ImageUtil.clampRoundByte((float)f) : this.destNoDataByte;
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                    srcScanlineOffset += srcScanlineStride;
                    dstScanlineOffset += dstScanlineStride;
                }
            }
        } else {
            for (int k = 0; k < dnumBands; ++k) {
                byte[] dstData = dstDataArrays[k];
                byte[] srcData = srcDataArrays[k];
                int srcScanlineOffset = srcBandOffsets[k];
                int dstScanlineOffset = dstBandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int srcPixelOffset = srcScanlineOffset;
                    int dstPixelOffset = dstScanlineOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        byte b0 = srcData[srcPixelOffset];
                        byte b1 = srcData[srcPixelOffset + middlePixelOffset];
                        byte b2 = srcData[srcPixelOffset + rightPixelOffset];
                        byte b3 = srcData[srcPixelOffset + centerScanlineOffset];
                        byte b4 = srcData[srcPixelOffset + centerScanlineOffset + middlePixelOffset];
                        byte b5 = srcData[srcPixelOffset + centerScanlineOffset + rightPixelOffset];
                        byte b6 = srcData[srcPixelOffset + bottomScanlineOffset];
                        byte b7 = srcData[srcPixelOffset + bottomScanlineOffset + middlePixelOffset];
                        byte b8 = srcData[srcPixelOffset + bottomScanlineOffset + rightPixelOffset];
                        float f = t0[128 + b0] + t1[128 + b1] + t2[128 + b2] + t3[128 + b3] + t4[128 + b4] + t5[128 + b5] + t6[128 + b6] + t7[128 + b7] + t8[128 + b8];
                        boolean isValid = true;
                        if (this.skipNoData) {
                            isValid = this.lut[b0] && this.lut[b1] && this.lut[b2] && this.lut[b3] && this.lut[b4] && this.lut[b5] && this.lut[b6] && this.lut[b7] && this.lut[b8];
                        }
                        dstData[dstPixelOffset] = isValid ? ImageUtil.clampRoundByte((float)f) : this.destNoDataByte;
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                    srcScanlineOffset += srcScanlineStride;
                    dstScanlineOffset += dstScanlineStride;
                }
            }
        }
    }

    protected void shortLoop(RasterAccessor src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int srcScanlineStride;
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int dnumBands = dst.getNumBands();
        short[][] dstDataArrays = dst.getShortDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        short[][] srcDataArrays = src.getShortDataArrays();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int centerScanlineOffset = srcScanlineStride = src.getScanlineStride();
        int bottomScanlineOffset = srcScanlineStride * 2;
        int middlePixelOffset = dnumBands;
        int rightPixelOffset = dnumBands * 2;
        float[] kdata = this.kernel.getKernelData();
        float k0 = kdata[0];
        float k1 = kdata[1];
        float k2 = kdata[2];
        float k3 = kdata[3];
        float k4 = kdata[4];
        float k5 = kdata[5];
        float k6 = kdata[6];
        float k7 = kdata[7];
        float k8 = kdata[8];
        int x0 = 0;
        int y0 = 0;
        int srcX = src.getX();
        int srcY = src.getY();
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int k = 0; k < dnumBands; ++k) {
                short[] dstData = dstDataArrays[k];
                short[] srcData = srcDataArrays[k];
                int srcScanlineOffset = srcBandOffsets[k];
                int dstScanlineOffset = dstBandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int srcPixelOffset = srcScanlineOffset;
                    int dstPixelOffset = dstScanlineOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        short s0 = srcData[srcPixelOffset];
                        short s1 = srcData[srcPixelOffset + middlePixelOffset];
                        short s2 = srcData[srcPixelOffset + rightPixelOffset];
                        short s3 = srcData[srcPixelOffset + centerScanlineOffset];
                        short s4 = srcData[srcPixelOffset + centerScanlineOffset + middlePixelOffset];
                        short s5 = srcData[srcPixelOffset + centerScanlineOffset + rightPixelOffset];
                        short s6 = srcData[srcPixelOffset + bottomScanlineOffset];
                        short s7 = srcData[srcPixelOffset + bottomScanlineOffset + middlePixelOffset];
                        short s8 = srcData[srcPixelOffset + bottomScanlineOffset + rightPixelOffset];
                        float f = k0 * (float)s0 + k1 * (float)s1 + k2 * (float)s2 + k3 * (float)s3 + k4 * (float)s4 + k5 * (float)s5 + k6 * (float)s6 + k7 * (float)s7 + k8 * (float)s8;
                        dstData[dstPixelOffset] = ImageUtil.clampRoundShort((float)f);
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                    srcScanlineOffset += srcScanlineStride;
                    dstScanlineOffset += dstScanlineStride;
                }
            }
        } else if (this.caseB) {
            for (int k = 0; k < dnumBands; ++k) {
                short[] dstData = dstDataArrays[k];
                short[] srcData = srcDataArrays[k];
                int srcScanlineOffset = srcBandOffsets[k];
                int dstScanlineOffset = dstBandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int srcPixelOffset = srcScanlineOffset;
                    int dstPixelOffset = dstScanlineOffset;
                    y0 = srcY + j;
                    for (int i = 0; i < dwidth; ++i) {
                        x0 = srcX + i;
                        boolean inROI = false;
                        for (int y = 0; y < this.kh && !inROI; ++y) {
                            int yI = y0 + y;
                            for (int x = 0; x < this.kw && !inROI; ++x) {
                                int xI = x0 + x;
                                if (!this.roiBounds.contains(xI, yI) || roiIter.getSample(xI, yI, 0) <= 0) continue;
                                inROI = true;
                            }
                        }
                        short s0 = srcData[srcPixelOffset];
                        short s1 = srcData[srcPixelOffset + middlePixelOffset];
                        short s2 = srcData[srcPixelOffset + rightPixelOffset];
                        short s3 = srcData[srcPixelOffset + centerScanlineOffset];
                        short s4 = srcData[srcPixelOffset + centerScanlineOffset + middlePixelOffset];
                        short s5 = srcData[srcPixelOffset + centerScanlineOffset + rightPixelOffset];
                        short s6 = srcData[srcPixelOffset + bottomScanlineOffset];
                        short s7 = srcData[srcPixelOffset + bottomScanlineOffset + middlePixelOffset];
                        short s8 = srcData[srcPixelOffset + bottomScanlineOffset + rightPixelOffset];
                        float f = k0 * (float)s0 + k1 * (float)s1 + k2 * (float)s2 + k3 * (float)s3 + k4 * (float)s4 + k5 * (float)s5 + k6 * (float)s6 + k7 * (float)s7 + k8 * (float)s8;
                        dstData[dstPixelOffset] = inROI ? ImageUtil.clampRoundShort((float)f) : this.destNoDataShort;
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                    srcScanlineOffset += srcScanlineStride;
                    dstScanlineOffset += dstScanlineStride;
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int k = 0; k < dnumBands; ++k) {
                short[] dstData = dstDataArrays[k];
                short[] srcData = srcDataArrays[k];
                int srcScanlineOffset = srcBandOffsets[k];
                int dstScanlineOffset = dstBandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int srcPixelOffset = srcScanlineOffset;
                    int dstPixelOffset = dstScanlineOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        short s0 = srcData[srcPixelOffset];
                        short s1 = srcData[srcPixelOffset + middlePixelOffset];
                        short s2 = srcData[srcPixelOffset + rightPixelOffset];
                        short s3 = srcData[srcPixelOffset + centerScanlineOffset];
                        short s4 = srcData[srcPixelOffset + centerScanlineOffset + middlePixelOffset];
                        short s5 = srcData[srcPixelOffset + centerScanlineOffset + rightPixelOffset];
                        short s6 = srcData[srcPixelOffset + bottomScanlineOffset];
                        short s7 = srcData[srcPixelOffset + bottomScanlineOffset + middlePixelOffset];
                        short s8 = srcData[srcPixelOffset + bottomScanlineOffset + rightPixelOffset];
                        boolean isValid = true;
                        boolean nod0 = this.noData.contains(s0);
                        boolean nod1 = this.noData.contains(s1);
                        boolean nod2 = this.noData.contains(s2);
                        boolean nod3 = this.noData.contains(s3);
                        boolean nod4 = this.noData.contains(s4);
                        boolean nod5 = this.noData.contains(s5);
                        boolean nod6 = this.noData.contains(s6);
                        boolean nod7 = this.noData.contains(s7);
                        boolean nod8 = this.noData.contains(s8);
                        if (this.skipNoData) {
                            boolean bl = isValid = !nod0 && !nod1 && !nod2 && !nod3 && !nod4 && !nod5 && !nod6 && !nod7 && !nod8;
                        }
                        if (isValid) {
                            float f = k0 * (float)(nod0 ? (short)0 : s0) + k1 * (float)(nod1 ? (short)0 : s1) + k2 * (float)(nod2 ? (short)0 : s2) + k3 * (float)(nod3 ? (short)0 : s3) + k4 * (float)(nod4 ? (short)0 : s4) + k5 * (float)(nod5 ? (short)0 : s5) + k6 * (float)(nod6 ? (short)0 : s6) + k7 * (float)(nod7 ? (short)0 : s7) + k8 * (float)(nod8 ? (short)0 : s8);
                            dstData[dstPixelOffset] = ImageUtil.clampRoundShort((float)f);
                        } else {
                            dstData[dstPixelOffset] = this.destNoDataShort;
                        }
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                    srcScanlineOffset += srcScanlineStride;
                    dstScanlineOffset += dstScanlineStride;
                }
            }
        } else {
            for (int k = 0; k < dnumBands; ++k) {
                short[] dstData = dstDataArrays[k];
                short[] srcData = srcDataArrays[k];
                int srcScanlineOffset = srcBandOffsets[k];
                int dstScanlineOffset = dstBandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int srcPixelOffset = srcScanlineOffset;
                    int dstPixelOffset = dstScanlineOffset;
                    y0 = srcY + j;
                    for (int i = 0; i < dwidth; ++i) {
                        x0 = srcX + i;
                        boolean inROI = false;
                        for (int y = 0; y < this.kh && !inROI; ++y) {
                            int yI = y0 + y;
                            for (int x = 0; x < this.kw && !inROI; ++x) {
                                int xI = x0 + x;
                                if (!this.roiBounds.contains(xI, yI) || roiIter.getSample(xI, yI, 0) <= 0) continue;
                                inROI = true;
                            }
                        }
                        short s0 = srcData[srcPixelOffset];
                        short s1 = srcData[srcPixelOffset + middlePixelOffset];
                        short s2 = srcData[srcPixelOffset + rightPixelOffset];
                        short s3 = srcData[srcPixelOffset + centerScanlineOffset];
                        short s4 = srcData[srcPixelOffset + centerScanlineOffset + middlePixelOffset];
                        short s5 = srcData[srcPixelOffset + centerScanlineOffset + rightPixelOffset];
                        short s6 = srcData[srcPixelOffset + bottomScanlineOffset];
                        short s7 = srcData[srcPixelOffset + bottomScanlineOffset + middlePixelOffset];
                        short s8 = srcData[srcPixelOffset + bottomScanlineOffset + rightPixelOffset];
                        boolean isValid = true;
                        boolean nod0 = this.noData.contains(s0);
                        boolean nod1 = this.noData.contains(s1);
                        boolean nod2 = this.noData.contains(s2);
                        boolean nod3 = this.noData.contains(s3);
                        boolean nod4 = this.noData.contains(s4);
                        boolean nod5 = this.noData.contains(s5);
                        boolean nod6 = this.noData.contains(s6);
                        boolean nod7 = this.noData.contains(s7);
                        boolean nod8 = this.noData.contains(s8);
                        if (this.skipNoData) {
                            boolean bl = isValid = !nod0 && !nod1 && !nod2 && !nod3 && !nod4 && !nod5 && !nod6 && !nod7 && !nod8;
                        }
                        if (inROI && isValid) {
                            float f = k0 * (float)(nod0 ? (short)0 : s0) + k1 * (float)(nod1 ? (short)0 : s1) + k2 * (float)(nod2 ? (short)0 : s2) + k3 * (float)(nod3 ? (short)0 : s3) + k4 * (float)(nod4 ? (short)0 : s4) + k5 * (float)(nod5 ? (short)0 : s5) + k6 * (float)(nod6 ? (short)0 : s6) + k7 * (float)(nod7 ? (short)0 : s7) + k8 * (float)(nod8 ? (short)0 : s8);
                            dstData[dstPixelOffset] = ImageUtil.clampRoundShort((float)f);
                        } else {
                            dstData[dstPixelOffset] = this.destNoDataShort;
                        }
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                    srcScanlineOffset += srcScanlineStride;
                    dstScanlineOffset += dstScanlineStride;
                }
            }
        }
    }

    protected void intLoop(RasterAccessor src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int srcScanlineStride;
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int dnumBands = dst.getNumBands();
        int[][] dstDataArrays = dst.getIntDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        int[][] srcDataArrays = src.getIntDataArrays();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int centerScanlineOffset = srcScanlineStride = src.getScanlineStride();
        int bottomScanlineOffset = srcScanlineStride * 2;
        int middlePixelOffset = dnumBands;
        int rightPixelOffset = dnumBands * 2;
        float[] kdata = this.kernel.getKernelData();
        float k0 = kdata[0];
        float k1 = kdata[1];
        float k2 = kdata[2];
        float k3 = kdata[3];
        float k4 = kdata[4];
        float k5 = kdata[5];
        float k6 = kdata[6];
        float k7 = kdata[7];
        float k8 = kdata[8];
        int x0 = 0;
        int y0 = 0;
        int srcX = src.getX();
        int srcY = src.getY();
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int k = 0; k < dnumBands; ++k) {
                int[] dstData = dstDataArrays[k];
                int[] srcData = srcDataArrays[k];
                int srcScanlineOffset = srcBandOffsets[k];
                int dstScanlineOffset = dstBandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int srcPixelOffset = srcScanlineOffset;
                    int dstPixelOffset = dstScanlineOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int s0 = srcData[srcPixelOffset];
                        int s1 = srcData[srcPixelOffset + middlePixelOffset];
                        int s2 = srcData[srcPixelOffset + rightPixelOffset];
                        int s3 = srcData[srcPixelOffset + centerScanlineOffset];
                        int s4 = srcData[srcPixelOffset + centerScanlineOffset + middlePixelOffset];
                        int s5 = srcData[srcPixelOffset + centerScanlineOffset + rightPixelOffset];
                        int s6 = srcData[srcPixelOffset + bottomScanlineOffset];
                        int s7 = srcData[srcPixelOffset + bottomScanlineOffset + middlePixelOffset];
                        int s8 = srcData[srcPixelOffset + bottomScanlineOffset + rightPixelOffset];
                        float f = k0 * (float)s0 + k1 * (float)s1 + k2 * (float)s2 + k3 * (float)s3 + k4 * (float)s4 + k5 * (float)s5 + k6 * (float)s6 + k7 * (float)s7 + k8 * (float)s8;
                        dstData[dstPixelOffset] = ImageUtil.clampRoundInt((float)f);
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                    srcScanlineOffset += srcScanlineStride;
                    dstScanlineOffset += dstScanlineStride;
                }
            }
        } else if (this.caseB) {
            for (int k = 0; k < dnumBands; ++k) {
                int[] dstData = dstDataArrays[k];
                int[] srcData = srcDataArrays[k];
                int srcScanlineOffset = srcBandOffsets[k];
                int dstScanlineOffset = dstBandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int srcPixelOffset = srcScanlineOffset;
                    int dstPixelOffset = dstScanlineOffset;
                    y0 = srcY + j;
                    for (int i = 0; i < dwidth; ++i) {
                        x0 = srcX + i;
                        boolean inROI = false;
                        for (int y = 0; y < this.kh && !inROI; ++y) {
                            int yI = y0 + y;
                            for (int x = 0; x < this.kw && !inROI; ++x) {
                                int xI = x0 + x;
                                if (!this.roiBounds.contains(xI, yI) || roiIter.getSample(xI, yI, 0) <= 0) continue;
                                inROI = true;
                            }
                        }
                        int s0 = srcData[srcPixelOffset];
                        int s1 = srcData[srcPixelOffset + middlePixelOffset];
                        int s2 = srcData[srcPixelOffset + rightPixelOffset];
                        int s3 = srcData[srcPixelOffset + centerScanlineOffset];
                        int s4 = srcData[srcPixelOffset + centerScanlineOffset + middlePixelOffset];
                        int s5 = srcData[srcPixelOffset + centerScanlineOffset + rightPixelOffset];
                        int s6 = srcData[srcPixelOffset + bottomScanlineOffset];
                        int s7 = srcData[srcPixelOffset + bottomScanlineOffset + middlePixelOffset];
                        int s8 = srcData[srcPixelOffset + bottomScanlineOffset + rightPixelOffset];
                        float f = k0 * (float)s0 + k1 * (float)s1 + k2 * (float)s2 + k3 * (float)s3 + k4 * (float)s4 + k5 * (float)s5 + k6 * (float)s6 + k7 * (float)s7 + k8 * (float)s8;
                        dstData[dstPixelOffset] = inROI ? ImageUtil.clampRoundInt((float)f) : this.destNoDataInt;
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                    srcScanlineOffset += srcScanlineStride;
                    dstScanlineOffset += dstScanlineStride;
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int k = 0; k < dnumBands; ++k) {
                int[] dstData = dstDataArrays[k];
                int[] srcData = srcDataArrays[k];
                int srcScanlineOffset = srcBandOffsets[k];
                int dstScanlineOffset = dstBandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int srcPixelOffset = srcScanlineOffset;
                    int dstPixelOffset = dstScanlineOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int s0 = srcData[srcPixelOffset];
                        int s1 = srcData[srcPixelOffset + middlePixelOffset];
                        int s2 = srcData[srcPixelOffset + rightPixelOffset];
                        int s3 = srcData[srcPixelOffset + centerScanlineOffset];
                        int s4 = srcData[srcPixelOffset + centerScanlineOffset + middlePixelOffset];
                        int s5 = srcData[srcPixelOffset + centerScanlineOffset + rightPixelOffset];
                        int s6 = srcData[srcPixelOffset + bottomScanlineOffset];
                        int s7 = srcData[srcPixelOffset + bottomScanlineOffset + middlePixelOffset];
                        int s8 = srcData[srcPixelOffset + bottomScanlineOffset + rightPixelOffset];
                        boolean isValid = true;
                        boolean nod0 = this.noData.contains(s0);
                        boolean nod1 = this.noData.contains(s1);
                        boolean nod2 = this.noData.contains(s2);
                        boolean nod3 = this.noData.contains(s3);
                        boolean nod4 = this.noData.contains(s4);
                        boolean nod5 = this.noData.contains(s5);
                        boolean nod6 = this.noData.contains(s6);
                        boolean nod7 = this.noData.contains(s7);
                        boolean nod8 = this.noData.contains(s8);
                        if (this.skipNoData) {
                            boolean bl = isValid = !nod0 && !nod1 && !nod2 && !nod3 && !nod4 && !nod5 && !nod6 && !nod7 && !nod8;
                        }
                        if (isValid) {
                            float f = k0 * (float)(nod0 ? 0 : s0) + k1 * (float)(nod1 ? 0 : s1) + k2 * (float)(nod2 ? 0 : s2) + k3 * (float)(nod3 ? 0 : s3) + k4 * (float)(nod4 ? 0 : s4) + k5 * (float)(nod5 ? 0 : s5) + k6 * (float)(nod6 ? 0 : s6) + k7 * (float)(nod7 ? 0 : s7) + k8 * (float)(nod8 ? 0 : s8);
                            dstData[dstPixelOffset] = ImageUtil.clampRoundInt((float)f);
                        } else {
                            dstData[dstPixelOffset] = this.destNoDataInt;
                        }
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                    srcScanlineOffset += srcScanlineStride;
                    dstScanlineOffset += dstScanlineStride;
                }
            }
        } else {
            for (int k = 0; k < dnumBands; ++k) {
                int[] dstData = dstDataArrays[k];
                int[] srcData = srcDataArrays[k];
                int srcScanlineOffset = srcBandOffsets[k];
                int dstScanlineOffset = dstBandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int srcPixelOffset = srcScanlineOffset;
                    int dstPixelOffset = dstScanlineOffset;
                    y0 = srcY + j;
                    for (int i = 0; i < dwidth; ++i) {
                        x0 = srcX + i;
                        boolean inROI = false;
                        for (int y = 0; y < this.kh && !inROI; ++y) {
                            int yI = y0 + y;
                            for (int x = 0; x < this.kw && !inROI; ++x) {
                                int xI = x0 + x;
                                if (!this.roiBounds.contains(xI, yI) || roiIter.getSample(xI, yI, 0) <= 0) continue;
                                inROI = true;
                            }
                        }
                        int s0 = srcData[srcPixelOffset];
                        int s1 = srcData[srcPixelOffset + middlePixelOffset];
                        int s2 = srcData[srcPixelOffset + rightPixelOffset];
                        int s3 = srcData[srcPixelOffset + centerScanlineOffset];
                        int s4 = srcData[srcPixelOffset + centerScanlineOffset + middlePixelOffset];
                        int s5 = srcData[srcPixelOffset + centerScanlineOffset + rightPixelOffset];
                        int s6 = srcData[srcPixelOffset + bottomScanlineOffset];
                        int s7 = srcData[srcPixelOffset + bottomScanlineOffset + middlePixelOffset];
                        int s8 = srcData[srcPixelOffset + bottomScanlineOffset + rightPixelOffset];
                        boolean isValid = true;
                        boolean nod0 = this.noData.contains(s0);
                        boolean nod1 = this.noData.contains(s1);
                        boolean nod2 = this.noData.contains(s2);
                        boolean nod3 = this.noData.contains(s3);
                        boolean nod4 = this.noData.contains(s4);
                        boolean nod5 = this.noData.contains(s5);
                        boolean nod6 = this.noData.contains(s6);
                        boolean nod7 = this.noData.contains(s7);
                        boolean nod8 = this.noData.contains(s8);
                        if (this.skipNoData) {
                            boolean bl = isValid = !nod0 && !nod1 && !nod2 && !nod3 && !nod4 && !nod5 && !nod6 && !nod7 && !nod8;
                        }
                        if (inROI && isValid) {
                            float f = k0 * (float)(nod0 ? 0 : s0) + k1 * (float)(nod1 ? 0 : s1) + k2 * (float)(nod2 ? 0 : s2) + k3 * (float)(nod3 ? 0 : s3) + k4 * (float)(nod4 ? 0 : s4) + k5 * (float)(nod5 ? 0 : s5) + k6 * (float)(nod6 ? 0 : s6) + k7 * (float)(nod7 ? 0 : s7) + k8 * (float)(nod8 ? 0 : s8);
                            dstData[dstPixelOffset] = ImageUtil.clampRoundInt((float)f);
                        } else {
                            dstData[dstPixelOffset] = this.destNoDataInt;
                        }
                        srcPixelOffset += srcPixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                    srcScanlineOffset += srcScanlineStride;
                    dstScanlineOffset += dstScanlineStride;
                }
            }
        }
    }

    protected void ushortLoop(RasterAccessor src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        throw new UnsupportedOperationException(JaiI18N.getString("Convolve3x3OpImage1"));
    }

    protected void floatLoop(RasterAccessor src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        throw new UnsupportedOperationException(JaiI18N.getString("Convolve3x3OpImage1"));
    }

    protected void doubleLoop(RasterAccessor src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        throw new UnsupportedOperationException(JaiI18N.getString("Convolve3x3OpImage1"));
    }
}

