/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.concurrencytest;

import com.sun.media.jai.operator.ImageReadDescriptor;
import it.geosolutions.concurrent.ConcurrentTileCacheMultiMap;
import it.geosolutions.jaiext.testclasses.TestData;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.RenderedOp;
import junit.framework.Assert;
import org.junit.Test;

public class ConcurrentMultiMapTest {
    private static final int TOTAL = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddAndGetTile() throws InterruptedException, FileNotFoundException, IOException {
        FileImageInputStream stream_in = null;
        try {
            stream_in = new FileImageInputStream(TestData.file((Object)this, (String)"world.tiff"));
            final RenderedOp input = ImageReadDescriptor.create((ImageInputStream)stream_in, (Integer)0, (Boolean)false, (Boolean)false, (Boolean)false, null, null, null, null, null);
            final AtomicBoolean passed = new AtomicBoolean(true);
            final ConcurrentTileCacheMultiMap cache = new ConcurrentTileCacheMultiMap(1000000L, false, 1.0f, 4);
            Raster data = input.getTile(input.getMinTileX(), input.getMinTileY());
            cache.add((RenderedImage)input, input.getMinTileX(), input.getMinTileY(), data);
            ThreadPoolExecutor executor = new ThreadPoolExecutor(100, 100, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1000000));
            final CountDownLatch latch = new CountDownLatch(100);
            for (int counter = 100; counter > 0; --counter) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        Raster data = cache.getTile((RenderedImage)input, input.getMinTileX(), input.getMinTileY());
                        if (data == null) {
                            passed.getAndSet(false);
                        }
                        latch.countDown();
                    }
                });
            }
            latch.await();
            Assert.assertTrue((boolean)passed.get());
        }
        finally {
            try {
                if (stream_in != null) {
                    stream_in.flush();
                    stream_in.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoveTile() throws InterruptedException, FileNotFoundException, IOException {
        FileImageInputStream stream_in = null;
        try {
            stream_in = new FileImageInputStream(TestData.file((Object)this, (String)"world.tiff"));
            final RenderedOp input = ImageReadDescriptor.create((ImageInputStream)stream_in, (Integer)0, (Boolean)false, (Boolean)false, (Boolean)false, null, null, null, null, null);
            final AtomicBoolean passed = new AtomicBoolean(true);
            final ConcurrentTileCacheMultiMap cache = new ConcurrentTileCacheMultiMap(1000000L, false, 1.0f, 4);
            Raster data = input.getTile(input.getMinTileX(), input.getMinTileY());
            cache.add((RenderedImage)input, input.getMinTileX(), input.getMinTileY(), data);
            cache.remove((RenderedImage)input, input.getMinTileX(), input.getMinTileY());
            ThreadPoolExecutor executor = new ThreadPoolExecutor(100, 100, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1000000));
            final CountDownLatch latch = new CountDownLatch(100);
            for (int counter = 100; counter > 0; --counter) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        Raster data = cache.getTile((RenderedImage)input, input.getMinTileX(), input.getMinTileY());
                        if (data != null) {
                            passed.getAndSet(false);
                        }
                        latch.countDown();
                    }
                });
            }
            latch.await();
            Assert.assertTrue((boolean)passed.get());
        }
        finally {
            try {
                if (stream_in != null) {
                    stream_in.flush();
                    stream_in.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }
}

