/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.colorconvert;

import it.geosolutions.jaiext.colorconvert.IHSColorSpaceJAIExt;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.testclasses.TestBase;
import it.geosolutions.jaiext.testclasses.TestData;
import it.geosolutions.rendered.viewer.RenderedImageBrowser;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.media.jai.IHSColorSpace;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.ROIShape;
import javax.media.jai.RasterFactory;
import javax.media.jai.RenderedOp;
import org.junit.Test;

public class TestColorConvert
extends TestBase {
    @Test
    public void Synthetic_Short() throws IOException {
        BufferedImage image = this.getSynthetic_Short();
        ParameterBlockJAI pbj = new ParameterBlockJAI("ColorConvert");
        pbj.addSource((Object)image);
        pbj.setParameter("colorModel", (Object)this.getJAICm());
        RenderedOp finalimage = JAI.create((String)"ColorConvert", (ParameterBlock)pbj);
        if (INTERACTIVE) {
            RenderedImageBrowser.showChain((RenderedImage)finalimage, (boolean)false, (boolean)false, null);
        } else {
            finalimage.getTiles();
        }
        finalimage.dispose();
        ROIShape roi = new ROIShape((Shape)new Rectangle(image.getMinX() + 5, image.getMinY() + 5, image.getWidth() / 4, image.getHeight() / 4));
        Range nodata = RangeFactory.create((short)5, (short)5);
        pbj = new ParameterBlockJAI("ColorConvert");
        pbj.addSource((Object)image);
        pbj.setParameter("colorModel", (Object)this.getJAICm());
        pbj.setParameter("roi", (Object)roi);
        finalimage = JAI.create((String)"ColorConvert", (ParameterBlock)pbj);
        if (INTERACTIVE) {
            RenderedImageBrowser.showChain((RenderedImage)finalimage, (boolean)false, (boolean)false, null);
        } else {
            finalimage.getTiles();
        }
        finalimage.dispose();
        pbj = new ParameterBlockJAI("ColorConvert");
        pbj.addSource((Object)image);
        pbj.setParameter("colorModel", (Object)this.getJAICm());
        pbj.setParameter("nodata", (Object)nodata);
        finalimage = JAI.create((String)"ColorConvert", (ParameterBlock)pbj);
        if (INTERACTIVE) {
            RenderedImageBrowser.showChain((RenderedImage)finalimage, (boolean)false, (boolean)false, null);
        } else {
            finalimage.getTiles();
        }
        finalimage.dispose();
        pbj = new ParameterBlockJAI("ColorConvert");
        pbj.addSource((Object)image);
        pbj.setParameter("colorModel", (Object)this.getJAICm());
        pbj.setParameter("roi", (Object)roi);
        pbj.setParameter("nodata", (Object)nodata);
        finalimage = JAI.create((String)"ColorConvert", (ParameterBlock)pbj);
        if (INTERACTIVE) {
            RenderedImageBrowser.showChain((RenderedImage)finalimage, (boolean)false, (boolean)false, null);
        } else {
            finalimage.getTiles();
        }
        finalimage.dispose();
    }

    private BufferedImage getSynthetic_Short() {
        int width = 500;
        int height = 500;
        WritableRaster raster = RasterFactory.createBandedRaster((int)1, (int)500, (int)500, (int)3, null);
        for (int y = 0; y < 500; ++y) {
            for (int x = 0; x < 500; ++x) {
                raster.setSample(x, y, 0, x + y);
            }
        }
        ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1004), false, false, 1, 1);
        BufferedImage image = new BufferedImage(cm, raster, false, null);
        return image;
    }

    @Test
    public void Synthetic_Byte() throws IOException {
        BufferedImage image = this.getSynthetic_Byte();
        ParameterBlockJAI pbj = new ParameterBlockJAI("ColorConvert");
        pbj.addSource((Object)image);
        pbj.setParameter("colorModel", (Object)this.getJAIEXTCm());
        RenderedOp finalimage = JAI.create((String)"ColorConvert", (ParameterBlock)pbj);
        if (INTERACTIVE) {
            RenderedImageBrowser.showChain((RenderedImage)finalimage, (boolean)false, (boolean)false, null);
        } else {
            finalimage.getTiles();
        }
        finalimage.dispose();
        ROIShape roi = new ROIShape((Shape)new Rectangle(image.getMinX() + 5, image.getMinY() + 5, image.getWidth() / 4, image.getHeight() / 4));
        Range nodata = RangeFactory.create((byte)5, (byte)5);
        pbj = new ParameterBlockJAI("ColorConvert");
        pbj.addSource((Object)image);
        pbj.setParameter("colorModel", (Object)this.getJAIEXTCm());
        pbj.setParameter("roi", (Object)roi);
        finalimage = JAI.create((String)"ColorConvert", (ParameterBlock)pbj);
        if (INTERACTIVE) {
            RenderedImageBrowser.showChain((RenderedImage)finalimage, (boolean)false, (boolean)false, null);
        } else {
            finalimage.getTiles();
        }
        finalimage.dispose();
        pbj = new ParameterBlockJAI("ColorConvert");
        pbj.addSource((Object)image);
        pbj.setParameter("colorModel", (Object)this.getJAIEXTCm());
        pbj.setParameter("nodata", (Object)nodata);
        finalimage = JAI.create((String)"ColorConvert", (ParameterBlock)pbj);
        if (INTERACTIVE) {
            RenderedImageBrowser.showChain((RenderedImage)finalimage, (boolean)false, (boolean)false, null);
        } else {
            finalimage.getTiles();
        }
        finalimage.dispose();
        pbj = new ParameterBlockJAI("ColorConvert");
        pbj.addSource((Object)image);
        pbj.setParameter("colorModel", (Object)this.getJAIEXTCm());
        pbj.setParameter("roi", (Object)roi);
        pbj.setParameter("nodata", (Object)nodata);
        finalimage = JAI.create((String)"ColorConvert", (ParameterBlock)pbj);
        if (INTERACTIVE) {
            RenderedImageBrowser.showChain((RenderedImage)finalimage, (boolean)false, (boolean)false, null);
        } else {
            finalimage.getTiles();
        }
        finalimage.dispose();
    }

    @Test
    public void Synthetic_Byte_IHS() throws IOException {
        BufferedImage image = this.getSynthetic_Byte_IHS();
        ParameterBlockJAI pbj = new ParameterBlockJAI("ColorConvert");
        pbj.addSource((Object)image);
        pbj.setParameter("colorModel", (Object)this.getNotJAICm());
        RenderedOp finalimage = JAI.create((String)"ColorConvert", (ParameterBlock)pbj);
        if (INTERACTIVE) {
            RenderedImageBrowser.showChain((RenderedImage)finalimage, (boolean)false, (boolean)false, null);
        } else {
            finalimage.getTiles();
        }
        finalimage.dispose();
        ROIShape roi = new ROIShape((Shape)new Rectangle(image.getMinX() + 5, image.getMinY() + 5, image.getWidth() / 4, image.getHeight() / 4));
        Range nodata = RangeFactory.create((byte)5, (byte)5);
        pbj = new ParameterBlockJAI("ColorConvert");
        pbj.addSource((Object)image);
        pbj.setParameter("colorModel", (Object)this.getNotJAICm());
        pbj.setParameter("roi", (Object)roi);
        finalimage = JAI.create((String)"ColorConvert", (ParameterBlock)pbj);
        if (INTERACTIVE) {
            RenderedImageBrowser.showChain((RenderedImage)finalimage, (boolean)false, (boolean)false, null);
        } else {
            finalimage.getTiles();
        }
        finalimage.dispose();
        pbj = new ParameterBlockJAI("ColorConvert");
        pbj.addSource((Object)image);
        pbj.setParameter("colorModel", (Object)this.getNotJAICm());
        pbj.setParameter("nodata", (Object)nodata);
        finalimage = JAI.create((String)"ColorConvert", (ParameterBlock)pbj);
        if (INTERACTIVE) {
            RenderedImageBrowser.showChain((RenderedImage)finalimage, (boolean)false, (boolean)false, null);
        } else {
            finalimage.getTiles();
        }
        finalimage.dispose();
        pbj = new ParameterBlockJAI("ColorConvert");
        pbj.addSource((Object)image);
        pbj.setParameter("colorModel", (Object)this.getNotJAICm());
        pbj.setParameter("roi", (Object)roi);
        pbj.setParameter("nodata", (Object)nodata);
        finalimage = JAI.create((String)"ColorConvert", (ParameterBlock)pbj);
        if (INTERACTIVE) {
            RenderedImageBrowser.showChain((RenderedImage)finalimage, (boolean)false, (boolean)false, null);
        } else {
            finalimage.getTiles();
        }
        finalimage.dispose();
    }

    private BufferedImage getSynthetic_Byte() {
        int width = 500;
        int height = 500;
        WritableRaster raster = RasterFactory.createBandedRaster((int)0, (int)500, (int)500, (int)3, null);
        for (int y = 0; y < 500; ++y) {
            for (int x = 0; x < 500; ++x) {
                raster.setSample(x, y, 0, x + y);
            }
        }
        ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1004), false, false, 1, 0);
        BufferedImage image = new BufferedImage(cm, raster, false, null);
        return image;
    }

    private BufferedImage getSynthetic_Byte_IHS() {
        int width = 500;
        int height = 500;
        WritableRaster raster = RasterFactory.createBandedRaster((int)0, (int)500, (int)500, (int)3, null);
        for (int y = 0; y < 500; ++y) {
            for (int x = 0; x < 500; ++x) {
                raster.setSample(x, y, 0, x + y);
            }
        }
        ComponentColorModel cm = new ComponentColorModel((ColorSpace)new IHSColorSpaceJAIExt(), false, false, 1, 0);
        BufferedImage image = new BufferedImage(cm, raster, false, null);
        return image;
    }

    @Test
    public void testTiff() throws IOException {
        RenderedImage image = this.getTestTiff();
        ParameterBlockJAI pbj = new ParameterBlockJAI("ColorConvert");
        pbj.addSource((Object)image);
        pbj.setParameter("colorModel", (Object)this.getNotJAICm());
        RenderedOp finalimage = JAI.create((String)"ColorConvert", (ParameterBlock)pbj);
        if (INTERACTIVE) {
            RenderedImageBrowser.showChain((RenderedImage)finalimage, (boolean)false, (boolean)false, null);
        } else {
            finalimage.getTiles();
        }
        finalimage.dispose();
        ROIShape roi = new ROIShape((Shape)new Rectangle(image.getMinX() + 5, image.getMinY() + 5, image.getWidth() / 4, image.getHeight() / 4));
        Range nodata = RangeFactory.create((byte)5, (byte)5);
        pbj = new ParameterBlockJAI("ColorConvert");
        pbj.addSource((Object)image);
        pbj.setParameter("colorModel", (Object)this.getNotJAICm());
        pbj.setParameter("roi", (Object)roi);
        finalimage = JAI.create((String)"ColorConvert", (ParameterBlock)pbj);
        if (INTERACTIVE) {
            RenderedImageBrowser.showChain((RenderedImage)finalimage, (boolean)false, (boolean)false, null);
        } else {
            finalimage.getTiles();
        }
        finalimage.dispose();
        pbj = new ParameterBlockJAI("ColorConvert");
        pbj.addSource((Object)image);
        pbj.setParameter("colorModel", (Object)this.getNotJAICm());
        pbj.setParameter("nodata", (Object)nodata);
        finalimage = JAI.create((String)"ColorConvert", (ParameterBlock)pbj);
        if (INTERACTIVE) {
            RenderedImageBrowser.showChain((RenderedImage)finalimage, (boolean)false, (boolean)false, null);
        } else {
            finalimage.getTiles();
        }
        finalimage.dispose();
        pbj = new ParameterBlockJAI("ColorConvert");
        pbj.addSource((Object)image);
        pbj.setParameter("colorModel", (Object)this.getNotJAICm());
        pbj.setParameter("roi", (Object)roi);
        pbj.setParameter("nodata", (Object)nodata);
        finalimage = JAI.create((String)"ColorConvert", (ParameterBlock)pbj);
        if (INTERACTIVE) {
            RenderedImageBrowser.showChain((RenderedImage)finalimage, (boolean)false, (boolean)false, null);
        } else {
            finalimage.getTiles();
        }
        finalimage.dispose();
    }

    private RenderedImage getTestTiff() throws IOException, FileNotFoundException {
        File spearfish = TestData.file((Object)((Object)this), (String)"test.tif");
        RenderedOp image = JAI.create((String)"ImageRead", (Object)spearfish);
        return image;
    }

    private ColorModel getJAIEXTCm() {
        IHSColorSpaceJAIExt cs = new IHSColorSpaceJAIExt();
        ComponentColorModel cm = new ComponentColorModel((ColorSpace)cs, false, false, 1, 0);
        return cm;
    }

    private ColorModel getJAICm() {
        IHSColorSpace cs = IHSColorSpace.getInstance();
        ComponentColorModel cm = new ComponentColorModel((ColorSpace)cs, false, false, 1, 1);
        return cm;
    }

    private ColorModel getNotJAICm() {
        ColorSpace cs = ColorSpace.getInstance(1004);
        ComponentColorModel cm = new ComponentColorModel(cs, false, false, 1, 0);
        return cm;
    }
}

