/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.classifier;

import it.geosolutions.jaiext.classifier.LinearColorMap;
import it.geosolutions.jaiext.classifier.LinearColorMapElement;
import it.geosolutions.jaiext.piecewise.TransformationException;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.testclasses.TestBase;
import it.geosolutions.jaiext.testclasses.TestData;
import it.geosolutions.rendered.viewer.RenderedImageBrowser;
import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RasterFactory;
import javax.media.jai.RenderedOp;
import javax.media.jai.TiledImage;
import org.junit.Assert;
import org.junit.Test;

public class RasterClassifierTest
extends TestBase {
    private static final int TEST_NUM = 1;

    @Test
    public void testSyntheticDouble() throws IOException {
        BufferedImage image = this.getSyntheticDoubleImage();
        for (int i = 0; i < 1; ++i) {
            LinearColorMap list = this.buildCategories();
            ParameterBlockJAI pbj = new ParameterBlockJAI("RasterClassifier");
            pbj.addSource((Object)image);
            pbj.setParameter("Domain1D", (Object)list);
            RenderedOp finalimage = JAI.create((String)"RasterClassifier", (ParameterBlock)pbj);
            if (INTERACTIVE) {
                RenderedImageBrowser.showChain((RenderedImage)finalimage, (boolean)false, (boolean)false, null);
            } else {
                finalimage.getTiles();
            }
            finalimage.dispose();
        }
    }

    @Test
    public void testHugeDataset() throws IOException {
        int width = 20000;
        int height = 20000;
        ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, 4);
        SampleModel sm = ((ColorModel)cm).createCompatibleSampleModel(512, 512);
        TiledImage image = new TiledImage(0, 0, 20000, 20000, 0, 0, sm, (ColorModel)cm);
        LinearColorMap list = this.buildCategories();
        ParameterBlockJAI pbj = new ParameterBlockJAI("RasterClassifier");
        pbj.addSource((Object)image);
        pbj.setParameter("Domain1D", (Object)list);
        RenderedOp finalImage = JAI.create((String)"RasterClassifier", (ParameterBlock)pbj);
        boolean success = true;
        try {
            Raster raster = finalImage.getTile(0, 0);
            Assert.assertNotNull((Object)raster);
        }
        catch (RuntimeException ie) {
            success = false;
        }
        Assert.assertTrue((boolean)success);
    }

    private BufferedImage getSyntheticDoubleImage() {
        int width = 500;
        int height = 500;
        WritableRaster raster = RasterFactory.createBandedRaster((int)5, (int)500, (int)500, (int)1, null);
        for (int y = 0; y < 500; ++y) {
            for (int x = 0; x < 500; ++x) {
                raster.setSample(x, y, 0, x + y);
            }
        }
        ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, 5);
        BufferedImage image = new BufferedImage(cm, raster, false, null);
        return image;
    }

    @Test
    public void testSyntheticFloat() throws IOException {
        BufferedImage image = this.getSyntheticFloatImage();
        for (int i = 0; i < 1; ++i) {
            LinearColorMap list = this.buildCategories();
            ParameterBlockJAI pbj = new ParameterBlockJAI("RasterClassifier");
            pbj.addSource((Object)image);
            pbj.setParameter("Domain1D", (Object)list);
            RenderedOp finalimage = JAI.create((String)"RasterClassifier", (ParameterBlock)pbj);
            if (INTERACTIVE) {
                RenderedImageBrowser.showChain((RenderedImage)finalimage, (boolean)false, (boolean)false, null);
            } else {
                finalimage.getTiles();
            }
            finalimage.dispose();
        }
    }

    private LinearColorMap buildCategories() {
        LinearColorMapElement c0 = LinearColorMapElement.create((CharSequence)"c0", (Color)Color.BLACK, (Range)RangeFactory.create((double)Double.NEGATIVE_INFINITY, (boolean)false, (double)10.0, (boolean)true), (int)0);
        LinearColorMapElement c1 = LinearColorMapElement.create((CharSequence)"c2", (Color)Color.blue, (Range)RangeFactory.create((float)10.0f, (boolean)false, (float)100.0f, (boolean)true), (int)1);
        LinearColorMapElement c3 = LinearColorMapElement.create((CharSequence)"c3", (Color)Color.green, (Range)RangeFactory.create((float)100.0f, (boolean)false, (float)300.0f, (boolean)true), (int)2);
        LinearColorMapElement c4 = LinearColorMapElement.create((CharSequence)"c4", (Color[])new Color[]{Color.green, Color.red}, (Range)RangeFactory.create((float)300.0f, (boolean)false, (float)400.0f, (boolean)true), (Range)RangeFactory.create((int)3, (int)1000));
        LinearColorMapElement c5 = LinearColorMapElement.create((CharSequence)"c5", (Color[])new Color[]{Color.red, Color.white}, (Range)RangeFactory.create((float)400.0f, (boolean)false, (float)1000.0f, (boolean)true), (Range)RangeFactory.create((int)1001, (int)2000));
        LinearColorMapElement c6 = LinearColorMapElement.create((CharSequence)"c6", (Color)Color.red, (float)1001.0f, (int)2001);
        LinearColorMapElement c7 = LinearColorMapElement.create((CharSequence)"nodata", (Color)new Color(0, 0, 0, 0), (Range)RangeFactory.create((double)Double.NaN, (double)Double.NaN), (int)2201);
        LinearColorMap list = new LinearColorMap("", new LinearColorMapElement[]{c0, c1, c3, c4, c5, c6}, new LinearColorMapElement[]{c7});
        return list;
    }

    private BufferedImage getSyntheticFloatImage() {
        int width = 500;
        int height = 500;
        WritableRaster raster = RasterFactory.createBandedRaster((int)4, (int)500, (int)500, (int)1, null);
        for (int y = 0; y < 500; ++y) {
            for (int x = 0; x < 500; ++x) {
                raster.setSample(x, y, 0, x + y);
            }
        }
        ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, 4);
        BufferedImage image = new BufferedImage(cm, raster, false, null);
        return image;
    }

    @Test
    public void testNoDataOnly() throws IOException, TransformationException {
        for (int i = 0; i < 1; ++i) {
            LinearColorMapElement n0 = LinearColorMapElement.create((CharSequence)"nodata", (Color)new Color(0, 0, 0, 0), (Range)RangeFactory.create((double)Double.NaN, (double)Double.NaN), (int)9999);
            LinearColorMap list = new LinearColorMap((CharSequence)"", new LinearColorMapElement[]{n0});
            double testNum = Math.random();
            boolean exceptionThrown = false;
            try {
                Assert.assertEquals((double)list.transform(testNum), (double)testNum, (double)0.0);
            }
            catch (Exception e) {
                exceptionThrown = true;
            }
            Assert.assertTrue((boolean)exceptionThrown);
            Assert.assertEquals((double)list.transform(Double.NaN), (double)9999.0, (double)0.0);
        }
    }

    @Test
    public void testSpearfish() throws IOException {
        RenderedImage image = this.getSpearfhisDemo();
        for (int i = 0; i < 1; ++i) {
            LinearColorMapElement c0 = LinearColorMapElement.create((CharSequence)"c0", (Color)Color.yellow, (Range)RangeFactory.create((int)0, (boolean)true, (int)11, (boolean)true), (int)5);
            LinearColorMapElement c1 = LinearColorMapElement.create((CharSequence)"c2", (Color)Color.blue, (Range)RangeFactory.create((int)11, (boolean)false, (int)12, (boolean)true), (int)1);
            LinearColorMapElement c3 = LinearColorMapElement.create((CharSequence)"c3", (Color)Color.green, (Range)RangeFactory.create((int)12, (boolean)false, (int)14, (boolean)true), (int)7);
            LinearColorMapElement c4 = LinearColorMapElement.create((CharSequence)"c4", (Color)Color.blue, (Range)RangeFactory.create((int)14, (boolean)false, (int)16, (boolean)true), (int)1);
            LinearColorMapElement c5 = LinearColorMapElement.create((CharSequence)"c4", (Color)Color.CYAN, (Range)RangeFactory.create((int)16, (boolean)false, (int)255, (boolean)false), (int)11);
            LinearColorMapElement c6 = LinearColorMapElement.create((CharSequence)"nodata", (Color)new Color(0, 0, 0, 0), (Range)RangeFactory.create((int)255, (int)255), (int)0);
            LinearColorMap list = new LinearColorMap("", new LinearColorMapElement[]{c0, c1, c3, c4, c5}, new LinearColorMapElement[]{c6});
            ParameterBlockJAI pbj = new ParameterBlockJAI("RasterClassifier");
            pbj.addSource((Object)image);
            pbj.setParameter("Domain1D", (Object)list);
            RenderedOp finalimage = JAI.create((String)"RasterClassifier", (ParameterBlock)pbj);
            if (INTERACTIVE) {
                RenderedImageBrowser.showChain((RenderedImage)finalimage, (boolean)false, (boolean)false, null);
            } else {
                finalimage.getTiles();
            }
            finalimage.dispose();
        }
    }

    private RenderedImage getSpearfhisDemo() throws IOException, FileNotFoundException {
        File spearfish = TestData.file((Object)((Object)this), (String)"spearfish.png");
        RenderedOp image = JAI.create((String)"ImageRead", (Object)spearfish);
        return image;
    }

    @Test
    public void testSWAN() throws IOException {
        RenderedImage image = this.getSWANData();
        for (int i = 0; i < 1; ++i) {
            LinearColorMapElement c0 = LinearColorMapElement.create((CharSequence)"c0", (Color)Color.green, (Range)RangeFactory.create((double)Double.NEGATIVE_INFINITY, (double)0.3), (int)51);
            LinearColorMapElement c1 = LinearColorMapElement.create((CharSequence)"c2", (Color)Color.yellow, (Range)RangeFactory.create((double)0.3, (boolean)false, (double)0.6, (boolean)true), (int)1);
            LinearColorMapElement c1b = LinearColorMapElement.create((CharSequence)"c2", (Color)Color.BLACK, (Range)RangeFactory.create((double)0.3, (boolean)false, (double)0.6, (boolean)true), (int)1);
            LinearColorMapElement c1c = LinearColorMapElement.create((CharSequence)"c2", (Color)Color.yellow, (Range)RangeFactory.create((double)0.3, (boolean)false, (double)0.6, (boolean)true), (int)1);
            Assert.assertFalse((boolean)c1.equals((Object)c1b));
            Assert.assertTrue((boolean)c1.equals((Object)c1c));
            LinearColorMapElement c3 = LinearColorMapElement.create((CharSequence)"c3", (Color)Color.red, (Range)RangeFactory.create((double)0.6, (boolean)false, (double)0.9, (boolean)true), (int)2);
            LinearColorMapElement c4 = LinearColorMapElement.create((CharSequence)"c4", (Color)Color.BLUE, (Range)RangeFactory.create((double)0.9, (boolean)false, (double)Double.POSITIVE_INFINITY, (boolean)true), (int)3);
            LinearColorMapElement nodata = LinearColorMapElement.create((CharSequence)"nodata", (Color)new Color(0, 0, 0, 0), (Range)RangeFactory.create((double)-9.0, (double)-9.0), (int)4);
            LinearColorMap list = new LinearColorMap((CharSequence)"testSWAN", new LinearColorMapElement[]{c0, c1, c3, c4}, new LinearColorMapElement[]{nodata}, new Color(0, 0, 0));
            Assert.assertEquals((long)list.getSourceDimensions(), (long)1L);
            Assert.assertEquals((long)list.getTargetDimensions(), (long)1L);
            Assert.assertEquals((Object)list.getName().toString(), (Object)"testSWAN");
            Assert.assertNotNull((Object)c0.toString());
            ParameterBlockJAI pbj = new ParameterBlockJAI("RasterClassifier");
            pbj.addSource((Object)image);
            pbj.setParameter("Domain1D", (Object)list);
            boolean exceptionThrown = false;
            try {
                pbj.setParameter("bandIndex", (Object)new Integer(2));
                RenderedOp d = JAI.create((String)"RasterClassifier", (ParameterBlock)pbj);
                d.getTiles();
            }
            catch (Exception e) {
                exceptionThrown = true;
            }
            Assert.assertTrue((boolean)exceptionThrown);
            pbj.setParameter("bandIndex", (Object)new Integer(0));
            RenderedOp finalimage = JAI.create((String)"RasterClassifier", (ParameterBlock)pbj);
            if (INTERACTIVE) {
                RenderedImageBrowser.showChain((RenderedImage)finalimage, (boolean)false, (boolean)false, null);
            } else {
                finalimage.getTiles();
            }
            finalimage.dispose();
        }
    }

    @Test
    public void testSWANwithGap() throws IOException {
        RenderedImage image = this.getSWANData();
        for (int i = 0; i < 1; ++i) {
            LinearColorMapElement c0 = LinearColorMapElement.create((CharSequence)"c0", (Color)Color.green, (Range)RangeFactory.create((double)Double.NEGATIVE_INFINITY, (double)0.3), (int)51);
            LinearColorMapElement c1 = LinearColorMapElement.create((CharSequence)"c2", (Color)Color.yellow, (Range)RangeFactory.create((double)0.3, (boolean)false, (double)0.6, (boolean)true), (int)1);
            LinearColorMapElement c3 = LinearColorMapElement.create((CharSequence)"c3", (Color)Color.red, (Range)RangeFactory.create((double)0.7, (boolean)false, (double)0.9, (boolean)true), (int)2);
            LinearColorMapElement c4 = LinearColorMapElement.create((CharSequence)"c4", (Color)Color.BLUE, (Range)RangeFactory.create((double)0.9, (boolean)false, (double)Double.POSITIVE_INFINITY, (boolean)true), (int)3);
            LinearColorMapElement nodata = LinearColorMapElement.create((CharSequence)"nodata", (Color)Color.red, (Range)RangeFactory.create((double)-9.0, (double)-9.0), (int)4);
            LinearColorMap list = new LinearColorMap((CharSequence)"testSWAN", new LinearColorMapElement[]{c0, c1, c3, c4}, new LinearColorMapElement[]{nodata}, new Color(0, 0, 0, 0));
            ParameterBlockJAI pbj = new ParameterBlockJAI("RasterClassifier");
            pbj.addSource((Object)image);
            pbj.setParameter("Domain1D", (Object)list);
            try {
                pbj.setParameter("bandIndex", (Object)new Integer(2));
                RenderedOp d = JAI.create((String)"RasterClassifier", (ParameterBlock)pbj);
                d.getTiles();
                Assert.assertTrue((boolean)false);
            }
            catch (Exception d) {
                // empty catch block
            }
            pbj.setParameter("bandIndex", (Object)new Integer(0));
            RenderedOp finalimage = JAI.create((String)"RasterClassifier", (ParameterBlock)pbj);
            IndexColorModel icm = (IndexColorModel)finalimage.getColorModel();
            Assert.assertEquals((long)icm.getRed(4), (long)255L);
            Assert.assertEquals((long)icm.getRed(2), (long)255L);
            if (INTERACTIVE) {
                RenderedImageBrowser.showChain((RenderedImage)finalimage, (boolean)false, (boolean)false, null);
            } else {
                finalimage.getTiles();
            }
            finalimage.dispose();
        }
    }

    private RenderedImage getSWANData() {
        int width = 500;
        int height = 500;
        WritableRaster raster = RasterFactory.createBandedRaster((int)5, (int)500, (int)500, (int)1, null);
        for (int y = 0; y < 500; ++y) {
            for (int x = 0; x < 500; ++x) {
                if (x == y || x == -y) {
                    raster.setSample(x, y, 0, -9.0);
                    continue;
                }
                raster.setSample(x, y, 0, Math.random() * 5.0 - 5.0);
            }
        }
        ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, 5);
        BufferedImage image = new BufferedImage(cm, raster, false, null);
        return image;
    }
}

