/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.classbreaks;

import it.geosolutions.jaiext.classbreaks.Classification;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class HistogramClassification
extends Classification {
    private final double[] maximums;
    private final int[][] bucketCounts;
    private final double[][] bucketAverages;
    private final boolean[][] bucketSingleValue;
    private final double[] minimums;
    private final double[] bucketSize;

    public HistogramClassification(int numBands, Double[][] extrema, int numBins) {
        super(null, numBands);
        int b;
        if (extrema == null) {
            throw new IllegalArgumentException("Histogram based classification methods need to be provided with the extrema parameter");
        }
        this.checkExtremaArray(numBands, extrema, 0, "min");
        this.checkExtremaArray(numBands, extrema, 1, "max");
        for (b = 0; b < numBands; ++b) {
            this.setMin(b, extrema[0][b]);
            this.setMax(b, extrema[1][b]);
        }
        this.minimums = Arrays.stream(extrema[0]).mapToDouble(d -> d).toArray();
        this.maximums = Arrays.stream(extrema[1]).mapToDouble(d -> d).toArray();
        this.bucketSize = new double[numBands];
        for (b = 0; b < numBands; ++b) {
            this.bucketSize[b] = (extrema[1][b] - extrema[0][b]) / (double)numBins;
        }
        this.bucketCounts = new int[numBands][numBins];
        this.bucketAverages = new double[numBands][numBins];
        this.bucketSingleValue = new boolean[numBands][numBins];
        for (b = 0; b < numBands; ++b) {
            Arrays.fill(this.bucketSingleValue[b], true);
        }
    }

    private void checkExtremaArray(int numBands, Double[][] extrema, int minMax, String minMaxName) {
        if (extrema[minMax].length < numBands) {
            throw new IllegalArgumentException("Illegal extrema array, should have " + minMaxName + " array of " + numBands + " elements but only has " + extrema[minMax].length + " instead");
        }
    }

    public void count(double value, int band) {
        double minimum = this.minimums[band];
        double maximum = this.maximums[band];
        if (value < minimum || value > maximum) {
            return;
        }
        int idx = (int)((value - minimum) / this.bucketSize[band]);
        int[] bucketCount = this.bucketCounts[band];
        if (idx == bucketCount.length) {
            // empty if block
        }
        int n = --idx;
        bucketCount[n] = bucketCount[n] + 1;
        double[] bucketsAverage = this.bucketAverages[band];
        double average = bucketsAverage[idx];
        if (bucketCount[idx] > 1) {
            boolean[] blArray = this.bucketSingleValue[band];
            int n2 = idx;
            blArray[n2] = blArray[n2] & average == value;
        }
        bucketsAverage[idx] = average + (value - average) / (double)bucketCount[idx];
    }

    public List<Bucket> getBuckets(int band) {
        ArrayList<Bucket> buckets = new ArrayList<Bucket>();
        int[] histogram = this.bucketCounts[band];
        double[] bucketAverage = this.bucketAverages[band];
        double minimum = this.minimums[band];
        double size = this.bucketSize[band];
        for (int i = 0; i < histogram.length; ++i) {
            if (histogram[i] <= 0) continue;
            if (this.bucketSingleValue[band][i]) {
                buckets.add(new Bucket(histogram[i], bucketAverage[i]));
                continue;
            }
            buckets.add(new Bucket(histogram[i], bucketAverage[i], minimum + (double)i * size, minimum + (double)(i + 1) * size));
        }
        return buckets;
    }

    public static final class Bucket {
        int count;
        double average;
        double min;
        double max;

        public Bucket(int count, double singleValue) {
            this.count = count;
            this.min = this.max = singleValue;
            this.average = this.max;
        }

        public Bucket(int count, double average, double min, double max) {
            this.count = count;
            this.average = average;
            this.min = min;
            this.max = max;
        }

        public int getCount() {
            return this.count;
        }

        public double getAverage() {
            return this.average;
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }

        public String toString() {
            return "Bucket{count=" + this.count + ", average=" + this.average + ", min=" + this.min + ", max=" + this.max + '}';
        }
    }
}

