/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.classbreaks;

import it.geosolutions.jaiext.classbreaks.ClassBreaksOpImage;
import it.geosolutions.jaiext.classbreaks.ClassPercentagesManager;
import it.geosolutions.jaiext.classbreaks.Classification;
import it.geosolutions.jaiext.classbreaks.QuantileClassification;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.media.jai.ROI;

public class QuantileBreaksOpImage
extends ClassBreaksOpImage {
    public QuantileBreaksOpImage(RenderedImage image, Integer numClasses, Double[][] extrema, ROI roi, Integer[] bands, Integer xStart, Integer yStart, Integer xPeriod, Integer yPeriod, Double noData, Boolean percentages) {
        super(image, numClasses, extrema, roi, bands, xStart, yStart, xPeriod, yPeriod, noData, percentages);
    }

    @Override
    protected Classification createClassification() {
        return new QuantileClassification(this.bands.length);
    }

    @Override
    protected void handleValue(double d, Classification c, int band) {
        QuantileClassification qc = (QuantileClassification)c;
        if (this.extrema != null) {
            double min = this.extrema[0][band];
            double max = this.extrema[1][band];
            if (d < min || d > max) {
                return;
            }
        }
        qc.count(d, band);
    }

    @Override
    protected void postCalculate(Classification c, int band) {
        QuantileClassification qc = (QuantileClassification)c;
        int nvalues = qc.getCount(band);
        Double dSize = nvalues;
        int size = (int)Math.ceil((double)nvalues / (double)this.numClasses.intValue());
        SortedMap<Double, Integer> valuesMap = qc.getTable(band);
        TreeMap<Double, Integer> valuesMapWork = this.percentages != false ? new TreeMap<Double, Integer>((Map<Double, Integer>)valuesMap) : null;
        Iterator it = this.percentages != false ? valuesMapWork.entrySet().iterator() : valuesMap.entrySet().iterator();
        TreeSet set = new TreeSet();
        Map.Entry e = it.next();
        while (nvalues > 0) {
            set.add(e.getKey());
            for (int i = 0; i < size && nvalues > 0; ++i) {
                int count = (Integer)e.getValue();
                e.setValue(--count);
                --nvalues;
                if (count != 0) continue;
                if (!it.hasNext()) break;
                e = it.next();
            }
            if (nvalues != 0) continue;
            set.add(e.getKey());
        }
        qc.setBreaks(band, set.toArray(new Double[set.size()]));
        if (this.percentages.booleanValue()) {
            ClassPercentagesManager percentagesManager = new ClassPercentagesManager();
            int nBreak = set.size();
            int actualNumClasses = this.numClasses >= nBreak ? nBreak - 1 : this.numClasses;
            double[] percentages = percentagesManager.getPercentages(valuesMap, new ArrayList<Double>(set), (double)dSize, actualNumClasses);
            qc.setPercentages(percentages);
        }
    }
}

