/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.clamp;

import it.geosolutions.jaiext.range.Range;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.logging.Logger;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;

public class ClampDescriptor
extends OperationDescriptorImpl {
    static final Logger LOGGER = Logger.getLogger(ClampDescriptor.class.getName());
    private static final String[][] resources = new String[][]{{"GlobalName", "Clampop"}, {"LocalName", "Clampop"}, {"Vendor", "it.geosolutions.jaiext"}, {"Description", "Operation used for sets all the pixels whose value is below a low value to that low value and all the pixels whose value is above a high value to that high value"}, {"DocURL", "Not Defined"}, {"Version", "1.0"}, {"arg0Desc", "noData values"}, {"arg1Desc", "Destination No Data value"}, {"arg2Desc", "ROI object to use"}, {"arg3Desc", "The lower boundary for each band"}, {"arg4Desc", "The upper boundary for each band"}};
    private static final String[] paramNames = new String[]{"noData", "destinationNoData", "roi", "low", "high"};
    private static final Class[] paramClasses = new Class[]{Range.class, Double.class, ROI.class, double[].class, double[].class};
    private static final Object[] paramDefaults = new Object[]{null, 0.0, null, new double[]{0.0}, new double[]{255.0}};

    public ClampDescriptor() {
        super(resources, 1, paramClasses, paramNames, paramDefaults);
    }

    protected boolean validateParameters(ParameterBlock args, StringBuffer msg) {
        if (!super.validateParameters(args, msg)) {
            return false;
        }
        double[] low = (double[])args.getObjectParameter(3);
        double[] high = (double[])args.getObjectParameter(4);
        if (low.length < 1 || high.length < 1) {
            msg.append(this.getName() + " wrong parameters number");
            return false;
        }
        int length = Math.min(low.length, high.length);
        for (int i = 0; i < length; ++i) {
            if (!(low[i] > high[i])) continue;
            msg.append(this.getName() + " wrong parameters");
            return false;
        }
        int numBands = ((RenderedImage)args.getSource(0)).getSampleModel().getNumBands();
        if (!(numBands == low.length && numBands == high.length || low.length == 1 && high.length == 1)) {
            msg.append(this.getName() + " wrong parameters number");
            return false;
        }
        return true;
    }

    public static RenderedOp create(Range noData, double destinationNoData, ROI roi, double[] low, double[] high, RenderingHints hints, RenderedImage sources) {
        ParameterBlockJAI pb = new ParameterBlockJAI("Clampop", "rendered");
        if (sources == null) {
            throw new IllegalArgumentException("This resource is null");
        }
        pb.setSource((Object)sources, 0);
        pb.setParameter("high", (Object)high);
        pb.setParameter("noData", (Object)noData);
        pb.setParameter("destinationNoData", destinationNoData);
        pb.setParameter("roi", (Object)roi);
        pb.setParameter("low", (Object)low);
        pb.setParameter("high", (Object)high);
        return JAI.create((String)"Clampop", (ParameterBlock)pb, (RenderingHints)hints);
    }
}

