/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.binarize;

import it.geosolutions.jaiext.binarize.BinarizeDescriptor;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.testclasses.TestBase;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class BinarizeTest
extends TestBase {
    private static RenderedImage[] testImages;
    private static Range noDataByte;
    private static Range noDataUShort;
    private static Range noDataShort;
    private static Range noDataInt;
    private static Range noDataFloat;
    private static Range noDataDouble;
    private static ROI roiObject;
    private static double[] thresholds;

    @BeforeClass
    public static void initialSetup() {
        byte noDataB = 50;
        short noDataS = 50;
        int noDataI = 50;
        float noDataF = 50.0f;
        double noDataD = 50.0;
        thresholds = new double[6];
        BinarizeTest.thresholds[0] = 63.0;
        BinarizeTest.thresholds[1] = 8191.0;
        BinarizeTest.thresholds[2] = -49.0;
        BinarizeTest.thresholds[3] = 105.0;
        BinarizeTest.thresholds[4] = 635.0;
        BinarizeTest.thresholds[5] = 468.0;
        testImages = new RenderedImage[6];
        IMAGE_FILLER = true;
        BinarizeTest.testImages[0] = BinarizeTest.createTestImage((int)0, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataB, (boolean)false, (int)1, (Number)((byte)(thresholds[0] + 1.0)));
        BinarizeTest.testImages[1] = BinarizeTest.createTestImage((int)1, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataS, (boolean)false, (int)1, (Number)((short)(thresholds[1] + 1.0)));
        BinarizeTest.testImages[2] = BinarizeTest.createTestImage((int)2, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataS, (boolean)false, (int)1, (Number)((short)(thresholds[2] + 1.0)));
        BinarizeTest.testImages[3] = BinarizeTest.createTestImage((int)3, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataI, (boolean)false, (int)1, (Number)((int)(thresholds[3] + 1.0)));
        BinarizeTest.testImages[4] = BinarizeTest.createTestImage((int)4, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)Float.valueOf(noDataF), (boolean)false, (int)1, (Number)Float.valueOf((float)(thresholds[4] + 1.0)));
        BinarizeTest.testImages[5] = BinarizeTest.createTestImage((int)5, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataD, (boolean)false, (int)1, (Number)(thresholds[5] + 1.0));
        IMAGE_FILLER = false;
        boolean minIncluded = true;
        boolean maxIncluded = true;
        noDataByte = RangeFactory.create((byte)noDataB, (boolean)minIncluded, (byte)noDataB, (boolean)maxIncluded);
        noDataUShort = RangeFactory.createU((short)noDataS, (boolean)minIncluded, (short)noDataS, (boolean)maxIncluded);
        noDataShort = RangeFactory.create((short)noDataS, (boolean)minIncluded, (short)noDataS, (boolean)maxIncluded);
        noDataInt = RangeFactory.create((int)noDataI, (boolean)minIncluded, (int)noDataI, (boolean)maxIncluded);
        noDataFloat = RangeFactory.create((float)noDataF, (boolean)minIncluded, (float)noDataF, (boolean)maxIncluded, (boolean)true);
        noDataDouble = RangeFactory.create((double)noDataD, (boolean)minIncluded, (double)noDataD, (boolean)maxIncluded, (boolean)true);
        Rectangle roiBounds = new Rectangle(5, 5, DEFAULT_WIDTH / 4, DEFAULT_HEIGHT / 4);
        roiObject = new ROIShape((Shape)roiBounds);
    }

    @Test
    public void testValidData() {
        boolean roiUsed = false;
        boolean noDataUsed = false;
        for (int i = 0; i < 6; ++i) {
            this.testType(testImages[i], noDataUsed, roiUsed);
        }
    }

    @Test
    public void testRoi() {
        boolean roiUsed = true;
        boolean noDataUsed = false;
        for (int i = 0; i < 6; ++i) {
            this.testType(testImages[i], noDataUsed, roiUsed);
        }
    }

    @Test
    public void testNoData() {
        boolean roiUsed = false;
        boolean noDataUsed = true;
        for (int i = 0; i < 6; ++i) {
            this.testType(testImages[i], noDataUsed, roiUsed);
        }
    }

    @Test
    public void testRoiNoData() {
        boolean roiUsed = true;
        boolean noDataUsed = true;
        for (int i = 0; i < 6; ++i) {
            this.testType(testImages[i], noDataUsed, roiUsed);
        }
    }

    private void testType(RenderedImage src, boolean nodataUsed, boolean roiUsed) {
        Range noData;
        int dataType;
        block14: {
            block13: {
                dataType = src.getSampleModel().getDataType();
                if (!nodataUsed) break block13;
                switch (dataType) {
                    case 0: {
                        noData = noDataByte;
                        break block14;
                    }
                    case 1: {
                        noData = noDataUShort;
                        break block14;
                    }
                    case 2: {
                        noData = noDataShort;
                        break block14;
                    }
                    case 3: {
                        noData = noDataInt;
                        break block14;
                    }
                    case 4: {
                        noData = noDataFloat;
                        break block14;
                    }
                    case 5: {
                        noData = noDataDouble;
                        break block14;
                    }
                    default: {
                        throw new IllegalArgumentException("Wrong data type");
                    }
                }
            }
            noData = null;
        }
        double threshold = thresholds[dataType];
        Object roi = roiUsed ? roiObject : null;
        RenderedOp binarized = BinarizeDescriptor.create((RenderedImage)src, (Double)threshold, (ROI)roi, (Range)noData, null);
        int tileWidth = binarized.getTileWidth();
        int tileHeight = binarized.getTileHeight();
        int minTileX = binarized.getMinTileX();
        int minTileY = binarized.getMinTileY();
        int numXTiles = binarized.getNumXTiles();
        int numYTiles = binarized.getNumYTiles();
        int maxTileX = minTileX + numXTiles;
        int maxTileY = minTileY + numYTiles;
        Assert.assertEquals((long)binarized.getWidth(), (long)src.getWidth());
        Assert.assertEquals((long)binarized.getHeight(), (long)src.getHeight());
        Assert.assertEquals((long)binarized.getMinX(), (long)src.getMinX());
        Assert.assertEquals((long)binarized.getMinY(), (long)src.getMinY());
        Assert.assertEquals((long)minTileX, (long)src.getMinTileX());
        Assert.assertEquals((long)minTileY, (long)src.getMinTileY());
        Assert.assertEquals((long)numXTiles, (long)src.getNumXTiles());
        Assert.assertEquals((long)numYTiles, (long)src.getNumYTiles());
        Assert.assertEquals((long)tileWidth, (long)src.getTileWidth());
        Assert.assertEquals((long)tileHeight, (long)src.getTileHeight());
        for (int tileX = minTileX; tileX < maxTileX; ++tileX) {
            for (int tileY = minTileY; tileY < maxTileY; ++tileY) {
                Raster tile = binarized.getTile(tileX, tileY);
                Raster srcTile = src.getTile(tileX, tileY);
                int minX = tile.getMinX();
                int minY = tile.getMinY();
                int maxX = minX + tileWidth - 1;
                int maxY = minY + tileHeight - 1;
                for (int x = minX; x <= maxX; ++x) {
                    for (int y = minY; y <= maxY; ++y) {
                        boolean isValidData;
                        double sample = srcTile.getSampleDouble(x, y, 0);
                        int result = tile.getSample(x, y, 0);
                        boolean over = result > 0;
                        boolean bl = isValidData = (!roiUsed || roiUsed && roiObject.contains(x, y)) && (!nodataUsed || nodataUsed && !noDataDouble.contains(sample));
                        if (isValidData) {
                            Assert.assertEquals((Object)over, (Object)(sample >= threshold ? 1 : 0));
                            continue;
                        }
                        Assert.assertEquals((Object)over, (Object)false);
                    }
                }
            }
        }
        binarized.dispose();
    }
}

