/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.bandselect;

import com.sun.media.jai.opimage.CopyOpImage;
import it.geosolutions.jaiext.bandselect.BandSelectDescriptor;
import it.geosolutions.jaiext.testclasses.TestBase;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.ConstantDescriptor;
import org.junit.Assert;
import org.junit.Test;

public class BandSelectTest
extends TestBase {
    @Test
    public void baseTest() {
        RenderedOp twoBands = ConstantDescriptor.create((Float)Float.valueOf(512.0f), (Float)Float.valueOf(512.0f), (Number[])new Double[]{1.0, 0.0}, null);
        ParameterBlockJAI pb = new ParameterBlockJAI("BandSelect");
        pb.addSource((Object)twoBands);
        pb.setParameter("bandIndices", (Object)new int[]{1});
        RenderedOp oneBand = JAI.create((String)"BandSelect", (ParameterBlock)pb);
        Assert.assertEquals((long)1L, (long)oneBand.getSampleModel().getNumBands());
        Assert.assertEquals((double)0.0, (double)oneBand.getData().getSample(0, 0, 0), (double)1.0E-11);
    }

    @Test
    public void copyTest() {
        ImageLayout layout = new ImageLayout();
        int[] bitMask = new int[]{0, 1};
        SinglePixelPackedSampleModel sampleModel = new SinglePixelPackedSampleModel(0, 512, 512, bitMask);
        layout.setSampleModel((SampleModel)sampleModel);
        layout.setColorModel(null);
        RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        RenderedOp twoBands = ConstantDescriptor.create((Float)Float.valueOf(512.0f), (Float)Float.valueOf(512.0f), (Number[])new Byte[]{(byte)1, (byte)0}, null);
        CopyOpImage twoBandsPacked = new CopyOpImage((RenderedImage)twoBands, (Map)hints, layout);
        RenderedOp oneBand = BandSelectDescriptor.create((RenderedImage)twoBandsPacked, (int[])new int[]{1}, (RenderingHints)hints);
        Assert.assertEquals((long)1L, (long)oneBand.getSampleModel().getNumBands());
        Assert.assertEquals((double)0.0, (double)oneBand.getData().getSample(0, 0, 0), (double)1.0E-11);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testZeroIndexes() {
        RenderedOp twoBands = ConstantDescriptor.create((Float)Float.valueOf(1.0f), (Float)Float.valueOf(1.0f), (Number[])new Double[]{1.0, 0.0}, null);
        ParameterBlockJAI pb = new ParameterBlockJAI("BandSelect");
        pb.addSource((Object)twoBands);
        pb.setParameter("bandIndices", (Object)new int[0]);
        RenderedOp oneBand = JAI.create((String)"BandSelect", (ParameterBlock)pb);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNegativeIndex() {
        RenderedOp twoBands = ConstantDescriptor.create((Float)Float.valueOf(1.0f), (Float)Float.valueOf(1.0f), (Number[])new Double[]{1.0, 0.0}, null);
        ParameterBlockJAI pb = new ParameterBlockJAI("BandSelect");
        pb.addSource((Object)twoBands);
        pb.setParameter("bandIndices", (Object)new int[]{-1});
        RenderedOp oneBand = JAI.create((String)"BandSelect", (ParameterBlock)pb);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGreaterIndex() {
        RenderedOp twoBands = ConstantDescriptor.create((Float)Float.valueOf(1.0f), (Float)Float.valueOf(1.0f), (Number[])new Double[]{1.0, 0.0}, null);
        ParameterBlockJAI pb = new ParameterBlockJAI("BandSelect");
        pb.addSource((Object)twoBands);
        pb.setParameter("bandIndices", (Object)new int[]{2});
        RenderedOp oneBand = JAI.create((String)"BandSelect", (ParameterBlock)pb);
    }

    @Test
    public void testColorModelDouble() throws Exception {
        RenderedOp source = ConstantDescriptor.create((Float)Float.valueOf(512.0f), (Float)Float.valueOf(512.0f), (Number[])new Double[]{1.0, 2.0, 3.0, 4.0}, null);
        Assert.assertEquals((long)5L, (long)source.getSampleModel().getDataType());
        BandSelectTest.checkFloatingPointColorModel((RenderedImage)source);
    }

    @Test
    public void testColorModelFloat() throws Exception {
        RenderedOp source = ConstantDescriptor.create((Float)Float.valueOf(512.0f), (Float)Float.valueOf(512.0f), (Number[])new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f), Float.valueOf(4.0f)}, null);
        Assert.assertEquals((long)4L, (long)source.getSampleModel().getDataType());
        BandSelectTest.checkFloatingPointColorModel((RenderedImage)source);
    }

    private static void checkFloatingPointColorModel(RenderedImage source) {
        for (int bandCount = 1; bandCount <= 4; ++bandCount) {
            int[] bandIndices = new int[bandCount];
            for (int j = 0; j < bandCount; ++j) {
                bandIndices[j] = j;
            }
            ParameterBlockJAI pb = new ParameterBlockJAI("BandSelect");
            pb.addSource((Object)source);
            pb.setParameter("bandIndices", (Object)bandIndices);
            RenderedOp op = JAI.create((String)"BandSelect", (ParameterBlock)pb);
            Assert.assertFalse((String)("Has alpha with " + bandCount + " bands"), (boolean)op.getColorModel().hasAlpha());
            Assert.assertEquals((long)1L, (long)op.getColorModel().getTransparency());
        }
    }

    @Test
    public void testColorModelByte() throws Exception {
        RenderedOp source = ConstantDescriptor.create((Float)Float.valueOf(512.0f), (Float)Float.valueOf(512.0f), (Number[])new Byte[]{(byte)1, (byte)2, (byte)3, (byte)4}, null);
        Assert.assertEquals((long)0L, (long)source.getSampleModel().getDataType());
        for (int bandCount = 1; bandCount <= 4; ++bandCount) {
            int[] bandIndices = new int[bandCount];
            for (int j = 0; j < bandCount; ++j) {
                bandIndices[j] = j;
            }
            ParameterBlockJAI pb = new ParameterBlockJAI("BandSelect");
            pb.addSource((Object)source);
            pb.setParameter("bandIndices", (Object)bandIndices);
            RenderedOp op = JAI.create((String)"BandSelect", (ParameterBlock)pb);
            if (bandCount == 2 || bandCount == 4) {
                Assert.assertTrue((boolean)op.getColorModel().hasAlpha());
                Assert.assertEquals((long)3L, (long)op.getColorModel().getTransparency());
                continue;
            }
            Assert.assertFalse((String)("Has alpha with " + bandCount + " bands"), (boolean)op.getColorModel().hasAlpha());
            Assert.assertEquals((long)1L, (long)op.getColorModel().getTransparency());
        }
    }
}

