/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.bandselect;

import com.sun.media.jai.opimage.CopyOpImage;
import it.geosolutions.jaiext.bandselect.BandSelectDescriptor;
import it.geosolutions.jaiext.testclasses.TestBase;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.ConstantDescriptor;
import org.junit.Assert;
import org.junit.Test;

public class BandSelectTest
extends TestBase {
    @Test
    public void baseTest() {
        RenderedOp twoBands = ConstantDescriptor.create((Float)Float.valueOf(512.0f), (Float)Float.valueOf(512.0f), (Number[])new Double[]{1.0, 0.0}, null);
        ParameterBlockJAI pb = new ParameterBlockJAI("BandSelect2");
        pb.addSource((Object)twoBands);
        pb.setParameter("bandIndices", (Object)new int[]{1});
        RenderedOp oneBand = JAI.create((String)"BandSelect2", (ParameterBlock)pb);
        Assert.assertEquals((long)1L, (long)oneBand.getSampleModel().getNumBands());
        Assert.assertEquals((double)0.0, (double)oneBand.getData().getSample(0, 0, 0), (double)1.0E-11);
    }

    @Test
    public void copyTest() {
        ImageLayout layout = new ImageLayout();
        int[] bitMask = new int[]{0, 1};
        SinglePixelPackedSampleModel sampleModel = new SinglePixelPackedSampleModel(0, 512, 512, bitMask);
        layout.setSampleModel((SampleModel)sampleModel);
        layout.setColorModel(null);
        RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        RenderedOp twoBands = ConstantDescriptor.create((Float)Float.valueOf(512.0f), (Float)Float.valueOf(512.0f), (Number[])new Byte[]{(byte)1, (byte)0}, null);
        CopyOpImage twoBandsPacked = new CopyOpImage((RenderedImage)twoBands, (Map)hints, layout);
        RenderedOp oneBand = BandSelectDescriptor.create((RenderedImage)twoBandsPacked, (int[])new int[]{1}, (RenderingHints)hints);
        Assert.assertEquals((long)1L, (long)oneBand.getSampleModel().getNumBands());
        Assert.assertEquals((double)0.0, (double)oneBand.getData().getSample(0, 0, 0), (double)1.0E-11);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testZeroIndexes() {
        RenderedOp twoBands = ConstantDescriptor.create((Float)Float.valueOf(1.0f), (Float)Float.valueOf(1.0f), (Number[])new Double[]{1.0, 0.0}, null);
        ParameterBlockJAI pb = new ParameterBlockJAI("BandSelect2");
        pb.addSource((Object)twoBands);
        pb.setParameter("bandIndices", (Object)new int[0]);
        RenderedOp oneBand = JAI.create((String)"BandSelect2", (ParameterBlock)pb);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNegativeIndex() {
        RenderedOp twoBands = ConstantDescriptor.create((Float)Float.valueOf(1.0f), (Float)Float.valueOf(1.0f), (Number[])new Double[]{1.0, 0.0}, null);
        ParameterBlockJAI pb = new ParameterBlockJAI("BandSelect2");
        pb.addSource((Object)twoBands);
        pb.setParameter("bandIndices", (Object)new int[]{-1});
        RenderedOp oneBand = JAI.create((String)"BandSelect2", (ParameterBlock)pb);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGreaterIndex() {
        RenderedOp twoBands = ConstantDescriptor.create((Float)Float.valueOf(1.0f), (Float)Float.valueOf(1.0f), (Number[])new Double[]{1.0, 0.0}, null);
        ParameterBlockJAI pb = new ParameterBlockJAI("BandSelect2");
        pb.addSource((Object)twoBands);
        pb.setParameter("bandIndices", (Object)new int[]{2});
        RenderedOp oneBand = JAI.create((String)"BandSelect2", (ParameterBlock)pb);
    }
}

