/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.bandmerge;

import com.sun.media.jai.util.ImageUtil;
import it.geosolutions.jaiext.bandmerge.BandMergeDescriptor;
import it.geosolutions.jaiext.bandmerge.BandMergeOpImage;
import it.geosolutions.jaiext.bandmerge.ExtendedBandMergeOpImage;
import it.geosolutions.jaiext.iterators.RandomIterFactory;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.testclasses.TestBase;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import javax.media.jai.TiledImage;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.operator.BandSelectDescriptor;
import javax.media.jai.operator.TranslateDescriptor;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class BandMergeTest
extends TestBase {
    private static final int IMAGE_HEIGHT = 128;
    private static final int IMAGE_WIDTH = 128;
    private static final int BAND_NUMBER = 4;
    private static final double TOLERANCE = 0.1;
    private static final int ROI_WIDTH = 40;
    private static final int ROI_HEIGHT = 40;
    private static RenderedImage[][] images;
    private static Range[] noDataByte;
    private static Range[] noDataUShort;
    private static Range[] noDataShort;
    private static Range[] noDataInt;
    private static Range[] noDataFloat;
    private static Range[] noDataDouble;
    private static double destNoData;
    private static ROI roiData;

    @BeforeClass
    public static void initialSetup() {
        IMAGE_FILLER = true;
        images = new RenderedImage[6][4];
        byte noDataB = 50;
        short noDataS = 50;
        int noDataI = 50;
        float noDataF = 50.0f;
        double noDataD = 50.0;
        for (int band = 0; band < 4; ++band) {
            BandMergeTest.images[0][band] = BandMergeTest.createTestImage((int)0, (int)128, (int)128, (Number)noDataB, (boolean)false, (int)1);
            BandMergeTest.images[1][band] = BandMergeTest.createTestImage((int)1, (int)128, (int)128, (Number)noDataS, (boolean)false, (int)1);
            BandMergeTest.images[2][band] = BandMergeTest.createTestImage((int)2, (int)128, (int)128, (Number)noDataS, (boolean)false, (int)1);
            BandMergeTest.images[3][band] = BandMergeTest.createTestImage((int)3, (int)128, (int)128, (Number)noDataI, (boolean)false, (int)1);
            BandMergeTest.images[4][band] = BandMergeTest.createTestImage((int)4, (int)128, (int)128, (Number)Float.valueOf(noDataF), (boolean)false, (int)1);
            BandMergeTest.images[5][band] = BandMergeTest.createTestImage((int)5, (int)128, (int)128, (Number)noDataD, (boolean)false, (int)1);
        }
        IMAGE_FILLER = false;
        boolean minIncluded = true;
        boolean maxIncluded = true;
        noDataByte = new Range[]{RangeFactory.create((byte)noDataB, (boolean)minIncluded, (byte)noDataB, (boolean)maxIncluded)};
        noDataUShort = new Range[]{RangeFactory.createU((short)noDataS, (boolean)minIncluded, (short)noDataS, (boolean)maxIncluded)};
        noDataShort = new Range[]{RangeFactory.create((short)noDataS, (boolean)minIncluded, (short)noDataS, (boolean)maxIncluded)};
        noDataInt = new Range[]{RangeFactory.create((int)noDataI, (boolean)minIncluded, (int)noDataI, (boolean)maxIncluded)};
        noDataFloat = new Range[]{RangeFactory.create((float)noDataF, (boolean)minIncluded, (float)noDataF, (boolean)maxIncluded, (boolean)true)};
        noDataDouble = new Range[]{RangeFactory.create((double)noDataD, (boolean)minIncluded, (double)noDataD, (boolean)maxIncluded, (boolean)true)};
        destNoData = 100.0;
        roiData = new ROIShape((Shape)new Rectangle(0, 0, 40, 40));
    }

    @Test
    public void testBandMerge() {
        boolean noDataUsed = false;
        boolean roiUsed = false;
        this.testBandMerge(images[0], noDataUsed, roiUsed, 4);
        this.testBandMerge(images[1], noDataUsed, roiUsed, 4);
        this.testBandMerge(images[2], noDataUsed, roiUsed, 4);
        this.testBandMerge(images[3], noDataUsed, roiUsed, 4);
        this.testBandMerge(images[4], noDataUsed, roiUsed, 4);
        this.testBandMerge(images[5], noDataUsed, roiUsed, 4);
    }

    @Test
    public void testBandMergeNoData() {
        boolean noDataUsed = true;
        boolean roiUsed = false;
        this.testBandMerge(images[0], noDataUsed, roiUsed, 4);
        this.testBandMerge(images[1], noDataUsed, roiUsed, 4);
        this.testBandMerge(images[2], noDataUsed, roiUsed, 4);
        this.testBandMerge(images[3], noDataUsed, roiUsed, 4);
        this.testBandMerge(images[4], noDataUsed, roiUsed, 4);
        this.testBandMerge(images[5], noDataUsed, roiUsed, 4);
    }

    @Test
    public void testBandMergeROI() {
        boolean noDataUsed = false;
        boolean roiUsed = true;
        this.testBandMerge(images[0], noDataUsed, roiUsed, 4);
        this.testBandMerge(images[1], noDataUsed, roiUsed, 4);
        this.testBandMerge(images[2], noDataUsed, roiUsed, 4);
        this.testBandMerge(images[3], noDataUsed, roiUsed, 4);
        this.testBandMerge(images[4], noDataUsed, roiUsed, 4);
        this.testBandMerge(images[5], noDataUsed, roiUsed, 4);
    }

    @Test
    public void testBandMergeNotIntersectingROI() {
        boolean roiUsed = true;
        ROI roi = null;
        if (roiUsed) {
            roi = roiData;
        }
        ImageLayout layout = new ImageLayout(images[0][0]);
        layout.setTileHeight(32);
        layout.setTileWidth(32);
        RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        RenderedOp merged = BandMergeDescriptor.create(null, (double)destNoData, (boolean)false, (RenderingHints)hints, null, (ROI)roi, (RenderedImage[])images[0]);
        int outTileX = 3;
        int outTileY = 3;
        Raster outOfRoiTile = merged.getTile(outTileX, outTileY);
        int minX = outOfRoiTile.getMinX();
        int minY = outOfRoiTile.getMinY();
        int maxX = outOfRoiTile.getWidth() + minX;
        int maxY = outOfRoiTile.getHeight() + minY;
        for (int b = 0; b < 3; ++b) {
            for (int x = minX; x < maxX; ++x) {
                for (int y = minY; y < maxY; ++y) {
                    double value = outOfRoiTile.getSampleDouble(x, y, b);
                    Assert.assertFalse((boolean)roi.contains(x, y));
                    Assert.assertEquals((double)value, (double)destNoData, (double)0.1);
                }
            }
        }
        merged.dispose();
    }

    @Test
    public void testBandMergeNoDataROI() {
        boolean noDataUsed = true;
        boolean roiUsed = true;
        this.testBandMerge(images[0], noDataUsed, roiUsed, 4);
        this.testBandMerge(images[1], noDataUsed, roiUsed, 4);
        this.testBandMerge(images[2], noDataUsed, roiUsed, 4);
        this.testBandMerge(images[3], noDataUsed, roiUsed, 4);
        this.testBandMerge(images[4], noDataUsed, roiUsed, 4);
        this.testBandMerge(images[5], noDataUsed, roiUsed, 4);
    }

    @Test
    public void testExtendedBandMerge() {
        boolean noDataUsed = false;
        boolean roiUsed = false;
        this.testExtendedBandMerge(images[0], noDataUsed, roiUsed, 4);
        this.testExtendedBandMerge(images[1], noDataUsed, roiUsed, 4);
        this.testExtendedBandMerge(images[2], noDataUsed, roiUsed, 4);
        this.testExtendedBandMerge(images[3], noDataUsed, roiUsed, 4);
        this.testExtendedBandMerge(images[4], noDataUsed, roiUsed, 4);
        this.testExtendedBandMerge(images[5], noDataUsed, roiUsed, 4);
    }

    @Test
    public void testExtendedBandMergeNoData() {
        boolean noDataUsed = true;
        boolean roiUsed = false;
        this.testExtendedBandMerge(images[0], noDataUsed, roiUsed, 4);
        this.testExtendedBandMerge(images[1], noDataUsed, roiUsed, 4);
        this.testExtendedBandMerge(images[2], noDataUsed, roiUsed, 4);
        this.testExtendedBandMerge(images[3], noDataUsed, roiUsed, 4);
        this.testExtendedBandMerge(images[4], noDataUsed, roiUsed, 4);
        this.testExtendedBandMerge(images[5], noDataUsed, roiUsed, 4);
    }

    @Test
    public void testExtendedBandMergeROI() {
        boolean noDataUsed = false;
        boolean roiUsed = true;
        this.testExtendedBandMerge(images[0], noDataUsed, roiUsed, 4);
        this.testExtendedBandMerge(images[1], noDataUsed, roiUsed, 4);
        this.testExtendedBandMerge(images[2], noDataUsed, roiUsed, 4);
        this.testExtendedBandMerge(images[3], noDataUsed, roiUsed, 4);
        this.testExtendedBandMerge(images[4], noDataUsed, roiUsed, 4);
        this.testExtendedBandMerge(images[5], noDataUsed, roiUsed, 4);
    }

    @Test
    public void testExtendedBandMergeNoDataROI() {
        boolean noDataUsed = true;
        boolean roiUsed = true;
        this.testExtendedBandMerge(images[0], noDataUsed, roiUsed, 4);
        this.testExtendedBandMerge(images[1], noDataUsed, roiUsed, 4);
        this.testExtendedBandMerge(images[2], noDataUsed, roiUsed, 4);
        this.testExtendedBandMerge(images[3], noDataUsed, roiUsed, 4);
        this.testExtendedBandMerge(images[4], noDataUsed, roiUsed, 4);
        this.testExtendedBandMerge(images[5], noDataUsed, roiUsed, 4);
    }

    @AfterClass
    public static void disposal() {
        for (int band = 0; band < 4; ++band) {
            ((TiledImage)images[0][band]).dispose();
            ((TiledImage)images[1][band]).dispose();
            ((TiledImage)images[2][band]).dispose();
            ((TiledImage)images[3][band]).dispose();
            ((TiledImage)images[4][band]).dispose();
            ((TiledImage)images[5][band]).dispose();
        }
    }

    private void testBandMerge(RenderedImage[] sources, boolean noDataUsed, boolean roiUsed, int numberOfBands) {
        Range[] noData;
        int dataType;
        block30: {
            block29: {
                dataType = sources[0].getSampleModel().getDataType();
                if (!noDataUsed) break block29;
                switch (dataType) {
                    case 0: {
                        noData = noDataByte;
                        break block30;
                    }
                    case 1: {
                        noData = noDataUShort;
                        break block30;
                    }
                    case 2: {
                        noData = noDataShort;
                        break block30;
                    }
                    case 3: {
                        noData = noDataInt;
                        break block30;
                    }
                    case 4: {
                        noData = noDataFloat;
                        break block30;
                    }
                    case 5: {
                        noData = noDataDouble;
                        break block30;
                    }
                    default: {
                        throw new IllegalArgumentException("Wrong data type");
                    }
                }
            }
            noData = null;
        }
        ROI roi = null;
        if (roiUsed) {
            roi = roiData;
        }
        RenderedOp merged = BandMergeDescriptor.create((Range[])noData, (double)destNoData, (boolean)false, null, null, (ROI)roi, (RenderedImage[])sources);
        Assert.assertEquals((long)numberOfBands, (long)merged.getNumBands());
        Assert.assertNotNull((Object)merged.getColorModel());
        if (merged.getSampleModel().getDataType() != 2) {
            Assert.assertTrue((!merged.getColorModel().hasAlpha() ? 1 : 0) != 0);
        }
        int minTileX = merged.getMinTileX();
        int minTileY = merged.getMinTileY();
        Raster upperLeftTile = merged.getTile(minTileX, minTileY);
        int minX = upperLeftTile.getMinX();
        int minY = upperLeftTile.getMinY();
        int maxX = upperLeftTile.getWidth() + minX;
        int maxY = upperLeftTile.getHeight() + minY;
        for (int b = 0; b < 4; ++b) {
            Raster bandRaster = sources[b].getTile(minTileX, minTileY);
            for (int x = minX; x < maxX; ++x) {
                block18: for (int y = minY; y < maxY; ++y) {
                    double value = upperLeftTile.getSampleDouble(x, y, b);
                    double valueOld = bandRaster.getSampleDouble(x, y, 0);
                    boolean contained = true;
                    if (roiUsed && !roi.contains(x, y)) {
                        contained = false;
                        Assert.assertEquals((double)value, (double)destNoData, (double)0.1);
                    }
                    if (!contained) continue;
                    if (noDataUsed) {
                        switch (dataType) {
                            case 0: {
                                byte sampleB = ImageUtil.clampRoundByte((double)value);
                                byte sampleBOld = ImageUtil.clampRoundByte((double)valueOld);
                                if (noData[0].contains(sampleBOld)) {
                                    Assert.assertEquals((double)sampleB, (double)destNoData, (double)0.1);
                                    continue block18;
                                }
                                Assert.assertEquals((double)sampleB, (double)valueOld, (double)0.1);
                                continue block18;
                            }
                            case 1: {
                                short sampleUS = ImageUtil.clampRoundUShort((double)value);
                                short sampleUSOld = ImageUtil.clampRoundUShort((double)valueOld);
                                if (noData[0].contains(sampleUSOld)) {
                                    Assert.assertEquals((double)sampleUS, (double)destNoData, (double)0.1);
                                    continue block18;
                                }
                                Assert.assertEquals((double)sampleUS, (double)valueOld, (double)0.1);
                                continue block18;
                            }
                            case 2: {
                                short sampleS = ImageUtil.clampRoundShort((double)value);
                                short sampleSOld = ImageUtil.clampRoundShort((double)valueOld);
                                if (noData[0].contains(sampleSOld)) {
                                    Assert.assertEquals((double)sampleS, (double)destNoData, (double)0.1);
                                    continue block18;
                                }
                                Assert.assertEquals((double)sampleS, (double)valueOld, (double)0.1);
                                continue block18;
                            }
                            case 3: {
                                int sampleI = ImageUtil.clampRoundInt((double)value);
                                int sampleIOld = ImageUtil.clampRoundInt((double)valueOld);
                                if (noData[0].contains(sampleIOld)) {
                                    Assert.assertEquals((double)sampleI, (double)destNoData, (double)0.1);
                                    continue block18;
                                }
                                Assert.assertEquals((double)sampleI, (double)valueOld, (double)0.1);
                                continue block18;
                            }
                            case 4: {
                                float sampleF = ImageUtil.clampFloat((double)value);
                                float sampleFOld = ImageUtil.clampFloat((double)valueOld);
                                if (noData[0].contains(sampleFOld)) {
                                    Assert.assertEquals((double)sampleF, (double)destNoData, (double)0.1);
                                    continue block18;
                                }
                                Assert.assertEquals((double)sampleF, (double)valueOld, (double)0.1);
                                continue block18;
                            }
                            case 5: {
                                if (noData[0].contains(valueOld)) {
                                    Assert.assertEquals((double)value, (double)destNoData, (double)0.1);
                                    continue block18;
                                }
                                Assert.assertEquals((double)value, (double)valueOld, (double)0.1);
                                continue block18;
                            }
                            default: {
                                throw new IllegalArgumentException("Wrong data type");
                            }
                        }
                    }
                    Assert.assertEquals((double)value, (double)valueOld, (double)0.1);
                }
            }
        }
        merged.dispose();
    }

    private void testExtendedBandMerge(RenderedImage[] sources, boolean noDataUsed, boolean roiUsed, int numberOfBands) {
        Range[] noData;
        int dataType;
        block32: {
            block31: {
                dataType = sources[0].getSampleModel().getDataType();
                if (!noDataUsed) break block31;
                switch (dataType) {
                    case 0: {
                        noData = noDataByte;
                        break block32;
                    }
                    case 1: {
                        noData = noDataUShort;
                        break block32;
                    }
                    case 2: {
                        noData = noDataShort;
                        break block32;
                    }
                    case 3: {
                        noData = noDataInt;
                        break block32;
                    }
                    case 4: {
                        noData = noDataFloat;
                        break block32;
                    }
                    case 5: {
                        noData = noDataDouble;
                        break block32;
                    }
                    default: {
                        throw new IllegalArgumentException("Wrong data type");
                    }
                }
            }
            noData = null;
        }
        ROI roi = null;
        if (roiUsed) {
            roi = roiData;
        }
        RenderedOp[] translated = new RenderedOp[sources.length];
        ArrayList<AffineTransform> transform = new ArrayList<AffineTransform>();
        for (int i = 0; i < sources.length; ++i) {
            int xTrans = (int)(Math.random() * 10.0);
            int yTrans = (int)(Math.random() * 10.0);
            AffineTransform tr = AffineTransform.getTranslateInstance(xTrans, yTrans);
            transform.add(tr);
            translated[i] = TranslateDescriptor.create((RenderedImage)sources[i], (Float)Float.valueOf(xTrans), (Float)Float.valueOf(yTrans), null, null);
        }
        ImageLayout layout = new ImageLayout();
        layout.setMinX(sources[0].getMinX());
        layout.setMinY(sources[0].getMinY());
        layout.setWidth(sources[0].getWidth());
        layout.setHeight(sources[0].getHeight());
        RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        RenderedOp merged = BandMergeDescriptor.create((Range[])noData, (double)destNoData, (boolean)false, (RenderingHints)hints, transform, (ROI)roi, (RenderedImage[])translated);
        Assert.assertNotNull((Object)merged.getTiles());
        Assert.assertEquals((long)numberOfBands, (long)merged.getNumBands());
        int minTileX = merged.getMinTileX();
        int minTileY = merged.getMinTileY();
        Raster upperLeftTile = merged.getTile(minTileX, minTileY);
        int minX = upperLeftTile.getMinX();
        int minY = upperLeftTile.getMinY();
        int maxX = upperLeftTile.getWidth() + minX;
        int maxY = upperLeftTile.getHeight() + minY;
        int dstMinX = merged.getMinX();
        int dstMinY = merged.getMinY();
        int dstMaxX = merged.getMaxX();
        int dstMaxY = merged.getMaxY();
        Point2D.Double ptDst = new Point2D.Double(0.0, 0.0);
        Point2D.Double ptSrc = new Point2D.Double(0.0, 0.0);
        for (int b = 0; b < numberOfBands; ++b) {
            RandomIter iter = RandomIterFactory.create((RenderedImage)translated[b], null, (boolean)true, (boolean)true);
            int srcMinX = translated[b].getMinX();
            int srcMinY = translated[b].getMinY();
            int srcMaxX = translated[b].getMaxX();
            int srcMaxY = translated[b].getMaxY();
            for (int x = minX; x < maxX; ++x) {
                block19: for (int y = minY; y < maxY; ++y) {
                    double value = upperLeftTile.getSampleDouble(x, y, b);
                    if (x < dstMinX || x >= dstMaxX || y < dstMinY || y >= dstMaxY) {
                        value = destNoData;
                    }
                    ((Point2D)ptDst).setLocation(x, y);
                    ((AffineTransform)transform.get(b)).transform(ptDst, ptSrc);
                    int srcX = BandMergeTest.round(((Point2D)ptSrc).getX());
                    int srcY = BandMergeTest.round(((Point2D)ptSrc).getY());
                    double valueOld = destNoData;
                    if (srcX >= srcMinX && srcX < srcMaxX && srcY >= srcMinY && srcY < srcMaxY) {
                        valueOld = iter.getSampleDouble(srcX, srcY, 0);
                    }
                    boolean contained = true;
                    if (roiUsed && !roi.contains(x, y)) {
                        contained = false;
                        Assert.assertEquals((double)value, (double)destNoData, (double)0.1);
                    }
                    if (!contained) continue;
                    if (noDataUsed) {
                        switch (dataType) {
                            case 0: {
                                byte sampleB = ImageUtil.clampRoundByte((double)value);
                                byte sampleBOld = ImageUtil.clampRoundByte((double)valueOld);
                                if (noData[0].contains(sampleBOld)) {
                                    Assert.assertEquals((double)sampleB, (double)destNoData, (double)0.1);
                                    continue block19;
                                }
                                Assert.assertEquals((double)sampleB, (double)valueOld, (double)0.1);
                                continue block19;
                            }
                            case 1: {
                                short sampleUS = ImageUtil.clampRoundUShort((double)value);
                                short sampleUSOld = ImageUtil.clampRoundUShort((double)valueOld);
                                if (noData[0].contains(sampleUSOld)) {
                                    Assert.assertEquals((double)sampleUS, (double)destNoData, (double)0.1);
                                    continue block19;
                                }
                                Assert.assertEquals((double)sampleUS, (double)valueOld, (double)0.1);
                                continue block19;
                            }
                            case 2: {
                                short sampleS = ImageUtil.clampRoundShort((double)value);
                                short sampleSOld = ImageUtil.clampRoundShort((double)valueOld);
                                if (noData[0].contains(sampleSOld)) {
                                    Assert.assertEquals((double)sampleS, (double)destNoData, (double)0.1);
                                    continue block19;
                                }
                                Assert.assertEquals((double)sampleS, (double)valueOld, (double)0.1);
                                continue block19;
                            }
                            case 3: {
                                int sampleI = ImageUtil.clampRoundInt((double)value);
                                int sampleIOld = ImageUtil.clampRoundInt((double)valueOld);
                                if (noData[0].contains(sampleIOld)) {
                                    Assert.assertEquals((double)sampleI, (double)destNoData, (double)0.1);
                                    continue block19;
                                }
                                Assert.assertEquals((double)sampleI, (double)valueOld, (double)0.1);
                                continue block19;
                            }
                            case 4: {
                                float sampleF = ImageUtil.clampFloat((double)value);
                                float sampleFOld = ImageUtil.clampFloat((double)valueOld);
                                if (noData[0].contains(sampleFOld)) {
                                    Assert.assertEquals((double)sampleF, (double)destNoData, (double)0.1);
                                    continue block19;
                                }
                                Assert.assertEquals((double)sampleF, (double)valueOld, (double)0.1);
                                continue block19;
                            }
                            case 5: {
                                if (noData[0].contains(valueOld)) {
                                    Assert.assertEquals((double)value, (double)destNoData, (double)0.1);
                                    continue block19;
                                }
                                Assert.assertEquals((double)value, (double)valueOld, (double)0.1);
                                continue block19;
                            }
                            default: {
                                throw new IllegalArgumentException("Wrong data type");
                            }
                        }
                    }
                    Assert.assertEquals((double)value, (double)valueOld, (double)0.1);
                }
            }
        }
        merged.dispose();
    }

    private static int round(double f) {
        return f >= 0.0 ? (int)(f + 0.5) : (int)(f - 0.5);
    }

    @Test
    public void testBandMergeBandSelected() {
        this.testBandMergeOnBandSelected(0, (byte)0, (byte)1);
        this.testBandMergeOnBandSelected(1, (short)0, (short)1);
        this.testBandMergeOnBandSelected(2, (short)0, (short)1);
        this.testBandMergeOnBandSelected(3, 0, 1);
        this.testBandMergeOnBandSelected(4, Float.valueOf(0.0f), Float.valueOf(1.0f));
        this.testBandMergeOnBandSelected(5, 0.0, 1.0);
    }

    public void testBandMergeOnBandSelected(int dataType, Number noDataValue, Number dataValue) {
        this.testBandMergeOnBandSelected(dataType, noDataValue, dataValue, true);
        this.testBandMergeOnBandSelected(dataType, noDataValue, dataValue, false);
        this.testBandMergeOnBandSelected(dataType, null, dataValue, true);
        this.testBandMergeOnBandSelected(dataType, null, dataValue, false);
    }

    private void testBandMergeOnBandSelected(int dataType, Number noDataValue, Number dataValue, boolean addROI) {
        RenderedOp bandMerged;
        Range[] nodata;
        if (noDataValue == null) {
            nodata = null;
        } else {
            switch (dataType) {
                case 0: {
                    byte noDataPrimitive = noDataValue.byteValue();
                    nodata = new Range[]{RangeFactory.create((byte)noDataPrimitive, (byte)noDataPrimitive)};
                    break;
                }
                case 2: {
                    short noDataPrimitive = noDataValue.shortValue();
                    nodata = new Range[]{RangeFactory.create((short)noDataPrimitive, (short)noDataPrimitive)};
                    break;
                }
                case 1: 
                case 3: {
                    int noDataPrimitive = noDataValue.intValue();
                    nodata = new Range[]{RangeFactory.create((int)noDataPrimitive, (int)noDataPrimitive)};
                    break;
                }
                case 4: {
                    float noDataPrimitive = noDataValue.floatValue();
                    nodata = new Range[]{RangeFactory.create((float)noDataPrimitive, (float)noDataPrimitive)};
                    break;
                }
                case 5: {
                    double noDataPrimitive = noDataValue.doubleValue();
                    nodata = new Range[]{RangeFactory.create((double)noDataPrimitive, (double)noDataPrimitive)};
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        TiledImage image = (TiledImage)BandMergeTest.createTestImage((int)dataType, (int)10, (int)10, (Number)noDataValue, (boolean)false, (int)3, (Number)dataValue);
        for (int i = 0; i < image.getHeight(); ++i) {
            for (int j = 0; j < image.getWidth(); ++j) {
                for (int b = 0; b < image.getNumBands(); ++b) {
                    int value = b == image.getNumBands() - 1 ? 1 : 0;
                    image.setSample(j, i, b, value);
                }
            }
        }
        RenderedOp selected = BandSelectDescriptor.create((RenderedImage)image, (int[])new int[]{2}, null);
        if (addROI) {
            ROIShape roi = new ROIShape((Shape)new Rectangle2D.Double(0.0, 0.0, 100.0, 100.0));
            bandMerged = BandMergeDescriptor.create((Range[])nodata, (double)0.0, (boolean)false, (RenderingHints)null, null, (ROI)roi, (RenderedImage[])new RenderedImage[]{selected, selected});
        } else {
            bandMerged = BandMergeDescriptor.create((Range[])nodata, (double)0.0, (boolean)false, (RenderingHints)null, (RenderedImage[])new RenderedImage[]{selected, selected});
        }
        Raster data = bandMerged.getData();
        for (int i = 0; i < bandMerged.getHeight(); ++i) {
            for (int j = 0; j < bandMerged.getWidth(); ++j) {
                for (int b = 0; b < bandMerged.getNumBands(); ++b) {
                    Assert.assertEquals((long)1L, (long)data.getSample(j, i, b));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultibandMerge() {
        int i;
        int MULTIBAND_BAND_COUNT = 13;
        RenderedImage[] images = new RenderedImage[13];
        for (i = 0; i < images.length; ++i) {
            images[i] = BandMergeTest.createTestImage((int)0, (int)128, (int)128, (Number)50, (boolean)false, (int)1);
        }
        try {
            this.testBandMerge(images, false, false, 13);
            this.testBandMerge(images, true, false, 13);
            this.testBandMerge(images, false, true, 13);
            this.testBandMerge(images, true, true, 13);
            this.testExtendedBandMerge(images, false, false, 13);
            this.testExtendedBandMerge(images, true, false, 13);
            this.testExtendedBandMerge(images, false, true, 13);
            this.testExtendedBandMerge(images, true, true, 13);
        }
        finally {
            for (i = 0; i < images.length; ++i) {
                RenderedImage image = images[i];
                ((TiledImage)image).dispose();
            }
        }
    }

    @Test
    public void testExtendedWithIdentityTransform() {
        this.assertBandMergeImplementation(AffineTransform.getScaleInstance(1.000000000001, 1.000000000001), BandMergeOpImage.class);
        this.assertBandMergeImplementation(AffineTransform.getScaleInstance(1.000001, 1.000001), ExtendedBandMergeOpImage.class);
        this.assertBandMergeImplementation(AffineTransform.getShearInstance(1.0E-12, 1.0E-12), BandMergeOpImage.class);
        this.assertBandMergeImplementation(AffineTransform.getShearInstance(1.0E-6, 1.0E-6), ExtendedBandMergeOpImage.class);
        this.assertBandMergeImplementation(AffineTransform.getTranslateInstance(1.0E-12, 1.0E-12), BandMergeOpImage.class);
        this.assertBandMergeImplementation(AffineTransform.getTranslateInstance(0.6, 0.6), ExtendedBandMergeOpImage.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertBandMergeImplementation(AffineTransform affine, Class opImageClass) {
        RenderedImage[] images = BandMergeTest.images[0];
        ArrayList<AffineTransform> transforms = new ArrayList<AffineTransform>();
        for (int i = 0; i < images.length; ++i) {
            transforms.add(affine);
        }
        RenderedOp merged = BandMergeDescriptor.create(null, (double)0.0, (boolean)false, null, transforms, null, (RenderedImage[])images);
        try {
            Assert.assertTrue((boolean)opImageClass.isInstance(merged.getRendering()));
        }
        finally {
            merged.dispose();
        }
    }
}

