/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.bandmerge;

import com.sun.media.jai.opimage.RIFUtil;
import it.geosolutions.jaiext.bandmerge.BandMergeOpImage;
import it.geosolutions.jaiext.bandmerge.ExtendedBandMergeOpImage;
import it.geosolutions.jaiext.range.Range;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.ArrayList;
import java.util.List;
import javax.media.jai.CRIFImpl;
import javax.media.jai.ImageLayout;
import javax.media.jai.ROI;

public class BandMergeCRIF
extends CRIFImpl {
    private static final double EPS = 1.0E-9;

    public BandMergeCRIF() {
        super("bandmergeOp");
    }

    public RenderedImage create(ParameterBlock paramBlock, RenderingHints renderHints) {
        ImageLayout layout = RIFUtil.getImageLayoutHint((RenderingHints)renderHints);
        int numSources = paramBlock.getNumSources();
        ArrayList<Object> sources = new ArrayList<Object>(numSources);
        for (int i = 0; i < numSources; ++i) {
            sources.add(paramBlock.getSource(i));
        }
        Range[] nodata = (Range[])paramBlock.getObjectParameter(0);
        double destinationNoData = paramBlock.getDoubleParameter(1);
        List transform = (List)paramBlock.getObjectParameter(2);
        ROI roi = (ROI)paramBlock.getObjectParameter(3);
        boolean setAlpha = (Boolean)paramBlock.getObjectParameter(4);
        if (transform != null && !transform.isEmpty() && !this.allIdentities(transform)) {
            return new ExtendedBandMergeOpImage(sources, transform, renderHints, nodata, roi, destinationNoData, setAlpha, layout);
        }
        return new BandMergeOpImage(sources, renderHints, nodata, roi, destinationNoData, setAlpha, layout);
    }

    private boolean allIdentities(List<AffineTransform> transform) {
        for (AffineTransform at : transform) {
            if (this.eqTol(at.getScaleX(), 1.0, 1.0E-9) && this.eqTol(at.getScaleY(), 1.0, 1.0E-9) && this.eqTol(Math.abs(at.getShearX()), 0.0, 1.0E-9) && this.eqTol(Math.abs(at.getShearX()), 0.0, 1.0E-9) && this.eqTol(Math.abs(at.getTranslateX()), 0.0, 0.5) && this.eqTol(Math.abs(at.getTranslateY()), 0.0, 0.5)) continue;
            return false;
        }
        return true;
    }

    private boolean eqTol(double value, double reference, double tolerance) {
        return Math.abs(Math.abs(value) - reference) < tolerance;
    }
}

