/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.bandcombine;

import com.sun.media.jai.util.ImageUtil;
import it.geosolutions.jaiext.bandcombine.BandCombineDescriptor;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.testclasses.TestBase;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class BandCombineTest
extends TestBase {
    private static final double TOLERANCE = 0.1;
    private static RenderedImage[] testImages;
    private static Range noDataByte;
    private static Range noDataUShort;
    private static Range noDataShort;
    private static Range noDataInt;
    private static Range noDataFloat;
    private static Range noDataDouble;
    private static ROI roiObject;
    private static double[][] matrix;
    private static double destNoData;

    @BeforeClass
    public static void initialSetup() {
        byte noDataB = 50;
        short noDataS = 50;
        int noDataI = 50;
        float noDataF = 50.0f;
        double noDataD = 50.0;
        testImages = new RenderedImage[6];
        IMAGE_FILLER = true;
        BandCombineTest.testImages[0] = BandCombineTest.createTestImage((int)0, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataB, (boolean)false, (int)3);
        BandCombineTest.testImages[1] = BandCombineTest.createTestImage((int)1, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataS, (boolean)false, (int)3);
        BandCombineTest.testImages[2] = BandCombineTest.createTestImage((int)2, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataS, (boolean)false, (int)3);
        BandCombineTest.testImages[3] = BandCombineTest.createTestImage((int)3, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataI, (boolean)false, (int)3);
        BandCombineTest.testImages[4] = BandCombineTest.createTestImage((int)4, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)Float.valueOf(noDataF), (boolean)false, (int)3);
        BandCombineTest.testImages[5] = BandCombineTest.createTestImage((int)5, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataD, (boolean)false, (int)3);
        IMAGE_FILLER = false;
        boolean minIncluded = true;
        boolean maxIncluded = true;
        noDataByte = RangeFactory.create((byte)noDataB, (boolean)minIncluded, (byte)noDataB, (boolean)maxIncluded);
        noDataUShort = RangeFactory.createU((short)noDataS, (boolean)minIncluded, (short)noDataS, (boolean)maxIncluded);
        noDataShort = RangeFactory.create((short)noDataS, (boolean)minIncluded, (short)noDataS, (boolean)maxIncluded);
        noDataInt = RangeFactory.create((int)noDataI, (boolean)minIncluded, (int)noDataI, (boolean)maxIncluded);
        noDataFloat = RangeFactory.create((float)noDataF, (boolean)minIncluded, (float)noDataF, (boolean)maxIncluded, (boolean)true);
        noDataDouble = RangeFactory.create((double)noDataD, (boolean)minIncluded, (double)noDataD, (boolean)maxIncluded, (boolean)true);
        Rectangle roiBounds = new Rectangle(5, 5, DEFAULT_WIDTH / 4, DEFAULT_HEIGHT / 4);
        roiObject = new ROIShape((Shape)roiBounds);
        matrix = new double[2][4];
        for (int i = 0; i < matrix[0].length; ++i) {
            BandCombineTest.matrix[0][i] = i - 1;
            BandCombineTest.matrix[1][i] = i + 1;
        }
    }

    @Test
    public void testValidData() {
        boolean roiUsed = false;
        boolean noDataUsed = false;
        for (int i = 0; i < 6; ++i) {
            this.testType(testImages[i], noDataUsed, roiUsed);
        }
    }

    @Test
    public void testRoi() {
        boolean roiUsed = true;
        boolean noDataUsed = false;
        for (int i = 0; i < 6; ++i) {
            this.testType(testImages[i], noDataUsed, roiUsed);
        }
    }

    @Test
    public void testNoData() {
        boolean roiUsed = false;
        boolean noDataUsed = true;
        for (int i = 1; i < 6; ++i) {
            this.testType(testImages[i], noDataUsed, roiUsed);
        }
    }

    @Test
    public void testRoiNoData() {
        boolean roiUsed = true;
        boolean noDataUsed = true;
        for (int i = 0; i < 6; ++i) {
            this.testType(testImages[i], noDataUsed, roiUsed);
        }
    }

    private void testType(RenderedImage src, boolean nodataUsed, boolean roiUsed) {
        Range noData;
        int dataType;
        block31: {
            block30: {
                dataType = src.getSampleModel().getDataType();
                if (!nodataUsed) break block30;
                switch (dataType) {
                    case 0: {
                        noData = noDataByte;
                        break block31;
                    }
                    case 1: {
                        noData = noDataUShort;
                        break block31;
                    }
                    case 2: {
                        noData = noDataShort;
                        break block31;
                    }
                    case 3: {
                        noData = noDataInt;
                        break block31;
                    }
                    case 4: {
                        noData = noDataFloat;
                        break block31;
                    }
                    case 5: {
                        noData = noDataDouble;
                        break block31;
                    }
                    default: {
                        throw new IllegalArgumentException("Wrong data type");
                    }
                }
            }
            noData = null;
        }
        Object roi = roiUsed ? roiObject : null;
        RenderedOp combined = BandCombineDescriptor.create((RenderedImage)src, (double[][])matrix, (ROI)roi, (Range)noData, (double)this.destinationNoData, null);
        int tileWidth = combined.getTileWidth();
        int tileHeight = combined.getTileHeight();
        int minTileX = combined.getMinTileX();
        int minTileY = combined.getMinTileY();
        int numXTiles = combined.getNumXTiles();
        int numYTiles = combined.getNumYTiles();
        int maxTileX = minTileX + numXTiles;
        int maxTileY = minTileY + numYTiles;
        Assert.assertEquals((long)combined.getWidth(), (long)src.getWidth());
        Assert.assertEquals((long)combined.getHeight(), (long)src.getHeight());
        Assert.assertEquals((long)combined.getMinX(), (long)src.getMinX());
        Assert.assertEquals((long)combined.getMinY(), (long)src.getMinY());
        Assert.assertEquals((long)minTileX, (long)src.getMinTileX());
        Assert.assertEquals((long)minTileY, (long)src.getMinTileY());
        Assert.assertEquals((long)numXTiles, (long)src.getNumXTiles());
        Assert.assertEquals((long)numYTiles, (long)src.getNumYTiles());
        Assert.assertEquals((long)tileWidth, (long)src.getTileWidth());
        Assert.assertEquals((long)tileHeight, (long)src.getTileHeight());
        int srcBands = src.getSampleModel().getNumBands();
        int dstBands = combined.getNumBands();
        Assert.assertEquals((long)dstBands, (long)matrix.length);
        for (int tileX = minTileX; tileX < maxTileX; ++tileX) {
            for (int tileY = minTileY; tileY < maxTileY; ++tileY) {
                Raster tile = combined.getTile(tileX, tileY);
                Raster srcTile = src.getTile(tileX, tileY);
                int minX = tile.getMinX();
                int minY = tile.getMinY();
                int maxX = minX + tileWidth - 1;
                int maxY = minY + tileHeight - 1;
                for (int x = minX; x <= maxX; ++x) {
                    for (int y = minY; y <= maxY; ++y) {
                        int b;
                        boolean isValidRoi;
                        boolean bl = isValidRoi = !roiUsed || roiUsed && roiObject.contains(x, y);
                        if (isValidRoi) {
                            for (b = 0; b < dstBands; ++b) {
                                double result = tile.getSampleDouble(x, y, b);
                                boolean valid = false;
                                double calculated = 0.0;
                                block26: for (int i = 0; i < srcBands; ++i) {
                                    double sample = srcTile.getSampleDouble(x, y, i);
                                    boolean isValidData = !nodataUsed || nodataUsed && !noDataDouble.contains(sample);
                                    valid |= isValidData;
                                    if (!isValidData) continue;
                                    switch (dataType) {
                                        case 0: {
                                            calculated += (double)((int)sample & 0xFF) * matrix[b][i];
                                            continue block26;
                                        }
                                        case 1: {
                                            calculated += (double)((int)sample & 0xFFFF) * matrix[b][i];
                                            continue block26;
                                        }
                                        case 2: 
                                        case 3: 
                                        case 4: 
                                        case 5: {
                                            calculated += sample * matrix[b][i];
                                            continue block26;
                                        }
                                    }
                                }
                                if (valid) {
                                    calculated += matrix[b][srcBands];
                                    switch (dataType) {
                                        case 0: {
                                            calculated = ImageUtil.clampRoundByte((double)calculated);
                                            result = ImageUtil.clampRoundByte((double)result);
                                            break;
                                        }
                                        case 1: {
                                            calculated = ImageUtil.clampRoundUShort((double)calculated);
                                            result = ImageUtil.clampRoundUShort((double)result);
                                            break;
                                        }
                                        case 2: {
                                            calculated = ImageUtil.clampRoundShort((double)calculated);
                                            result = ImageUtil.clampRoundShort((double)result);
                                            break;
                                        }
                                        case 3: {
                                            calculated = ImageUtil.clampRoundInt((double)calculated);
                                            result = ImageUtil.clampRoundInt((double)result);
                                            break;
                                        }
                                        case 4: {
                                            calculated = (float)calculated;
                                            calculated = (float)result;
                                            break;
                                        }
                                        case 5: {
                                            break;
                                        }
                                    }
                                    Assert.assertEquals((double)result, (double)calculated, (double)0.1);
                                    continue;
                                }
                                Assert.assertEquals((double)result, (double)destNoData, (double)0.1);
                            }
                            continue;
                        }
                        for (b = 0; b < dstBands; ++b) {
                            Assert.assertEquals((double)tile.getSampleDouble(x, y, b), (double)destNoData, (double)0.1);
                        }
                    }
                }
            }
        }
        combined.dispose();
    }
}

