/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.artifacts;

import it.geosolutions.jaiext.artifacts.ArtifactsFilterDescriptor;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.stats.Statistics;
import it.geosolutions.jaiext.stats.StatisticsDescriptor;
import it.geosolutions.jaiext.testclasses.TestBase;
import it.geosolutions.jaiext.testclasses.TestData;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.RenderedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.media.jai.JAI;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.FormatDescriptor;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ArtifactsFilterTest
extends TestBase {
    private static RenderedOp image;
    private static Range[] nodata;

    @BeforeClass
    public static void setupData() throws FileNotFoundException, IOException {
        image = JAI.create((String)"ImageRead", (Object)TestData.file(ArtifactsFilterTest.class, (String)"filter.tif"));
        nodata = new Range[6];
        ArtifactsFilterTest.nodata[0] = RangeFactory.create((byte)-56, (byte)-56);
        ArtifactsFilterTest.nodata[1] = RangeFactory.createU((short)200, (short)200);
        ArtifactsFilterTest.nodata[2] = RangeFactory.create((short)200, (short)200);
        ArtifactsFilterTest.nodata[3] = RangeFactory.create((int)200, (int)200);
        ArtifactsFilterTest.nodata[4] = RangeFactory.create((float)200.0f, (float)200.0f);
        ArtifactsFilterTest.nodata[5] = RangeFactory.create((double)200.0, (double)200.0);
    }

    @Test
    public void testValidData() {
        for (int i = 0; i < 6; ++i) {
            if (i == 2) continue;
            this.testArtifact(i, (RenderedImage)image, null);
        }
    }

    @Test
    public void testNoData() {
        for (int i = 0; i < 6; ++i) {
            if (i == 2) continue;
            this.testArtifact(i, (RenderedImage)image, nodata[i]);
        }
    }

    private void testArtifact(int dataType, RenderedImage image, Range nodata) {
        image.getWidth();
        image = FormatDescriptor.create((RenderedImage)image, (Integer)dataType, null);
        Statistics.StatsType[] stats = new Statistics.StatsType[]{Statistics.StatsType.HISTOGRAM};
        RenderedOp histogramOp = StatisticsDescriptor.create((RenderedImage)image, (int)1, (int)1, null, null, (boolean)false, (int[])new int[]{0, 1, 2}, (Statistics.StatsType[])stats, (double[])new double[]{0.0}, (double[])new double[]{256.0}, (int[])new int[]{256}, null);
        int[][] bins = new int[3][256];
        Statistics[][] results = (Statistics[][])histogramOp.getProperty("JAI-EXT.stats");
        for (int i = 0; i < 3; ++i) {
            double[] res = (double[])results[i][0].getResult();
            for (int k = 0; k < 256; ++k) {
                bins[i][k] = (int)res[k];
            }
        }
        Assert.assertEquals((long)bins[0][0], (long)4261L);
        Assert.assertEquals((long)bins[1][0], (long)4261L);
        Assert.assertEquals((long)bins[2][0], (long)4832L);
        Assert.assertEquals((long)bins[0][20], (long)127L);
        Assert.assertEquals((long)bins[1][20], (long)127L);
        Assert.assertEquals((long)bins[2][20], (long)127L);
        Assert.assertEquals((long)bins[0][180], (long)571L);
        Assert.assertEquals((long)bins[0][200], (long)5041L);
        Assert.assertEquals((long)bins[2][200], (long)5041L);
        Assert.assertEquals((long)bins[1][255], (long)5612L);
        Assert.assertEquals((long)(bins[0][0] + bins[1][0] + bins[2][0] + bins[0][20] + bins[1][20] + bins[2][20] + bins[0][180] + bins[0][200] + bins[2][200] + bins[1][255]), (long)30000L);
        ROIShape roi = new ROIShape((Shape)new Rectangle(14, 11, 75, 75));
        double[] backgroundValues = new double[]{0.0, 0.0, 0.0};
        RenderedImage filtered = ArtifactsFilterDescriptor.create((RenderedImage)image, (ROI)roi, (double[])backgroundValues, (int)30, (int)3, (Range)nodata, null);
        histogramOp = StatisticsDescriptor.create((RenderedImage)filtered, (int)1, (int)1, null, null, (boolean)false, (int[])new int[]{0, 1, 2}, (Statistics.StatsType[])stats, (double[])new double[]{0.0}, (double[])new double[]{256.0}, (int[])new int[]{256}, null);
        bins = new int[3][256];
        results = (Statistics[][])histogramOp.getProperty("JAI-EXT.stats");
        for (int i = 0; i < 3; ++i) {
            double[] res = (double[])results[i][0].getResult();
            for (int k = 0; k < 256; ++k) {
                bins[i][k] = (int)res[k];
            }
        }
        if (nodata != null) {
            Assert.assertEquals((long)bins[0][0], (long)(dataType < 2 ? 9302L : 4261L));
            Assert.assertEquals((long)bins[1][0], (long)4261L);
            Assert.assertEquals((long)bins[2][0], (long)(dataType < 2 ? 9886L : 4845L));
            Assert.assertEquals((long)bins[0][180], (long)584L);
            Assert.assertEquals((long)bins[0][200], (long)0L);
            Assert.assertEquals((long)bins[2][200], (long)0L);
            Assert.assertEquals((long)bins[1][255], (long)5625L);
        } else {
            Assert.assertEquals((long)bins[0][0], (long)4261L);
            Assert.assertEquals((long)bins[1][0], (long)4261L);
            Assert.assertEquals((long)bins[2][0], (long)4845L);
            Assert.assertEquals((long)bins[0][180], (long)584L);
            Assert.assertEquals((long)bins[0][200], (long)5041L);
            Assert.assertEquals((long)bins[2][200], (long)5041L);
            Assert.assertEquals((long)bins[1][255], (long)5625L);
            Assert.assertEquals((long)(bins[0][0] + bins[1][0] + bins[2][0] + bins[0][20] + bins[1][20] + bins[2][20] + bins[0][180] + bins[0][200] + bins[2][200] + bins[1][255]), (long)30000L);
        }
    }
}

