/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.algebra;

import com.sun.media.jai.util.ImageUtil;
import it.geosolutions.jaiext.algebra.AlgebraDescriptor;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.testclasses.TestBase;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class AlgebraTest
extends TestBase {
    private static final int NUM_IMAGES = 3;
    private static final int NUM_TYPES = 6;
    private static final int DEFAULT_WIDTH_REDUCED = DEFAULT_WIDTH / 2;
    private static final int DEFAULT_HEIGHT_REDUCED = DEFAULT_HEIGHT / 2;
    private static final double TOLERANCE = 0.1;
    private static RenderedImage[][] testImages;
    private static Range noDataByte;
    private static Range noDataUShort;
    private static Range noDataShort;
    private static Range noDataInt;
    private static Range noDataFloat;
    private static Range noDataDouble;
    private static int destNoData;
    private static ROI roiObject;

    @BeforeClass
    public static void initialSetup() {
        byte noDataB = 50;
        short noDataS = 50;
        int noDataI = 50;
        float noDataF = 50.0f;
        double noDataD = 50.0;
        testImages = new RenderedImage[6][3];
        IMAGE_FILLER = true;
        for (int j = 0; j < 3; ++j) {
            AlgebraTest.testImages[0][j] = AlgebraTest.createTestImage((int)0, (int)DEFAULT_WIDTH_REDUCED, (int)DEFAULT_HEIGHT_REDUCED, (Number)noDataB, (boolean)false, (int)(j == 0 ? 1 : 3), (Number)(64 + j));
            AlgebraTest.testImages[1][j] = AlgebraTest.createTestImage((int)1, (int)DEFAULT_WIDTH_REDUCED, (int)DEFAULT_HEIGHT_REDUCED, (Number)noDataS, (boolean)false, (int)(j == 0 ? 1 : 3), (Number)(8191 + j));
            AlgebraTest.testImages[2][j] = AlgebraTest.createTestImage((int)2, (int)DEFAULT_WIDTH_REDUCED, (int)DEFAULT_HEIGHT_REDUCED, (Number)noDataS, (boolean)false, (int)(j == 0 ? 1 : 3), (Number)(-50 + j));
            AlgebraTest.testImages[3][j] = AlgebraTest.createTestImage((int)3, (int)DEFAULT_WIDTH_REDUCED, (int)DEFAULT_HEIGHT_REDUCED, (Number)noDataI, (boolean)false, (int)(j == 0 ? 1 : 3), (Number)(100 + j));
            AlgebraTest.testImages[4][j] = AlgebraTest.createTestImage((int)4, (int)DEFAULT_WIDTH_REDUCED, (int)DEFAULT_HEIGHT_REDUCED, (Number)Float.valueOf(noDataF), (boolean)false, (int)(j == 0 ? 1 : 3), (Number)(635 + j));
            AlgebraTest.testImages[5][j] = AlgebraTest.createTestImage((int)5, (int)DEFAULT_WIDTH_REDUCED, (int)DEFAULT_HEIGHT_REDUCED, (Number)noDataD, (boolean)false, (int)(j == 0 ? 1 : 3), (Number)(1020 + j));
        }
        IMAGE_FILLER = false;
        boolean minIncluded = true;
        boolean maxIncluded = true;
        noDataByte = RangeFactory.create((byte)noDataB, (boolean)minIncluded, (byte)noDataB, (boolean)maxIncluded);
        noDataUShort = RangeFactory.createU((short)noDataS, (boolean)minIncluded, (short)noDataS, (boolean)maxIncluded);
        noDataShort = RangeFactory.create((short)noDataS, (boolean)minIncluded, (short)noDataS, (boolean)maxIncluded);
        noDataInt = RangeFactory.create((int)noDataI, (boolean)minIncluded, (int)noDataI, (boolean)maxIncluded);
        noDataFloat = RangeFactory.create((float)noDataF, (boolean)minIncluded, (float)noDataF, (boolean)maxIncluded, (boolean)true);
        noDataDouble = RangeFactory.create((double)noDataD, (boolean)minIncluded, (double)noDataD, (boolean)maxIncluded, (boolean)true);
        destNoData = 100;
        Rectangle roiBounds = new Rectangle(5, 5, DEFAULT_WIDTH_REDUCED / 4, DEFAULT_HEIGHT_REDUCED / 4);
        roiObject = new ROIShape((Shape)roiBounds);
    }

    @Test
    public void testNoROINoNoData() {
        boolean roiUsed = false;
        boolean noDataUsed = false;
        for (int i = 0; i < 6; ++i) {
            this.runTests(i, noDataUsed, roiUsed);
        }
    }

    @Test
    public void testOnlyNoData() {
        boolean roiUsed = false;
        boolean noDataUsed = true;
        for (int i = 0; i < 6; ++i) {
            this.runTests(i, noDataUsed, roiUsed);
        }
    }

    @Test
    public void testOnlyROI() {
        boolean roiUsed = true;
        boolean noDataUsed = false;
        for (int i = 0; i < 6; ++i) {
            this.runTests(i, noDataUsed, roiUsed);
        }
    }

    @Test
    public void testROIAndNoData() {
        boolean roiUsed = true;
        boolean noDataUsed = true;
        for (int i = 0; i < 6; ++i) {
            this.runTests(i, noDataUsed, roiUsed);
        }
    }

    private void runTests(int dataType, boolean noDataUsed, boolean roiUsed) {
        this.testOperation(testImages[dataType], AlgebraDescriptor.Operator.SUM, noDataUsed, roiUsed);
        this.testOperation(testImages[dataType], AlgebraDescriptor.Operator.SUBTRACT, noDataUsed, roiUsed);
        this.testOperation(testImages[dataType], AlgebraDescriptor.Operator.MULTIPLY, noDataUsed, roiUsed);
        this.testOperation(testImages[dataType], AlgebraDescriptor.Operator.DIVIDE, noDataUsed, roiUsed);
        this.testOperation(testImages[dataType], AlgebraDescriptor.Operator.LOG, noDataUsed, roiUsed);
        this.testOperation(testImages[dataType], AlgebraDescriptor.Operator.EXP, noDataUsed, roiUsed);
        if (dataType != 4 && dataType != 5) {
            this.testOperation(testImages[dataType], AlgebraDescriptor.Operator.ABSOLUTE, noDataUsed, roiUsed);
            this.testOperation(testImages[dataType], AlgebraDescriptor.Operator.AND, noDataUsed, roiUsed);
            this.testOperation(testImages[dataType], AlgebraDescriptor.Operator.OR, noDataUsed, roiUsed);
            this.testOperation(testImages[dataType], AlgebraDescriptor.Operator.XOR, noDataUsed, roiUsed);
            this.testOperation(testImages[dataType], AlgebraDescriptor.Operator.INVERT, noDataUsed, roiUsed);
            this.testOperation(testImages[dataType], AlgebraDescriptor.Operator.NOT, noDataUsed, roiUsed);
        }
    }

    private void testOperation(RenderedImage[] sources, AlgebraDescriptor.Operator op, boolean noDataUsed, boolean roiUsed) {
        Range noData;
        block18: {
            block17: {
                int dataType = sources[0].getSampleModel().getDataType();
                if (!noDataUsed) break block17;
                switch (dataType) {
                    case 0: {
                        noData = noDataByte;
                        break block18;
                    }
                    case 1: {
                        noData = noDataUShort;
                        break block18;
                    }
                    case 2: {
                        noData = noDataShort;
                        break block18;
                    }
                    case 3: {
                        noData = noDataInt;
                        break block18;
                    }
                    case 4: {
                        noData = noDataFloat;
                        break block18;
                    }
                    case 5: {
                        noData = noDataDouble;
                        break block18;
                    }
                    default: {
                        throw new IllegalArgumentException("Wrong data type");
                    }
                }
            }
            noData = null;
        }
        Object roi = roiUsed ? roiObject : null;
        int minBandNumber = Integer.MAX_VALUE;
        for (int i = 0; i < 3; ++i) {
            int numBandImage = sources[i].getSampleModel().getNumBands();
            if (numBandImage >= minBandNumber) continue;
            minBandNumber = numBandImage;
        }
        RenderedOp calculated = AlgebraDescriptor.create((AlgebraDescriptor.Operator)op, (ROI)roi, (Range)noData, (double)destNoData, null, (RenderedImage[])sources);
        Assert.assertEquals((long)minBandNumber, (long)calculated.getNumBands());
        switch (op) {
            case SUM: {
                this.testSum(calculated, sources, (ROI)roi, noData, minBandNumber);
                break;
            }
            case SUBTRACT: {
                this.testSubtract(calculated, sources, (ROI)roi, noData, minBandNumber);
                break;
            }
            case MULTIPLY: {
                this.testMultiply(calculated, sources, (ROI)roi, noData, minBandNumber);
                break;
            }
            case DIVIDE: {
                this.testDivide(calculated, sources, (ROI)roi, noData, minBandNumber);
                break;
            }
            case AND: 
            case OR: 
            case XOR: {
                this.testLogicalOp(calculated, sources, (ROI)roi, noData, minBandNumber, op);
                break;
            }
            case EXP: 
            case NOT: 
            case INVERT: 
            case ABSOLUTE: 
            case LOG: {
                this.testSingleImageOp(calculated, sources, (ROI)roi, noData, minBandNumber, op);
            }
        }
        calculated.dispose();
    }

    private void testLogicalOp(RenderedOp calculated, RenderedImage[] sources, ROI roi, Range noData, int minBandNumber, AlgebraDescriptor.Operator op) {
        boolean roiUsed = roi != null;
        boolean noDataUsed = noData != null;
        int minTileX = calculated.getMinTileX();
        int minTileY = calculated.getMinTileY();
        Raster upperLeftTile = calculated.getTile(minTileX, minTileY);
        int minX = upperLeftTile.getMinX();
        int minY = upperLeftTile.getMinY();
        int maxX = upperLeftTile.getWidth() + minX;
        int maxY = upperLeftTile.getHeight() + minY;
        int numSrc = sources.length;
        Raster[] sourceRasters = new Raster[numSrc];
        for (int i = 0; i < numSrc; ++i) {
            sourceRasters[i] = sources[i].getTile(minTileX, minTileY);
        }
        double valueOld = 0.0;
        double value = 0.0;
        double sample = 0.0;
        boolean isValidData = false;
        int dataType = calculated.getSampleModel().getDataType();
        for (int b = 0; b < minBandNumber; ++b) {
            for (int x = minX; x < maxX; ++x) {
                for (int y = minY; y < maxY; ++y) {
                    boolean isValidROI;
                    value = upperLeftTile.getSampleDouble(x, y, b);
                    valueOld = 0.0;
                    isValidData = false;
                    boolean bl = isValidROI = !roiUsed || roiUsed && roi.contains(x, y);
                    if (isValidROI) {
                        switch (dataType) {
                            case 0: {
                                byte valueB = 0;
                                for (int i = 0; i < numSrc; ++i) {
                                    sample = sourceRasters[i].getSampleDouble(x, y, b);
                                    if (noDataUsed && (!noDataUsed || noDataDouble.contains(sample))) continue;
                                    isValidData = true;
                                    valueB = i == 0 ? (byte)sample : op.calculate(new byte[]{valueB, (byte)sample});
                                }
                                valueOld = valueB;
                                value = (byte)(((int)value << 23 >> 31 | (int)value) & 0xFF);
                                break;
                            }
                            case 1: {
                                short valueU = 0;
                                for (int i = 0; i < numSrc; ++i) {
                                    sample = sourceRasters[i].getSampleDouble(x, y, b);
                                    if (noDataUsed && (!noDataUsed || noDataDouble.contains(sample))) continue;
                                    isValidData = true;
                                    valueU = i == 0 ? (short)sample : op.calculate(true, new short[]{valueU, (short)sample});
                                }
                                valueOld = valueU;
                                break;
                            }
                            case 2: {
                                short valueS = 0;
                                for (int i = 0; i < numSrc; ++i) {
                                    sample = sourceRasters[i].getSampleDouble(x, y, b);
                                    if (noDataUsed && (!noDataUsed || noDataDouble.contains(sample))) continue;
                                    isValidData = true;
                                    valueS = i == 0 ? (short)sample : op.calculate(false, new short[]{valueS, (short)sample});
                                }
                                valueOld = valueS;
                                break;
                            }
                            case 3: {
                                int valueI = 0;
                                for (int i = 0; i < numSrc; ++i) {
                                    sample = sourceRasters[i].getSampleDouble(x, y, b);
                                    if (noDataUsed && (!noDataUsed || noDataDouble.contains(sample))) continue;
                                    isValidData = true;
                                    valueI = i == 0 ? (int)sample : op.calculate(new int[]{valueI, (int)sample});
                                }
                                valueOld = valueI;
                                break;
                            }
                        }
                        if (!isValidData) {
                            Assert.assertEquals((double)value, (double)destNoData, (double)0.1);
                            continue;
                        }
                        Assert.assertEquals((double)value, (double)valueOld, (double)0.1);
                        continue;
                    }
                    Assert.assertEquals((double)value, (double)destNoData, (double)0.1);
                }
            }
        }
    }

    private void testSingleImageOp(RenderedOp calculated, RenderedImage[] sources, ROI roi, Range noData, int minBandNumber, AlgebraDescriptor.Operator op) {
        boolean roiUsed = roi != null;
        boolean noDataUsed = noData != null;
        int minTileX = calculated.getMinTileX();
        int minTileY = calculated.getMinTileY();
        Raster upperLeftTile = calculated.getTile(minTileX, minTileY);
        int minX = upperLeftTile.getMinX();
        int minY = upperLeftTile.getMinY();
        int maxX = upperLeftTile.getWidth() + minX;
        int maxY = upperLeftTile.getHeight() + minY;
        Raster sourceRasters = sources[0].getTile(minTileX, minTileY);
        double valueOld = 0.0;
        double value = 0.0;
        double sample = 0.0;
        boolean isValidData = false;
        int dataType = calculated.getSampleModel().getDataType();
        for (int b = 0; b < minBandNumber; ++b) {
            for (int x = minX; x < maxX; ++x) {
                for (int y = minY; y < maxY; ++y) {
                    value = upperLeftTile.getSampleDouble(x, y, b);
                    valueOld = 0.0;
                    sample = sourceRasters.getSampleDouble(x, y, b);
                    boolean bl = isValidData = (!roiUsed || roiUsed && roi.contains(x, y)) && (!noDataUsed || noDataUsed && !noDataDouble.contains(sample));
                    if (isValidData) {
                        switch (dataType) {
                            case 0: {
                                valueOld = op.calculate(new byte[]{(byte)sample});
                                value = (byte)(((int)value << 23 >> 31 | (int)value) & 0xFF);
                                break;
                            }
                            case 1: {
                                valueOld = op.calculate(true, new short[]{(short)sample}) & 0xFFFF;
                                break;
                            }
                            case 2: {
                                valueOld = op.calculate(false, new short[]{(short)sample});
                                valueOld = ImageUtil.clampRoundShort((double)valueOld);
                                break;
                            }
                            case 3: {
                                valueOld = op.calculate(new int[]{(int)sample});
                                valueOld = ImageUtil.clampRoundInt((double)valueOld);
                                break;
                            }
                            case 4: {
                                valueOld = op.calculate(new float[]{(float)sample});
                                break;
                            }
                            case 5: {
                                valueOld = op.calculate(new double[]{sample});
                                break;
                            }
                        }
                        Assert.assertEquals((double)value, (double)valueOld, (double)0.1);
                        continue;
                    }
                    Assert.assertEquals((double)value, (double)destNoData, (double)0.1);
                }
            }
        }
    }

    private void testSum(RenderedOp calculated, RenderedImage[] sources, ROI roi, Range noData, int minBandNumber) {
        boolean roiUsed = roi != null;
        boolean noDataUsed = noData != null;
        int minTileX = calculated.getMinTileX();
        int minTileY = calculated.getMinTileY();
        Raster upperLeftTile = calculated.getTile(minTileX, minTileY);
        int minX = upperLeftTile.getMinX();
        int minY = upperLeftTile.getMinY();
        int maxX = upperLeftTile.getWidth() + minX;
        int maxY = upperLeftTile.getHeight() + minY;
        int numSrc = sources.length;
        Raster[] sourceRasters = new Raster[numSrc];
        for (int i = 0; i < numSrc; ++i) {
            sourceRasters[i] = sources[i].getTile(minTileX, minTileY);
        }
        double valueOld = 0.0;
        double value = 0.0;
        double sample = 0.0;
        boolean isValidData = false;
        int dataType = calculated.getSampleModel().getDataType();
        for (int b = 0; b < minBandNumber; ++b) {
            for (int x = minX; x < maxX; ++x) {
                for (int y = minY; y < maxY; ++y) {
                    int i;
                    value = upperLeftTile.getSampleDouble(x, y, b);
                    valueOld = 0.0;
                    isValidData = false;
                    if (noDataUsed && roiUsed) {
                        if (roi.contains(x, y)) {
                            for (i = 0; i < numSrc; ++i) {
                                sample = sourceRasters[i].getSampleDouble(x, y, b);
                                if (noDataDouble.contains(sample)) continue;
                                valueOld += sample;
                                isValidData = true;
                            }
                            if (isValidData) {
                                switch (dataType) {
                                    case 0: {
                                        valueOld = (byte)(((int)valueOld << 23 >> 31 | (int)valueOld) & 0xFF);
                                        value = (byte)(((int)value << 23 >> 31 | (int)value) & 0xFF);
                                        break;
                                    }
                                    case 1: {
                                        valueOld = ImageUtil.clampRoundUShort((double)valueOld) & 0xFFFF;
                                        break;
                                    }
                                    case 2: {
                                        valueOld = ImageUtil.clampRoundShort((double)valueOld);
                                        break;
                                    }
                                    case 3: {
                                        valueOld = ImageUtil.clampRoundInt((double)valueOld);
                                        break;
                                    }
                                    case 4: {
                                        valueOld = (float)valueOld;
                                        break;
                                    }
                                }
                                Assert.assertEquals((double)value, (double)valueOld, (double)0.1);
                                continue;
                            }
                            Assert.assertEquals((double)value, (double)destNoData, (double)0.1);
                            continue;
                        }
                        Assert.assertEquals((double)value, (double)destNoData, (double)0.1);
                        continue;
                    }
                    if (noDataUsed) {
                        for (i = 0; i < numSrc; ++i) {
                            sample = sourceRasters[i].getSampleDouble(x, y, b);
                            if (noDataDouble.contains(sample)) continue;
                            valueOld += sample;
                            isValidData = true;
                        }
                        if (isValidData) {
                            switch (dataType) {
                                case 0: {
                                    valueOld = (byte)(((int)valueOld << 23 >> 31 | (int)valueOld) & 0xFF);
                                    value = (byte)(((int)value << 23 >> 31 | (int)value) & 0xFF);
                                    break;
                                }
                                case 1: {
                                    valueOld = ImageUtil.clampRoundUShort((double)valueOld) & 0xFFFF;
                                    break;
                                }
                                case 2: {
                                    valueOld = ImageUtil.clampRoundShort((double)valueOld);
                                    break;
                                }
                                case 3: {
                                    valueOld = ImageUtil.clampRoundInt((double)valueOld);
                                    break;
                                }
                                case 4: {
                                    valueOld = (float)valueOld;
                                    break;
                                }
                            }
                            Assert.assertEquals((double)value, (double)valueOld, (double)0.1);
                            continue;
                        }
                        Assert.assertEquals((double)value, (double)destNoData, (double)0.1);
                        continue;
                    }
                    if (roiUsed) {
                        if (roi.contains(x, y)) {
                            for (i = 0; i < numSrc; ++i) {
                                valueOld += sourceRasters[i].getSampleDouble(x, y, b);
                            }
                            switch (dataType) {
                                case 0: {
                                    valueOld = (byte)(((int)valueOld << 23 >> 31 | (int)valueOld) & 0xFF);
                                    value = (byte)(((int)value << 23 >> 31 | (int)value) & 0xFF);
                                    break;
                                }
                                case 1: {
                                    valueOld = ImageUtil.clampRoundUShort((double)valueOld) & 0xFFFF;
                                    break;
                                }
                                case 2: {
                                    valueOld = ImageUtil.clampRoundShort((double)valueOld);
                                    break;
                                }
                                case 3: {
                                    valueOld = ImageUtil.clampRoundInt((double)valueOld);
                                    break;
                                }
                                case 4: {
                                    valueOld = (float)valueOld;
                                    break;
                                }
                            }
                            Assert.assertEquals((double)value, (double)valueOld, (double)0.1);
                            continue;
                        }
                        Assert.assertEquals((double)value, (double)destNoData, (double)0.1);
                        continue;
                    }
                    for (i = 0; i < numSrc; ++i) {
                        valueOld += sourceRasters[i].getSampleDouble(x, y, b);
                    }
                    switch (dataType) {
                        case 0: {
                            valueOld = (byte)(((int)valueOld << 23 >> 31 | (int)valueOld) & 0xFF);
                            value = (byte)(((int)value << 23 >> 31 | (int)value) & 0xFF);
                            break;
                        }
                        case 1: {
                            valueOld = ImageUtil.clampRoundUShort((double)valueOld) & 0xFFFF;
                            break;
                        }
                        case 2: {
                            valueOld = ImageUtil.clampRoundShort((double)valueOld);
                            break;
                        }
                        case 3: {
                            valueOld = ImageUtil.clampRoundInt((double)valueOld);
                            break;
                        }
                        case 4: {
                            valueOld = (float)valueOld;
                            break;
                        }
                    }
                    Assert.assertEquals((double)value, (double)valueOld, (double)0.1);
                }
            }
        }
    }

    private void testSubtract(RenderedOp calculated, RenderedImage[] sources, ROI roi, Range noData, int minBandNumber) {
        boolean roiUsed = roi != null;
        boolean noDataUsed = noData != null;
        int minTileX = calculated.getMinTileX();
        int minTileY = calculated.getMinTileY();
        Raster upperLeftTile = calculated.getTile(minTileX, minTileY);
        int minX = upperLeftTile.getMinX();
        int minY = upperLeftTile.getMinY();
        int maxX = upperLeftTile.getWidth() + minX;
        int maxY = upperLeftTile.getHeight() + minY;
        int numSrc = sources.length;
        Raster[] sourceRasters = new Raster[numSrc];
        for (int i = 0; i < numSrc; ++i) {
            sourceRasters[i] = sources[i].getTile(minTileX, minTileY);
        }
        double valueOld = 0.0;
        double value = 0.0;
        double sample = 0.0;
        boolean isValidData = false;
        int dataType = calculated.getSampleModel().getDataType();
        for (int b = 0; b < minBandNumber; ++b) {
            for (int x = minX; x < maxX; ++x) {
                for (int y = minY; y < maxY; ++y) {
                    int i;
                    value = upperLeftTile.getSampleDouble(x, y, b);
                    valueOld = 0.0;
                    isValidData = false;
                    if (noDataUsed && roiUsed) {
                        if (roi.contains(x, y)) {
                            sample = sourceRasters[0].getSampleDouble(x, y, b);
                            if (!noDataDouble.contains(sample)) {
                                valueOld = sample;
                                isValidData = true;
                            }
                            for (i = 1; i < numSrc; ++i) {
                                sample = sourceRasters[i].getSampleDouble(x, y, b);
                                if (noDataDouble.contains(sample)) continue;
                                valueOld -= sample;
                                isValidData = true;
                            }
                            if (isValidData) {
                                switch (dataType) {
                                    case 0: {
                                        valueOld = (byte)(((int)valueOld << 23 >> 31 | (int)valueOld) & 0xFF);
                                        value = (byte)(((int)value << 23 >> 31 | (int)value) & 0xFF);
                                        break;
                                    }
                                    case 1: {
                                        valueOld = ImageUtil.clampRoundUShort((double)valueOld) & 0xFFFF;
                                        break;
                                    }
                                    case 2: {
                                        valueOld = ImageUtil.clampRoundShort((double)valueOld);
                                        break;
                                    }
                                    case 3: {
                                        valueOld = ImageUtil.clampRoundInt((double)valueOld);
                                        break;
                                    }
                                    case 4: {
                                        valueOld = (float)valueOld;
                                        break;
                                    }
                                }
                                Assert.assertEquals((double)value, (double)valueOld, (double)0.1);
                                continue;
                            }
                            Assert.assertEquals((double)value, (double)destNoData, (double)0.1);
                            continue;
                        }
                        Assert.assertEquals((double)value, (double)destNoData, (double)0.1);
                        continue;
                    }
                    if (noDataUsed) {
                        sample = sourceRasters[0].getSampleDouble(x, y, b);
                        if (!noDataDouble.contains(sample)) {
                            valueOld = sample;
                            isValidData = true;
                        }
                        for (i = 1; i < numSrc; ++i) {
                            sample = sourceRasters[i].getSampleDouble(x, y, b);
                            if (noDataDouble.contains(sample)) continue;
                            valueOld -= sample;
                            isValidData = true;
                        }
                        if (isValidData) {
                            switch (dataType) {
                                case 0: {
                                    valueOld = (byte)(((int)valueOld << 23 >> 31 | (int)valueOld) & 0xFF);
                                    value = (byte)(((int)value << 23 >> 31 | (int)value) & 0xFF);
                                    break;
                                }
                                case 1: {
                                    valueOld = ImageUtil.clampRoundUShort((double)valueOld) & 0xFFFF;
                                    break;
                                }
                                case 2: {
                                    valueOld = ImageUtil.clampRoundShort((double)valueOld);
                                    break;
                                }
                                case 3: {
                                    valueOld = ImageUtil.clampRoundInt((double)valueOld);
                                    break;
                                }
                                case 4: {
                                    valueOld = (float)valueOld;
                                    break;
                                }
                            }
                            Assert.assertEquals((double)value, (double)valueOld, (double)0.1);
                            continue;
                        }
                        Assert.assertEquals((double)value, (double)destNoData, (double)0.1);
                        continue;
                    }
                    if (roiUsed) {
                        if (roi.contains(x, y)) {
                            valueOld = sourceRasters[0].getSampleDouble(x, y, b);
                            for (i = 1; i < numSrc; ++i) {
                                valueOld -= sourceRasters[i].getSampleDouble(x, y, b);
                            }
                            switch (dataType) {
                                case 0: {
                                    valueOld = (byte)(((int)valueOld << 23 >> 31 | (int)valueOld) & 0xFF);
                                    value = (byte)(((int)value << 23 >> 31 | (int)value) & 0xFF);
                                    break;
                                }
                                case 1: {
                                    valueOld = ImageUtil.clampRoundUShort((double)valueOld) & 0xFFFF;
                                    break;
                                }
                                case 2: {
                                    valueOld = ImageUtil.clampRoundShort((double)valueOld);
                                    break;
                                }
                                case 3: {
                                    valueOld = ImageUtil.clampRoundInt((double)valueOld);
                                    break;
                                }
                                case 4: {
                                    valueOld = (float)valueOld;
                                    break;
                                }
                            }
                            Assert.assertEquals((double)value, (double)valueOld, (double)0.1);
                            continue;
                        }
                        Assert.assertEquals((double)value, (double)destNoData, (double)0.1);
                        continue;
                    }
                    valueOld = sourceRasters[0].getSampleDouble(x, y, b);
                    for (i = 1; i < numSrc; ++i) {
                        valueOld -= sourceRasters[i].getSampleDouble(x, y, b);
                    }
                    switch (dataType) {
                        case 0: {
                            valueOld = (byte)(((int)valueOld << 23 >> 31 | (int)valueOld) & 0xFF);
                            value = (byte)(((int)value << 23 >> 31 | (int)value) & 0xFF);
                            break;
                        }
                        case 1: {
                            valueOld = ImageUtil.clampRoundUShort((double)valueOld) & 0xFFFF;
                            break;
                        }
                        case 2: {
                            valueOld = ImageUtil.clampRoundShort((double)valueOld);
                            break;
                        }
                        case 3: {
                            valueOld = ImageUtil.clampRoundInt((double)valueOld);
                            break;
                        }
                        case 4: {
                            valueOld = (float)valueOld;
                            break;
                        }
                    }
                    Assert.assertEquals((double)value, (double)valueOld, (double)0.1);
                }
            }
        }
    }

    private void testMultiply(RenderedOp calculated, RenderedImage[] sources, ROI roi, Range noData, int minBandNumber) {
        boolean roiUsed = roi != null;
        boolean noDataUsed = noData != null;
        int minTileX = calculated.getMinTileX();
        int minTileY = calculated.getMinTileY();
        Raster upperLeftTile = calculated.getTile(minTileX, minTileY);
        int minX = upperLeftTile.getMinX();
        int minY = upperLeftTile.getMinY();
        int maxX = upperLeftTile.getWidth() + minX;
        int maxY = upperLeftTile.getHeight() + minY;
        int numSrc = sources.length;
        Raster[] sourceRasters = new Raster[numSrc];
        for (int i = 0; i < numSrc; ++i) {
            sourceRasters[i] = sources[i].getTile(minTileX, minTileY);
        }
        double valueOld = 0.0;
        double value = 0.0;
        double sample = 0.0;
        boolean isValidData = false;
        int dataType = calculated.getSampleModel().getDataType();
        for (int b = 0; b < minBandNumber; ++b) {
            for (int x = minX; x < maxX; ++x) {
                for (int y = minY; y < maxY; ++y) {
                    int i;
                    value = upperLeftTile.getSampleDouble(x, y, b);
                    valueOld = 0.0;
                    isValidData = false;
                    if (noDataUsed && roiUsed) {
                        if (roi.contains(x, y)) {
                            sample = sourceRasters[0].getSampleDouble(x, y, b);
                            if (!noDataDouble.contains(sample)) {
                                valueOld = sample;
                                isValidData = true;
                            } else {
                                valueOld = 1.0;
                            }
                            for (i = 1; i < numSrc; ++i) {
                                sample = sourceRasters[i].getSampleDouble(x, y, b);
                                if (noDataDouble.contains(sample)) continue;
                                valueOld *= sample;
                                isValidData = true;
                            }
                            if (isValidData) {
                                switch (dataType) {
                                    case 0: {
                                        valueOld = (byte)(((int)valueOld << 23 >> 31 | (int)valueOld) & 0xFF);
                                        value = (byte)(((int)value << 23 >> 31 | (int)value) & 0xFF);
                                        break;
                                    }
                                    case 1: {
                                        valueOld = ImageUtil.clampRoundUShort((double)valueOld) & 0xFFFF;
                                        break;
                                    }
                                    case 2: {
                                        valueOld = ImageUtil.clampRoundShort((double)valueOld);
                                        break;
                                    }
                                    case 3: {
                                        valueOld = ImageUtil.clampRoundInt((double)valueOld);
                                        break;
                                    }
                                    case 4: {
                                        valueOld = (float)valueOld;
                                        break;
                                    }
                                }
                                Assert.assertEquals((double)value, (double)valueOld, (double)0.1);
                                continue;
                            }
                            Assert.assertEquals((double)value, (double)destNoData, (double)0.1);
                            continue;
                        }
                        Assert.assertEquals((double)value, (double)destNoData, (double)0.1);
                        continue;
                    }
                    if (noDataUsed) {
                        sample = sourceRasters[0].getSampleDouble(x, y, b);
                        if (!noDataDouble.contains(sample)) {
                            valueOld = sample;
                            isValidData = true;
                        } else {
                            valueOld = 1.0;
                        }
                        for (i = 1; i < numSrc; ++i) {
                            sample = sourceRasters[i].getSampleDouble(x, y, b);
                            if (noDataDouble.contains(sample)) continue;
                            valueOld *= sample;
                            isValidData = true;
                        }
                        if (isValidData) {
                            switch (dataType) {
                                case 0: {
                                    valueOld = (byte)(((int)valueOld << 23 >> 31 | (int)valueOld) & 0xFF);
                                    value = (byte)(((int)value << 23 >> 31 | (int)value) & 0xFF);
                                    break;
                                }
                                case 1: {
                                    valueOld = ImageUtil.clampRoundUShort((double)valueOld) & 0xFFFF;
                                    break;
                                }
                                case 2: {
                                    valueOld = ImageUtil.clampRoundShort((double)valueOld);
                                    break;
                                }
                                case 3: {
                                    valueOld = ImageUtil.clampRoundInt((double)valueOld);
                                    break;
                                }
                                case 4: {
                                    valueOld = (float)valueOld;
                                    break;
                                }
                            }
                            Assert.assertEquals((double)value, (double)valueOld, (double)0.1);
                            continue;
                        }
                        Assert.assertEquals((double)value, (double)destNoData, (double)0.1);
                        continue;
                    }
                    if (roiUsed) {
                        if (roi.contains(x, y)) {
                            valueOld = sourceRasters[0].getSampleDouble(x, y, b);
                            for (i = 1; i < numSrc; ++i) {
                                valueOld *= sourceRasters[i].getSampleDouble(x, y, b);
                            }
                            switch (dataType) {
                                case 0: {
                                    valueOld = (byte)(((int)valueOld << 23 >> 31 | (int)valueOld) & 0xFF);
                                    value = (byte)(((int)value << 23 >> 31 | (int)value) & 0xFF);
                                    break;
                                }
                                case 1: {
                                    valueOld = ImageUtil.clampRoundUShort((double)valueOld) & 0xFFFF;
                                    break;
                                }
                                case 2: {
                                    valueOld = ImageUtil.clampRoundShort((double)valueOld);
                                    break;
                                }
                                case 3: {
                                    valueOld = ImageUtil.clampRoundInt((double)valueOld);
                                    break;
                                }
                                case 4: {
                                    valueOld = (float)valueOld;
                                    break;
                                }
                            }
                            Assert.assertEquals((double)value, (double)valueOld, (double)0.1);
                            continue;
                        }
                        Assert.assertEquals((double)value, (double)destNoData, (double)0.1);
                        continue;
                    }
                    valueOld = sourceRasters[0].getSampleDouble(x, y, b);
                    for (i = 1; i < numSrc; ++i) {
                        valueOld *= sourceRasters[i].getSampleDouble(x, y, b);
                    }
                    switch (dataType) {
                        case 0: {
                            valueOld = (byte)(((int)valueOld << 23 >> 31 | (int)valueOld) & 0xFF);
                            value = (byte)(((int)value << 23 >> 31 | (int)value) & 0xFF);
                            break;
                        }
                        case 1: {
                            valueOld = ImageUtil.clampRoundUShort((double)valueOld) & 0xFFFF;
                            break;
                        }
                        case 2: {
                            valueOld = ImageUtil.clampRoundShort((double)valueOld);
                            break;
                        }
                        case 3: {
                            valueOld = ImageUtil.clampRoundInt((double)valueOld);
                            break;
                        }
                        case 4: {
                            valueOld = (float)valueOld;
                            break;
                        }
                    }
                    Assert.assertEquals((double)value, (double)valueOld, (double)0.1);
                }
            }
        }
    }

    private void testDivide(RenderedOp calculated, RenderedImage[] sources, ROI roi, Range noData, int minBandNumber) {
        boolean roiUsed = roi != null;
        boolean noDataUsed = noData != null;
        int minTileX = calculated.getMinTileX();
        int minTileY = calculated.getMinTileY();
        Raster upperLeftTile = calculated.getTile(minTileX, minTileY);
        int minX = upperLeftTile.getMinX();
        int minY = upperLeftTile.getMinY();
        int maxX = upperLeftTile.getWidth() + minX;
        int maxY = upperLeftTile.getHeight() + minY;
        int numSrc = sources.length;
        Raster[] sourceRasters = new Raster[numSrc];
        for (int i = 0; i < numSrc; ++i) {
            sourceRasters[i] = sources[i].getTile(minTileX, minTileY);
        }
        double valueOld = 0.0;
        double value = 0.0;
        double sample = 0.0;
        boolean isValidData = false;
        int dataType = calculated.getSampleModel().getDataType();
        for (int b = 0; b < minBandNumber; ++b) {
            for (int x = minX; x < maxX; ++x) {
                for (int y = minY; y < maxY; ++y) {
                    int i;
                    value = upperLeftTile.getSampleDouble(x, y, b);
                    valueOld = 0.0;
                    isValidData = false;
                    if (noDataUsed && roiUsed) {
                        if (roi.contains(x, y)) {
                            sample = sourceRasters[0].getSampleDouble(x, y, b);
                            if (!noDataDouble.contains(sample)) {
                                valueOld = sample;
                                isValidData = true;
                            } else {
                                valueOld = 1.0;
                            }
                            for (i = 1; i < numSrc; ++i) {
                                sample = sourceRasters[i].getSampleDouble(x, y, b);
                                if (noDataDouble.contains(sample)) continue;
                                valueOld /= sample == 0.0 ? 1.0 : sample;
                                isValidData = true;
                            }
                            if (isValidData) {
                                switch (dataType) {
                                    case 0: {
                                        valueOld = (byte)(((int)valueOld << 23 >> 31 | (int)valueOld) & 0xFF);
                                        value = (byte)(((int)value << 23 >> 31 | (int)value) & 0xFF);
                                        break;
                                    }
                                    case 1: {
                                        valueOld = ImageUtil.clampRoundUShort((double)valueOld) & 0xFFFF;
                                        break;
                                    }
                                    case 2: {
                                        valueOld = ImageUtil.clampRoundShort((double)valueOld);
                                        break;
                                    }
                                    case 3: {
                                        valueOld = ImageUtil.clampRoundInt((double)valueOld);
                                        break;
                                    }
                                    case 4: {
                                        valueOld = (float)valueOld;
                                        break;
                                    }
                                }
                                Assert.assertEquals((double)value, (double)valueOld, (double)0.1);
                                continue;
                            }
                            Assert.assertEquals((double)value, (double)destNoData, (double)0.1);
                            continue;
                        }
                        Assert.assertEquals((double)value, (double)destNoData, (double)0.1);
                        continue;
                    }
                    if (noDataUsed) {
                        sample = sourceRasters[0].getSampleDouble(x, y, b);
                        if (!noDataDouble.contains(sample)) {
                            valueOld = sample;
                            isValidData = true;
                        } else {
                            valueOld = 1.0;
                        }
                        for (i = 1; i < numSrc; ++i) {
                            sample = sourceRasters[i].getSampleDouble(x, y, b);
                            if (noDataDouble.contains(sample)) continue;
                            valueOld /= sample == 0.0 ? 1.0 : sample;
                            isValidData = true;
                        }
                        if (isValidData) {
                            switch (dataType) {
                                case 0: {
                                    valueOld = (byte)(((int)valueOld << 23 >> 31 | (int)valueOld) & 0xFF);
                                    value = (byte)(((int)value << 23 >> 31 | (int)value) & 0xFF);
                                    break;
                                }
                                case 1: {
                                    valueOld = ImageUtil.clampRoundUShort((double)valueOld) & 0xFFFF;
                                    break;
                                }
                                case 2: {
                                    valueOld = ImageUtil.clampRoundShort((double)valueOld);
                                    break;
                                }
                                case 3: {
                                    valueOld = ImageUtil.clampRoundInt((double)valueOld);
                                    break;
                                }
                                case 4: {
                                    valueOld = (float)valueOld;
                                    break;
                                }
                            }
                            Assert.assertEquals((double)value, (double)valueOld, (double)0.1);
                            continue;
                        }
                        Assert.assertEquals((double)value, (double)destNoData, (double)0.1);
                        continue;
                    }
                    if (roiUsed) {
                        if (roi.contains(x, y)) {
                            valueOld = sourceRasters[0].getSampleDouble(x, y, b);
                            for (i = 1; i < numSrc; ++i) {
                                sample = sourceRasters[i].getSampleDouble(x, y, b);
                                valueOld /= sample == 0.0 ? 1.0 : sample;
                            }
                            switch (dataType) {
                                case 0: {
                                    valueOld = (byte)(((int)valueOld << 23 >> 31 | (int)valueOld) & 0xFF);
                                    value = (byte)(((int)value << 23 >> 31 | (int)value) & 0xFF);
                                    break;
                                }
                                case 1: {
                                    valueOld = ImageUtil.clampRoundUShort((double)valueOld) & 0xFFFF;
                                    break;
                                }
                                case 2: {
                                    valueOld = ImageUtil.clampRoundShort((double)valueOld);
                                    break;
                                }
                                case 3: {
                                    valueOld = ImageUtil.clampRoundInt((double)valueOld);
                                    break;
                                }
                                case 4: {
                                    valueOld = (float)valueOld;
                                    break;
                                }
                            }
                            Assert.assertEquals((double)value, (double)valueOld, (double)0.1);
                            continue;
                        }
                        Assert.assertEquals((double)value, (double)destNoData, (double)0.1);
                        continue;
                    }
                    valueOld = sourceRasters[0].getSampleDouble(x, y, b);
                    for (i = 1; i < numSrc; ++i) {
                        sample = sourceRasters[i].getSampleDouble(x, y, b);
                        valueOld /= sample == 0.0 ? 1.0 : sample;
                    }
                    switch (dataType) {
                        case 0: {
                            valueOld = (byte)(((int)valueOld << 23 >> 31 | (int)valueOld) & 0xFF);
                            value = (byte)(((int)value << 23 >> 31 | (int)value) & 0xFF);
                            break;
                        }
                        case 1: {
                            valueOld = ImageUtil.clampRoundUShort((double)valueOld) & 0xFFFF;
                            break;
                        }
                        case 2: {
                            valueOld = ImageUtil.clampRoundShort((double)valueOld);
                            break;
                        }
                        case 3: {
                            valueOld = ImageUtil.clampRoundInt((double)valueOld);
                            break;
                        }
                        case 4: {
                            valueOld = (float)valueOld;
                            break;
                        }
                    }
                    Assert.assertEquals((double)value, (double)valueOld, (double)0.1);
                }
            }
        }
    }
}

