/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.algebra.constant;

import com.sun.media.jai.util.ImageUtil;
import it.geosolutions.jaiext.algebra.AlgebraDescriptor;
import it.geosolutions.jaiext.algebra.constant.OperationConstDescriptor;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.testclasses.TestBase;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class OperationConstTest
extends TestBase {
    private static final int NUM_TYPES = 6;
    private static final int DEFAULT_WIDTH_REDUCED = DEFAULT_WIDTH / 2;
    private static final int DEFAULT_HEIGHT_REDUCED = DEFAULT_HEIGHT / 2;
    private static final double TOLERANCE = 0.1;
    private static RenderedImage[] testImages;
    private static Range noDataByte;
    private static Range noDataUShort;
    private static Range noDataShort;
    private static Range noDataInt;
    private static Range noDataFloat;
    private static Range noDataDouble;
    private static int destNoData;
    private static ROI roiObject;
    private static double[] doubleConsts;

    @BeforeClass
    public static void initialSetup() {
        byte noDataB = 50;
        short noDataS = 50;
        int noDataI = 50;
        float noDataF = 50.0f;
        double noDataD = 50.0;
        testImages = new RenderedImage[6];
        IMAGE_FILLER = true;
        OperationConstTest.testImages[0] = OperationConstTest.createTestImage((int)0, (int)DEFAULT_WIDTH_REDUCED, (int)DEFAULT_HEIGHT_REDUCED, (Number)noDataB, (boolean)false, (int)3);
        OperationConstTest.testImages[1] = OperationConstTest.createTestImage((int)1, (int)DEFAULT_WIDTH_REDUCED, (int)DEFAULT_HEIGHT_REDUCED, (Number)noDataS, (boolean)false, (int)3);
        OperationConstTest.testImages[2] = OperationConstTest.createTestImage((int)2, (int)DEFAULT_WIDTH_REDUCED, (int)DEFAULT_HEIGHT_REDUCED, (Number)noDataS, (boolean)false, (int)3);
        OperationConstTest.testImages[3] = OperationConstTest.createTestImage((int)3, (int)DEFAULT_WIDTH_REDUCED, (int)DEFAULT_HEIGHT_REDUCED, (Number)noDataI, (boolean)false, (int)3);
        OperationConstTest.testImages[4] = OperationConstTest.createTestImage((int)4, (int)DEFAULT_WIDTH_REDUCED, (int)DEFAULT_HEIGHT_REDUCED, (Number)Float.valueOf(noDataF), (boolean)false, (int)3);
        OperationConstTest.testImages[5] = OperationConstTest.createTestImage((int)5, (int)DEFAULT_WIDTH_REDUCED, (int)DEFAULT_HEIGHT_REDUCED, (Number)noDataD, (boolean)false, (int)3);
        IMAGE_FILLER = false;
        boolean minIncluded = true;
        boolean maxIncluded = true;
        noDataByte = RangeFactory.create((byte)noDataB, (boolean)minIncluded, (byte)noDataB, (boolean)maxIncluded);
        noDataUShort = RangeFactory.createU((short)noDataS, (boolean)minIncluded, (short)noDataS, (boolean)maxIncluded);
        noDataShort = RangeFactory.create((short)noDataS, (boolean)minIncluded, (short)noDataS, (boolean)maxIncluded);
        noDataInt = RangeFactory.create((int)noDataI, (boolean)minIncluded, (int)noDataI, (boolean)maxIncluded);
        noDataFloat = RangeFactory.create((float)noDataF, (boolean)minIncluded, (float)noDataF, (boolean)maxIncluded, (boolean)true);
        noDataDouble = RangeFactory.create((double)noDataD, (boolean)minIncluded, (double)noDataD, (boolean)maxIncluded, (boolean)true);
        doubleConsts = new double[]{10.5, 15.5, 20.5};
        destNoData = 100;
        Rectangle roiBounds = new Rectangle(5, 5, DEFAULT_WIDTH_REDUCED / 4, DEFAULT_HEIGHT_REDUCED / 4);
        roiObject = new ROIShape((Shape)roiBounds);
    }

    @Test
    public void testNoROINoNoData() {
        boolean roiUsed = false;
        boolean noDataUsed = false;
        for (int i = 0; i < 6; ++i) {
            this.runTests(i, noDataUsed, roiUsed);
        }
    }

    @Test
    public void testOnlyNoData() {
        boolean roiUsed = false;
        boolean noDataUsed = true;
        for (int i = 0; i < 6; ++i) {
            this.runTests(i, noDataUsed, roiUsed);
        }
    }

    @Test
    public void testOnlyROI() {
        boolean roiUsed = true;
        boolean noDataUsed = false;
        for (int i = 0; i < 6; ++i) {
            this.runTests(i, noDataUsed, roiUsed);
        }
    }

    @Test
    public void testROIAndNoData() {
        boolean roiUsed = true;
        boolean noDataUsed = true;
        for (int i = 0; i < 6; ++i) {
            this.runTests(i, noDataUsed, roiUsed);
        }
    }

    private void runTests(int dataType, boolean noDataUsed, boolean roiUsed) {
        this.testOperation(testImages[dataType], AlgebraDescriptor.Operator.SUM, noDataUsed, roiUsed);
        this.testOperation(testImages[dataType], AlgebraDescriptor.Operator.SUBTRACT, noDataUsed, roiUsed);
        this.testOperation(testImages[dataType], AlgebraDescriptor.Operator.MULTIPLY, noDataUsed, roiUsed);
        this.testOperation(testImages[dataType], AlgebraDescriptor.Operator.DIVIDE, noDataUsed, roiUsed);
        this.testOperation(testImages[dataType], AlgebraDescriptor.Operator.DIVIDE_INTO, noDataUsed, roiUsed);
        if (dataType != 4 && dataType != 5) {
            this.testOperation(testImages[dataType], AlgebraDescriptor.Operator.AND, noDataUsed, roiUsed);
            this.testOperation(testImages[dataType], AlgebraDescriptor.Operator.OR, noDataUsed, roiUsed);
            this.testOperation(testImages[dataType], AlgebraDescriptor.Operator.XOR, noDataUsed, roiUsed);
        }
    }

    private void testOperation(RenderedImage source, AlgebraDescriptor.Operator op, boolean noDataUsed, boolean roiUsed) {
        Range noData;
        block9: {
            block8: {
                int dataType = source.getSampleModel().getDataType();
                if (!noDataUsed) break block8;
                switch (dataType) {
                    case 0: {
                        noData = noDataByte;
                        break block9;
                    }
                    case 1: {
                        noData = noDataUShort;
                        break block9;
                    }
                    case 2: {
                        noData = noDataShort;
                        break block9;
                    }
                    case 3: {
                        noData = noDataInt;
                        break block9;
                    }
                    case 4: {
                        noData = noDataFloat;
                        break block9;
                    }
                    case 5: {
                        noData = noDataDouble;
                        break block9;
                    }
                    default: {
                        throw new IllegalArgumentException("Wrong data type");
                    }
                }
            }
            noData = null;
        }
        Object roi = roiUsed ? roiObject : null;
        RenderedOp calculated = OperationConstDescriptor.create((RenderedImage)source, (double[])doubleConsts, (AlgebraDescriptor.Operator)op, (ROI)roi, (Range)noData, (double)destNoData, null);
        this.testOperation(calculated, source, (ROI)roi, noData, op);
        calculated.dispose();
    }

    private void testOperation(RenderedOp calculated, RenderedImage source, ROI roi, Range noData, AlgebraDescriptor.Operator op) {
        boolean roiUsed = roi != null;
        boolean noDataUsed = noData != null;
        int minTileX = calculated.getMinTileX();
        int minTileY = calculated.getMinTileY();
        Raster upperLeftTile = calculated.getTile(minTileX, minTileY);
        int minX = upperLeftTile.getMinX();
        int minY = upperLeftTile.getMinY();
        int maxX = upperLeftTile.getWidth() + minX;
        int maxY = upperLeftTile.getHeight() + minY;
        Raster sourceRaster = source.getTile(minTileX, minTileY);
        double valueOld = 0.0;
        double value = 0.0;
        double sample = 0.0;
        boolean isValidData = false;
        boolean supportsDouble = op.isDataTypeSupported(5);
        int dataType = calculated.getSampleModel().getDataType();
        int numBands = calculated.getSampleModel().getNumBands();
        for (int b = 0; b < numBands; ++b) {
            for (int x = minX; x < maxX; ++x) {
                for (int y = minY; y < maxY; ++y) {
                    value = upperLeftTile.getSampleDouble(x, y, b);
                    sample = sourceRaster.getSampleDouble(x, y, b);
                    valueOld = 0.0;
                    boolean bl = isValidData = (!roiUsed || roiUsed && roi.contains(x, y)) && (!noDataUsed || noDataUsed && !noDataDouble.contains(sample));
                    if (isValidData) {
                        valueOld = supportsDouble ? op.calculate(new double[]{sample, doubleConsts[b]}) : (double)op.calculate(new int[]{(int)sample, ImageUtil.clampRoundInt((double)doubleConsts[b])});
                        switch (dataType) {
                            case 0: {
                                valueOld = ImageUtil.clampRoundByte((double)valueOld);
                                value = (byte)(((int)value << 23 >> 31 | (int)value) & 0xFF);
                                break;
                            }
                            case 1: {
                                valueOld = ImageUtil.clampRoundUShort((double)valueOld) & 0xFFFF;
                                break;
                            }
                            case 2: {
                                valueOld = ImageUtil.clampRoundShort((double)valueOld);
                                break;
                            }
                            case 3: {
                                valueOld = ImageUtil.clampRoundInt((double)valueOld);
                                break;
                            }
                            case 4: {
                                valueOld = ImageUtil.clampFloat((double)valueOld);
                                break;
                            }
                            case 5: {
                                break;
                            }
                        }
                        Assert.assertEquals((double)value, (double)valueOld, (double)0.1);
                        continue;
                    }
                    Assert.assertEquals((double)value, (double)destNoData, (double)0.1);
                }
            }
        }
    }
}

