/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.algebra.constant;

import it.geosolutions.jaiext.algebra.AlgebraDescriptor;
import it.geosolutions.jaiext.range.Range;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.ROI;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;

public class OperationConstDescriptor
extends OperationDescriptorImpl {
    public static final int OPERATION_INDEX = 0;
    public static final int ROI_INDEX = 1;
    public static final int RANGE_INDEX = 2;
    public static final int DEST_NODATA_INDEX = 3;
    public static final int CONSTANT_INDEX = 3;
    private static final String[][] resources = new String[][]{{"GlobalName", "operationConst"}, {"LocalName", "operationConst"}, {"Vendor", "it.geosolutions.jaiext"}, {"Description", "This class executes the operation selected by the user on each pixel of the source images "}, {"DocURL", "Not Defined"}, {"Version", "1.0"}, {"arg0Desc", "Operation to execute"}, {"arg1Desc", "Constant Values to Add"}, {"arg2Desc", "ROI object used"}, {"arg3Desc", "No Data Range used"}, {"arg4Desc", "Output value for No Data"}};
    private static final String[] paramNames = new String[]{"constants", "operation", "roi", "noData", "destinationNoData"};
    private static final Class[] paramClasses = new Class[]{double[].class, AlgebraDescriptor.Operator.class, ROI.class, Range.class, Double.class};
    private static final Object[] paramDefaults = new Object[]{NO_PARAMETER_DEFAULT, NO_PARAMETER_DEFAULT, null, null, 0.0};

    public OperationConstDescriptor() {
        super(resources, 1, paramClasses, paramNames, paramDefaults);
    }

    public boolean isRenderableSupported() {
        return true;
    }

    protected boolean validateParameters(String modeName, ParameterBlock args, StringBuffer msg) {
        if (modeName.equalsIgnoreCase("rendered")) {
            double[] constants = null;
            Object param = args.getObjectParameter(0);
            if (param != null) {
                if (param instanceof double[]) {
                    return true;
                }
                if (param instanceof int[]) {
                    int[] paramInt = (int[])param;
                    constants = new double[paramInt.length];
                    for (int i = 0; i < paramInt.length; ++i) {
                        constants[i] = paramInt[i];
                    }
                    args.set(constants, 0);
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public static RenderedOp create(RenderedImage source, double[] constants, AlgebraDescriptor.Operator op, ROI roi, Range noData, double destinationNoData, RenderingHints hints) {
        ParameterBlockJAI pb = new ParameterBlockJAI("operationConst", "rendered");
        pb.setSource((Object)source, 0);
        if (pb.getNumSources() == 0) {
            throw new IllegalArgumentException("The input images are Null");
        }
        pb.setParameter("operation", (Object)op);
        pb.setParameter("roi", (Object)roi);
        pb.setParameter("constants", (Object)constants);
        pb.setParameter("noData", (Object)noData);
        pb.setParameter("destinationNoData", destinationNoData);
        return JAI.create((String)"operationConst", (ParameterBlock)pb, (RenderingHints)hints);
    }

    public static RenderableOp createRenderable(RenderableImage source, double[] constants, AlgebraDescriptor.Operator op, ROI roi, Range noData, double destinationNoData, RenderingHints hints) {
        ParameterBlockJAI pb = new ParameterBlockJAI("operationConst", "renderable");
        pb.setSource((Object)source, 0);
        if (pb.getNumSources() == 0) {
            throw new IllegalArgumentException("The input images are Null");
        }
        pb.setParameter("operation", (Object)op);
        pb.setParameter("roi", (Object)roi);
        pb.setParameter("constants", (Object)constants);
        pb.setParameter("noData", (Object)noData);
        pb.setParameter("destinationNoData", destinationNoData);
        return JAI.createRenderable((String)"operationConst", (ParameterBlock)pb, (RenderingHints)hints);
    }
}

