/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.algebra;

import it.geosolutions.jaiext.range.Range;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.ROI;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;

public class AlgebraDescriptor
extends OperationDescriptorImpl {
    public static final int OPERATION_INDEX = 0;
    public static final int ROI_INDEX = 1;
    public static final int RANGE_INDEX = 2;
    public static final int DEST_NODATA_INDEX = 3;
    private static final String[][] resources = new String[][]{{"GlobalName", "algebric"}, {"LocalName", "algebric"}, {"Vendor", "it.geosolutions.jaiext.roiaware"}, {"Description", "This class executes the operation selected by the user on each pixel of the source images "}, {"DocURL", "Not Defined"}, {"Version", "1.0"}, {"arg0Desc", "Operation to execute"}, {"arg1Desc", "ROI object used"}, {"arg2Desc", "No Data Range used"}, {"arg3Desc", "Output value for No Data"}};
    private static final String[] paramNames = new String[]{"operation", "roi", "noData", "destinationNoData"};
    private static final Class[] paramClasses = new Class[]{Operator.class, ROI.class, Range.class, Double.class};
    private static final Object[] paramDefaults = new Object[]{null, null, null, 0.0};

    public AlgebraDescriptor() {
        super(resources, paramClasses, paramNames, paramDefaults);
    }

    public boolean isRenderableSupported() {
        return true;
    }

    public static RenderedOp create(Operator op, ROI roi, Range noData, double destinationNoData, RenderingHints hints, RenderedImage ... sources) {
        ParameterBlockJAI pb = new ParameterBlockJAI("algebric", "rendered");
        int numSources = sources.length;
        for (int i = 0; i < numSources; ++i) {
            RenderedImage img = sources[i];
            if (img == null) continue;
            pb.setSource((Object)img, i);
        }
        if (pb.getNumSources() == 0) {
            throw new IllegalArgumentException("The input images are Null");
        }
        pb.setParameter("operation", (Object)op);
        pb.setParameter("roi", (Object)roi);
        pb.setParameter("noData", (Object)noData);
        pb.setParameter("destinationNoData", destinationNoData);
        return JAI.create((String)"algebric", (ParameterBlock)pb, (RenderingHints)hints);
    }

    public static RenderableOp createRenderable(Operator op, ROI roi, Range noData, double destinationNoData, RenderingHints hints, RenderableImage ... sources) {
        ParameterBlockJAI pb = new ParameterBlockJAI("algebric", "renderable");
        int numSources = sources.length;
        for (int i = 0; i < numSources; ++i) {
            RenderableImage img = sources[i];
            if (img == null) continue;
            pb.setSource((Object)img, i);
        }
        if (pb.getNumSources() == 0) {
            throw new IllegalArgumentException("The input images are Null");
        }
        pb.setParameter("operation", (Object)op);
        pb.setParameter("roi", (Object)roi);
        pb.setParameter("noData", (Object)noData);
        pb.setParameter("destinationNoData", destinationNoData);
        return JAI.createRenderable((String)"algebric", (ParameterBlock)pb, (RenderingHints)hints);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operator {
        SUM(0, 0.0){

            public byte calculate(byte ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = (byte)(values[0] + values[i]);
                    }
                }
                return values[0];
            }

            public short calculate(short ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = (short)(values[0] + values[i]);
                    }
                }
                return values[0];
            }

            public int calculate(int ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = values[0] + values[i];
                    }
                }
                return values[0];
            }

            public float calculate(float ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = values[0] + values[i];
                    }
                }
                return values[0];
            }

            public double calculate(double ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = values[0] + values[i];
                    }
                }
                return values[0];
            }

            public long calculate(long ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = values[0] + values[i];
                    }
                }
                return values[0];
            }

            public double getNullValue() {
                return this.nullValue;
            }

            public byte calculate(byte value0, byte value1) {
                return (byte)(value0 + value1);
            }

            public short calculate(short value0, short value1) {
                return (short)(value0 + value1);
            }

            public int calculate(int value0, int value1) {
                return value0 + value1;
            }

            public float calculate(float value0, float value1) {
                return value0 + value1;
            }

            public double calculate(double value0, double value1) {
                return value0 + value1;
            }

            public long calculate(long value0, long value1) {
                return value0 + value1;
            }
        }
        ,
        SUBTRACT(1, 0.0){

            public byte calculate(byte ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = (byte)(values[0] - values[i]);
                    }
                }
                return values[0];
            }

            public short calculate(short ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = (short)(values[0] - values[i]);
                    }
                }
                return values[0];
            }

            public int calculate(int ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = values[0] - values[i];
                    }
                }
                return values[0];
            }

            public float calculate(float ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = values[0] - values[i];
                    }
                }
                return values[0];
            }

            public double calculate(double ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = values[0] - values[i];
                    }
                }
                return values[0];
            }

            public long calculate(long ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = values[0] - values[i];
                    }
                }
                return values[0];
            }

            public double getNullValue() {
                return this.nullValue;
            }

            public byte calculate(byte value0, byte value1) {
                return (byte)(value0 - value1);
            }

            public short calculate(short value0, short value1) {
                return (short)(value0 - value1);
            }

            public int calculate(int value0, int value1) {
                return value0 - value1;
            }

            public float calculate(float value0, float value1) {
                return value0 - value1;
            }

            public double calculate(double value0, double value1) {
                return value0 - value1;
            }

            public long calculate(long value0, long value1) {
                return value0 - value1;
            }
        }
        ,
        MULTIPLY(2, 1.0){

            public byte calculate(byte ... values) {
                long temp = 1L;
                if (values.length > 1) {
                    for (int i = 0; i < values.length; ++i) {
                        temp *= (long)values[i];
                    }
                    values[0] = temp > 127L ? 127 : (temp < -128L ? -128 : (byte)temp);
                }
                return values[0];
            }

            public short calculate(short ... values) {
                long temp = 1L;
                if (values.length > 1) {
                    for (int i = 0; i < values.length; ++i) {
                        temp *= (long)values[i];
                    }
                    values[0] = temp > 32767L ? Short.MAX_VALUE : (temp < -32768L ? Short.MIN_VALUE : (short)temp);
                }
                return values[0];
            }

            public int calculate(int ... values) {
                long temp = 1L;
                if (values.length > 1) {
                    for (int i = 0; i < values.length; ++i) {
                        temp *= (long)values[i];
                    }
                    values[0] = temp > Integer.MAX_VALUE ? Integer.MAX_VALUE : (temp < Integer.MIN_VALUE ? Integer.MIN_VALUE : (int)temp);
                }
                return values[0];
            }

            public float calculate(float ... values) {
                double temp = 1.0;
                if (values.length > 1) {
                    for (int i = 0; i < values.length; ++i) {
                        temp *= (double)values[i];
                    }
                    values[0] = temp > 3.4028234663852886E38 ? Float.MAX_VALUE : (temp < -3.4028234663852886E38 ? -3.4028235E38f : (float)temp);
                }
                return values[0];
            }

            public double calculate(double ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = values[0] * values[i];
                    }
                }
                return values[0];
            }

            public long calculate(long ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = values[0] * values[i];
                    }
                }
                return values[0];
            }

            public double getNullValue() {
                return this.nullValue;
            }

            public byte calculate(byte value0, byte value1) {
                long temp = 1L;
                temp = 1L * (long)value0 * (long)value1;
                if (temp > 127L) {
                    temp = 127L;
                } else if (temp < -128L) {
                    temp = -128L;
                }
                return (byte)temp;
            }

            public short calculate(short value0, short value1) {
                long temp = 1L;
                temp = 1L * (long)value0 * (long)value1;
                if (temp > 32767L) {
                    temp = 32767L;
                } else if (temp < -32768L) {
                    temp = -32768L;
                }
                return (short)temp;
            }

            public int calculate(int value0, int value1) {
                long temp = 1L;
                temp = 1L * (long)value0 * (long)value1;
                if (temp > Integer.MAX_VALUE) {
                    temp = Integer.MAX_VALUE;
                } else if (temp < Integer.MIN_VALUE) {
                    temp = Integer.MIN_VALUE;
                }
                return (int)temp;
            }

            public float calculate(float value0, float value1) {
                double temp = 1.0;
                temp = 1.0 * (double)value0 * (double)value1;
                if (temp > 3.4028234663852886E38) {
                    temp = 3.4028234663852886E38;
                } else if (temp < -3.4028234663852886E38) {
                    temp = -3.4028234663852886E38;
                }
                return (float)temp;
            }

            public double calculate(double value0, double value1) {
                return value0 * value1;
            }

            public long calculate(long value0, long value1) {
                return value0 * value1;
            }
        }
        ,
        DIVIDE(3, 1.0){

            public byte calculate(byte ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = values[i] == 0 && values[0] >= 0 ? 127 : (values[i] == 0 && values[0] < 0 ? -128 : (byte)(values[0] / values[i]));
                    }
                }
                return values[0];
            }

            public short calculate(short ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = values[i] == 0 && values[0] >= 0 ? Short.MAX_VALUE : (values[i] == 0 && values[0] < 0 ? Short.MIN_VALUE : (short)(values[0] / values[i]));
                    }
                }
                return values[0];
            }

            public int calculate(int ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = values[i] == 0 && values[0] >= 0 ? Integer.MAX_VALUE : (values[i] == 0 && values[0] < 0 ? Integer.MIN_VALUE : values[0] / values[i]);
                    }
                }
                return values[0];
            }

            public float calculate(float ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = values[0] / values[i];
                    }
                }
                return values[0];
            }

            public double calculate(double ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = values[0] / values[i];
                    }
                }
                return values[0];
            }

            public long calculate(long ... values) {
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        values[0] = values[i] == 0L && values[0] >= 0L ? Long.MAX_VALUE : (values[i] == 0L && values[0] < 0L ? Long.MIN_VALUE : values[0] / values[i]);
                    }
                }
                return values[0];
            }

            public double getNullValue() {
                return this.nullValue;
            }

            public byte calculate(byte value0, byte value1) {
                if (value1 == 0 && value0 >= 0) {
                    return 127;
                }
                if (value1 == 0 && value0 < 0) {
                    return -128;
                }
                return (byte)(value0 / value1);
            }

            public short calculate(short value0, short value1) {
                if (value1 == 0 && value0 >= 0) {
                    return Short.MAX_VALUE;
                }
                if (value1 == 0 && value0 < 0) {
                    return Short.MIN_VALUE;
                }
                return (short)(value0 / value1);
            }

            public int calculate(int value0, int value1) {
                if (value1 == 0 && value0 >= 0) {
                    return Integer.MAX_VALUE;
                }
                if (value1 == 0 && value0 < 0) {
                    return Integer.MIN_VALUE;
                }
                return value0 / value1;
            }

            public float calculate(float value0, float value1) {
                return value0 / value1;
            }

            public double calculate(double value0, double value1) {
                return value0 / value1;
            }

            public long calculate(long value0, long value1) {
                if (value1 == 0L && value0 >= 0L) {
                    return Long.MAX_VALUE;
                }
                if (value1 == 0L && value0 < 0L) {
                    return Long.MIN_VALUE;
                }
                return value0 / value1;
            }
        };

        protected final double nullValue;
        private final int type;

        private Operator(int type, double nullValue) {
            this.nullValue = nullValue;
            this.type = type;
        }

        public abstract byte calculate(byte var1, byte var2);

        public abstract short calculate(short var1, short var2);

        public abstract int calculate(int var1, int var2);

        public abstract float calculate(float var1, float var2);

        public abstract double calculate(double var1, double var3);

        public abstract long calculate(long var1, long var3);

        public abstract byte calculate(byte ... var1);

        public abstract short calculate(short ... var1);

        public abstract int calculate(int ... var1);

        public abstract float calculate(float ... var1);

        public abstract double calculate(double ... var1);

        public abstract long calculate(long ... var1);

        public abstract double getNullValue();

        public int getType() {
            return this.type;
        }
    }
}

