/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.algebra;

import it.geosolutions.jaiext.algebra.AlgebraDescriptor;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.testclasses.TestBase;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.RenderedImage;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.AddDescriptor;
import javax.media.jai.operator.DivideDescriptor;
import javax.media.jai.operator.MultiplyDescriptor;
import javax.media.jai.operator.SubtractDescriptor;
import org.junit.BeforeClass;
import org.junit.Test;

public class ComparisonTest
extends TestBase {
    private static final Integer BENCHMARK_ITERATION = Integer.getInteger("JAI.Ext.BenchmarkCycles", 1);
    private static final int NOT_BENCHMARK_ITERATION = Integer.getInteger("JAI.Ext.NotBenchmarkCycles", 0);
    private static final boolean OLD_DESCRIPTOR = Boolean.getBoolean("JAI.Ext.OldDescriptor");
    private static final boolean RANGE_USED = Boolean.getBoolean("JAI.Ext.RangeUsed");
    private static final boolean ROI_USED = Boolean.getBoolean("JAI.Ext.ROIUsed");
    private static final int OPERATION_TYPE = Integer.getInteger("JAI.Ext.OperationType", 0);
    private static final int NUM_IMAGES = Integer.getInteger("JAI.Ext.NumImages", 2);
    private static final int NUM_BANDS = 1;
    private static RenderedImage[] images;
    private static Range range;
    private static double destNoData;
    private static ROIShape roi;
    private static AlgebraDescriptor.Operator op;

    @BeforeClass
    public static void initialSetup() {
        IMAGE_FILLER = true;
        byte noDataB = 100;
        short noDataUS = 100;
        short noDataS = 100;
        int noDataI = 100;
        float noDataF = 100.0f;
        double noDataD = 100.0;
        images = new RenderedImage[NUM_IMAGES];
        switch (TEST_SELECTOR) {
            case 0: {
                int i;
                for (i = 0; i < NUM_IMAGES; ++i) {
                    ComparisonTest.images[i] = ComparisonTest.createTestImage((int)0, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataB, (boolean)false, (int)1);
                }
                break;
            }
            case 1: {
                int i;
                for (i = 0; i < NUM_IMAGES; ++i) {
                    ComparisonTest.images[i] = ComparisonTest.createTestImage((int)1, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataUS, (boolean)false, (int)1);
                }
                break;
            }
            case 2: {
                int i;
                for (i = 0; i < NUM_IMAGES; ++i) {
                    ComparisonTest.images[i] = ComparisonTest.createTestImage((int)2, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataS, (boolean)false, (int)1);
                }
                break;
            }
            case 3: {
                int i;
                for (i = 0; i < NUM_IMAGES; ++i) {
                    ComparisonTest.images[i] = ComparisonTest.createTestImage((int)3, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataI, (boolean)false, (int)1);
                }
                break;
            }
            case 4: {
                int i;
                for (i = 0; i < NUM_IMAGES; ++i) {
                    ComparisonTest.images[i] = ComparisonTest.createTestImage((int)4, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)Float.valueOf(noDataF), (boolean)false, (int)1);
                }
                break;
            }
            case 5: {
                int i;
                for (i = 0; i < NUM_IMAGES; ++i) {
                    ComparisonTest.images[i] = ComparisonTest.createTestImage((int)5, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataD, (boolean)false, (int)1);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong data type");
            }
        }
        IMAGE_FILLER = false;
        if (RANGE_USED && !OLD_DESCRIPTOR) {
            switch (TEST_SELECTOR) {
                case 0: {
                    range = RangeFactory.create((byte)noDataB, (boolean)true, (byte)noDataB, (boolean)true);
                    break;
                }
                case 1: {
                    range = RangeFactory.createU((short)noDataUS, (boolean)true, (short)noDataUS, (boolean)true);
                    break;
                }
                case 2: {
                    range = RangeFactory.create((short)noDataS, (boolean)true, (short)noDataS, (boolean)true);
                    break;
                }
                case 3: {
                    range = RangeFactory.create((int)noDataI, (boolean)true, (int)noDataI, (boolean)true);
                    break;
                }
                case 4: {
                    range = RangeFactory.create((float)noDataF, (boolean)true, (float)noDataF, (boolean)true, (boolean)true);
                    break;
                }
                case 5: {
                    range = RangeFactory.create((double)noDataD, (boolean)true, (double)noDataD, (boolean)true, (boolean)true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong data type");
                }
            }
        }
        if (ROI_USED) {
            Rectangle rect = new Rectangle(0, 0, DEFAULT_WIDTH / 4, DEFAULT_HEIGHT / 4);
            roi = new ROIShape((Shape)rect);
        } else {
            roi = null;
        }
        if (OPERATION_TYPE >= AlgebraDescriptor.Operator.values().length) {
            throw new IllegalArgumentException("Operation not defined");
        }
        op = AlgebraDescriptor.Operator.values()[OPERATION_TYPE];
        destNoData = 100.0;
    }

    @Test
    public void testOperation() {
        int dataType = TEST_SELECTOR;
        String description = "";
        switch (op) {
            case SUM: {
                description = "Add";
                break;
            }
            case SUBTRACT: {
                description = "Subtract";
                break;
            }
            case MULTIPLY: {
                description = "Multiply";
                break;
            }
            case DIVIDE: {
                description = "Divide";
            }
        }
        description = OLD_DESCRIPTOR ? "Old " + description : "New " + description;
        String dataTypeString = "";
        switch (dataType) {
            case 0: {
                dataTypeString = dataTypeString + "Byte";
                break;
            }
            case 1: {
                dataTypeString = dataTypeString + "UShort";
                break;
            }
            case 2: {
                dataTypeString = dataTypeString + "Short";
                break;
            }
            case 3: {
                dataTypeString = dataTypeString + "Integer";
                break;
            }
            case 4: {
                dataTypeString = dataTypeString + "Float";
                break;
            }
            case 5: {
                dataTypeString = dataTypeString + "Double";
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong data type");
            }
        }
        int totalCycles = BENCHMARK_ITERATION + NOT_BENCHMARK_ITERATION;
        RenderedOp imageCalculated = null;
        long mean = 0L;
        long max = Long.MIN_VALUE;
        long min = Long.MAX_VALUE;
        for (int i = 0; i < totalCycles; ++i) {
            if (OLD_DESCRIPTOR) {
                switch (op) {
                    case SUM: {
                        int j;
                        RenderedImage firstOp = images[0];
                        for (j = 1; j < NUM_IMAGES; ++j) {
                            firstOp = AddDescriptor.create((RenderedImage)firstOp, (RenderedImage)images[j], null);
                        }
                        imageCalculated = (PlanarImage)firstOp;
                        break;
                    }
                    case SUBTRACT: {
                        int j;
                        RenderedImage firstOp = images[0];
                        for (j = 1; j < NUM_IMAGES; ++j) {
                            firstOp = SubtractDescriptor.create((RenderedImage)firstOp, (RenderedImage)images[j], null);
                        }
                        imageCalculated = (PlanarImage)firstOp;
                        break;
                    }
                    case MULTIPLY: {
                        int j;
                        RenderedImage firstOp = images[0];
                        for (j = 1; j < NUM_IMAGES; ++j) {
                            firstOp = MultiplyDescriptor.create((RenderedImage)firstOp, (RenderedImage)images[j], null);
                        }
                        imageCalculated = (PlanarImage)firstOp;
                        break;
                    }
                    case DIVIDE: {
                        int j;
                        RenderedImage firstOp = images[0];
                        for (j = 1; j < NUM_IMAGES; ++j) {
                            firstOp = DivideDescriptor.create((RenderedImage)firstOp, (RenderedImage)images[j], null);
                        }
                        imageCalculated = (PlanarImage)firstOp;
                    }
                }
            } else {
                imageCalculated = AlgebraDescriptor.create((AlgebraDescriptor.Operator)op, (ROI)roi, (Range)range, (double)destNoData, null, (RenderedImage[])images);
            }
            long start = System.nanoTime();
            imageCalculated.getTiles();
            long end = System.nanoTime() - start;
            if (i > NOT_BENCHMARK_ITERATION - 1) {
                mean = i == NOT_BENCHMARK_ITERATION ? end : (mean += end);
                if (end > max) {
                    max = end;
                }
                if (end < min) {
                    min = end;
                }
            }
            JAI.getDefaultInstance().getTileCache().flush();
        }
        double meanValue = (double)(mean / (long)BENCHMARK_ITERATION.intValue()) * 1.0E-6;
        double maxD = (double)max * 1.0E-6;
        double minD = (double)min * 1.0E-6;
        System.out.println(dataTypeString);
        System.out.println("\nMean value for " + description + "Descriptor : " + meanValue + " msec.");
        System.out.println("Maximum value for " + description + "Descriptor : " + maxD + " msec.");
        System.out.println("Minimum value for " + description + "Descriptor : " + minD + " msec.");
        if (imageCalculated instanceof RenderedOp) {
            imageCalculated.dispose();
        }
    }
}

