/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.affine;

import com.sun.media.jai.util.ImageUtil;
import it.geosolutions.jaiext.affine.AffineOpImage;
import it.geosolutions.jaiext.interpolators.InterpolationBicubic;
import it.geosolutions.jaiext.interpolators.InterpolationBilinear;
import it.geosolutions.jaiext.interpolators.InterpolationNearest;
import it.geosolutions.jaiext.interpolators.InterpolationNoData;
import it.geosolutions.jaiext.range.Range;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

public class AffineGeneralOpImage
extends AffineOpImage {
    static final BorderExtender roiExtender = BorderExtender.createInstance((int)0);
    private InterpolationNearest interpN;
    private InterpolationBilinear interpB;
    private InterpolationBicubic interpBN;
    private boolean isBinary;
    private int subsampleBits;
    private Interpolation interpolator;
    private int shiftvalue;
    private boolean useROIAccessor;
    private double[] destinationNoData;
    private int interp_width;
    private int interp_height;
    private int interp_left;
    private int interp_top;
    private int interp_bottom;
    private int interp_right;
    private boolean setDestinationNoData;
    private int black;

    public AffineGeneralOpImage(RenderedImage source, BorderExtender extender, Map config, ImageLayout layout, AffineTransform transform, Interpolation interp, boolean useROIAccessor, double[] destinationNoData, boolean setDestinationNoData, Range nodata) {
        super(source, extender, AffineGeneralOpImage.configHelper(config, source), layout, transform, interp, destinationNoData);
        this.affineOpInitialization(source, interp, layout, useROIAccessor, setDestinationNoData, nodata, destinationNoData);
    }

    private static Map configHelper(Map configuration, RenderedImage source) {
        boolean binaryImage;
        SampleModel sm = source.getSampleModel();
        boolean bl = binaryImage = sm instanceof MultiPixelPackedSampleModel && sm.getSampleSize(0) == 1 && (sm.getDataType() == 0 || sm.getDataType() == 1 || sm.getDataType() == 3);
        if (binaryImage) {
            Map config;
            if (configuration == null) {
                config = new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
            } else {
                config = configuration;
                if (!config.containsKey(JAI.KEY_REPLACE_INDEX_COLOR_MODEL)) {
                    RenderingHints hints = (RenderingHints)configuration;
                    config = (RenderingHints)hints.clone();
                    config.put(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
                }
            }
            return config;
        }
        return configuration;
    }

    private void affineOpInitialization(RenderedImage source, Interpolation interp, ImageLayout layout, boolean useROIAccessor, boolean setDestinationNoData, Range nodata, double[] destNoData) {
        SampleModel sm = source.getSampleModel();
        boolean bl = this.isBinary = sm instanceof MultiPixelPackedSampleModel && sm.getSampleSize(0) == 1 && (sm.getDataType() == 0 || sm.getDataType() == 1 || sm.getDataType() == 3);
        if (this.isBinary) {
            this.colorModel = layout != null ? layout.getColorModel(source) : source.getColorModel();
            this.sampleModel = source.getSampleModel().createCompatibleSampleModel(this.tileWidth, this.tileHeight);
        } else {
            ColorModel srcColorModel = source.getColorModel();
            if (srcColorModel instanceof IndexColorModel) {
                this.sampleModel = source.getSampleModel().createCompatibleSampleModel(this.tileWidth, this.tileHeight);
                this.colorModel = srcColorModel;
            }
        }
        this.interpolator = interp;
        double[] destNod = null;
        if (destNoData != null && destNoData.length > 0) {
            destNod = destNoData;
        }
        if (this.interpolator instanceof InterpolationNearest) {
            this.interpN = (InterpolationNearest)this.interpolator;
            this.interpN.setROIdata(this.roiBounds, this.roiIter);
            if (destNod == null) {
                destNod = new double[]{this.interpN.getDestinationNoData()};
            }
        } else if (this.interpolator instanceof InterpolationBilinear) {
            this.interpB = (InterpolationBilinear)this.interpolator;
            this.interpB.setROIdata(this.roiBounds, this.roiIter);
            if (destNod == null) {
                destNod = new double[]{this.interpB.getDestinationNoData()};
            }
        } else if (this.interpolator instanceof InterpolationBicubic) {
            this.interpBN = (InterpolationBicubic)this.interpolator;
            this.interpBN.setROIdata(this.roiBounds, this.roiIter);
            if (destNod == null) {
                destNod = new double[]{this.interpN.getDestinationNoData()};
            }
        } else if (this.backgroundValues != null) {
            destNod = this.backgroundValues;
        }
        int numBands = this.getSampleModel().getNumBands();
        if (destNod == null) {
            destNod = new double[numBands];
        }
        if (destNod.length < numBands) {
            double[] tmp = new double[numBands];
            Arrays.fill(tmp, destNod[0]);
            destNod = tmp;
        }
        this.destinationNoData = destNod;
        if (this.interpolator instanceof InterpolationNoData) {
            InterpolationNoData interpolationNoData = (InterpolationNoData)this.interpolator;
            interpolationNoData.setDestinationNoData(destNod[0]);
            if (nodata != null) {
                this.hasNoData = true;
                interpolationNoData.setNoDataRange(nodata);
            }
            interpolationNoData.setUseROIAccessor(this.useROIAccessor);
        }
        this.black = (int)this.destinationNoData[0] & 1;
        this.subsampleBits = interp.getSubsampleBitsH();
        this.shiftvalue = 1 << this.subsampleBits;
        this.interp_width = interp.getWidth();
        this.interp_height = interp.getHeight();
        this.interp_left = interp.getLeftPadding();
        this.interp_top = interp.getTopPadding();
        this.interp_right = this.interp_width - this.interp_left - 1;
        this.interp_bottom = this.interp_height - this.interp_top - 1;
        this.useROIAccessor = this.hasROI && (this.interpN != null || this.interpB != null || this.interpBN != null) ? useROIAccessor : false;
        this.setDestinationNoData = setDestinationNoData;
    }

    public Raster computeTile(int tileX, int tileY) {
        Point org = new Point(this.tileXToX(tileX), this.tileYToY(tileY));
        WritableRaster dest = this.createWritableRaster(this.sampleModel, org);
        Rectangle rect = new Rectangle(org.x, org.y, this.tileWidth, this.tileHeight);
        int dstBandNum = dest.getNumBands();
        double[] destinationNoDataArray = new double[dstBandNum];
        for (int i = 0; i < dstBandNum; ++i) {
            destinationNoDataArray[i] = this.destinationNoData[i];
        }
        Rectangle destRect = rect.intersection(this.theDest);
        Rectangle destRect1 = rect.intersection(this.getBounds());
        if (destRect.width <= 0 || destRect.height <= 0) {
            if (this.setDestinationNoData) {
                ImageUtil.fillBackground((WritableRaster)dest, (Rectangle)destRect1, (double[])destinationNoDataArray);
            }
            return dest;
        }
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        srcRect = this.extender == null ? srcRect.intersection(this.srcimg) : srcRect.intersection(this.padimg);
        if (srcRect.width <= 0 || srcRect.height <= 0) {
            if (this.setDestinationNoData) {
                ImageUtil.fillBackground((WritableRaster)dest, (Rectangle)destRect1, (double[])destinationNoDataArray);
            }
            return dest;
        }
        if (!destRect1.equals(destRect)) {
            ImageUtil.fillBordersWithBackgroundValues((Rectangle)destRect1, (Rectangle)destRect, (WritableRaster)dest, (double[])destinationNoDataArray);
        }
        Raster[] sources = new Raster[1];
        Raster[] rois = new Raster[1];
        PlanarImage srcIMG = this.getSourceImage(0);
        if (this.extender == null) {
            sources[0] = srcIMG.getData(srcRect);
            if (this.hasROI && this.useROIAccessor) {
                rois[0] = this.srcROIImage.getBounds().contains(srcRect) ? this.srcROIImage.getData(srcRect) : this.srcROIImgExt.getData(srcRect);
            }
        } else {
            sources[0] = srcIMG.getBounds().contains(srcRect) ? srcIMG.getData(srcRect) : this.extendedIMG.getData(srcRect);
            if (this.hasROI && this.useROIAccessor) {
                rois[0] = this.srcROIImage.getBounds().contains(srcRect) ? this.srcROIImage.getData(srcRect) : this.srcROIImgExt.getData(srcRect);
            }
        }
        if (this.hasROI && this.useROIAccessor) {
            this.computeRect(sources, dest, destRect, rois);
        } else {
            this.computeRect(sources, dest, destRect);
        }
        if (this.getSourceImage(0).overlapsMultipleTiles(srcRect) && !this.isBinary) {
            this.recycleTile(sources[0]);
        }
        return dest;
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        this.computeRect(sources, dest, destRect, null);
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect, Raster[] rois) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        Raster source = sources[0];
        Rectangle srcRect = source.getBounds();
        int srcRectX = srcRect.x;
        int srcRectY = srcRect.y;
        RasterAccessor srcAccessor = new RasterAccessor(source, srcRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor dstAccessor = new RasterAccessor((Raster)dest, destRect, formatTags[1], this.getColorModel());
        RasterAccessor roiAccessor = null;
        Raster roi = null;
        if (rois != null) {
            roi = rois[0];
            roiAccessor = new RasterAccessor(roi, srcRect, RasterAccessor.findCompatibleTags((RenderedImage[])new RenderedImage[]{this.srcROIImage}, (RenderedImage)this.srcROIImage)[0], this.srcROIImage.getColorModel());
        }
        int dataType = dest.getSampleModel().getDataType();
        if (!this.isBinary) {
            switch (dataType) {
                case 0: {
                    this.byteLoop(dataType, srcAccessor, destRect, srcRectX, srcRectY, dstAccessor, roiAccessor);
                    break;
                }
                case 3: {
                    this.intLoop(dataType, srcAccessor, destRect, srcRectX, srcRectY, dstAccessor, roiAccessor);
                    break;
                }
                case 2: {
                    this.shortLoop(dataType, srcAccessor, destRect, srcRectX, srcRectY, dstAccessor, roiAccessor);
                    break;
                }
                case 1: {
                    this.ushortLoop(dataType, srcAccessor, destRect, srcRectX, srcRectY, dstAccessor, roiAccessor);
                    break;
                }
                case 4: {
                    this.floatLoop(dataType, srcAccessor, destRect, srcRectX, srcRectY, dstAccessor, roiAccessor);
                    break;
                }
                case 5: {
                    this.doubleLoop(dataType, srcAccessor, destRect, srcRectX, srcRectY, dstAccessor, roiAccessor);
                }
            }
        } else {
            dataType = source.getSampleModel().getDataType();
            switch (dataType) {
                case 0: {
                    this.byteLoopBinary(dataType, srcAccessor, source, dest, destRect, roi, srcRectX, srcRectY);
                    break;
                }
                case 3: {
                    this.intLoopBinary(dataType, srcAccessor, source, dest, destRect, roi, srcRectX, srcRectY);
                    break;
                }
                case 1: 
                case 2: {
                    this.ushortLoopBinary(dataType, srcAccessor, source, dest, destRect, roi, srcRectX, srcRectY);
                }
            }
        }
        if (dstAccessor.isDataCopy() && !this.isBinary) {
            dstAccessor.clampDataArrays();
            dstAccessor.copyDataToRaster();
        }
    }

    private void byteLoop(int dataType, RasterAccessor src, Rectangle destRect, int srcRectX, int srcRectY, RasterAccessor dst, RasterAccessor roiAccessor) {
        int[][] samples = new int[this.interp_height][this.interp_width];
        float src_rect_x1 = src.getX();
        float src_rect_y1 = src.getY();
        float src_rect_x2 = src_rect_x1 + (float)src.getWidth();
        float src_rect_y2 = src_rect_y1 + (float)src.getHeight();
        int dstOffset = 0;
        Point2D.Float dst_pt = new Point2D.Float();
        Point2D.Float src_pt = new Point2D.Float();
        byte[][] dstDataArrays = dst.getByteDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        byte[][] srcDataArrays = src.getByteDataArrays();
        int[] bandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        int dst_num_bands = dst.getNumBands();
        int roiScanlineStride = 0;
        if (roiAccessor != null) {
            roiScanlineStride = roiAccessor.getScanlineStride();
        }
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        Integer posyROI = null;
        Number[] fracValues = new Number[2];
        for (int y = dst_min_y; y < dst_max_y; ++y) {
            int dstPixelOffset = dstOffset;
            ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
            this.mapDestPoint(dst_pt, src_pt);
            float s_x = (float)((Point2D)src_pt).getX();
            float s_y = (float)((Point2D)src_pt).getY();
            if (this.interpN == null || !(this.interp instanceof InterpolationNearest)) {
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
            }
            int s_ix = (int)Math.floor(s_x);
            int s_iy = (int)Math.floor(s_y);
            float fracx = s_x - (float)s_ix;
            float fracy = s_y - (float)s_iy;
            int xfrac = (int)(fracx * (float)this.shiftvalue);
            int yfrac = (int)(fracy * (float)this.shiftvalue);
            if (dataType < 4) {
                fracValues[0] = xfrac;
                fracValues[1] = yfrac;
            } else {
                fracValues[0] = Float.valueOf(fracx);
                fracValues[1] = Float.valueOf(fracy);
            }
            int posy = (s_iy - srcRectY) * srcScanlineStride;
            int posx = (s_ix - srcRectX) * srcPixelStride;
            int ifracx = (int)Math.floor(fracx * 1048576.0f);
            int ifracy = (int)Math.floor(fracy * 1048576.0f);
            if (roiAccessor != null) {
                posyROI = (s_iy - srcRectY) * roiScanlineStride;
            }
            for (int x = dst_min_x; x < dst_max_x; ++x) {
                if ((float)s_ix >= src_rect_x1 + (float)this.interp_left && (float)s_ix < src_rect_x2 - (float)this.interp_right && (float)s_iy >= src_rect_y1 + (float)this.interp_top && (float)s_iy < src_rect_y2 - (float)this.interp_bottom) {
                    for (int k2 = 0; k2 < dst_num_bands; ++k2) {
                        float result = 0.0f;
                        int s = 0;
                        int posyy = posy + bandOffsets[k2];
                        if (this.interpN != null) {
                            result = this.interpN.interpolate(src, k2, dst_num_bands, posx, posyy, posyROI, roiAccessor, false).intValue();
                        } else if (this.interpB != null) {
                            result = this.interpB.interpolate(src, k2, dst_num_bands, posx, posyy, fracValues, posyROI, roiAccessor, false).intValue();
                        } else if (this.interpBN != null) {
                            result = this.interpBN.interpolate(src, k2, dst_num_bands, posx, posyy, fracValues, posyROI, roiAccessor, false).intValue();
                        } else {
                            byte[] srcData = srcDataArrays[k2];
                            int tmp = bandOffsets[k2];
                            int start = this.interp_left * srcPixelStride + this.interp_top * srcScanlineStride;
                            start = posx + posy - start;
                            int countH = 0;
                            int countV = 0;
                            for (int i = 0; i < this.interp_height; ++i) {
                                int startY = start;
                                for (int j = 0; j < this.interp_width; ++j) {
                                    samples[countV][countH++] = srcData[start + tmp] & 0xFF;
                                    start += srcPixelStride;
                                }
                                ++countV;
                                countH = 0;
                                start = startY + srcScanlineStride;
                            }
                            xfrac = (int)(fracx * (float)this.shiftvalue);
                            yfrac = (int)(fracy * (float)this.shiftvalue);
                            result = this.interp.interpolate(samples, xfrac, yfrac);
                        }
                        s = this.interpN == null || !(this.interp instanceof InterpolationNearest) ? (result < 0.5f ? 0 : (result > 254.5f ? 255 : (int)result)) : (int)result;
                        dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = (byte)(s & 0xFF);
                    }
                } else if (this.setDestinationNoData) {
                    for (int k = 0; k < dst_num_bands; ++k) {
                        dstDataArrays[k][dstPixelOffset + dstBandOffsets[k]] = (byte)this.destinationNoData[k];
                    }
                }
                if (this.interpN == null || !(this.interp instanceof InterpolationNearest)) {
                    if ((double)fracx < this.fracdx1) {
                        s_ix += this.incx;
                        fracx = (float)((double)fracx + this.fracdx);
                    } else {
                        s_ix += this.incx1;
                        fracx = (float)((double)fracx - this.fracdx1);
                    }
                    if ((double)fracy < this.fracdy1) {
                        s_iy += this.incy;
                        fracy = (float)((double)fracy + this.fracdy);
                    } else {
                        s_iy += this.incy1;
                        fracy = (float)((double)fracy - this.fracdy1);
                    }
                } else {
                    if (ifracx < this.ifracdx1) {
                        s_ix += this.incx;
                        ifracx += this.ifracdx;
                    } else {
                        s_ix += this.incx1;
                        ifracx -= this.ifracdx1;
                    }
                    if (ifracy < this.ifracdy1) {
                        s_iy += this.incy;
                        ifracy += this.ifracdy;
                    } else {
                        s_iy += this.incy1;
                        ifracy -= this.ifracdy1;
                    }
                }
                posy = (s_iy - srcRectY) * srcScanlineStride;
                posx = (s_ix - srcRectX) * srcPixelStride;
                if (roiAccessor != null) {
                    posyROI = (s_iy - srcRectY) * roiScanlineStride;
                }
                dstPixelOffset += dstPixelStride;
            }
            dstOffset += dstScanlineStride;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void byteLoopBinary(int dataType, RasterAccessor src, Raster source, WritableRaster dest, Rectangle destRect, Raster roi, int srcRectX, int srcRectY) {
        float src_rect_x1 = source.getMinX();
        float src_rect_y1 = source.getMinY();
        float src_rect_x2 = src_rect_x1 + (float)source.getWidth();
        float src_rect_y2 = src_rect_y1 + (float)source.getHeight();
        MultiPixelPackedSampleModel sourceSM = (MultiPixelPackedSampleModel)source.getSampleModel();
        DataBufferByte sourceDB = (DataBufferByte)source.getDataBuffer();
        int sourceTransX = source.getSampleModelTranslateX();
        int sourceTransY = source.getSampleModelTranslateY();
        int sourceDataBitOffset = sourceSM.getDataBitOffset();
        int sourceScanlineStride = sourceSM.getScanlineStride();
        int sourcePixelStride = sourceSM.getPixelBitStride();
        MultiPixelPackedSampleModel destSM = (MultiPixelPackedSampleModel)dest.getSampleModel();
        DataBufferByte destDB = (DataBufferByte)dest.getDataBuffer();
        int destTransX = dest.getSampleModelTranslateX();
        int destTransY = dest.getSampleModelTranslateY();
        int destDataBitOffset = destSM.getDataBitOffset();
        int destScanlineStride = destSM.getScanlineStride();
        byte[] sourceData = sourceDB.getData();
        Number[] sourceDataNum = new Number[sourceData.length];
        for (int i = 0; i < sourceData.length; ++i) {
            sourceDataNum[i] = sourceData[i];
        }
        int sourceDBOffset = sourceDB.getOffset();
        byte[] destData = destDB.getData();
        int destDBOffset = destDB.getOffset();
        Point2D.Float dst_pt = new Point2D.Float();
        Point2D.Float src_pt = new Point2D.Float();
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        int s = 0;
        int[] coordinates = new int[2];
        int[] roiData = null;
        int roiDBOffset = 0;
        MultiPixelPackedSampleModel roiSM = null;
        int roiTransY = 0;
        int roiScanlineStride = 0;
        if (roi != null) {
            roiSM = (MultiPixelPackedSampleModel)roi.getSampleModel();
            roiTransY = roi.getSampleModelTranslateY();
            roiScanlineStride = roiSM.getScanlineStride();
            DataBuffer roiDB = roi.getDataBuffer();
            roiDBOffset = roiDB.getOffset();
            DataBufferByte roiDBByte = (DataBufferByte)roiDB;
            byte[] roiDataB = roiDBByte.getData();
            roiData = new int[roiDataB.length];
            for (int ii = 0; ii < roiDataB.length; ++ii) {
                roiData[ii] = roiDataB[ii];
            }
        }
        for (int y = dst_min_y; y < dst_max_y; ++y) {
            ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
            this.mapDestPoint(dst_pt, src_pt);
            float s_x = (float)((Point2D)src_pt).getX();
            float s_y = (float)((Point2D)src_pt).getY();
            int s_ix = (int)Math.floor(s_x);
            int s_iy = (int)Math.floor(s_y);
            double fracx = (double)s_x - (double)s_ix;
            double fracy = (double)s_y - (double)s_iy;
            int xfrac = (int)(fracx * (double)this.shiftvalue);
            int yfrac = (int)(fracy * (double)this.shiftvalue);
            int ifracx = (int)Math.floor(fracx * 1048576.0);
            int ifracy = (int)Math.floor(fracy * 1048576.0);
            int destYOffset = (y - destTransY) * destScanlineStride + destDBOffset;
            int destXOffset = destDataBitOffset + (dst_min_x - destTransX);
            int sourceYOffset = (s_iy - sourceTransY) * sourceScanlineStride + sourceDBOffset;
            int roiYOffset = (s_iy - roiTransY) * roiScanlineStride + roiDBOffset;
            for (int x = dst_min_x; x < dst_max_x; ++x) {
                sourceYOffset = (s_iy - sourceTransY) * sourceScanlineStride + sourceDBOffset;
                roiYOffset = (s_iy - roiTransY) * roiScanlineStride + roiDBOffset;
                int dindex = 0;
                if ((float)s_ix >= src_rect_x1 + (float)this.interp_left && (float)s_ix < src_rect_x2 - (float)this.interp_right && (float)s_iy >= src_rect_y1 + (float)this.interp_top && (float)s_iy < src_rect_y2 - (float)this.interp_bottom) {
                    coordinates[0] = src.getX() + (s_ix - srcRectX) * sourcePixelStride;
                    coordinates[1] = src.getY() + (s_iy - srcRectY) * sourceScanlineStride / sourceScanlineStride;
                    int xNextBitNo = sourceDataBitOffset + (s_ix + 1 - sourceTransX);
                    if (this.interpN != null) {
                        s = this.interpN.interpolateBinary(xNextBitNo, sourceDataNum, sourceYOffset, sourceScanlineStride, coordinates, roiData, roiYOffset, roiScanlineStride);
                    } else if (this.interpB != null) {
                        s = this.interpB.interpolateBinary(xNextBitNo, sourceDataNum, xfrac, yfrac, sourceYOffset, sourceScanlineStride, coordinates, roiData, roiYOffset, roiScanlineStride);
                    } else {
                        if (this.interpBN == null) throw new UnsupportedOperationException("Binary interpolation not supported for interpolators different fromInterpolatorNearestNew,InterpolatorBinaryNew,InterpolatorBicubicNew");
                        s = this.interpBN.interpolateBinary(xNextBitNo, sourceDataNum, xfrac, yfrac, sourceYOffset, sourceScanlineStride, coordinates, roiData, roiYOffset, roiScanlineStride);
                    }
                } else if (this.setDestinationNoData) {
                    s = this.black;
                }
                dindex = destYOffset + (destXOffset >> 3);
                int dshift = 7 - (destXOffset & 7);
                if (s == 1) {
                    int n = dindex;
                    destData[n] = (byte)(destData[n] | 1 << dshift);
                } else {
                    int n = dindex;
                    destData[n] = (byte)(destData[n] & 255 - (1 << dshift));
                }
                if (this.interpN == null || !(this.interp instanceof InterpolationNearest)) {
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        fracx += this.fracdx;
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        fracy += this.fracdy;
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                } else {
                    if (ifracx < this.ifracdx1) {
                        s_ix += this.incx;
                        ifracx += this.ifracdx;
                    } else {
                        s_ix += this.incx1;
                        ifracx -= this.ifracdx1;
                    }
                    if (ifracy < this.ifracdy1) {
                        s_iy += this.incy;
                        ifracy += this.ifracdy;
                    } else {
                        s_iy += this.incy1;
                        ifracy -= this.ifracdy1;
                    }
                }
                ++destXOffset;
            }
        }
    }

    private void ushortLoop(int dataType, RasterAccessor src, Rectangle destRect, int srcRectX, int srcRectY, RasterAccessor dst, RasterAccessor roiAccessor) {
        int[][] samples = new int[this.interp_height][this.interp_width];
        float src_rect_x1 = src.getX();
        float src_rect_y1 = src.getY();
        float src_rect_x2 = src_rect_x1 + (float)src.getWidth();
        float src_rect_y2 = src_rect_y1 + (float)src.getHeight();
        int dstOffset = 0;
        Point2D.Float dst_pt = new Point2D.Float();
        Point2D.Float src_pt = new Point2D.Float();
        short[][] dstDataArrays = dst.getShortDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        short[][] srcDataArrays = src.getShortDataArrays();
        int[] bandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        int dst_num_bands = dst.getNumBands();
        int roiScanlineStride = 0;
        if (roiAccessor != null) {
            roiScanlineStride = roiAccessor.getScanlineStride();
        }
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        Integer posyROI = null;
        Number[] fracValues = new Number[2];
        for (int y = dst_min_y; y < dst_max_y; ++y) {
            int dstPixelOffset = dstOffset;
            ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
            this.mapDestPoint(dst_pt, src_pt);
            float s_x = (float)((Point2D)src_pt).getX();
            float s_y = (float)((Point2D)src_pt).getY();
            if (this.interpN == null || !(this.interp instanceof InterpolationNearest)) {
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
            }
            int s_ix = (int)Math.floor(s_x);
            int s_iy = (int)Math.floor(s_y);
            float fracx = s_x - (float)s_ix;
            float fracy = s_y - (float)s_iy;
            int xfrac = (int)(fracx * (float)this.shiftvalue);
            int yfrac = (int)(fracy * (float)this.shiftvalue);
            if (dataType < 4) {
                fracValues[0] = xfrac;
                fracValues[1] = yfrac;
            } else {
                fracValues[0] = Float.valueOf(fracx);
                fracValues[1] = Float.valueOf(fracy);
            }
            int posy = (s_iy - srcRectY) * srcScanlineStride;
            int posx = (s_ix - srcRectX) * srcPixelStride;
            int ifracx = (int)Math.floor(fracx * 1048576.0f);
            int ifracy = (int)Math.floor(fracy * 1048576.0f);
            if (roiAccessor != null) {
                posyROI = (s_iy - srcRectY) * roiScanlineStride;
            }
            for (int x = dst_min_x; x < dst_max_x; ++x) {
                if ((float)s_ix >= src_rect_x1 + (float)this.interp_left && (float)s_ix < src_rect_x2 - (float)this.interp_right && (float)s_iy >= src_rect_y1 + (float)this.interp_top && (float)s_iy < src_rect_y2 - (float)this.interp_bottom) {
                    for (int k2 = 0; k2 < dst_num_bands; ++k2) {
                        float result = 0.0f;
                        int s = 0;
                        int posyy = posy + bandOffsets[k2];
                        if (this.interpN != null) {
                            result = this.interpN.interpolate(src, k2, dst_num_bands, posx, posyy, posyROI, roiAccessor, false).intValue();
                        } else if (this.interpB != null) {
                            result = this.interpB.interpolate(src, k2, dst_num_bands, posx, posyy, fracValues, posyROI, roiAccessor, false).intValue();
                        } else if (this.interpBN != null) {
                            result = this.interpBN.interpolate(src, k2, dst_num_bands, posx, posyy, fracValues, posyROI, roiAccessor, false).intValue();
                        } else {
                            short[] srcData = srcDataArrays[k2];
                            int tmp = bandOffsets[k2];
                            int start = this.interp_left * srcPixelStride + this.interp_top * srcScanlineStride;
                            start = posx + posy - start;
                            int countH = 0;
                            int countV = 0;
                            for (int i = 0; i < this.interp_height; ++i) {
                                int startY = start;
                                for (int j = 0; j < this.interp_width; ++j) {
                                    samples[countV][countH++] = srcData[start + tmp] & 0xFFFF;
                                    start += srcPixelStride;
                                }
                                ++countV;
                                countH = 0;
                                start = startY + srcScanlineStride;
                            }
                            xfrac = (int)(fracx * (float)this.shiftvalue);
                            yfrac = (int)(fracy * (float)this.shiftvalue);
                            result = this.interp.interpolate(samples, xfrac, yfrac);
                        }
                        s = this.interpN == null || !(this.interp instanceof InterpolationNearest) ? (result < 0.0f ? 0 : (result > 65535.0f ? 65535 : (int)result)) : (int)result;
                        dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = (short)(s & 0xFFFF);
                    }
                } else if (this.setDestinationNoData) {
                    for (int k = 0; k < dst_num_bands; ++k) {
                        dstDataArrays[k][dstPixelOffset + dstBandOffsets[k]] = (short)this.destinationNoData[k];
                    }
                }
                if (this.interpN == null || !(this.interp instanceof InterpolationNearest)) {
                    if ((double)fracx < this.fracdx1) {
                        s_ix += this.incx;
                        fracx = (float)((double)fracx + this.fracdx);
                    } else {
                        s_ix += this.incx1;
                        fracx = (float)((double)fracx - this.fracdx1);
                    }
                    if ((double)fracy < this.fracdy1) {
                        s_iy += this.incy;
                        fracy = (float)((double)fracy + this.fracdy);
                    } else {
                        s_iy += this.incy1;
                        fracy = (float)((double)fracy - this.fracdy1);
                    }
                } else {
                    if (ifracx < this.ifracdx1) {
                        s_ix += this.incx;
                        ifracx += this.ifracdx;
                    } else {
                        s_ix += this.incx1;
                        ifracx -= this.ifracdx1;
                    }
                    if (ifracy < this.ifracdy1) {
                        s_iy += this.incy;
                        ifracy += this.ifracdy;
                    } else {
                        s_iy += this.incy1;
                        ifracy -= this.ifracdy1;
                    }
                }
                posy = (s_iy - srcRectY) * srcScanlineStride;
                posx = (s_ix - srcRectX) * srcPixelStride;
                if (roiAccessor != null) {
                    posyROI = (s_iy - srcRectY) * roiScanlineStride;
                }
                dstPixelOffset += dstPixelStride;
            }
            dstOffset += dstScanlineStride;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void ushortLoopBinary(int dataType, RasterAccessor src, Raster source, WritableRaster dest, Rectangle destRect, Raster roi, int srcRectX, int srcRectY) {
        float src_rect_x1 = source.getMinX();
        float src_rect_y1 = source.getMinY();
        float src_rect_x2 = src_rect_x1 + (float)source.getWidth();
        float src_rect_y2 = src_rect_y1 + (float)source.getHeight();
        MultiPixelPackedSampleModel sourceSM = (MultiPixelPackedSampleModel)source.getSampleModel();
        DataBuffer sourceDBUS = source.getDataBuffer();
        DataBufferUShort sourceDB = (DataBufferUShort)sourceDBUS;
        int sourceTransX = source.getSampleModelTranslateX();
        int sourceTransY = source.getSampleModelTranslateY();
        int sourceDataBitOffset = sourceSM.getDataBitOffset();
        int sourceScanlineStride = sourceSM.getScanlineStride();
        int sourcePixelStride = sourceSM.getPixelBitStride();
        MultiPixelPackedSampleModel destSM = (MultiPixelPackedSampleModel)dest.getSampleModel();
        DataBufferUShort destDB = (DataBufferUShort)dest.getDataBuffer();
        int destTransX = dest.getSampleModelTranslateX();
        int destTransY = dest.getSampleModelTranslateY();
        int destDataBitOffset = destSM.getDataBitOffset();
        int destScanlineStride = destSM.getScanlineStride();
        short[] sourceData = sourceDB.getData();
        Number[] sourceDataNum = new Number[sourceData.length];
        for (int i = 0; i < sourceData.length; ++i) {
            sourceDataNum[i] = sourceData[i];
        }
        int sourceDBOffset = sourceDB.getOffset();
        short[] destData = destDB.getData();
        int destDBOffset = destDB.getOffset();
        Point2D.Float dst_pt = new Point2D.Float();
        Point2D.Float src_pt = new Point2D.Float();
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        int s = 0;
        int[] coordinates = new int[2];
        int[] roiData = null;
        int roiDBOffset = 0;
        MultiPixelPackedSampleModel roiSM = null;
        int roiTransY = 0;
        int roiScanlineStride = 0;
        if (roi != null) {
            roiSM = (MultiPixelPackedSampleModel)roi.getSampleModel();
            roiTransY = roi.getSampleModelTranslateY();
            roiScanlineStride = roiSM.getScanlineStride();
            DataBuffer roiDB = roi.getDataBuffer();
            roiDBOffset = roiDB.getOffset();
            DataBufferByte roiDBByte = (DataBufferByte)roiDB;
            byte[] roiDataB = roiDBByte.getData();
            roiData = new int[roiDataB.length];
            for (int ii = 0; ii < roiDataB.length; ++ii) {
                roiData[ii] = roiDataB[ii];
            }
        }
        for (int y = dst_min_y; y < dst_max_y; ++y) {
            ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
            this.mapDestPoint(dst_pt, src_pt);
            float s_x = (float)((Point2D)src_pt).getX();
            float s_y = (float)((Point2D)src_pt).getY();
            int s_ix = (int)Math.floor(s_x);
            int s_iy = (int)Math.floor(s_y);
            double fracx = (double)s_x - (double)s_ix;
            double fracy = (double)s_y - (double)s_iy;
            int xfrac = (int)(fracx * (double)this.shiftvalue);
            int yfrac = (int)(fracy * (double)this.shiftvalue);
            int ifracx = (int)Math.floor(fracx * 1048576.0);
            int ifracy = (int)Math.floor(fracy * 1048576.0);
            int destYOffset = (y - destTransY) * destScanlineStride + destDBOffset;
            int destXOffset = destDataBitOffset + (dst_min_x - destTransX);
            int sourceYOffset = (s_iy - sourceTransY) * sourceScanlineStride + sourceDBOffset;
            int roiYOffset = (s_iy - roiTransY) * roiScanlineStride + roiDBOffset;
            for (int x = dst_min_x; x < dst_max_x; ++x) {
                sourceYOffset = (s_iy - sourceTransY) * sourceScanlineStride + sourceDBOffset;
                roiYOffset = (s_iy - roiTransY) * roiScanlineStride + roiDBOffset;
                int dindex = 0;
                if ((float)s_ix >= src_rect_x1 + (float)this.interp_left && (float)s_ix < src_rect_x2 - (float)this.interp_right && (float)s_iy >= src_rect_y1 + (float)this.interp_top && (float)s_iy < src_rect_y2 - (float)this.interp_bottom) {
                    coordinates[0] = src.getX() + (s_ix - srcRectX) * sourcePixelStride;
                    coordinates[1] = src.getY() + (s_iy - srcRectY) * sourceScanlineStride / sourceScanlineStride;
                    int xNextBitNo = sourceDataBitOffset + (s_ix + 1 - sourceTransX);
                    if (this.interpN != null) {
                        s = this.interpN.interpolateBinary(xNextBitNo, sourceDataNum, sourceYOffset, sourceScanlineStride, coordinates, roiData, roiYOffset, roiScanlineStride);
                    } else if (this.interpB != null) {
                        s = this.interpB.interpolateBinary(xNextBitNo, sourceDataNum, xfrac, yfrac, sourceYOffset, sourceScanlineStride, coordinates, roiData, roiYOffset, roiScanlineStride);
                    } else {
                        if (this.interpBN == null) throw new UnsupportedOperationException("Binary interpolation not supported for interpolators different fromInterpolatorNearestNew,InterpolatorBinaryNew,InterpolatorBicubicNew");
                        s = this.interpBN.interpolateBinary(xNextBitNo, sourceDataNum, xfrac, yfrac, sourceYOffset, sourceScanlineStride, coordinates, roiData, roiYOffset, roiScanlineStride);
                    }
                } else if (this.setDestinationNoData) {
                    s = this.black;
                }
                dindex = destYOffset + (destXOffset >> 4);
                int dshift = 15 - (destXOffset & 0xF);
                if (s == 1) {
                    int n = dindex;
                    destData[n] = (short)(destData[n] | 1 << dshift);
                } else {
                    int n = dindex;
                    destData[n] = (short)(destData[n] & 65535 - (1 << dshift));
                }
                if (this.interpN == null || !(this.interp instanceof InterpolationNearest)) {
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        fracx += this.fracdx;
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        fracy += this.fracdy;
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                } else {
                    if (ifracx < this.ifracdx1) {
                        s_ix += this.incx;
                        ifracx += this.ifracdx;
                    } else {
                        s_ix += this.incx1;
                        ifracx -= this.ifracdx1;
                    }
                    if (ifracy < this.ifracdy1) {
                        s_iy += this.incy;
                        ifracy += this.ifracdy;
                    } else {
                        s_iy += this.incy1;
                        ifracy -= this.ifracdy1;
                    }
                }
                ++destXOffset;
            }
        }
    }

    private void shortLoop(int dataType, RasterAccessor src, Rectangle destRect, int srcRectX, int srcRectY, RasterAccessor dst, RasterAccessor roiAccessor) {
        int[][] samples = new int[this.interp_height][this.interp_width];
        float src_rect_x1 = src.getX();
        float src_rect_y1 = src.getY();
        float src_rect_x2 = src_rect_x1 + (float)src.getWidth();
        float src_rect_y2 = src_rect_y1 + (float)src.getHeight();
        int dstOffset = 0;
        Point2D.Float dst_pt = new Point2D.Float();
        Point2D.Float src_pt = new Point2D.Float();
        short[][] dstDataArrays = dst.getShortDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        short[][] srcDataArrays = src.getShortDataArrays();
        int[] bandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        int dst_num_bands = dst.getNumBands();
        int roiScanlineStride = 0;
        if (roiAccessor != null) {
            roiScanlineStride = roiAccessor.getScanlineStride();
        }
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        Integer posyROI = null;
        Number[] fracValues = new Number[2];
        for (int y = dst_min_y; y < dst_max_y; ++y) {
            int dstPixelOffset = dstOffset;
            ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
            this.mapDestPoint(dst_pt, src_pt);
            float s_x = (float)((Point2D)src_pt).getX();
            float s_y = (float)((Point2D)src_pt).getY();
            if (this.interpN == null || !(this.interp instanceof InterpolationNearest)) {
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
            }
            int s_ix = (int)Math.floor(s_x);
            int s_iy = (int)Math.floor(s_y);
            float fracx = s_x - (float)s_ix;
            float fracy = s_y - (float)s_iy;
            int xfrac = (int)(fracx * (float)this.shiftvalue);
            int yfrac = (int)(fracy * (float)this.shiftvalue);
            if (dataType < 4) {
                fracValues[0] = xfrac;
                fracValues[1] = yfrac;
            } else {
                fracValues[0] = Float.valueOf(fracx);
                fracValues[1] = Float.valueOf(fracy);
            }
            int posy = (s_iy - srcRectY) * srcScanlineStride;
            int posx = (s_ix - srcRectX) * srcPixelStride;
            int ifracx = (int)Math.floor(fracx * 1048576.0f);
            int ifracy = (int)Math.floor(fracy * 1048576.0f);
            if (roiAccessor != null) {
                posyROI = (s_iy - srcRectY) * roiScanlineStride;
            }
            for (int x = dst_min_x; x < dst_max_x; ++x) {
                if ((float)s_ix >= src_rect_x1 + (float)this.interp_left && (float)s_ix < src_rect_x2 - (float)this.interp_right && (float)s_iy >= src_rect_y1 + (float)this.interp_top && (float)s_iy < src_rect_y2 - (float)this.interp_bottom) {
                    for (int k2 = 0; k2 < dst_num_bands; ++k2) {
                        float result = 0.0f;
                        int s = 0;
                        int posyy = posy + bandOffsets[k2];
                        if (this.interpN != null) {
                            result = this.interpN.interpolate(src, k2, dst_num_bands, posx, posyy, posyROI, roiAccessor, false).intValue();
                        } else if (this.interpB != null) {
                            result = this.interpB.interpolate(src, k2, dst_num_bands, posx, posyy, fracValues, posyROI, roiAccessor, false).intValue();
                        } else if (this.interpBN != null) {
                            result = this.interpBN.interpolate(src, k2, dst_num_bands, posx, posyy, fracValues, posyROI, roiAccessor, false).intValue();
                        } else {
                            short[] srcData = srcDataArrays[k2];
                            int tmp = bandOffsets[k2];
                            int start = this.interp_left * srcPixelStride + this.interp_top * srcScanlineStride;
                            start = posx + posy - start;
                            int countH = 0;
                            int countV = 0;
                            for (int i = 0; i < this.interp_height; ++i) {
                                int startY = start;
                                for (int j = 0; j < this.interp_width; ++j) {
                                    samples[countV][countH++] = srcData[start + tmp];
                                    start += srcPixelStride;
                                }
                                ++countV;
                                countH = 0;
                                start = startY + srcScanlineStride;
                            }
                            xfrac = (int)(fracx * (float)this.shiftvalue);
                            yfrac = (int)(fracy * (float)this.shiftvalue);
                            result = this.interp.interpolate(samples, xfrac, yfrac);
                        }
                        s = result < -32768.0f ? Short.MIN_VALUE : (result > 32767.0f ? Short.MAX_VALUE : (int)result);
                        dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = (short)s;
                    }
                } else if (this.setDestinationNoData) {
                    for (int k = 0; k < dst_num_bands; ++k) {
                        dstDataArrays[k][dstPixelOffset + dstBandOffsets[k]] = (short)this.destinationNoData[k];
                    }
                }
                if (this.interpN == null || !(this.interp instanceof InterpolationNearest)) {
                    if ((double)fracx < this.fracdx1) {
                        s_ix += this.incx;
                        fracx = (float)((double)fracx + this.fracdx);
                    } else {
                        s_ix += this.incx1;
                        fracx = (float)((double)fracx - this.fracdx1);
                    }
                    if ((double)fracy < this.fracdy1) {
                        s_iy += this.incy;
                        fracy = (float)((double)fracy + this.fracdy);
                    } else {
                        s_iy += this.incy1;
                        fracy = (float)((double)fracy - this.fracdy1);
                    }
                } else {
                    if (ifracx < this.ifracdx1) {
                        s_ix += this.incx;
                        ifracx += this.ifracdx;
                    } else {
                        s_ix += this.incx1;
                        ifracx -= this.ifracdx1;
                    }
                    if (ifracy < this.ifracdy1) {
                        s_iy += this.incy;
                        ifracy += this.ifracdy;
                    } else {
                        s_iy += this.incy1;
                        ifracy -= this.ifracdy1;
                    }
                }
                posy = (s_iy - srcRectY) * srcScanlineStride;
                posx = (s_ix - srcRectX) * srcPixelStride;
                if (roiAccessor != null) {
                    posyROI = (s_iy - srcRectY) * roiScanlineStride;
                }
                dstPixelOffset += dstPixelStride;
            }
            dstOffset += dstScanlineStride;
        }
    }

    private void intLoop(int dataType, RasterAccessor src, Rectangle destRect, int srcRectX, int srcRectY, RasterAccessor dst, RasterAccessor roiAccessor) {
        int[][] samples = new int[this.interp_height][this.interp_width];
        float src_rect_x1 = src.getX();
        float src_rect_y1 = src.getY();
        float src_rect_x2 = src_rect_x1 + (float)src.getWidth();
        float src_rect_y2 = src_rect_y1 + (float)src.getHeight();
        int dstOffset = 0;
        Point2D.Float dst_pt = new Point2D.Float();
        Point2D.Float src_pt = new Point2D.Float();
        int[][] dstDataArrays = dst.getIntDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        int[][] srcDataArrays = src.getIntDataArrays();
        int[] bandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        int dst_num_bands = dst.getNumBands();
        int roiScanlineStride = 0;
        if (roiAccessor != null) {
            roiScanlineStride = roiAccessor.getScanlineStride();
        }
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        Integer posyROI = null;
        Number[] fracValues = new Number[2];
        for (int y = dst_min_y; y < dst_max_y; ++y) {
            int dstPixelOffset = dstOffset;
            ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
            this.mapDestPoint(dst_pt, src_pt);
            float s_x = (float)((Point2D)src_pt).getX();
            float s_y = (float)((Point2D)src_pt).getY();
            if (this.interpN == null || !(this.interp instanceof InterpolationNearest)) {
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
            }
            int s_ix = (int)Math.floor(s_x);
            int s_iy = (int)Math.floor(s_y);
            float fracx = s_x - (float)s_ix;
            float fracy = s_y - (float)s_iy;
            int xfrac = (int)(fracx * (float)this.shiftvalue);
            int yfrac = (int)(fracy * (float)this.shiftvalue);
            if (dataType < 4) {
                fracValues[0] = xfrac;
                fracValues[1] = yfrac;
            } else {
                fracValues[0] = Float.valueOf(fracx);
                fracValues[1] = Float.valueOf(fracy);
            }
            int posy = (s_iy - srcRectY) * srcScanlineStride;
            int posx = (s_ix - srcRectX) * srcPixelStride;
            int ifracx = (int)Math.floor(fracx * 1048576.0f);
            int ifracy = (int)Math.floor(fracy * 1048576.0f);
            if (roiAccessor != null) {
                posyROI = (s_iy - srcRectY) * roiScanlineStride;
            }
            for (int x = dst_min_x; x < dst_max_x; ++x) {
                if ((float)s_ix >= src_rect_x1 + (float)this.interp_left && (float)s_ix < src_rect_x2 - (float)this.interp_right && (float)s_iy >= src_rect_y1 + (float)this.interp_top && (float)s_iy < src_rect_y2 - (float)this.interp_bottom) {
                    for (int k2 = 0; k2 < dst_num_bands; ++k2) {
                        float result = 0.0f;
                        int s = 0;
                        int posyy = posy + bandOffsets[k2];
                        if (this.interpN != null) {
                            result = this.interpN.interpolate(src, k2, dst_num_bands, posx, posyy, posyROI, roiAccessor, false).intValue();
                        } else if (this.interpB != null) {
                            result = this.interpB.interpolate(src, k2, dst_num_bands, posx, posyy, fracValues, posyROI, roiAccessor, false).intValue();
                        } else if (this.interpBN != null) {
                            result = this.interpBN.interpolate(src, k2, dst_num_bands, posx, posyy, fracValues, posyROI, roiAccessor, false).intValue();
                        } else {
                            int[] srcData = srcDataArrays[k2];
                            int tmp = bandOffsets[k2];
                            int start = this.interp_left * srcPixelStride + this.interp_top * srcScanlineStride;
                            start = posx + posy - start;
                            int countH = 0;
                            int countV = 0;
                            for (int i = 0; i < this.interp_height; ++i) {
                                int startY = start;
                                for (int j = 0; j < this.interp_width; ++j) {
                                    samples[countV][countH++] = srcData[start + tmp];
                                    start += srcPixelStride;
                                }
                                ++countV;
                                countH = 0;
                                start = startY + srcScanlineStride;
                            }
                            xfrac = (int)(fracx * (float)this.shiftvalue);
                            yfrac = (int)(fracy * (float)this.shiftvalue);
                            result = this.interp.interpolate(samples, xfrac, yfrac);
                        }
                        s = result < -2.1474836E9f ? Integer.MIN_VALUE : (result > 2.1474836E9f ? Integer.MAX_VALUE : (int)result);
                        dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = s;
                    }
                } else if (this.setDestinationNoData) {
                    for (int k = 0; k < dst_num_bands; ++k) {
                        dstDataArrays[k][dstPixelOffset + dstBandOffsets[k]] = (int)this.destinationNoData[k];
                    }
                }
                if (this.interpN == null || !(this.interp instanceof InterpolationNearest)) {
                    if ((double)fracx < this.fracdx1) {
                        s_ix += this.incx;
                        fracx = (float)((double)fracx + this.fracdx);
                    } else {
                        s_ix += this.incx1;
                        fracx = (float)((double)fracx - this.fracdx1);
                    }
                    if ((double)fracy < this.fracdy1) {
                        s_iy += this.incy;
                        fracy = (float)((double)fracy + this.fracdy);
                    } else {
                        s_iy += this.incy1;
                        fracy = (float)((double)fracy - this.fracdy1);
                    }
                } else {
                    if (ifracx < this.ifracdx1) {
                        s_ix += this.incx;
                        ifracx += this.ifracdx;
                    } else {
                        s_ix += this.incx1;
                        ifracx -= this.ifracdx1;
                    }
                    if (ifracy < this.ifracdy1) {
                        s_iy += this.incy;
                        ifracy += this.ifracdy;
                    } else {
                        s_iy += this.incy1;
                        ifracy -= this.ifracdy1;
                    }
                }
                posy = (s_iy - srcRectY) * srcScanlineStride;
                posx = (s_ix - srcRectX) * srcPixelStride;
                if (roiAccessor != null) {
                    posyROI = (s_iy - srcRectY) * roiScanlineStride;
                }
                dstPixelOffset += dstPixelStride;
            }
            dstOffset += dstScanlineStride;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void intLoopBinary(int dataType, RasterAccessor src, Raster source, WritableRaster dest, Rectangle destRect, Raster roi, int srcRectX, int srcRectY) {
        float src_rect_x1 = source.getMinX();
        float src_rect_y1 = source.getMinY();
        float src_rect_x2 = src_rect_x1 + (float)source.getWidth();
        float src_rect_y2 = src_rect_y1 + (float)source.getHeight();
        MultiPixelPackedSampleModel sourceSM = (MultiPixelPackedSampleModel)source.getSampleModel();
        DataBufferInt sourceDB = (DataBufferInt)source.getDataBuffer();
        int sourceTransX = source.getSampleModelTranslateX();
        int sourceTransY = source.getSampleModelTranslateY();
        int sourceDataBitOffset = sourceSM.getDataBitOffset();
        int sourceScanlineStride = sourceSM.getScanlineStride();
        int sourcePixelStride = sourceSM.getPixelBitStride();
        MultiPixelPackedSampleModel destSM = (MultiPixelPackedSampleModel)dest.getSampleModel();
        DataBufferInt destDB = (DataBufferInt)dest.getDataBuffer();
        int destTransX = dest.getSampleModelTranslateX();
        int destTransY = dest.getSampleModelTranslateY();
        int destDataBitOffset = destSM.getDataBitOffset();
        int destScanlineStride = destSM.getScanlineStride();
        int[] sourceData = sourceDB.getData();
        Number[] sourceDataNum = new Number[sourceData.length];
        for (int i = 0; i < sourceData.length; ++i) {
            sourceDataNum[i] = sourceData[i];
        }
        int sourceDBOffset = sourceDB.getOffset();
        int[] destData = destDB.getData();
        int destDBOffset = destDB.getOffset();
        Point2D.Float dst_pt = new Point2D.Float();
        Point2D.Float src_pt = new Point2D.Float();
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        int s = 0;
        int[] coordinates = new int[2];
        int[] roiData = null;
        int roiDBOffset = 0;
        MultiPixelPackedSampleModel roiSM = null;
        int roiTransY = 0;
        int roiScanlineStride = 0;
        if (roi != null) {
            roiSM = (MultiPixelPackedSampleModel)roi.getSampleModel();
            roiTransY = roi.getSampleModelTranslateY();
            roiScanlineStride = roiSM.getScanlineStride();
            DataBuffer roiDB = roi.getDataBuffer();
            roiDBOffset = roiDB.getOffset();
            DataBufferByte roiDBByte = (DataBufferByte)roiDB;
            byte[] roiDataB = roiDBByte.getData();
            roiData = new int[roiDataB.length];
            for (int ii = 0; ii < roiDataB.length; ++ii) {
                roiData[ii] = roiDataB[ii];
            }
        }
        for (int y = dst_min_y; y < dst_max_y; ++y) {
            ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
            this.mapDestPoint(dst_pt, src_pt);
            float s_x = (float)((Point2D)src_pt).getX();
            float s_y = (float)((Point2D)src_pt).getY();
            int s_ix = (int)Math.floor(s_x);
            int s_iy = (int)Math.floor(s_y);
            double fracx = (double)s_x - (double)s_ix;
            double fracy = (double)s_y - (double)s_iy;
            int xfrac = (int)(fracx * (double)this.shiftvalue);
            int yfrac = (int)(fracy * (double)this.shiftvalue);
            int ifracx = (int)Math.floor(fracx * 1048576.0);
            int ifracy = (int)Math.floor(fracy * 1048576.0);
            int destYOffset = (y - destTransY) * destScanlineStride + destDBOffset;
            int destXOffset = destDataBitOffset + (dst_min_x - destTransX);
            int sourceYOffset = (s_iy - sourceTransY) * sourceScanlineStride + sourceDBOffset;
            int roiYOffset = (s_iy - roiTransY) * roiScanlineStride + roiDBOffset;
            for (int x = dst_min_x; x < dst_max_x; ++x) {
                sourceYOffset = (s_iy - sourceTransY) * sourceScanlineStride + sourceDBOffset;
                roiYOffset = (s_iy - roiTransY) * roiScanlineStride + roiDBOffset;
                int dindex = 0;
                if ((float)s_ix >= src_rect_x1 + (float)this.interp_left && (float)s_ix < src_rect_x2 - (float)this.interp_right && (float)s_iy >= src_rect_y1 + (float)this.interp_top && (float)s_iy < src_rect_y2 - (float)this.interp_bottom) {
                    coordinates[0] = src.getX() + (s_ix - srcRectX) * sourcePixelStride;
                    coordinates[1] = src.getY() + (s_iy - srcRectY) * sourceScanlineStride / sourceScanlineStride;
                    int xNextBitNo = sourceDataBitOffset + (s_ix + 1 - sourceTransX);
                    if (this.interpN != null) {
                        s = this.interpN.interpolateBinary(xNextBitNo, sourceDataNum, sourceYOffset, sourceScanlineStride, coordinates, roiData, roiYOffset, roiScanlineStride);
                    } else if (this.interpB != null) {
                        s = this.interpB.interpolateBinary(xNextBitNo, sourceDataNum, xfrac, yfrac, sourceYOffset, sourceScanlineStride, coordinates, roiData, roiYOffset, roiScanlineStride);
                    } else {
                        if (this.interpBN == null) throw new UnsupportedOperationException("Binary interpolation not supported for interpolators different fromInterpolatorNearestNew,InterpolatorBinaryNew,InterpolatorBicubicNew");
                        s = this.interpBN.interpolateBinary(xNextBitNo, sourceDataNum, xfrac, yfrac, sourceYOffset, sourceScanlineStride, coordinates, roiData, roiYOffset, roiScanlineStride);
                    }
                } else if (this.setDestinationNoData) {
                    s = this.black;
                }
                dindex = destYOffset + (destXOffset >> 5);
                int dshift = 31 - (destXOffset & 0x1F);
                if (s == 1) {
                    int n = dindex;
                    destData[n] = destData[n] | 1 << dshift;
                } else {
                    int n = dindex;
                    destData[n] = destData[n] & -1 - (1 << dshift);
                }
                if (this.interpN == null || !(this.interp instanceof InterpolationNearest)) {
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        fracx += this.fracdx;
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        fracy += this.fracdy;
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                } else {
                    if (ifracx < this.ifracdx1) {
                        s_ix += this.incx;
                        ifracx += this.ifracdx;
                    } else {
                        s_ix += this.incx1;
                        ifracx -= this.ifracdx1;
                    }
                    if (ifracy < this.ifracdy1) {
                        s_iy += this.incy;
                        ifracy += this.ifracdy;
                    } else {
                        s_iy += this.incy1;
                        ifracy -= this.ifracdy1;
                    }
                }
                ++destXOffset;
            }
        }
    }

    private void floatLoop(int dataType, RasterAccessor src, Rectangle destRect, int srcRectX, int srcRectY, RasterAccessor dst, RasterAccessor roiAccessor) {
        float[][] samples = new float[this.interp_height][this.interp_width];
        float src_rect_x1 = src.getX();
        float src_rect_y1 = src.getY();
        float src_rect_x2 = src_rect_x1 + (float)src.getWidth();
        float src_rect_y2 = src_rect_y1 + (float)src.getHeight();
        int dstOffset = 0;
        Point2D.Float dst_pt = new Point2D.Float();
        Point2D.Float src_pt = new Point2D.Float();
        float[][] dstDataArrays = dst.getFloatDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        float[][] srcDataArrays = src.getFloatDataArrays();
        int[] bandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        int dst_num_bands = dst.getNumBands();
        int roiScanlineStride = 0;
        if (roiAccessor != null) {
            roiScanlineStride = roiAccessor.getScanlineStride();
        }
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        Integer posyROI = null;
        Number[] fracValues = new Number[2];
        for (int y = dst_min_y; y < dst_max_y; ++y) {
            int dstPixelOffset = dstOffset;
            ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
            this.mapDestPoint(dst_pt, src_pt);
            float s_x = (float)((Point2D)src_pt).getX();
            float s_y = (float)((Point2D)src_pt).getY();
            if (this.interpN == null || !(this.interp instanceof InterpolationNearest)) {
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
            }
            int s_ix = (int)Math.floor(s_x);
            int s_iy = (int)Math.floor(s_y);
            float fracx = s_x - (float)s_ix;
            float fracy = s_y - (float)s_iy;
            int xfrac = (int)(fracx * (float)this.shiftvalue);
            int yfrac = (int)(fracy * (float)this.shiftvalue);
            if (dataType < 4) {
                fracValues[0] = xfrac;
                fracValues[1] = yfrac;
            } else {
                fracValues[0] = Float.valueOf(fracx);
                fracValues[1] = Float.valueOf(fracy);
            }
            int posy = (s_iy - srcRectY) * srcScanlineStride;
            int posx = (s_ix - srcRectX) * srcPixelStride;
            int ifracx = (int)Math.floor(fracx * 1048576.0f);
            int ifracy = (int)Math.floor(fracy * 1048576.0f);
            if (roiAccessor != null) {
                posyROI = (s_iy - srcRectY) * roiScanlineStride;
            }
            for (int x = dst_min_x; x < dst_max_x; ++x) {
                if ((float)s_ix >= src_rect_x1 + (float)this.interp_left && (float)s_ix < src_rect_x2 - (float)this.interp_right && (float)s_iy >= src_rect_y1 + (float)this.interp_top && (float)s_iy < src_rect_y2 - (float)this.interp_bottom) {
                    for (int k2 = 0; k2 < dst_num_bands; ++k2) {
                        float s = 0.0f;
                        int posyy = posy + bandOffsets[k2];
                        if (this.interpN != null) {
                            s = this.interpN.interpolate(src, k2, dst_num_bands, posx, posyy, posyROI, roiAccessor, false).floatValue();
                        } else if (this.interpB != null) {
                            s = this.interpB.interpolate(src, k2, dst_num_bands, posx, posyy, fracValues, posyROI, roiAccessor, false).floatValue();
                        } else if (this.interpBN != null) {
                            s = this.interpBN.interpolate(src, k2, dst_num_bands, posx, posyy, fracValues, posyROI, roiAccessor, false).floatValue();
                        } else {
                            float[] srcData = srcDataArrays[k2];
                            int tmp = bandOffsets[k2];
                            int start = this.interp_left * srcPixelStride + this.interp_top * srcScanlineStride;
                            start = posx + posy - start;
                            int countH = 0;
                            int countV = 0;
                            for (int i = 0; i < this.interp_height; ++i) {
                                int startY = start;
                                for (int j = 0; j < this.interp_width; ++j) {
                                    samples[countV][countH++] = srcData[start + tmp];
                                    start += srcPixelStride;
                                }
                                ++countV;
                                countH = 0;
                                start = startY + srcScanlineStride;
                            }
                            s = this.interp.interpolate(samples, fracx, fracy);
                        }
                        dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = s;
                    }
                } else if (this.setDestinationNoData) {
                    for (int k = 0; k < dst_num_bands; ++k) {
                        dstDataArrays[k][dstPixelOffset + dstBandOffsets[k]] = (float)this.destinationNoData[k];
                    }
                }
                if (this.interpN == null || !(this.interp instanceof InterpolationNearest)) {
                    if ((double)fracx < this.fracdx1) {
                        s_ix += this.incx;
                        fracx = (float)((double)fracx + this.fracdx);
                    } else {
                        s_ix += this.incx1;
                        fracx = (float)((double)fracx - this.fracdx1);
                    }
                    if ((double)fracy < this.fracdy1) {
                        s_iy += this.incy;
                        fracy = (float)((double)fracy + this.fracdy);
                    } else {
                        s_iy += this.incy1;
                        fracy = (float)((double)fracy - this.fracdy1);
                    }
                } else {
                    if (ifracx < this.ifracdx1) {
                        s_ix += this.incx;
                        ifracx += this.ifracdx;
                    } else {
                        s_ix += this.incx1;
                        ifracx -= this.ifracdx1;
                    }
                    if (ifracy < this.ifracdy1) {
                        s_iy += this.incy;
                        ifracy += this.ifracdy;
                    } else {
                        s_iy += this.incy1;
                        ifracy -= this.ifracdy1;
                    }
                }
                posy = (s_iy - srcRectY) * srcScanlineStride;
                posx = (s_ix - srcRectX) * srcPixelStride;
                if (roiAccessor != null) {
                    posyROI = (s_iy - srcRectY) * roiScanlineStride;
                }
                dstPixelOffset += dstPixelStride;
            }
            dstOffset += dstScanlineStride;
        }
    }

    private void doubleLoop(int dataType, RasterAccessor src, Rectangle destRect, int srcRectX, int srcRectY, RasterAccessor dst, RasterAccessor roiAccessor) {
        double[][] samples = new double[this.interp_height][this.interp_width];
        float src_rect_x1 = src.getX();
        float src_rect_y1 = src.getY();
        float src_rect_x2 = src_rect_x1 + (float)src.getWidth();
        float src_rect_y2 = src_rect_y1 + (float)src.getHeight();
        int dstOffset = 0;
        Point2D.Float dst_pt = new Point2D.Float();
        Point2D.Float src_pt = new Point2D.Float();
        double[][] dstDataArrays = dst.getDoubleDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        double[][] srcDataArrays = src.getDoubleDataArrays();
        int[] bandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        int dst_num_bands = dst.getNumBands();
        int roiScanlineStride = 0;
        if (roiAccessor != null) {
            roiScanlineStride = roiAccessor.getScanlineStride();
        }
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        Integer posyROI = null;
        Number[] fracValues = new Number[2];
        for (int y = dst_min_y; y < dst_max_y; ++y) {
            int dstPixelOffset = dstOffset;
            ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
            this.mapDestPoint(dst_pt, src_pt);
            float s_x = (float)((Point2D)src_pt).getX();
            float s_y = (float)((Point2D)src_pt).getY();
            if (this.interpN == null || !(this.interp instanceof InterpolationNearest)) {
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
            }
            int s_ix = (int)Math.floor(s_x);
            int s_iy = (int)Math.floor(s_y);
            float fracx = s_x - (float)s_ix;
            float fracy = s_y - (float)s_iy;
            int xfrac = (int)(fracx * (float)this.shiftvalue);
            int yfrac = (int)(fracy * (float)this.shiftvalue);
            if (dataType < 4) {
                fracValues[0] = xfrac;
                fracValues[1] = yfrac;
            } else {
                fracValues[0] = Float.valueOf(fracx);
                fracValues[1] = Float.valueOf(fracy);
            }
            int posy = (s_iy - srcRectY) * srcScanlineStride;
            int posx = (s_ix - srcRectX) * srcPixelStride;
            int ifracx = (int)Math.floor(fracx * 1048576.0f);
            int ifracy = (int)Math.floor(fracy * 1048576.0f);
            if (roiAccessor != null) {
                posyROI = (s_iy - srcRectY) * roiScanlineStride;
            }
            for (int x = dst_min_x; x < dst_max_x; ++x) {
                if ((float)s_ix >= src_rect_x1 + (float)this.interp_left && (float)s_ix < src_rect_x2 - (float)this.interp_right && (float)s_iy >= src_rect_y1 + (float)this.interp_top && (float)s_iy < src_rect_y2 - (float)this.interp_bottom) {
                    for (int k2 = 0; k2 < dst_num_bands; ++k2) {
                        double s = 0.0;
                        int posyy = posy + bandOffsets[k2];
                        if (this.interpN != null) {
                            s = this.interpN.interpolate(src, k2, dst_num_bands, posx, posyy, posyROI, roiAccessor, false).doubleValue();
                        } else if (this.interpB != null) {
                            s = this.interpB.interpolate(src, k2, dst_num_bands, posx, posyy, fracValues, posyROI, roiAccessor, false).doubleValue();
                        } else if (this.interpBN != null) {
                            s = this.interpBN.interpolate(src, k2, dst_num_bands, posx, posyy, fracValues, posyROI, roiAccessor, false).doubleValue();
                        } else {
                            double[] srcData = srcDataArrays[k2];
                            int tmp = bandOffsets[k2];
                            int start = this.interp_left * srcPixelStride + this.interp_top * srcScanlineStride;
                            start = posx + posy - start;
                            int countH = 0;
                            int countV = 0;
                            for (int i = 0; i < this.interp_height; ++i) {
                                int startY = start;
                                for (int j = 0; j < this.interp_width; ++j) {
                                    samples[countV][countH++] = srcData[start + tmp];
                                    start += srcPixelStride;
                                }
                                ++countV;
                                countH = 0;
                                start = startY + srcScanlineStride;
                            }
                            s = this.interp.interpolate(samples, fracx, fracy);
                        }
                        dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = s;
                    }
                } else if (this.setDestinationNoData) {
                    for (int k = 0; k < dst_num_bands; ++k) {
                        dstDataArrays[k][dstPixelOffset + dstBandOffsets[k]] = this.destinationNoData[k];
                    }
                }
                if (this.interpN == null || !(this.interp instanceof InterpolationNearest)) {
                    if ((double)fracx < this.fracdx1) {
                        s_ix += this.incx;
                        fracx = (float)((double)fracx + this.fracdx);
                    } else {
                        s_ix += this.incx1;
                        fracx = (float)((double)fracx - this.fracdx1);
                    }
                    if ((double)fracy < this.fracdy1) {
                        s_iy += this.incy;
                        fracy = (float)((double)fracy + this.fracdy);
                    } else {
                        s_iy += this.incy1;
                        fracy = (float)((double)fracy - this.fracdy1);
                    }
                } else {
                    if (ifracx < this.ifracdx1) {
                        s_ix += this.incx;
                        ifracx += this.ifracdx;
                    } else {
                        s_ix += this.incx1;
                        ifracx -= this.ifracdx1;
                    }
                    if (ifracy < this.ifracdy1) {
                        s_iy += this.incy;
                        ifracy += this.ifracdy;
                    } else {
                        s_iy += this.incy1;
                        ifracy -= this.ifracdy1;
                    }
                }
                posy = (s_iy - srcRectY) * srcScanlineStride;
                posx = (s_ix - srcRectX) * srcPixelStride;
                if (roiAccessor != null) {
                    posyROI = (s_iy - srcRectY) * roiScanlineStride;
                }
                dstPixelOffset += dstPixelStride;
            }
            dstOffset += dstScanlineStride;
        }
    }
}

