/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.netcdf;

import it.geosolutions.imageio.plugins.netcdf.NetCDFConverterUtilities;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import javax.imageio.stream.FileImageInputStream;
import javax.vecmath.GMatrix;
import org.eclipse.imagen.RasterFactory;
import org.eclipse.imagen.iterator.RandomIterFactory;
import org.eclipse.imagen.iterator.WritableRandomIter;
import ucar.ma2.Array;
import ucar.ma2.ArrayFloat;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.Variable;

public class InterpolateVNetCDF {
    private float[] xminTV = new float[]{Float.NaN, Float.NaN};
    private float[] yminTV = new float[]{Float.NaN, Float.NaN};
    private float[] xmaxTV = new float[]{Float.NaN, Float.NaN};
    private float[] ymaxTV = new float[]{Float.NaN, Float.NaN};
    private float[] xperiodTV = new float[]{Float.NaN, Float.NaN};
    private float[] yperiodTV = new float[]{Float.NaN, Float.NaN};
    private float[] zmaxTV = new float[]{Float.NaN, Float.NaN};
    private float[] zminTV = new float[]{Float.NaN, Float.NaN};
    private float[] zperiodTV = new float[]{Float.NaN, Float.NaN};
    private static final int T = 0;
    private static final int V = 1;
    private static final ArrayList<String> variablesT = new ArrayList(12);
    private static final ArrayList<String> variablesV = new ArrayList(4);
    static final int NUMVARS_T = variablesT.size();
    static final int NUMVARS_V;
    static final String LATITUDE = "latitude";
    static final String LONGITUDE = "longitude";
    static final String DEPTH = "depth";
    static final String UNITS = "units";
    private static final boolean APPLY_MASK = true;
    public static final String fileNameOut = "D:/tmp/netcdf/pe_out_intT.nc";
    public static final String fileNameOutV = "D:/tmp/netcdf/pe_out_intV.nc";
    public static final String fileNameIn = "D:/tmp/netcdf/pe_out.nc";

    public static void main(String[] args) {
        InterpolateVNetCDF o = new InterpolateVNetCDF();
        o.run();
    }

    private void run() {
        try {
            Attribute fv;
            Index varIndex;
            Array originalVarData;
            Variable var;
            String varName;
            int i;
            Variable var2;
            String varName2;
            int i2;
            NetcdfFile ncFileIn = NetcdfFile.open((String)fileNameIn);
            ncFileIn.writeCDL((OutputStream)System.out, true);
            NetcdfFileWriteable ncFileOut = NetcdfFileWriteable.createNew((String)fileNameOut);
            NetcdfFileWriteable ncFileOutV = NetcdfFileWriteable.createNew((String)fileNameOutV);
            File iniFile = new File("D:/tmp/netcdf/pi_ini.in");
            float julianDay = Float.NaN;
            if (iniFile.exists()) {
                FileImageInputStream fiis = new FileImageInputStream(iniFile);
                boolean goOn = true;
                while (goOn) {
                    try {
                        String line = fiis.readLine();
                        if (!line.contains("TSTART")) continue;
                        int startIndex = line.indexOf("TSTART");
                        String time = line.substring(0, startIndex).trim();
                        julianDay = Float.parseFloat(time);
                        julianDay += 2440000.0f;
                        break;
                    }
                    catch (IOException ioe) {
                        goOn = false;
                    }
                }
            }
            GregorianCalendar calendar = !Float.isNaN(julianDay) ? NetCDFConverterUtilities.fromJulian(julianDay) : new GregorianCalendar();
            Dimension timeDim0 = ncFileIn.findDimension("time");
            Dimension tLatDim0 = ncFileIn.findDimension("tlat");
            Dimension tLonDim0 = ncFileIn.findDimension("tlon");
            Dimension vLatDim0 = ncFileIn.findDimension("vlat");
            Dimension vLonDim0 = ncFileIn.findDimension("vlon");
            Variable time_0 = ncFileIn.findVariable("time");
            Array time_0_Data = time_0.read();
            Index time_0_Index = time_0_Data.getIndex();
            Variable tGrid3 = ncFileIn.findVariable("tgrid3");
            Variable vGrid3 = ncFileIn.findVariable("vgrid3");
            int nTLat = tGrid3.getDimension(0).getLength();
            int nTLon = tGrid3.getDimension(1).getLength();
            int nTLevels = tGrid3.getDimension(2).getLength();
            String tUnits = tGrid3.findAttribute(UNITS).getStringValue();
            String[] tUnit = tUnits.split(",");
            Array tLatOriginalData = tGrid3.read("0:" + (nTLat - 1) + ":1, 0:0:1, 0:0:1, 1:1:1").reduce();
            Index tLatOriginalIndex = tLatOriginalData.getIndex();
            Array tLonOriginalData = tGrid3.read("0:0:1, 0:" + (nTLon - 1) + ":1, 0:0:1, 0:0:1").reduce();
            Index tLonOriginalIndex = tLonOriginalData.getIndex();
            Array tLevOriginalData = tGrid3.read("0:" + (nTLat - 1) + ":1, 0:" + (nTLon - 1) + ":1, 0:" + (nTLevels - 1) + ":1, 2:2:1").reduce();
            Index tLevOriginalIndex = tLevOriginalData.getIndex();
            int nVLat = vGrid3.getDimension(0).getLength();
            int nVLon = vGrid3.getDimension(1).getLength();
            int nVLevels = vGrid3.getDimension(2).getLength();
            String vUnits = vGrid3.findAttribute(UNITS).getStringValue();
            String[] vUnit = tUnits.split(",");
            Array vLatOriginalData = vGrid3.read("0:" + (nVLat - 1) + ":1, 0:0:1, 0:0:1, 1:1:1").reduce();
            Index vLatOriginalIndex = vLatOriginalData.getIndex();
            Array vLonOriginalData = vGrid3.read("0:0:1, 0:" + (nVLon - 1) + ":1, 0:0:1, 0:0:1").reduce();
            Index vLonOriginalIndex = vLonOriginalData.getIndex();
            Array vLevOriginalData = vGrid3.read("0:" + (nVLat - 1) + ":1, 0:" + (nVLon - 1) + ":1, 0:" + (nVLevels - 1) + ":1, 2:2:1").reduce();
            Index vLevOriginalIndex = vLevOriginalData.getIndex();
            Dimension timeDimT = ncFileOut.addDimension("time", timeDim0.getLength());
            Dimension latDimT = ncFileOut.addDimension("lat", tLatDim0.getLength());
            Dimension lonDimT = ncFileOut.addDimension("lon", tLonDim0.getLength());
            Dimension depthDimT = ncFileOut.addDimension(DEPTH, nTLevels);
            Dimension timeDimV = ncFileOutV.addDimension("time", timeDim0.getLength());
            Dimension latDimV = ncFileOutV.addDimension("lat", vLatDim0.getLength());
            Dimension lonDimV = ncFileOutV.addDimension("lon", vLonDim0.getLength());
            Dimension depthDimV = ncFileOutV.addDimension(DEPTH, nVLevels);
            this.computeMatrixExtremes(tLatOriginalData, tLonOriginalData, tLevOriginalData, tLonDim0.getLength(), tLatDim0.getLength(), depthDimT.getLength(), tLatOriginalIndex, tLonOriginalIndex, tLevOriginalIndex, 0);
            this.computeMatrixExtremes(vLatOriginalData, vLonOriginalData, vLevOriginalData, vLonDim0.getLength(), vLatDim0.getLength(), depthDimV.getLength(), vLatOriginalIndex, vLonOriginalIndex, vLevOriginalIndex, 1);
            List globalAttributes = ncFileIn.getGlobalAttributes();
            InterpolateVNetCDF.copyGlobalAttributes(ncFileOut, globalAttributes);
            InterpolateVNetCDF.copyGlobalAttributes(ncFileOutV, globalAttributes);
            ncFileOut.addVariable("time", DataType.FLOAT, new Dimension[]{timeDimT});
            ncFileOutV.addVariable("time", DataType.FLOAT, new Dimension[]{timeDimV});
            this.setTimeVariableAttributes(time_0, ncFileOut, calendar);
            this.setTimeVariableAttributes(time_0, ncFileOutV, calendar);
            ArrayFloat tLatData = new ArrayFloat(new int[]{tLatDim0.getLength()});
            Index tLatIndex = tLatData.getIndex();
            ncFileOut.addVariable("lat", DataType.FLOAT, new Dimension[]{latDimT});
            ncFileOut.addVariableAttribute("lat", "long_name", LATITUDE);
            ncFileOut.addVariableAttribute("lat", UNITS, tUnit[1].trim());
            for (int yPos = 0; yPos < tLatDim0.getLength(); ++yPos) {
                tLatData.setFloat(tLatIndex.set(yPos), new Float(this.ymaxTV[0] - new Float(yPos).floatValue() * this.yperiodTV[0]).floatValue());
            }
            ArrayFloat tLonData = new ArrayFloat(new int[]{tLonDim0.getLength()});
            Index tLonIndex = tLonData.getIndex();
            ncFileOut.addVariable("lon", DataType.FLOAT, new Dimension[]{lonDimT});
            ncFileOut.addVariableAttribute("lon", "long_name", LONGITUDE);
            ncFileOut.addVariableAttribute("lon", UNITS, tUnit[0].trim());
            for (int xPos = 0; xPos < tLonDim0.getLength(); ++xPos) {
                tLonData.setFloat(tLonIndex.set(xPos), new Float(this.xminTV[0] + new Float(xPos).floatValue() * this.xperiodTV[0]).floatValue());
            }
            ArrayFloat tDepthData = new ArrayFloat(new int[]{depthDimT.getLength()});
            Index tDepthIndex = tDepthData.getIndex();
            ncFileOut.addVariable(DEPTH, DataType.FLOAT, new Dimension[]{depthDimT});
            ncFileOut.addVariableAttribute(DEPTH, "long_name", DEPTH);
            ncFileOut.addVariableAttribute(DEPTH, UNITS, tUnit[2].trim());
            for (int zPos = 0; zPos < depthDimT.getLength(); ++zPos) {
                tDepthData.setFloat(tDepthIndex.set(zPos), new Float(this.zmaxTV[0] - new Float(zPos).floatValue() * this.zperiodTV[0]).floatValue());
            }
            ArrayFloat vLatData = new ArrayFloat(new int[]{tLatDim0.getLength()});
            Index vLatIndex = vLatData.getIndex();
            ncFileOutV.addVariable("lat", DataType.FLOAT, new Dimension[]{latDimV});
            ncFileOutV.addVariableAttribute("lat", "long_name", LATITUDE);
            ncFileOutV.addVariableAttribute("lat", UNITS, vUnit[1].trim());
            for (int yPos = 0; yPos < vLatDim0.getLength(); ++yPos) {
                vLatData.setFloat(vLatIndex.set(yPos), new Float(this.ymaxTV[1] - new Float(yPos).floatValue() * this.yperiodTV[1]).floatValue());
            }
            ArrayFloat vLonData = new ArrayFloat(new int[]{tLonDim0.getLength()});
            Index vLonIndex = vLonData.getIndex();
            ncFileOutV.addVariable("lon", DataType.FLOAT, new Dimension[]{lonDimV});
            ncFileOutV.addVariableAttribute("lon", "long_name", LONGITUDE);
            ncFileOutV.addVariableAttribute("lon", UNITS, vUnit[0].trim());
            for (int xPos = 0; xPos < vLonDim0.getLength(); ++xPos) {
                vLonData.setFloat(vLonIndex.set(xPos), new Float(this.xminTV[1] + new Float(xPos).floatValue() * this.xperiodTV[1]).floatValue());
            }
            ArrayFloat vDepthData = new ArrayFloat(new int[]{depthDimT.getLength()});
            Index vDepthIndex = vDepthData.getIndex();
            ncFileOutV.addVariable(DEPTH, DataType.FLOAT, new Dimension[]{depthDimV});
            ncFileOutV.addVariableAttribute(DEPTH, "long_name", DEPTH);
            ncFileOutV.addVariableAttribute(DEPTH, UNITS, vUnit[2].trim());
            for (int zPos = 0; zPos < depthDimV.getLength(); ++zPos) {
                vDepthData.setFloat(vDepthIndex.set(zPos), new Float(this.zmaxTV[1] - new Float(zPos).floatValue() * this.zperiodTV[1]).floatValue());
            }
            for (i2 = 0; i2 < NUMVARS_T; ++i2) {
                varName2 = variablesT.get(i2);
                var2 = ncFileIn.findVariable(varName2);
                ncFileOut.addVariable(varName2, var2.getDataType(), new Dimension[]{timeDimT, depthDimT, latDimT, lonDimT});
                InterpolateVNetCDF.setVariableAttributes(var2, ncFileOut, new String[]{"positions"});
            }
            for (i2 = 0; i2 < NUMVARS_V; ++i2) {
                varName2 = variablesV.get(i2);
                var2 = ncFileIn.findVariable(varName2);
                ncFileOutV.addVariable(varName2 + "0", var2.getDataType(), new Dimension[]{timeDimV, depthDimV, latDimV, lonDimV});
                ncFileOutV.addVariable(varName2 + "1", var2.getDataType(), new Dimension[]{timeDimV, depthDimV, latDimV, lonDimV});
                InterpolateVNetCDF.setVariableAttributes(var2, ncFileOutV, new String[]{"positions"}, 0);
                InterpolateVNetCDF.setVariableAttributes(var2, ncFileOutV, new String[]{"positions"}, 1);
            }
            ncFileOut.create();
            ncFileOutV.create();
            ArrayFloat timeData = new ArrayFloat(new int[]{timeDimT.getLength()});
            Index timeIndex = timeData.getIndex();
            for (int t = 0; t < timeDimT.getLength(); ++t) {
                float seconds = time_0_Data.getFloat(time_0_Index.set(t));
                timeData.setFloat(timeIndex.set(t), seconds);
            }
            ncFileOut.write("time", (Array)timeData);
            Variable timeVar = ncFileOut.findVariable("time");
            timeDimT.addCoordinateVariable(timeVar);
            Variable depthVarT = ncFileOut.findVariable(DEPTH);
            depthDimT.addCoordinateVariable(depthVarT);
            ncFileOut.write(DEPTH, (Array)vDepthData);
            ncFileOut.write("lat", (Array)tLatData);
            ncFileOut.write("lon", (Array)tLonData);
            ncFileOutV.write("time", (Array)timeData);
            Variable timeVarV = ncFileOutV.findVariable("time");
            timeDimV.addCoordinateVariable(timeVarV);
            Variable depthVarV = ncFileOut.findVariable(DEPTH);
            depthDimV.addCoordinateVariable(depthVarV);
            ncFileOutV.write(DEPTH, (Array)vDepthData);
            ncFileOutV.write("lat", (Array)vLatData);
            ncFileOutV.write("lon", (Array)vLonData);
            ArrayFloat.D2 maskMatrixT = new ArrayFloat.D2(latDimT.getLength(), lonDimT.getLength());
            Index maskImaT = maskMatrixT.getIndex();
            Variable mask = ncFileIn.findVariable("landt");
            Array maskData = mask.read();
            Index maskIndex = maskData.getIndex();
            ArrayFloat tempData = new ArrayFloat(new int[]{tLatDim0.getLength(), tLonDim0.getLength()});
            Index tempIndex = tempData.getIndex();
            for (int yPos = 0; yPos < tLatDim0.getLength(); ++yPos) {
                for (int xPos = 0; xPos < tLonDim0.getLength(); ++xPos) {
                    tempData.setFloat(tempIndex.set(yPos, xPos), maskData.getFloat(maskIndex.set(yPos, xPos)));
                }
            }
            WritableRaster outData = this.Resampler(tLatOriginalData, tLonOriginalData, tLonDim0.getLength(), tLatDim0.getLength(), 2, (Array)tempData, -1.0f, 0);
            for (int j = 0; j < tLatDim0.getLength(); ++j) {
                for (int k = 0; k < tLonDim0.getLength(); ++k) {
                    float sample = outData.getSampleFloat(k, j, 0);
                    maskMatrixT.setFloat(maskImaT.set(j, k), sample);
                }
            }
            ArrayFloat.D2 maskMatrixV = new ArrayFloat.D2(latDimT.getLength(), lonDimT.getLength());
            Index maskImaV = maskMatrixV.getIndex();
            Variable mask2 = ncFileIn.findVariable("landv");
            Array maskData2 = mask2.read();
            Index maskIndex2 = maskData2.getIndex();
            ArrayFloat tempData2 = new ArrayFloat(new int[]{vLatDim0.getLength(), vLonDim0.getLength()});
            Index tempIndex2 = tempData2.getIndex();
            for (int yPos = 0; yPos < vLatDim0.getLength(); ++yPos) {
                for (int xPos = 0; xPos < vLonDim0.getLength(); ++xPos) {
                    tempData2.setFloat(tempIndex2.set(yPos, xPos), maskData2.getFloat(maskIndex2.set(yPos, xPos)));
                }
            }
            WritableRaster outData2 = this.Resampler(vLatOriginalData, vLonOriginalData, vLonDim0.getLength(), vLatDim0.getLength(), 2, (Array)tempData2, -1.0f, 1);
            for (int j = 0; j < vLatDim0.getLength(); ++j) {
                for (int k = 0; k < vLonDim0.getLength(); ++k) {
                    float sample = outData2.getSampleFloat(k, j, 0);
                    maskMatrixV.setFloat(maskImaV.set(j, k), sample);
                }
            }
            System.out.print("T Process complete...0.0%");
            for (i = 0; i < NUMVARS_T; ++i) {
                varName = variablesT.get(i);
                var = ncFileIn.findVariable(varName);
                originalVarData = var.read();
                varIndex = originalVarData.getIndex();
                fv = var.findAttribute("_FillValue");
                float fillValue = Float.NaN;
                if (fv != null) {
                    fillValue = fv.getNumericValue().floatValue();
                }
                ArrayFloat tempData3 = new ArrayFloat(new int[]{tLatDim0.getLength(), tLonDim0.getLength()});
                Index tempIndex3 = tempData3.getIndex();
                ArrayFloat.D4 tMatrix = new ArrayFloat.D4(timeDimT.getLength(), depthDimT.getLength(), latDimT.getLength(), lonDimT.getLength());
                Index tIma = tMatrix.getIndex();
                for (int tPos = 0; tPos < timeDim0.getLength(); ++tPos) {
                    for (int levelPos = 0; levelPos < depthDimT.getLength(); ++levelPos) {
                        for (int yPos = 0; yPos < tLatDim0.getLength(); ++yPos) {
                            for (int xPos = 0; xPos < tLonDim0.getLength(); ++xPos) {
                                double targetZ = new Double((double)this.zmaxTV[0] - new Double(levelPos) * (double)this.zperiodTV[0]);
                                int targetOutlev = 0;
                                double distance = Double.POSITIVE_INFINITY;
                                for (int ol = 0; ol < depthDimT.getLength(); ++ol) {
                                    double designatedZ = tLevOriginalData.getDouble(tLevOriginalIndex.set(yPos, xPos, ol));
                                    if (!(Math.abs(designatedZ - targetZ) < distance)) continue;
                                    distance = Math.abs(designatedZ - targetZ);
                                    targetOutlev = ol;
                                }
                                tempData3.setFloat(tempIndex3.set(yPos, xPos), originalVarData.getFloat(varIndex.set(tPos, yPos, xPos, targetOutlev)));
                            }
                        }
                        WritableRaster outData3 = this.Resampler(tLatOriginalData, tLonOriginalData, tLonDim0.getLength(), tLatDim0.getLength(), 2, (Array)tempData3, fillValue, 0);
                        for (int j = 0; j < tLatDim0.getLength(); ++j) {
                            for (int k = 0; k < tLonDim0.getLength(); ++k) {
                                float sample = outData3.getSampleFloat(k, j, 0);
                                float maskValue = maskMatrixV.getFloat(maskImaV.set(j, k));
                                if (maskValue == 0.0f) {
                                    sample = fillValue;
                                }
                                tMatrix.setFloat(tIma.set(tPos, levelPos, j, k), sample);
                            }
                        }
                    }
                }
                ncFileOut.write(varName, (Array)tMatrix);
                System.out.print("..." + new Double(new Double(i + 1) / new Double(NUMVARS_T) * 100.0).floatValue() + "%");
            }
            System.out.print("V Process complete...0.0%");
            for (i = 0; i < NUMVARS_V; ++i) {
                varName = variablesV.get(i);
                var = ncFileIn.findVariable(varName);
                originalVarData = var.read();
                varIndex = originalVarData.getIndex();
                fv = var.findAttribute("_FillValue");
                float fillValue = Float.NaN;
                if (fv != null) {
                    fillValue = fv.getNumericValue().floatValue();
                }
                ArrayFloat tempData0 = new ArrayFloat(new int[]{vLatDim0.getLength(), vLonDim0.getLength()});
                Index tempIndex0 = tempData0.getIndex();
                ArrayFloat tempData1 = new ArrayFloat(new int[]{vLatDim0.getLength(), vLonDim0.getLength()});
                Index tempIndex1 = tempData1.getIndex();
                ArrayFloat.D4 vMatrix0 = new ArrayFloat.D4(timeDimV.getLength(), depthDimV.getLength(), latDimV.getLength(), lonDimV.getLength());
                Index vIma0 = vMatrix0.getIndex();
                ArrayFloat.D4 vMatrix1 = new ArrayFloat.D4(timeDimV.getLength(), depthDimV.getLength(), latDimV.getLength(), lonDimV.getLength());
                Index vIma1 = vMatrix1.getIndex();
                for (int tPos = 0; tPos < timeDim0.getLength(); ++tPos) {
                    for (int levelPos = 0; levelPos < depthDimV.getLength(); ++levelPos) {
                        for (int yPos = 0; yPos < vLatDim0.getLength(); ++yPos) {
                            for (int xPos = 0; xPos < vLonDim0.getLength(); ++xPos) {
                                double targetZ = new Double((double)this.zmaxTV[1] - new Double(levelPos) * (double)this.zperiodTV[1]);
                                int targetOutlev = 0;
                                double distance = Double.POSITIVE_INFINITY;
                                for (int ol = 0; ol < depthDimV.getLength(); ++ol) {
                                    double designatedZ = vLevOriginalData.getDouble(vLevOriginalIndex.set(yPos, xPos, ol));
                                    if (!(Math.abs(designatedZ - targetZ) < distance)) continue;
                                    distance = Math.abs(designatedZ - targetZ);
                                    targetOutlev = ol;
                                }
                                tempData0.setFloat(tempIndex0.set(yPos, xPos), originalVarData.getFloat(varIndex.set(tPos, yPos, xPos, targetOutlev, 0)));
                                tempData1.setFloat(tempIndex1.set(yPos, xPos), originalVarData.getFloat(varIndex.set(tPos, yPos, xPos, targetOutlev, 1)));
                            }
                        }
                        WritableRaster outData0 = this.Resampler(vLatOriginalData, vLonOriginalData, vLonDim0.getLength(), vLatDim0.getLength(), 2, (Array)tempData0, fillValue, 1);
                        for (int j = 0; j < vLatDim0.getLength(); ++j) {
                            for (int k = 0; k < vLonDim0.getLength(); ++k) {
                                float sample = outData0.getSampleFloat(k, j, 0);
                                float maskValue = maskMatrixV.getFloat(maskImaV.set(j, k));
                                if (maskValue == 0.0f) {
                                    sample = fillValue;
                                }
                                vMatrix0.setFloat(vIma0.set(tPos, levelPos, j, k), sample);
                            }
                        }
                        WritableRaster outData1 = this.Resampler(vLatOriginalData, vLonOriginalData, vLonDim0.getLength(), vLatDim0.getLength(), 2, (Array)tempData1, fillValue, 1);
                        for (int j = 0; j < vLatDim0.getLength(); ++j) {
                            for (int k = 0; k < vLonDim0.getLength(); ++k) {
                                float sample = outData1.getSampleFloat(k, j, 0);
                                float maskValue = maskMatrixV.getFloat(maskImaV.set(j, k));
                                if (maskValue == 0.0f) {
                                    sample = fillValue;
                                }
                                vMatrix1.setFloat(vIma1.set(tPos, levelPos, j, k), sample);
                            }
                        }
                    }
                }
                ncFileOutV.write(varName + "0", (Array)vMatrix0);
                ncFileOutV.write(varName + "1", (Array)vMatrix1);
                System.out.print("..." + new Double(new Double(i + 1) / new Double(NUMVARS_V) * 100.0).floatValue() + "%");
            }
            ncFileOut.close();
            ncFileOutV.close();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    private WritableRaster Resampler(Array latData, Array lonData, int imageWidth, int imageHeight, int polyDegree, Array data, float fillValue, int tv) {
        Index latIndex = latData.getIndex();
        Index lonIndex = lonData.getIndex();
        int numCoeffs = (polyDegree + 1) * (polyDegree + 2) / 2;
        boolean XOFFSET = false;
        boolean YOFFSET = true;
        int stepX = 2;
        int stepY = 2;
        int numNeededPoints = 0;
        for (int xi = 0; xi < imageWidth; xi += 2) {
            for (int yi = 0; yi < imageHeight; yi += 2) {
                ++numNeededPoints;
            }
        }
        this.computeMatrixExtremes(latData, lonData, imageWidth, imageHeight, latIndex, lonIndex, tv);
        float[] destCoords = new float[2 * numNeededPoints];
        float[] srcCoords = new float[2 * numNeededPoints];
        float xmin = this.xminTV[tv];
        float xperiod = this.xperiodTV[tv];
        float ymax = this.ymaxTV[tv];
        float yperiod = this.yperiodTV[tv];
        int offset = 0;
        for (int yi = 0; yi < imageHeight; yi += 2) {
            for (int xi = 0; xi < imageWidth; xi += 2) {
                srcCoords[offset] = xi;
                srcCoords[offset + 1] = yi;
                destCoords[offset] = (lonData.getFloat(lonIndex.set(xi)) - xmin) / xperiod;
                destCoords[offset + 1] = (ymax - latData.getFloat(latIndex.set(yi))) / yperiod;
                offset += 2;
            }
        }
        GMatrix A = new GMatrix(numNeededPoints, numCoeffs);
        for (int coord = 0; coord < numNeededPoints; ++coord) {
            int var = 0;
            for (int i = 0; i <= polyDegree; ++i) {
                for (int j = 0; j <= i; ++j) {
                    double value = Math.pow(destCoords[2 * coord + 0], i - j) * Math.pow(destCoords[2 * coord + 1], j);
                    A.setElement(coord, var++, value);
                }
            }
        }
        GMatrix AtAi = new GMatrix(numCoeffs, numCoeffs);
        GMatrix Ap = new GMatrix(numCoeffs, numNeededPoints);
        AtAi.mulTransposeLeft(A, A);
        AtAi.invert();
        Ap.mulTransposeRight(AtAi, A);
        GMatrix xVector = new GMatrix(numNeededPoints, 1);
        GMatrix yVector = new GMatrix(numNeededPoints, 1);
        for (int idx = 0; idx < numNeededPoints; ++idx) {
            xVector.setElement(idx, 0, (double)srcCoords[2 * idx + 0]);
            yVector.setElement(idx, 0, (double)srcCoords[2 * idx + 1]);
        }
        GMatrix xCoeffsG = new GMatrix(numCoeffs, 1);
        GMatrix yCoeffsG = new GMatrix(numCoeffs, 1);
        xCoeffsG.mul(Ap, xVector);
        yCoeffsG.mul(Ap, yVector);
        float[] xCoeffs = new float[numCoeffs];
        float[] yCoeffs = new float[numCoeffs];
        for (int ii = 0; ii < numCoeffs; ++ii) {
            xCoeffs[ii] = new Double(xCoeffsG.getElement(ii, 0)).floatValue();
            yCoeffs[ii] = new Double(yCoeffsG.getElement(ii, 0)).floatValue();
        }
        SampleModel outSampleModel = RasterFactory.createBandedSampleModel((int)4, (int)imageWidth, (int)imageHeight, (int)1);
        WritableRaster outDataCube = Raster.createWritableRaster(outSampleModel, null);
        WritableRandomIter iteratorDataCube = RandomIterFactory.createWritable((WritableRaster)outDataCube, null);
        Index indexInputVar = data.getIndex();
        for (int jj = 0; jj < outDataCube.getNumBands(); ++jj) {
            for (int kk = 0; kk < outDataCube.getWidth(); ++kk) {
                for (int ll = 0; ll < outDataCube.getHeight(); ++ll) {
                    iteratorDataCube.setSample(kk, ll, jj, data.getFloat(indexInputVar.set(ll, kk)));
                }
            }
        }
        WritableRaster target = RasterFactory.createWritableRaster((SampleModel)outSampleModel, null);
        for (int bi = 0; bi < outDataCube.getNumBands(); ++bi) {
            for (int yi = 0; yi < imageHeight; ++yi) {
                for (int xi = 0; xi < imageWidth; ++xi) {
                    float[] dstCoords = new float[2];
                    GMatrix regressionVec = new GMatrix(numCoeffs, 1);
                    int var = 0;
                    for (int i = 0; i <= polyDegree; ++i) {
                        for (int j = 0; j <= i; ++j) {
                            double value = Math.pow(xi, i - j) * Math.pow(yi, j);
                            regressionVec.setElement(var++, 0, value);
                        }
                    }
                    GMatrix xG = new GMatrix(1, 1);
                    GMatrix yG = new GMatrix(1, 1);
                    xG.mulTransposeLeft(regressionVec, xCoeffsG);
                    yG.mulTransposeLeft(regressionVec, yCoeffsG);
                    int X = (int)Math.round(xG.getElement(0, 0));
                    int Y = (int)Math.round(yG.getElement(0, 0));
                    if (X >= 0 && Y >= 0 && X < imageWidth && Y < imageHeight) {
                        target.setSample(xi, yi, bi, outDataCube.getSampleFloat(X, Y, bi));
                        continue;
                    }
                    target.setSample(xi, yi, bi, fillValue);
                }
            }
        }
        return target;
    }

    private void computeMatrixExtremes(Array lat_0_Data, Array lon_0_Data, Array z_0_data, int imageWidth, int imageHeight, int depth, Index lat_0_Index, Index lon_0_Index, Index z_0_index, int tv) {
        this.computeMatrixExtremes(lat_0_Data, lon_0_Data, imageWidth, imageHeight, lat_0_Index, lon_0_Index, tv);
        if (Float.isNaN(this.zminTV[tv]) || Float.isNaN(this.zmaxTV[tv])) {
            this.zminTV[tv] = Float.POSITIVE_INFINITY;
            this.zmaxTV[tv] = Float.NEGATIVE_INFINITY;
            for (int yi = 0; yi < imageHeight; ++yi) {
                for (int xi = 0; xi < imageWidth; ++xi) {
                    for (int zi = 0; zi < depth; ++zi) {
                        float z = z_0_data.getFloat(z_0_index.set(yi, xi, zi));
                        if (z < this.zminTV[tv]) {
                            this.zminTV[tv] = z;
                        }
                        if (!(z > this.zmaxTV[tv])) continue;
                        this.zmaxTV[tv] = z;
                    }
                }
            }
        }
        float rangeZ = this.zmaxTV[tv] - this.zminTV[tv];
        this.zperiodTV[tv] = rangeZ / (float)(depth - 1);
        System.out.println(this.zminTV[tv] + ":" + this.zmaxTV[tv] + " / " + this.zperiodTV[tv]);
    }

    private void computeMatrixExtremes(Array latData, Array lonData, int imageWidth, int imageHeight, Index latIndex, Index lonIndex, int tv) {
        if (Float.isNaN(this.xminTV[tv]) || Float.isNaN(this.yminTV[tv]) || Float.isNaN(this.xmaxTV[tv]) || Float.isNaN(this.ymaxTV[tv]) || Float.isNaN(this.xperiodTV[tv]) || Float.isNaN(this.yperiodTV[tv])) {
            this.xminTV[tv] = Float.POSITIVE_INFINITY;
            this.yminTV[tv] = Float.POSITIVE_INFINITY;
            this.xmaxTV[tv] = Float.NEGATIVE_INFINITY;
            this.ymaxTV[tv] = Float.NEGATIVE_INFINITY;
            for (int yi = 0; yi < imageHeight; ++yi) {
                for (int xi = 0; xi < imageWidth; ++xi) {
                    float x = lonData.getFloat(lonIndex.set(xi));
                    float y = latData.getFloat(latIndex.set(yi));
                    if (x < this.xminTV[tv]) {
                        this.xminTV[tv] = x;
                    }
                    if (x > this.xmaxTV[tv]) {
                        this.xmaxTV[tv] = x;
                    }
                    if (y < this.yminTV[tv]) {
                        this.yminTV[tv] = y;
                    }
                    if (!(y > this.ymaxTV[tv])) continue;
                    this.ymaxTV[tv] = y;
                }
            }
            float rangeX = this.xmaxTV[tv] - this.xminTV[tv];
            float rangeY = this.ymaxTV[tv] - this.yminTV[tv];
            this.xperiodTV[tv] = rangeX / (float)(imageWidth - 1);
            this.yperiodTV[tv] = rangeY / (float)(imageHeight - 1);
            System.out.println(this.xminTV[tv] + ":" + this.yminTV[tv] + " - " + this.xmaxTV[tv] + ":" + this.ymaxTV[tv] + " / " + this.xperiodTV[tv] + ":" + this.yperiodTV[tv]);
        }
    }

    private static void setVariableAttributes(Variable variable, NetcdfFileWriteable writableFile, String[] exceptions) {
        InterpolateVNetCDF.setVariableAttributes(variable, writableFile, exceptions, -1);
    }

    private static void setVariableAttributes(Variable variable, NetcdfFileWriteable writableFile, String[] exceptions, int suffix) {
        List attributes = variable.getAttributes();
        Object name = variable.getName();
        if (suffix != -1) {
            name = (String)name + suffix;
        }
        if (attributes != null) {
            for (Attribute att : attributes) {
                String attribName = att.getName();
                boolean skip = false;
                if (exceptions != null) {
                    for (int i = 0; i < exceptions.length; ++i) {
                        if (!exceptions[i].equalsIgnoreCase(attribName)) continue;
                        skip = true;
                        break;
                    }
                }
                if (skip) continue;
                if (att.isArray()) {
                    writableFile.addVariableAttribute((String)name, attribName, att.getValues());
                    continue;
                }
                if (att.isString()) {
                    writableFile.addVariableAttribute((String)name, attribName, att.getStringValue());
                    continue;
                }
                writableFile.addVariableAttribute((String)name, attribName, att.getNumericValue());
            }
        }
    }

    private static void setVariableAttributes(Variable variable, NetcdfFileWriteable writableFile) {
        InterpolateVNetCDF.setVariableAttributes(variable, writableFile, null);
    }

    private static void copyGlobalAttributes(NetcdfFileWriteable writableFile, List<Attribute> attributes) {
        if (!attributes.isEmpty()) {
            for (Attribute attrib : attributes) {
                if (attrib.isArray()) {
                    writableFile.addGlobalAttribute(attrib.getName(), attrib.getValues());
                    continue;
                }
                if (attrib.isString()) {
                    writableFile.addGlobalAttribute(attrib.getName(), attrib.getStringValue());
                    continue;
                }
                writableFile.addGlobalAttribute(attrib.getName(), attrib.getNumericValue());
            }
        }
    }

    private void setTimeVariableAttributes(Variable time_0, NetcdfFileWriteable ncFileOut, GregorianCalendar calendar) throws IOException {
        Object second;
        Object minute;
        String name = time_0.getName();
        String year = Integer.toString(calendar.get(1));
        String month = Integer.toString(calendar.get(2) + 1);
        String day = Integer.toString(calendar.get(5));
        Object hour = Integer.toString(calendar.get(10));
        if (((String)hour).equalsIgnoreCase("0")) {
            hour = (String)hour + "0";
        }
        if (((String)(minute = Integer.toString(calendar.get(12)))).equalsIgnoreCase("0")) {
            minute = (String)minute + "0";
        }
        if (((String)(second = Integer.toString(calendar.get(13)))).equalsIgnoreCase("0")) {
            second = (String)second + "0";
        }
        String millisecond = Integer.toString(calendar.get(14));
        StringBuffer sbTime = new StringBuffer(year).append("-").append(month).append("-").append(day).append(" ").append((String)hour).append(":").append((String)minute).append(":").append((String)second).append(".").append(millisecond);
        ncFileOut.addVariableAttribute(name, UNITS, "seconds since " + sbTime.toString());
        ncFileOut.addVariableAttribute(name, "long_name", "time");
    }

    static {
        variablesV.add("vtot");
        NUMVARS_V = variablesV.size();
    }
}

