/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.netcdf;

import it.geosolutions.imageio.plugins.netcdf.NetCDFConverterUtilities;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.vecmath.GMatrix;
import org.eclipse.imagen.JAI;
import org.eclipse.imagen.RasterFactory;
import org.eclipse.imagen.iterator.RandomIterFactory;
import org.eclipse.imagen.iterator.WritableRandomIter;
import ucar.ma2.Array;
import ucar.ma2.ArrayFloat;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.Variable;

public class MercatorOceanConverter {
    private float xmin = Float.NaN;
    private float ymin = Float.NaN;
    private float xmax = Float.NaN;
    private float ymax = Float.NaN;
    private float periodX = Float.NaN;
    private float periodY = Float.NaN;
    private static final String TIME_ORIGIN = "bulletin_date";
    private static final String FORECAST_DAY = "forecast_range";
    private static final ArrayList<String> VARIABLES = new ArrayList(4);
    static final String UNITS = "units";
    private static final Logger LOGGER;
    private static final String fileNameIn = "C:\\Work\\data\\rixen\\lsvc08\\mercator-ocean\\PSY2V3R1\\20080924\\ext-mercatorPsy2v3R1v_med_mean_20080926_R20080924.nc";
    private static final String fileNameOut = "C:/work/data/rixen/converted/re_converted_ext-mercatorPsy2v3R1v_med_mean_20080926_R20080924.nc";
    static final int NUMVARS;

    public static void main(String[] args) throws IOException {
        MercatorOceanConverter converter = new MercatorOceanConverter();
        String fileNameIn = fileNameIn;
        String fileNameOut = fileNameOut;
        converter.run(fileNameIn, fileNameOut);
    }

    private void run(String fileNameIn, String fileNameOut) {
        try {
            File fileIn = new File(fileNameIn);
            NetcdfFile ncFileIn = NetcdfFile.open((String)fileNameIn);
            File fileOut = new File(fileNameOut);
            File outputFile = File.createTempFile(fileIn.getName(), ".tmp");
            NetcdfFileWriteable ncFileOut = NetcdfFileWriteable.createNew((String)outputFile.getAbsolutePath());
            Dimension latOriginalDim = ncFileIn.findDimension("latitude");
            Dimension lonOriginalDim = ncFileIn.findDimension("longitude");
            Variable lonOriginalVar = ncFileIn.findVariable("longitude");
            int nLon = lonOriginalDim.getLength();
            Variable latOriginalVar = ncFileIn.findVariable("latitude");
            int nLat = latOriginalDim.getLength();
            Array latOriginalData = latOriginalVar.read();
            Index latOriginalIndex = latOriginalData.getIndex();
            Array lonOriginalData = lonOriginalVar.read();
            Index lonOriginalIndex = lonOriginalData.getIndex();
            Variable depthOriginalVar = ncFileIn.findVariable("depth");
            int nLevels = depthOriginalVar.getDimension(0).getLength();
            Array depthOriginalData = depthOriginalVar.read();
            Dimension latDim = ncFileOut.addDimension("lat", nLat);
            Dimension lonDim = ncFileOut.addDimension("lon", nLon);
            Dimension depthDim = ncFileOut.addDimension("depth", nLevels);
            Dimension timeDim = ncFileOut.addDimension("time", 1);
            this.computeMatrixExtremes(latOriginalData, lonOriginalData, nLon, nLat, latOriginalIndex, lonOriginalIndex);
            NetCDFConverterUtilities.copyGlobalAttributes(ncFileOut, ncFileIn.getGlobalAttributes());
            Variable timeVar = ncFileOut.addVariable("time", DataType.FLOAT, new Dimension[]{timeDim});
            Attribute referenceTime = ncFileIn.findGlobalAttribute(TIME_ORIGIN);
            Attribute forecastDate = ncFileIn.findGlobalAttribute(FORECAST_DAY);
            int numDay = 0;
            if (referenceTime != null && forecastDate != null) {
                numDay = this.setTime(ncFileOut, referenceTime, forecastDate);
            }
            ArrayFloat latDestData = new ArrayFloat(new int[]{latOriginalDim.getLength()});
            Index latDestIndex = latDestData.getIndex();
            ncFileOut.addVariable("lat", DataType.FLOAT, new Dimension[]{latDim});
            ncFileOut.addVariableAttribute("lat", "long_name", "latitude");
            ncFileOut.addVariableAttribute("lat", UNITS, latOriginalVar.getUnitsString());
            for (int yPos = 0; yPos < latOriginalDim.getLength(); ++yPos) {
                latDestData.setFloat(latDestIndex.set(yPos), new Float(this.ymax - new Float(yPos).floatValue() * this.periodY).floatValue());
            }
            ArrayFloat lonDestData = new ArrayFloat(new int[]{lonOriginalDim.getLength()});
            Index lonDestIndex = lonDestData.getIndex();
            ncFileOut.addVariable("lon", DataType.FLOAT, new Dimension[]{lonDim});
            ncFileOut.addVariableAttribute("lon", "long_name", "longitude");
            ncFileOut.addVariableAttribute("lon", UNITS, lonOriginalVar.getUnitsString());
            for (int xPos = 0; xPos < lonOriginalDim.getLength(); ++xPos) {
                lonDestData.setFloat(lonDestIndex.set(xPos), new Float(this.xmin + new Float(xPos).floatValue() * this.periodX).floatValue());
            }
            ArrayFloat depthDestData = new ArrayFloat(new int[]{depthDim.getLength()});
            Index depthDestIndex = depthDestData.getIndex();
            ncFileOut.addVariable("depth", DataType.FLOAT, new Dimension[]{depthDim});
            ncFileOut.addVariableAttribute("depth", "long_name", "depth");
            ncFileOut.addVariableAttribute("depth", UNITS, depthOriginalVar.getUnitsString());
            Attribute positiveAttrib = depthOriginalVar.findAttribute("positive");
            String positiveValue = "down";
            if (positiveAttrib != null) {
                positiveValue = positiveAttrib.getStringValue();
            }
            ncFileOut.addVariableAttribute("depth", "positive", positiveValue);
            for (int wPos = 0; wPos < depthDim.getLength(); ++wPos) {
                depthDestData.setFloat(depthDestIndex.set(wPos), depthOriginalData.getFloat(depthDestIndex));
            }
            int numVars = 0;
            ArrayList<String> variables = new ArrayList<String>(5);
            for (int i = 0; i < NUMVARS; ++i) {
                String varName = VARIABLES.get(i);
                Variable var = ncFileIn.findVariable(varName);
                if (var == null) continue;
                variables.add(varName);
                boolean hasLocalDepth = NetCDFConverterUtilities.hasThisDimension(var, "depth");
                if (hasLocalDepth) {
                    ncFileOut.addVariable(varName, var.getDataType(), new Dimension[]{timeDim, depthDim, latDim, lonDim});
                } else {
                    ncFileOut.addVariable(varName, var.getDataType(), new Dimension[]{timeDim, latDim, lonDim});
                }
                NetCDFConverterUtilities.setVariableAttributes(var, ncFileOut, new String[]{"positions"});
                ++numVars;
            }
            ncFileOut.create();
            ArrayFloat timeData = new ArrayFloat(new int[]{timeDim.getLength()});
            Index timeIndex = timeData.getIndex();
            timeData.setFloat(timeIndex.set(0), (float)numDay);
            ncFileOut.write("time", (Array)timeData);
            timeDim.addCoordinateVariable(timeVar);
            Variable latitudeVar = ncFileOut.findVariable("lat");
            latDim.addCoordinateVariable(latitudeVar);
            ncFileOut.write("lat", (Array)latDestData);
            Variable longitudeVar = ncFileOut.findVariable("lon");
            lonDim.addCoordinateVariable(longitudeVar);
            ncFileOut.write("lon", (Array)lonDestData);
            Variable depthVar = ncFileOut.findVariable("depth");
            depthDim.addCoordinateVariable(depthVar);
            ncFileOut.write("depth", (Array)depthDestData);
            for (int i = 0; i < numVars; ++i) {
                String varName = (String)variables.get(i);
                Variable var = ncFileIn.findVariable(varName);
                boolean hasLocalDepth = NetCDFConverterUtilities.hasThisDimension(var, "depth");
                Array originalData = var.read();
                Index varIndex = originalData.getIndex();
                DataType varDataType = var.getDataType();
                Attribute fv = var.findAttribute("_FillValue");
                float fillValue = Float.NaN;
                if (fv != null) {
                    fillValue = fv.getNumericValue().floatValue();
                }
                Array destArray = null;
                int[] dimensions = null;
                dimensions = hasLocalDepth ? new int[]{timeDim.getLength(), depthDim.getLength(), nLat, nLon} : new int[]{timeDim.getLength(), nLat, nLon};
                destArray = NetCDFConverterUtilities.getArray(dimensions, varDataType);
                Index destIndex = destArray.getIndex();
                ArrayFloat tempData = new ArrayFloat(new int[]{latOriginalDim.getLength(), lonOriginalDim.getLength()});
                Index tempIndex = tempData.getIndex();
                if (hasLocalDepth) {
                    for (int levelPos = 0; levelPos < depthDim.getLength(); ++levelPos) {
                        for (int yPos = 0; yPos < latOriginalDim.getLength(); ++yPos) {
                            for (int xPos = 0; xPos < lonOriginalDim.getLength(); ++xPos) {
                                tempData.setFloat(tempIndex.set(yPos, xPos), originalData.getFloat(varIndex.set(levelPos, yPos, xPos)));
                            }
                        }
                        WritableRaster outData = this.Resampler(latOriginalData, lonOriginalData, lonOriginalDim.getLength(), latOriginalDim.getLength(), 2, (Array)tempData, fillValue);
                        for (int j = 0; j < latOriginalDim.getLength(); ++j) {
                            for (int k = 0; k < lonOriginalDim.getLength(); ++k) {
                                float sample = outData.getSampleFloat(k, j, 0);
                                destArray.setFloat(destIndex.set(0, levelPos, j, k), sample);
                            }
                        }
                    }
                } else {
                    for (int yPos = 0; yPos < latOriginalDim.getLength(); ++yPos) {
                        for (int xPos = 0; xPos < lonOriginalDim.getLength(); ++xPos) {
                            tempData.setFloat(tempIndex.set(yPos, xPos), originalData.getFloat(varIndex.set(yPos, xPos)));
                        }
                    }
                    WritableRaster outData = this.Resampler(latOriginalData, lonOriginalData, lonOriginalDim.getLength(), latOriginalDim.getLength(), 2, (Array)tempData, fillValue);
                    for (int j = 0; j < latOriginalDim.getLength(); ++j) {
                        for (int k = 0; k < lonOriginalDim.getLength(); ++k) {
                            float sample = outData.getSampleFloat(k, j, 0);
                            destArray.setFloat(destIndex.set(0, j, k), sample);
                        }
                    }
                }
                ncFileOut.write(varName, destArray);
            }
            ncFileOut.close();
            outputFile.renameTo(fileOut);
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, e.getLocalizedMessage(), e);
            }
            JAI.getDefaultInstance().getTileCache().flush();
        }
    }

    private int setTime(NetcdfFileWriteable ncFileOut, Attribute referenceTime, Attribute forecastDate) {
        String timeOrigin = referenceTime.getStringValue();
        String forecastDays = forecastDate.getStringValue();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setDateFormatSymbols(new DateFormatSymbols(Locale.CANADA));
        int numDay = 0;
        try {
            Object second;
            Object minute;
            Date startDate = sdf.parse(timeOrigin);
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(startDate);
            String year = Integer.toString(calendar.get(1));
            String month = Integer.toString(calendar.get(2) + 1);
            String day = Integer.toString(calendar.get(5));
            Object hour = Integer.toString(calendar.get(10));
            if (((String)hour).equalsIgnoreCase("0")) {
                hour = (String)hour + "0";
            }
            if (((String)(minute = Integer.toString(calendar.get(12)))).equalsIgnoreCase("0")) {
                minute = (String)minute + "0";
            }
            if (((String)(second = Integer.toString(calendar.get(13)))).equalsIgnoreCase("0")) {
                second = (String)second + "0";
            }
            String millisecond = Integer.toString(calendar.get(14));
            StringBuffer sbTime = new StringBuffer(year).append("-").append(month).append("-").append(day).append(" ").append((String)hour).append(":").append((String)minute).append(":").append((String)second).append(".").append(millisecond);
            ncFileOut.addVariableAttribute("time", UNITS, "days since " + sbTime.toString());
            ncFileOut.addVariableAttribute("time", "long_name", "time");
        }
        catch (ParseException calendar) {
            // empty catch block
        }
        if (forecastDays != null) {
            int index = forecastDays.indexOf("-day_forecast");
            if (index != -1) {
                numDay = Integer.parseInt(forecastDays.substring(0, index));
            }
            return numDay;
        }
        throw new IllegalArgumentException("Unable to find forecast day");
    }

    protected synchronized void dispose() {
        LOGGER.info("Disposing MercatorOceanConverter...");
        LOGGER.info("Disposing MercatorOceanConverter... Done!");
    }

    private WritableRaster Resampler(Array latData, Array lonData, int imageWidth, int imageHeight, int polyDegree, Array data, float fillValue) {
        Index latIndex = latData.getIndex();
        Index lonIndex = lonData.getIndex();
        int numCoeffs = (polyDegree + 1) * (polyDegree + 2) / 2;
        boolean XOFFSET = false;
        boolean YOFFSET = true;
        int stepX = 2;
        int stepY = 2;
        int numNeededPoints = 0;
        for (int xi = 0; xi < imageWidth; xi += 2) {
            for (int yi = 0; yi < imageHeight; yi += 2) {
                ++numNeededPoints;
            }
        }
        this.computeMatrixExtremes(latData, lonData, imageWidth, imageHeight, latIndex, lonIndex);
        float[] destCoords = new float[2 * numNeededPoints];
        float[] srcCoords = new float[2 * numNeededPoints];
        int offset = 0;
        for (int yi = 0; yi < imageHeight; yi += 2) {
            for (int xi = 0; xi < imageWidth; xi += 2) {
                srcCoords[offset] = xi;
                srcCoords[offset + 1] = yi;
                destCoords[offset] = (lonData.getFloat(lonIndex.set(xi)) - this.xmin) / this.periodX;
                destCoords[offset + 1] = (this.ymax - latData.getFloat(latIndex.set(yi))) / this.periodY;
                offset += 2;
            }
        }
        GMatrix A = new GMatrix(numNeededPoints, numCoeffs);
        for (int coord = 0; coord < numNeededPoints; ++coord) {
            int var = 0;
            for (int i = 0; i <= polyDegree; ++i) {
                for (int j = 0; j <= i; ++j) {
                    double value = Math.pow(destCoords[2 * coord + 0], i - j) * Math.pow(destCoords[2 * coord + 1], j);
                    A.setElement(coord, var++, value);
                }
            }
        }
        GMatrix AtAi = new GMatrix(numCoeffs, numCoeffs);
        GMatrix Ap = new GMatrix(numCoeffs, numNeededPoints);
        AtAi.mulTransposeLeft(A, A);
        AtAi.invert();
        Ap.mulTransposeRight(AtAi, A);
        GMatrix xVector = new GMatrix(numNeededPoints, 1);
        GMatrix yVector = new GMatrix(numNeededPoints, 1);
        for (int idx = 0; idx < numNeededPoints; ++idx) {
            xVector.setElement(idx, 0, (double)srcCoords[2 * idx + 0]);
            yVector.setElement(idx, 0, (double)srcCoords[2 * idx + 1]);
        }
        GMatrix xCoeffsG = new GMatrix(numCoeffs, 1);
        GMatrix yCoeffsG = new GMatrix(numCoeffs, 1);
        xCoeffsG.mul(Ap, xVector);
        yCoeffsG.mul(Ap, yVector);
        float[] xCoeffs = new float[numCoeffs];
        float[] yCoeffs = new float[numCoeffs];
        for (int ii = 0; ii < numCoeffs; ++ii) {
            xCoeffs[ii] = new Double(xCoeffsG.getElement(ii, 0)).floatValue();
            yCoeffs[ii] = new Double(yCoeffsG.getElement(ii, 0)).floatValue();
        }
        SampleModel outSampleModel = RasterFactory.createBandedSampleModel((int)4, (int)imageWidth, (int)imageHeight, (int)1);
        WritableRaster outDataCube = Raster.createWritableRaster(outSampleModel, null);
        WritableRandomIter iteratorDataCube = RandomIterFactory.createWritable((WritableRaster)outDataCube, null);
        Index indexInputVar = data.getIndex();
        for (int jj = 0; jj < outDataCube.getNumBands(); ++jj) {
            for (int kk = 0; kk < outDataCube.getWidth(); ++kk) {
                for (int ll = 0; ll < outDataCube.getHeight(); ++ll) {
                    iteratorDataCube.setSample(kk, ll, jj, data.getFloat(indexInputVar.set(ll, kk)));
                }
            }
        }
        WritableRaster target = RasterFactory.createWritableRaster((SampleModel)outSampleModel, null);
        for (int bi = 0; bi < outDataCube.getNumBands(); ++bi) {
            for (int yi = 0; yi < imageHeight; ++yi) {
                for (int xi = 0; xi < imageWidth; ++xi) {
                    GMatrix regressionVec = new GMatrix(numCoeffs, 1);
                    int var = 0;
                    for (int i = 0; i <= polyDegree; ++i) {
                        for (int j = 0; j <= i; ++j) {
                            double value = Math.pow(xi, i - j) * Math.pow(yi, j);
                            regressionVec.setElement(var++, 0, value);
                        }
                    }
                    GMatrix xG = new GMatrix(1, 1);
                    GMatrix yG = new GMatrix(1, 1);
                    xG.mulTransposeLeft(regressionVec, xCoeffsG);
                    yG.mulTransposeLeft(regressionVec, yCoeffsG);
                    int X = (int)Math.round(xG.getElement(0, 0));
                    int Y = (int)Math.round(yG.getElement(0, 0));
                    if (X >= 0 && Y >= 0 && X < imageWidth && Y < imageHeight) {
                        target.setSample(xi, yi, bi, outDataCube.getSampleFloat(X, Y, bi));
                        continue;
                    }
                    target.setSample(xi, yi, bi, fillValue);
                }
            }
        }
        return target;
    }

    private void computeMatrixExtremes(Array latData, Array lonData, int imageWidth, int imageHeight, Index latIndex, Index lonIndex) {
        if (Float.isNaN(this.xmin) || Float.isNaN(this.ymin) || Float.isNaN(this.xmax) || Float.isNaN(this.ymax) || Float.isNaN(this.periodX) || Float.isNaN(this.periodY)) {
            this.xmin = Float.POSITIVE_INFINITY;
            this.ymin = Float.POSITIVE_INFINITY;
            this.xmax = Float.NEGATIVE_INFINITY;
            this.ymax = Float.NEGATIVE_INFINITY;
            for (int yi = 0; yi < imageHeight; ++yi) {
                for (int xi = 0; xi < imageWidth; ++xi) {
                    float x = lonData.getFloat(lonIndex.set(xi));
                    float y = latData.getFloat(latIndex.set(yi));
                    if (x < this.xmin) {
                        this.xmin = x;
                    }
                    if (x > this.xmax) {
                        this.xmax = x;
                    }
                    if (y < this.ymin) {
                        this.ymin = y;
                    }
                    if (!(y > this.ymax)) continue;
                    this.ymax = y;
                }
            }
            float rangeX = this.xmax - this.xmin;
            float rangeY = this.ymax - this.ymin;
            this.periodX = rangeX / (float)(imageWidth - 1);
            this.periodY = rangeY / (float)(imageHeight - 1);
            System.out.println(this.xmin + ":" + this.ymin + " - " + this.xmax + ":" + this.ymax + " / " + this.periodX + ":" + this.periodY);
        }
    }

    static {
        VARIABLES.add("temperature");
        VARIABLES.add("salinity");
        VARIABLES.add("u");
        VARIABLES.add("v");
        VARIABLES.add("kz");
        VARIABLES.add("ssh");
        VARIABLES.add("mlp");
        VARIABLES.add("taux");
        VARIABLES.add("tauy");
        VARIABLES.add("qtot");
        VARIABLES.add("emp");
        VARIABLES.add("qsr");
        VARIABLES.add("hice");
        VARIABLES.add("fice");
        VARIABLES.add("uice");
        VARIABLES.add("hice");
        NUMVARS = VARIABLES.size();
        LOGGER = Logger.getLogger("it.geosolutions.processing.node.worker.netcdf");
    }
}

