/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.utilities;

import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageReaderWriterSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;
import org.eclipse.imagen.JAI;
import org.eclipse.imagen.NotAColorSpace;
import org.eclipse.imagen.OperationRegistry;
import org.eclipse.imagen.PlanarImage;
import org.eclipse.imagen.ROI;
import org.eclipse.imagen.RasterFactory;
import org.eclipse.imagen.RenderedOp;
import org.eclipse.imagen.media.viewer.RenderedImageBrowser;
import org.eclipse.imagen.registry.RIFRegistry;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ImageIOUtilities {
    private static boolean SKIP_EXTERNAL_FILES_LOOKUP = Boolean.getBoolean("it.geosolutions.skip.external.files.lookup");
    static final int MAX_SUBSAMPLING_FACTOR = Integer.MAX_VALUE;
    static final int MAX_LEVELS = 31;
    static final String[] spacesFactory = new String[20];
    private static final int DEFAULT_ROI = -999;

    private ImageIOUtilities() {
    }

    public static final ColorModel createColorModel(SampleModel sampleModel) {
        if (sampleModel == null) {
            throw new IllegalArgumentException("sampleModel == null!");
        }
        int dataType = sampleModel.getDataType();
        switch (dataType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                return null;
            }
        }
        ColorModel colorModel = null;
        int[] sampleSize = sampleModel.getSampleSize();
        if (sampleModel instanceof ComponentSampleModel) {
            int transparency;
            int numBands = sampleModel.getNumBands();
            ColorSpace colorSpace = null;
            colorSpace = numBands <= 2 ? ColorSpace.getInstance(1003) : (numBands <= 4 ? ColorSpace.getInstance(1000) : new NotAColorSpace(numBands));
            boolean hasAlpha = numBands == 2 || numBands == 4;
            boolean isAlphaPremultiplied = false;
            int n = transparency = hasAlpha ? 3 : 1;
            colorModel = dataType == 2 ? new ComponentColorModel(colorSpace, sampleSize, hasAlpha, isAlphaPremultiplied, transparency, dataType) : RasterFactory.createComponentColorModel((int)dataType, (ColorSpace)colorSpace, (boolean)hasAlpha, (boolean)isAlphaPremultiplied, (int)transparency);
        } else {
            if (sampleModel.getNumBands() <= 4 && sampleModel instanceof SinglePixelPackedSampleModel) {
                SinglePixelPackedSampleModel sppsm = (SinglePixelPackedSampleModel)sampleModel;
                int[] bitMasks = sppsm.getBitMasks();
                int rmask = 0;
                int gmask = 0;
                int bmask = 0;
                int amask = 0;
                int numBands = bitMasks.length;
                if (numBands <= 2) {
                    gmask = bmask = bitMasks[0];
                    rmask = bmask;
                    if (numBands == 2) {
                        amask = bitMasks[1];
                    }
                } else {
                    rmask = bitMasks[0];
                    gmask = bitMasks[1];
                    bmask = bitMasks[2];
                    if (numBands == 4) {
                        amask = bitMasks[3];
                    }
                }
                int bits = 0;
                for (int i = 0; i < sampleSize.length; ++i) {
                    bits += sampleSize[i];
                }
                return new DirectColorModel(bits, rmask, gmask, bmask, amask);
            }
            if (sampleModel instanceof MultiPixelPackedSampleModel) {
                int bitsPerSample = sampleSize[0];
                int numEntries = 1 << bitsPerSample;
                byte[] map = new byte[numEntries];
                for (int i = 0; i < numEntries; ++i) {
                    map[i] = (byte)(i * 255 / (numEntries - 1));
                }
                colorModel = new IndexColorModel(bitsPerSample, numEntries, map, map, map);
            }
        }
        return colorModel;
    }

    public static void displayImageIOMetadata(Node root) {
        ImageIOUtilities.displayMetadata(root, 0);
    }

    static void indent(int level) {
        for (int i = 0; i < level; ++i) {
            System.out.print("  ");
        }
    }

    static void displayMetadata(Node node, int level) {
        Node child;
        ImageIOUtilities.indent(level);
        System.out.print("<" + node.getNodeName());
        NamedNodeMap map = node.getAttributes();
        if (map != null) {
            int length = map.getLength();
            for (int i = 0; i < length; ++i) {
                Node attr = map.item(i);
                String attrValue = attr.getNodeValue();
                if (attrValue == null) {
                    attrValue = "";
                }
                System.out.print(" " + attr.getNodeName() + "=\"" + attrValue + "\"");
            }
        }
        System.out.print(">");
        String nodeValue = node.getNodeValue();
        if (nodeValue != null) {
            System.out.println(" " + nodeValue);
        } else {
            System.out.println("");
        }
        if (child != null) {
            for (child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                ImageIOUtilities.displayMetadata(child, level + 1);
            }
            ImageIOUtilities.indent(level);
            System.out.println("</" + node.getNodeName() + ">");
        }
    }

    static void visualizeRescaled(RenderedImage image, String title, int roiThreshold) {
        ROI roi = new ROI(image, roiThreshold);
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(image);
        if (roi != null) {
            pb.add(roi);
        }
        RenderedOp op = JAI.create((String)"extrema", (ParameterBlock)pb);
        double[][] extrema = (double[][])op.getProperty("extrema");
        double[] scale = new double[]{255.0 / (extrema[1][0] - extrema[0][0])};
        double[] offset = new double[]{255.0 * extrema[0][0] / (extrema[0][0] - extrema[1][0])};
        ParameterBlock pbRescale = new ParameterBlock();
        pbRescale.add(scale);
        pbRescale.add(offset);
        pbRescale.addSource(image);
        RenderedOp rescaledImage = JAI.create((String)"Rescale", (ParameterBlock)pbRescale);
        ParameterBlock pbConvert = new ParameterBlock();
        pbConvert.addSource(rescaledImage);
        pbConvert.add(0);
        RenderedOp destImage = JAI.create((String)"format", (ParameterBlock)pbConvert);
        ImageIOUtilities.visualize((RenderedImage)destImage, title);
    }

    public static void visualize(RenderedImage ri) {
        ImageIOUtilities.visualize(ri, "");
    }

    public static void visualize(RenderedImage ri, String title) {
        RenderedImageBrowser.showChain((RenderedImage)ri, (boolean)false, (boolean)true, (String)title, (boolean)true);
    }

    public static void visualize(RenderedImage ri, String title, boolean rescale) {
        ImageIOUtilities.visualize(ri, title, rescale, -999);
    }

    public static void visualize(RenderedImage ri, String title, boolean rescale, int roiThreshold) {
        if (rescale) {
            ImageIOUtilities.visualizeRescaled(ri, title, roiThreshold);
        } else {
            ImageIOUtilities.visualize(ri, title);
        }
    }

    public static List<ImageReaderWriterSpi> getJDKImageReaderWriterSPI(ServiceRegistry registry, String formatName, boolean isReader) {
        String descPart;
        Class spiClass;
        IIORegistry iioRegistry = (IIORegistry)registry;
        if (isReader) {
            spiClass = ImageReaderSpi.class;
            descPart = " image reader";
        } else {
            spiClass = ImageWriterSpi.class;
            descPart = " image writer";
        }
        Iterator<ImageReaderSpi> iter = iioRegistry.getServiceProviders(spiClass, true);
        String desc = "standard " + formatName + descPart;
        String jiioPath = "com.sun.media.imageioimpl";
        Locale locale = Locale.getDefault();
        ArrayList<ImageReaderWriterSpi> list = new ArrayList<ImageReaderWriterSpi>();
        block0: while (iter.hasNext()) {
            ImageReaderWriterSpi provider = iter.next();
            if (!provider.getVendorName().startsWith("Sun Microsystems") || !desc.equalsIgnoreCase(provider.getDescription(locale)) || provider.getPluginClassName().startsWith(jiioPath)) continue;
            String[] formatNames = provider.getFormatNames();
            for (int i = 0; i < formatNames.length; ++i) {
                if (!formatNames[i].equalsIgnoreCase(formatName)) continue;
                list.add(provider);
                continue block0;
            }
        }
        return list;
    }

    public static List<ImageReaderWriterSpi> getImageReaderWriterSPI(ServiceRegistry registry, ServiceRegistry.Filter filter, String formatName, boolean isReader) {
        IIORegistry iioRegistry = (IIORegistry)registry;
        Class spiClass = isReader ? ImageReaderSpi.class : ImageWriterSpi.class;
        Iterator<ImageReaderSpi> iter = iioRegistry.getServiceProviders(spiClass, filter, true);
        ArrayList<ImageReaderWriterSpi> list = new ArrayList<ImageReaderWriterSpi>();
        block0: while (iter.hasNext()) {
            ImageReaderWriterSpi provider = iter.next();
            String[] formatNames = provider.getFormatNames();
            for (int i = 0; i < formatNames.length; ++i) {
                if (!formatNames[i].equalsIgnoreCase(formatName)) continue;
                list.add(provider);
                continue block0;
            }
        }
        return list;
    }

    public static boolean replaceProvider(Class<? extends ImageReaderWriterSpi> providerClass, String customProviderName, String originalProviderName, String format) {
        IIORegistry registry = IIORegistry.getDefaultInstance();
        Object standard = null;
        ImageReaderWriterSpi custom = null;
        Iterator<? extends ImageReaderWriterSpi> it = registry.getServiceProviders(providerClass, false);
        while (it.hasNext()) {
            ImageReaderWriterSpi provider = it.next();
            String providerClassName = provider.getClass().getName();
            String[] formats = provider.getFormatNames();
            for (int i = 0; i < formats.length; ++i) {
                if (!formats[i].equalsIgnoreCase(format)) continue;
                if (providerClassName.equalsIgnoreCase(originalProviderName)) {
                    standard = provider;
                    continue;
                }
                if (!providerClassName.equalsIgnoreCase(customProviderName)) continue;
                custom = provider;
            }
        }
        if (standard != null && custom != null) {
            if (ImageReaderSpi.class.isAssignableFrom(standard.getClass())) {
                return registry.setOrdering(ImageReaderSpi.class, (ImageReaderSpi)custom, (ImageReaderSpi)standard);
            }
            return registry.setOrdering(ImageWriterSpi.class, (ImageWriterSpi)custom, (ImageWriterSpi)standard);
        }
        return false;
    }

    public static boolean equals(Object object1, Object object2) {
        return object1 == object2 || object1 != null && object1.equals(object2);
    }

    public static boolean sameInterfaces(Class<?> object1, Class<?> object2, Class<?> base) {
        Class<?> c;
        int i;
        if (object1 == object2) {
            return true;
        }
        if (object1 == null || object2 == null) {
            return false;
        }
        Class<?>[] c1 = object1.getInterfaces();
        Class<?>[] c2 = object2.getInterfaces();
        int n = 0;
        for (i = 0; i < c2.length; ++i) {
            c = c2[i];
            if (!base.isAssignableFrom(c)) continue;
            c2[n++] = c;
        }
        block1: for (i = 0; i < c1.length; ++i) {
            c = c1[i];
            if (!base.isAssignableFrom(c)) continue;
            for (int j = 0; j < n; ++j) {
                if (!c.equals(c2[j])) continue;
                System.arraycopy(c2, j + 1, c2, j, --n - j);
                continue block1;
            }
            return false;
        }
        return n == 0;
    }

    public static String spaces(int length) {
        int last = spacesFactory.length - 1;
        if (length < 0) {
            length = 0;
        }
        if (length <= last) {
            if (spacesFactory[length] == null) {
                if (spacesFactory[last] == null) {
                    char[] blancs = new char[last];
                    Arrays.fill(blancs, ' ');
                    ImageIOUtilities.spacesFactory[last] = new String(blancs).intern();
                }
                ImageIOUtilities.spacesFactory[length] = spacesFactory[last].substring(0, length).intern();
            }
            return spacesFactory[length];
        }
        char[] blancs = new char[length];
        Arrays.fill(blancs, ' ');
        return new String(blancs);
    }

    public static Class<?> classForDataBufferType(int dataType) {
        switch (dataType) {
            case 0: {
                return Byte.class;
            }
            case 1: 
            case 2: {
                return Short.class;
            }
            case 3: {
                return Integer.class;
            }
            case 4: {
                return Float.class;
            }
            case 5: {
                return Double.class;
            }
        }
        throw new IllegalArgumentException("Wrong datatype:" + dataType);
    }

    public static String getShortName(Class<?> classe) {
        Class<?> el;
        if (classe == null) {
            return "<*>";
        }
        int dimension = 0;
        while ((el = classe.getComponentType()) != null) {
            classe = el;
            ++dimension;
        }
        String name = classe.getName();
        int lower = name.lastIndexOf(46);
        int upper = name.length();
        name = name.substring(lower + 1, upper).replace('$', '.');
        if (dimension != 0) {
            StringBuffer buffer = new StringBuffer(name);
            do {
                buffer.append("[]");
            } while (--dimension != 0);
            name = buffer.toString();
        }
        return name;
    }

    public static File urlToFile(URL url) {
        Object path3;
        if (!"file".equals(url.getProtocol())) {
            return null;
        }
        String string = url.toExternalForm();
        if (string.contains("+")) {
            string = string.replace("+", "%2B");
        }
        try {
            string = URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Could not decode the URL to UTF-8 format", e);
        }
        String simplePrefix = "file:/";
        String standardPrefix = "file://";
        String os = System.getProperty("os.name");
        if (os.toUpperCase().contains("WINDOWS") && string.startsWith(standardPrefix)) {
            path3 = string.substring(standardPrefix.length() - 2);
        } else if (string.startsWith(standardPrefix)) {
            path3 = string.substring(standardPrefix.length());
        } else if (string.startsWith(simplePrefix)) {
            path3 = string.substring(simplePrefix.length() - 1);
        } else {
            String auth = url.getAuthority();
            String path2 = url.getPath().replace("%20", " ");
            path3 = auth != null && !auth.equals("") ? "//" + auth + path2 : path2;
        }
        return new File((String)path3);
    }

    public static int getSubSamplingFactor2(int xSubsamplingFactor, int ySubsamplingFactor) {
        boolean changedSubSamplingFactors;
        boolean resamplingIsRequired = false;
        int newSubSamplingFactor = 0;
        boolean subSamplingFactorsAreDifferent = xSubsamplingFactor != ySubsamplingFactor;
        newSubSamplingFactor = xSubsamplingFactor <= ySubsamplingFactor ? xSubsamplingFactor : ySubsamplingFactor;
        boolean bl = changedSubSamplingFactors = newSubSamplingFactor > Integer.MAX_VALUE;
        if (newSubSamplingFactor > Integer.MAX_VALUE) {
            newSubSamplingFactor = Integer.MAX_VALUE;
        }
        int optimalSubsampling = ImageIOUtilities.findOptimalSubSampling(newSubSamplingFactor);
        resamplingIsRequired = subSamplingFactorsAreDifferent || changedSubSamplingFactors || optimalSubsampling != newSubSamplingFactor;
        newSubSamplingFactor = !resamplingIsRequired ? 0 : optimalSubsampling;
        return newSubSamplingFactor;
    }

    static int findOptimalSubSampling(int newSubSamplingFactor) {
        int optimalSubSamplingFactor = 1;
        for (int level = 0; level < 31; ++level) {
            if (optimalSubSamplingFactor < newSubSamplingFactor) {
                optimalSubSamplingFactor = 1 << level;
                continue;
            }
            if (optimalSubSamplingFactor > newSubSamplingFactor) {
                optimalSubSamplingFactor >>= 1;
                break;
            }
            if (optimalSubSamplingFactor == newSubSamplingFactor) break;
        }
        return optimalSubSamplingFactor;
    }

    public static String getShortClassName(Object object) {
        return ImageIOUtilities.getShortName(object != null ? object.getClass() : null);
    }

    public static String adjustAttributeName(String attributeName) {
        if (attributeName.contains("\\")) {
            return attributeName.replace("\\", "_");
        }
        return attributeName;
    }

    public static synchronized void setNativeAccelerationAllowed(String operation, boolean allowed, JAI jai) {
        String product = "org.eclipse.imagen.media";
        OperationRegistry registry = jai.getOperationRegistry();
        List factories = registry.getOrderedFactoryList("rendered", operation, "org.eclipse.imagen.media");
        if (factories != null) {
            RenderedImageFactory javaFactory = null;
            RenderedImageFactory nativeFactory = null;
            Boolean currentState = null;
            for (RenderedImageFactory factory : factories) {
                String pack = factory.getClass().getPackage().getName();
                if (pack.equals("org.eclipse.imagen.media.mlib")) {
                    nativeFactory = factory;
                    if (javaFactory != null) {
                        currentState = Boolean.FALSE;
                    }
                }
                if (!pack.equals("org.eclipse.imagen.media.opimage")) continue;
                javaFactory = factory;
                if (nativeFactory == null) continue;
                currentState = Boolean.TRUE;
            }
            if (currentState != null && currentState != allowed) {
                RIFRegistry.unsetPreference((OperationRegistry)registry, (String)operation, (String)"org.eclipse.imagen.media", (RenderedImageFactory)(allowed ? javaFactory : nativeFactory), (RenderedImageFactory)(allowed ? nativeFactory : javaFactory));
                RIFRegistry.setPreference((OperationRegistry)registry, (String)operation, (String)"org.eclipse.imagen.media", (RenderedImageFactory)(allowed ? nativeFactory : javaFactory), (RenderedImageFactory)(allowed ? javaFactory : nativeFactory));
            }
        }
    }

    public static void setNativeAccelerationAllowed(String operation, boolean allowed) {
        ImageIOUtilities.setNativeAccelerationAllowed(operation, allowed, JAI.getDefaultInstance());
    }

    public static final void checkNotNull(Object checkMe, String message) {
        if (checkMe == null) {
            throw new IllegalArgumentException(message != null ? message : "The provided object was NULL");
        }
    }

    public static void disposeImage(RenderedImage rOp) {
        if (rOp != null && rOp instanceof RenderedOp) {
            ROI roiImage;
            PlanarImage image;
            Object roi;
            RenderedOp renderedOp = (RenderedOp)rOp;
            int nSources = renderedOp.getNumSources();
            if (nSources > 0) {
                for (int k = 0; k < nSources; ++k) {
                    Object source = null;
                    try {
                        source = renderedOp.getSourceObject(k);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                    if (source == null) continue;
                    if (source instanceof RenderedOp) {
                        ImageIOUtilities.disposeImage((RenderedImage)((RenderedOp)source));
                        continue;
                    }
                    if (!(source instanceof BufferedImage)) continue;
                    ((BufferedImage)source).flush();
                    source = null;
                }
            } else {
                Object imageReader = rOp.getProperty("JAI.ImageReader");
                if (imageReader != null && imageReader instanceof ImageReader) {
                    ImageReader reader = (ImageReader)imageReader;
                    ImageInputStream stream = (ImageInputStream)reader.getInput();
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        reader.dispose();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            if ((roi = rOp.getProperty("ROI")) != null && (roi instanceof ROI || roi instanceof RenderedImage) && (image = (roiImage = (ROI)roi).getAsImage()) != null) {
                image.dispose();
                image = null;
                roiImage = null;
            }
            if (rOp instanceof PlanarImage) {
                ((PlanarImage)rOp).dispose();
            } else if (rOp instanceof BufferedImage) {
                ((BufferedImage)rOp).flush();
                rOp = null;
            }
        }
    }

    public static boolean isSkipExternalFilesLookup() {
        return SKIP_EXTERNAL_FILES_LOOKUP;
    }

    public static ImageTypeSpecifier getBandSelectedType(int numBands, SampleModel sm) {
        ComponentColorModel cmDestination = new ComponentColorModel((ColorSpace)new NotAColorSpace(numBands), false, false, 1, sm.getDataType());
        SampleModel smDestination = RasterFactory.createComponentSampleModel((SampleModel)sm, (int)sm.getDataType(), (int)sm.getWidth(), (int)sm.getHeight(), (int)numBands);
        return new ImageTypeSpecifier(cmDestination, smDestination);
    }

    public static String convertObjectToString(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof byte[]) {
            byte[] bArray = (byte[])obj;
            StringBuilder sb = new StringBuilder();
            for (byte b : bArray) {
                sb.append(b).append(" ");
            }
            return sb.toString();
        }
        if (obj instanceof int[]) {
            int[] iArray = (int[])obj;
            StringBuilder sb = new StringBuilder();
            for (int i : iArray) {
                sb.append(i).append(" ");
            }
            return sb.toString();
        }
        if (obj instanceof short[]) {
            short[] sArray = (short[])obj;
            StringBuilder sb = new StringBuilder();
            for (short value : sArray) {
                sb.append(value).append(" ");
            }
            return sb.toString();
        }
        return obj.toString();
    }

    public static boolean isBinary(SampleModel sm) {
        return sm instanceof MultiPixelPackedSampleModel && ((MultiPixelPackedSampleModel)sm).getPixelBitStride() == 1 && sm.getNumBands() == 1;
    }

    public static final boolean imageIsContiguous(RenderedImage image) {
        SampleModel sm;
        if (image instanceof BufferedImage) {
            WritableRaster ras = ((BufferedImage)image).getRaster();
            sm = ras.getSampleModel();
        } else {
            sm = image.getSampleModel();
        }
        if (sm instanceof ComponentSampleModel) {
            ComponentSampleModel csm = (ComponentSampleModel)sm;
            if (csm.getPixelStride() != csm.getNumBands()) {
                return false;
            }
            int[] bandOffsets = csm.getBandOffsets();
            for (int i = 0; i < bandOffsets.length; ++i) {
                if (bandOffsets[i] == i) continue;
                return false;
            }
            int[] bankIndices = csm.getBankIndices();
            for (int i = 0; i < bandOffsets.length; ++i) {
                if (bankIndices[i] == 0) continue;
                return false;
            }
            return true;
        }
        return ImageIOUtilities.isBinary(sm);
    }

    public static byte[] getPackedBinaryData(Raster raster, Rectangle rect) {
        byte[] binaryDataArray;
        block24: {
            int bitOffset;
            int eltOffset;
            int lineStride;
            DataBuffer dataBuffer;
            int rectHeight;
            int rectWidth;
            block27: {
                block26: {
                    int numBytesPerRow;
                    block22: {
                        block25: {
                            block23: {
                                SampleModel sm = raster.getSampleModel();
                                if (!ImageIOUtilities.isBinary(sm)) {
                                    throw new IllegalArgumentException("Source image is not binary");
                                }
                                int rectX = rect.x;
                                int rectY = rect.y;
                                rectWidth = rect.width;
                                rectHeight = rect.height;
                                dataBuffer = raster.getDataBuffer();
                                int dx = rectX - raster.getSampleModelTranslateX();
                                int dy = rectY - raster.getSampleModelTranslateY();
                                MultiPixelPackedSampleModel mpp = (MultiPixelPackedSampleModel)sm;
                                lineStride = mpp.getScanlineStride();
                                eltOffset = dataBuffer.getOffset() + mpp.getOffset(dx, dy);
                                bitOffset = mpp.getBitOffset(dx);
                                numBytesPerRow = (rectWidth + 7) / 8;
                                if (dataBuffer instanceof DataBufferByte && eltOffset == 0 && bitOffset == 0 && numBytesPerRow == lineStride && ((DataBufferByte)dataBuffer).getData().length == numBytesPerRow * rectHeight) {
                                    return ((DataBufferByte)dataBuffer).getData();
                                }
                                binaryDataArray = new byte[numBytesPerRow * rectHeight];
                                int b = 0;
                                if (bitOffset != 0) break block22;
                                if (!(dataBuffer instanceof DataBufferByte)) break block23;
                                byte[] data = ((DataBufferByte)dataBuffer).getData();
                                int stride = numBytesPerRow;
                                int offset = 0;
                                for (int y = 0; y < rectHeight; ++y) {
                                    System.arraycopy(data, eltOffset, binaryDataArray, offset, stride);
                                    offset += stride;
                                    eltOffset += lineStride;
                                }
                                break block24;
                            }
                            if (dataBuffer instanceof DataBufferShort || dataBuffer instanceof DataBufferUShort) break block25;
                            if (!(dataBuffer instanceof DataBufferInt)) break block24;
                            int[] data = ((DataBufferInt)dataBuffer).getData();
                            for (int y = 0; y < rectHeight; ++y) {
                                int xRemaining;
                                int i = eltOffset;
                                for (xRemaining = rectWidth; xRemaining > 24; xRemaining -= 32) {
                                    int datum = data[i++];
                                    binaryDataArray[b++] = (byte)(datum >>> 24 & 0xFF);
                                    binaryDataArray[b++] = (byte)(datum >>> 16 & 0xFF);
                                    binaryDataArray[b++] = (byte)(datum >>> 8 & 0xFF);
                                    binaryDataArray[b++] = (byte)(datum & 0xFF);
                                }
                                int shift = 24;
                                while (xRemaining > 0) {
                                    binaryDataArray[b++] = (byte)(data[i] >>> shift & 0xFF);
                                    shift -= 8;
                                    xRemaining -= 8;
                                }
                                eltOffset += lineStride;
                            }
                            break block24;
                        }
                        short[] data = dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getData() : ((DataBufferUShort)dataBuffer).getData();
                        for (int y = 0; y < rectHeight; ++y) {
                            int xRemaining;
                            int i = eltOffset;
                            for (xRemaining = rectWidth; xRemaining > 8; xRemaining -= 16) {
                                short datum = data[i++];
                                binaryDataArray[b++] = (byte)(datum >>> 8 & 0xFF);
                                binaryDataArray[b++] = (byte)(datum & 0xFF);
                            }
                            if (xRemaining > 0) {
                                binaryDataArray[b++] = (byte)(data[i] >>> 8 & 0xFF);
                            }
                            eltOffset += lineStride;
                        }
                        break block24;
                    }
                    if (!(dataBuffer instanceof DataBufferByte)) break block26;
                    byte[] data = ((DataBufferByte)dataBuffer).getData();
                    if ((bitOffset & 7) == 0) {
                        int stride = numBytesPerRow;
                        int offset = 0;
                        for (int y = 0; y < rectHeight; ++y) {
                            System.arraycopy(data, eltOffset, binaryDataArray, offset, stride);
                            offset += stride;
                            eltOffset += lineStride;
                        }
                    } else {
                        int leftShift = bitOffset & 7;
                        int rightShift = 8 - leftShift;
                        for (int y = 0; y < rectHeight; ++y) {
                            int i = eltOffset;
                            for (int xRemaining = rectWidth; xRemaining > 0; xRemaining -= 8) {
                                binaryDataArray[b++] = xRemaining > rightShift ? (byte)((data[i++] & 0xFF) << leftShift | (data[i] & 0xFF) >>> rightShift) : (byte)((data[i] & 0xFF) << leftShift);
                            }
                            eltOffset += lineStride;
                        }
                    }
                    break block24;
                }
                if (dataBuffer instanceof DataBufferShort || dataBuffer instanceof DataBufferUShort) break block27;
                if (!(dataBuffer instanceof DataBufferInt)) break block24;
                int[] data = ((DataBufferInt)dataBuffer).getData();
                for (int y = 0; y < rectHeight; ++y) {
                    int bOffset = bitOffset;
                    int x = 0;
                    while (x < rectWidth) {
                        int i = eltOffset + bOffset / 32;
                        int mod = bOffset % 32;
                        int left = data[i];
                        if (mod <= 24) {
                            binaryDataArray[b++] = (byte)(left >>> 24 - mod);
                        } else {
                            int delta = mod - 24;
                            int right = data[i + 1];
                            binaryDataArray[b++] = (byte)(left << delta | right >>> 32 - delta);
                        }
                        x += 8;
                        bOffset += 8;
                    }
                    eltOffset += lineStride;
                }
                break block24;
            }
            short[] data = dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getData() : ((DataBufferUShort)dataBuffer).getData();
            for (int y = 0; y < rectHeight; ++y) {
                int bOffset = bitOffset;
                int x = 0;
                while (x < rectWidth) {
                    int i = eltOffset + bOffset / 16;
                    int mod = bOffset % 16;
                    int left = data[i] & 0xFFFF;
                    if (mod <= 8) {
                        binaryDataArray[b++] = (byte)(left >>> 8 - mod);
                    } else {
                        int delta = mod - 8;
                        int right = data[i + 1] & 0xFFFF;
                        binaryDataArray[b++] = (byte)(left << delta | right >>> 16 - delta);
                    }
                    x += 8;
                    bOffset += 8;
                }
                eltOffset += lineStride;
            }
        }
        return binaryDataArray;
    }

    public static void setPackedBinaryData(byte[] binaryDataArray, WritableRaster raster, Rectangle rect) {
        block36: {
            int b;
            int bitOffset;
            int eltOffset;
            int lineStride;
            DataBuffer dataBuffer;
            int rectHeight;
            int rectWidth;
            block39: {
                block38: {
                    block34: {
                        block37: {
                            block35: {
                                SampleModel sm = raster.getSampleModel();
                                if (!ImageIOUtilities.isBinary(sm)) {
                                    throw new IllegalArgumentException("Target raster is not binary");
                                }
                                int rectX = rect.x;
                                int rectY = rect.y;
                                rectWidth = rect.width;
                                rectHeight = rect.height;
                                dataBuffer = raster.getDataBuffer();
                                int dx = rectX - raster.getSampleModelTranslateX();
                                int dy = rectY - raster.getSampleModelTranslateY();
                                MultiPixelPackedSampleModel mpp = (MultiPixelPackedSampleModel)sm;
                                lineStride = mpp.getScanlineStride();
                                eltOffset = dataBuffer.getOffset() + mpp.getOffset(dx, dy);
                                bitOffset = mpp.getBitOffset(dx);
                                b = 0;
                                if (bitOffset != 0) break block34;
                                if (!(dataBuffer instanceof DataBufferByte)) break block35;
                                byte[] data = ((DataBufferByte)dataBuffer).getData();
                                if (data == binaryDataArray) {
                                    return;
                                }
                                int stride = (rectWidth + 7) / 8;
                                int offset = 0;
                                for (int y = 0; y < rectHeight; ++y) {
                                    System.arraycopy(binaryDataArray, offset, data, eltOffset, stride);
                                    offset += stride;
                                    eltOffset += lineStride;
                                }
                                break block36;
                            }
                            if (dataBuffer instanceof DataBufferShort || dataBuffer instanceof DataBufferUShort) break block37;
                            if (!(dataBuffer instanceof DataBufferInt)) break block36;
                            int[] data = ((DataBufferInt)dataBuffer).getData();
                            for (int y = 0; y < rectHeight; ++y) {
                                int xRemaining;
                                int i = eltOffset;
                                for (xRemaining = rectWidth; xRemaining > 24; xRemaining -= 32) {
                                    data[i++] = (binaryDataArray[b++] & 0xFF) << 24 | (binaryDataArray[b++] & 0xFF) << 16 | (binaryDataArray[b++] & 0xFF) << 8 | binaryDataArray[b++] & 0xFF;
                                }
                                int shift = 24;
                                while (xRemaining > 0) {
                                    int n = i;
                                    data[n] = data[n] | (binaryDataArray[b++] & 0xFF) << shift;
                                    shift -= 8;
                                    xRemaining -= 8;
                                }
                                eltOffset += lineStride;
                            }
                            break block36;
                        }
                        short[] data = dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getData() : ((DataBufferUShort)dataBuffer).getData();
                        for (int y = 0; y < rectHeight; ++y) {
                            int xRemaining;
                            int i = eltOffset;
                            for (xRemaining = rectWidth; xRemaining > 8; xRemaining -= 16) {
                                data[i++] = (short)((binaryDataArray[b++] & 0xFF) << 8 | binaryDataArray[b++] & 0xFF);
                            }
                            if (xRemaining > 0) {
                                data[i++] = (short)((binaryDataArray[b++] & 0xFF) << 8);
                            }
                            eltOffset += lineStride;
                        }
                        break block36;
                    }
                    int stride = (rectWidth + 7) / 8;
                    int offset = 0;
                    if (!(dataBuffer instanceof DataBufferByte)) break block38;
                    byte[] data = ((DataBufferByte)dataBuffer).getData();
                    if ((bitOffset & 7) == 0) {
                        for (int y = 0; y < rectHeight; ++y) {
                            System.arraycopy(binaryDataArray, offset, data, eltOffset, stride);
                            offset += stride;
                            eltOffset += lineStride;
                        }
                    } else {
                        int rightShift = bitOffset & 7;
                        int leftShift = 8 - rightShift;
                        int leftShift8 = 8 + leftShift;
                        byte mask = (byte)(255 << leftShift);
                        byte mask1 = ~mask;
                        for (int y = 0; y < rectHeight; ++y) {
                            int i = eltOffset;
                            for (int xRemaining = rectWidth; xRemaining > 0; xRemaining -= 8) {
                                byte datum = binaryDataArray[b++];
                                if (xRemaining > leftShift8) {
                                    data[i] = (byte)(data[i] & mask | (datum & 0xFF) >>> rightShift);
                                    data[++i] = (byte)((datum & 0xFF) << leftShift);
                                    continue;
                                }
                                if (xRemaining > leftShift) {
                                    data[i] = (byte)(data[i] & mask | (datum & 0xFF) >>> rightShift);
                                    data[++i] = (byte)(data[i] & mask1 | (datum & 0xFF) << leftShift);
                                    continue;
                                }
                                int remainMask = (1 << leftShift - xRemaining) - 1;
                                data[i] = (byte)(data[i] & (mask | remainMask) | (datum & 0xFF) >>> rightShift & ~remainMask);
                            }
                            eltOffset += lineStride;
                        }
                    }
                    break block36;
                }
                if (dataBuffer instanceof DataBufferShort || dataBuffer instanceof DataBufferUShort) break block39;
                if (!(dataBuffer instanceof DataBufferInt)) break block36;
                int[] data = ((DataBufferInt)dataBuffer).getData();
                int rightShift = bitOffset & 7;
                int leftShift = 8 - rightShift;
                int leftShift32 = 32 + leftShift;
                int mask = -1 << leftShift;
                int mask1 = ~mask;
                for (int y = 0; y < rectHeight; ++y) {
                    int bOffset = bitOffset;
                    int xRemaining = rectWidth;
                    int x = 0;
                    while (x < rectWidth) {
                        int i = eltOffset + (bOffset >> 5);
                        int mod = bOffset & 0x1F;
                        int datum = binaryDataArray[b++] & 0xFF;
                        if (mod <= 24) {
                            int shift = 24 - mod;
                            if (xRemaining < 8) {
                                datum &= 255 << 8 - xRemaining;
                            }
                            data[i] = data[i] & ~(255 << shift) | datum << shift;
                        } else if (xRemaining > leftShift32) {
                            data[i] = data[i] & mask | datum >>> rightShift;
                            data[++i] = datum << leftShift;
                        } else if (xRemaining > leftShift) {
                            data[i] = data[i] & mask | datum >>> rightShift;
                            data[++i] = data[i] & mask1 | datum << leftShift;
                        } else {
                            int remainMask = (1 << leftShift - xRemaining) - 1;
                            data[i] = data[i] & (mask | remainMask) | datum >>> rightShift & ~remainMask;
                        }
                        x += 8;
                        bOffset += 8;
                        xRemaining -= 8;
                    }
                    eltOffset += lineStride;
                }
                break block36;
            }
            short[] data = dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getData() : ((DataBufferUShort)dataBuffer).getData();
            int rightShift = bitOffset & 7;
            int leftShift = 8 - rightShift;
            int leftShift16 = 16 + leftShift;
            short mask = (short)(~(255 << leftShift));
            short mask1 = (short)(65535 << leftShift);
            short mask2 = ~mask1;
            for (int y = 0; y < rectHeight; ++y) {
                int bOffset = bitOffset;
                int xRemaining = rectWidth;
                int x = 0;
                while (x < rectWidth) {
                    int i = eltOffset + (bOffset >> 4);
                    int mod = bOffset & 0xF;
                    int datum = binaryDataArray[b++] & 0xFF;
                    if (mod <= 8) {
                        if (xRemaining < 8) {
                            datum &= 255 << 8 - xRemaining;
                        }
                        data[i] = (short)(data[i] & mask | datum << leftShift);
                    } else if (xRemaining > leftShift16) {
                        data[i] = (short)(data[i] & mask1 | datum >>> rightShift & 0xFFFF);
                        data[++i] = (short)(datum << leftShift & 0xFFFF);
                    } else if (xRemaining > leftShift) {
                        data[i] = (short)(data[i] & mask1 | datum >>> rightShift & 0xFFFF);
                        data[++i] = (short)(data[i] & mask2 | datum << leftShift & 0xFFFF);
                    } else {
                        int remainMask = (1 << leftShift - xRemaining) - 1;
                        data[i] = (short)(data[i] & (mask1 | remainMask) | datum >>> rightShift & 0xFFFF & ~remainMask);
                    }
                    x += 8;
                    bOffset += 8;
                    xRemaining -= 8;
                }
                eltOffset += lineStride;
            }
        }
    }

    public static final ImageTypeSpecifier getDestinationType(ImageReadParam param, Iterator<ImageTypeSpecifier> imageTypes) throws IIOException {
        if (imageTypes != null && imageTypes.hasNext()) {
            ImageTypeSpecifier imageType = null;
            if (param != null) {
                imageType = param.getDestinationType();
            }
            if (imageType == null) {
                ImageTypeSpecifier o = imageTypes.next();
                if (!(o instanceof ImageTypeSpecifier)) {
                    throw new IllegalArgumentException("Non-ImageTypeSpecifier retrieved from imageTypes!");
                }
                imageType = o;
            } else {
                boolean foundIt = false;
                while (imageTypes.hasNext()) {
                    ImageTypeSpecifier type = imageTypes.next();
                    if (!type.equals(imageType)) continue;
                    foundIt = true;
                    break;
                }
                if (!foundIt) {
                    throw new IIOException("Destination type from ImageReadParam does not match!");
                }
            }
            return imageType;
        }
        throw new IllegalArgumentException("imageTypes null or empty!");
    }

    public static boolean isNonStandardICCColorSpace(ColorSpace cs) {
        boolean retval = false;
        try {
            retval = cs instanceof ICC_ColorSpace && !cs.isCS_sRGB() && !cs.equals(ColorSpace.getInstance(1004)) && !cs.equals(ColorSpace.getInstance(1003)) && !cs.equals(ColorSpace.getInstance(1001)) && !cs.equals(ColorSpace.getInstance(1002));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return retval;
    }

    public static void canEncodeImage(ImageWriter writer, ImageTypeSpecifier type) throws IIOException {
        ImageWriterSpi spi = writer.getOriginatingProvider();
        if (type != null && spi != null && !spi.canEncodeImage(type)) {
            throw new IIOException(String.format("Writer %s cannot encode images of type %s", spi.getDescription(Locale.getDefault()), type));
        }
    }

    public static long getTileSize(SampleModel sm) {
        int elementSize = DataBuffer.getDataTypeSize(sm.getDataType());
        if (sm instanceof MultiPixelPackedSampleModel) {
            MultiPixelPackedSampleModel mppsm = (MultiPixelPackedSampleModel)sm;
            return (mppsm.getScanlineStride() * mppsm.getHeight() + (mppsm.getDataBitOffset() + elementSize - 1) / elementSize) * ((elementSize + 7) / 8);
        }
        if (sm instanceof ComponentSampleModel) {
            ComponentSampleModel csm = (ComponentSampleModel)sm;
            int[] bandOffsets = csm.getBandOffsets();
            int maxBandOff = bandOffsets[0];
            for (int i = 1; i < bandOffsets.length; ++i) {
                maxBandOff = Math.max(maxBandOff, bandOffsets[i]);
            }
            long size = 0L;
            int pixelStride = csm.getPixelStride();
            int scanlineStride = csm.getScanlineStride();
            if (maxBandOff >= 0) {
                size += (long)(maxBandOff + 1);
            }
            if (pixelStride > 0) {
                size += (long)(pixelStride * (sm.getWidth() - 1));
            }
            if (scanlineStride > 0) {
                size += (long)(scanlineStride * (sm.getHeight() - 1));
            }
            int[] bankIndices = csm.getBankIndices();
            maxBandOff = bankIndices[0];
            for (int i = 1; i < bankIndices.length; ++i) {
                maxBandOff = Math.max(maxBandOff, bankIndices[i]);
            }
            return size * (long)(maxBandOff + 1) * (long)((elementSize + 7) / 8);
        }
        if (sm instanceof SinglePixelPackedSampleModel) {
            SinglePixelPackedSampleModel sppsm = (SinglePixelPackedSampleModel)sm;
            long size = sppsm.getScanlineStride() * (sppsm.getHeight() - 1) + sppsm.getWidth();
            return size * (long)((elementSize + 7) / 8);
        }
        return 0L;
    }

    public static long getBandSize(SampleModel sm) {
        int elementSize = DataBuffer.getDataTypeSize(sm.getDataType());
        if (sm instanceof ComponentSampleModel) {
            ComponentSampleModel csm = (ComponentSampleModel)sm;
            int pixelStride = csm.getPixelStride();
            int scanlineStride = csm.getScanlineStride();
            long size = Math.min(pixelStride, scanlineStride);
            if (pixelStride > 0) {
                size += (long)(pixelStride * (sm.getWidth() - 1));
            }
            if (scanlineStride > 0) {
                size += (long)(scanlineStride * (sm.getHeight() - 1));
            }
            return size * (long)((elementSize + 7) / 8);
        }
        return ImageIOUtilities.getTileSize(sm);
    }
}

