/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.exif;

import it.geosolutions.imageio.plugins.exif.EXIFMetadata;
import it.geosolutions.imageio.plugins.exif.EXIFTags;
import it.geosolutions.imageio.plugins.exif.TIFFTagWrapper;
import it.geosolutions.imageio.stream.AccessibleStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.io.FileUtils;

public class EXIFUtilities {
    public static final int TAG_COPYRIGHT = 33432;
    public static final int TAG_EXIF_IFD_POINTER = 34665;
    public static final int TAG_USER_COMMENT = 37510;
    static final int DEFAULT_BUFFER_SIZE = 4096;
    static final int EXIF_SCAN_BUFFER_SIZE = 32768;
    static final byte _0 = 0;
    static final byte FF = -1;
    static final byte[] EXIF_MARKER = new byte[]{69, 120, 105, 102, 0, 0};
    static final byte[] NEXT_IFD = new byte[]{0, 0, 0, 0};
    static final byte[] TIFF_HEADER = new byte[]{77, 77, 0, 42, 0, 0, 0, 8};
    static final int TIFF_HEADER_LENGTH = TIFF_HEADER.length;
    static final byte[] USER_COMMENT_ASCII_CHAR_CODE = new byte[]{65, 83, 67, 73, 73, 0, 0, 0};
    static final byte[] APP1_MARKER = new byte[]{-1, -31};
    static final byte[] DQT_MARKER = new byte[]{-1, -37};
    static final int BYTES_FOR_TAGS_NUMBER = 2;
    static final byte[] NULL_STRING = new byte[]{0};
    static final int IFD_LENGTH = 12;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateStream(OutputStream outputStream, ImageInputStream inputStream, EXIFMetadata exif, int previousEXIFLength) throws IOException {
        ByteArrayOutputStream baos = null;
        FilterOutputStream bos = null;
        try {
            baos = EXIFUtilities.initializeExifStream(exif, null);
            bos = new BufferedOutputStream(outputStream, 4096);
            EXIFUtilities.updateFromStream(bos, baos, inputStream, previousEXIFLength);
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (Throwable throwable) {}
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static void insertEXIFintoStream(OutputStream outputStream, byte[] imageData, int imageDataSize, EXIFMetadata exif) throws IOException {
        ByteArrayOutputStream baos = null;
        if (outputStream instanceof ByteArrayOutputStream) {
            baos = (ByteArrayOutputStream)outputStream;
            EXIFUtilities.writeToByteStream(baos, imageData, imageDataSize, exif);
        } else {
            EXIFUtilities.writeBuffered(outputStream, imageData, imageDataSize, exif);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeBuffered(OutputStream outputStream, byte[] imageData, int imageDataSize, EXIFMetadata exif) throws IOException {
        ByteArrayOutputStream baos = null;
        try {
            baos = EXIFUtilities.initializeExifStream(exif, null);
            EXIFUtilities.updateFromBytes(outputStream, baos, imageData, imageDataSize);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private static void writeToByteStream(ByteArrayOutputStream outputStream, byte[] imageData, int imageDataSize, EXIFMetadata exif) throws IOException {
        int dqtMarkerPos = EXIFUtilities.locateFirst(imageData, DQT_MARKER);
        if (dqtMarkerPos != -1) {
            outputStream.write(imageData, 0, dqtMarkerPos);
            outputStream.flush();
            outputStream = EXIFUtilities.initializeExifStream(exif, outputStream);
            outputStream.write(0);
            outputStream.write(imageData, dqtMarkerPos, imageDataSize - dqtMarkerPos);
        }
    }

    private static ByteArrayOutputStream initializeExifStream(EXIFMetadata exif, ByteArrayOutputStream outputStream) throws IOException {
        ByteArrayOutputStream baos = outputStream == null ? new ByteArrayOutputStream() : outputStream;
        List<TIFFTagWrapper> baselineTags = exif.getList(EXIFTags.Type.BASELINE);
        List<TIFFTagWrapper> exifTags = exif.getList(EXIFTags.Type.EXIF);
        int baseLength = TIFF_HEADER_LENGTH + 2 + NEXT_IFD.length;
        int numBaselineTags = baselineTags.size();
        int numExifTags = exifTags.size();
        byte[] numFieldsB = EXIFUtilities.intToBytes(numBaselineTags);
        byte[] numSpecificFieldsB = EXIFUtilities.intToBytes(numExifTags);
        int[] baseLineTagsOffsets = new int[numBaselineTags];
        int[] baseLineTagsContentSizes = new int[numBaselineTags];
        EXIFUtilities.computeOffsetsAndSizes(baselineTags, baseLength, baseLineTagsOffsets, baseLineTagsContentSizes);
        int baselineContentLength = EXIFUtilities.sum(baseLineTagsContentSizes);
        int[] exifTagsOffsets = new int[numExifTags];
        int[] exifTagsContentSizes = new int[numExifTags];
        EXIFUtilities.computeOffsetsAndSizes(exifTags, baseLineTagsOffsets[numBaselineTags - 1] + 2, exifTagsOffsets, exifTagsContentSizes);
        int exifTagsContentLength = EXIFUtilities.sum(exifTagsContentSizes);
        int app1Lenght = APP1_MARKER.length - 1 + EXIF_MARKER.length + baseLength + 2 + 2 + numBaselineTags * 12 + numExifTags * 12 + baselineContentLength + exifTagsContentLength;
        baos.write(APP1_MARKER);
        baos.write(EXIFUtilities.intToBytes(app1Lenght));
        baos.write(EXIF_MARKER);
        baos.write(TIFF_HEADER);
        baos.write(numFieldsB);
        EXIFUtilities.writeIFDs(baos, baselineTags);
        baos.write(NEXT_IFD);
        EXIFUtilities.writeTagsContent(baos, baselineTags);
        baos.write(numSpecificFieldsB);
        EXIFUtilities.writeIFDs(baos, exifTags);
        EXIFUtilities.writeTagsContent(baos, exifTags);
        baos.flush();
        return baos;
    }

    private static void updateFromStream(OutputStream outputStream, ByteArrayOutputStream byteStream, ImageInputStream inputStream, int originalAPP1MarkerLength) throws IOException {
        byte[] buffer = new byte[4096];
        int readlength = 0;
        boolean replacedExif = false;
        while ((readlength = inputStream.read(buffer)) != -1) {
            int app1MarkerPos;
            int n = app1MarkerPos = replacedExif ? -1 : EXIFUtilities.locateFirst(buffer, APP1_MARKER);
            if (app1MarkerPos != -1) {
                replacedExif = true;
                outputStream.write(buffer, 0, app1MarkerPos);
                outputStream.write(byteStream.toByteArray());
                outputStream.write(0);
                outputStream.write(buffer, app1MarkerPos + originalAPP1MarkerLength + 2, readlength - (app1MarkerPos + originalAPP1MarkerLength + 2));
                continue;
            }
            outputStream.write(buffer, 0, readlength);
        }
    }

    private static void updateFromBytes(OutputStream outputStream, ByteArrayOutputStream byteStream, byte[] imageData, int imageDataSize) throws IOException {
        int dqtMarkerPos = EXIFUtilities.locateFirst(imageData, DQT_MARKER);
        if (dqtMarkerPos != -1) {
            outputStream.write(imageData, 0, dqtMarkerPos);
            outputStream.write(byteStream.toByteArray());
            outputStream.write(0);
            outputStream.write(imageData, dqtMarkerPos, imageDataSize - dqtMarkerPos);
            outputStream.flush();
        }
    }

    private static void writeIFDs(ByteArrayOutputStream stream, List<TIFFTagWrapper> tags) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Null stream has been provided");
        }
        for (TIFFTagWrapper tag : tags) {
            stream.write(EXIFUtilities.tagAsBytes(tag, true));
        }
    }

    private static void writeTagsContent(ByteArrayOutputStream stream, List<TIFFTagWrapper> tags) throws IOException {
        for (TIFFTagWrapper tag : tags) {
            if (tag.getContent() == null) continue;
            if (tag.getPrefix() != null) {
                stream.write(tag.getPrefix());
            }
            stream.write((byte[])tag.getContent());
            if (tag.getSuffix() == null) continue;
            stream.write(tag.getSuffix());
        }
    }

    static final int sum(int[] values) {
        int sum = 0;
        for (int s : values) {
            sum += s;
        }
        return sum;
    }

    private static void computeOffsetsAndSizes(List<TIFFTagWrapper> tags, int baseOffset, int[] valueOffsets, int[] sizes) {
        int elementsSize = tags.size();
        int i = 0;
        int previousOffset = 0;
        for (TIFFTagWrapper tag : tags) {
            valueOffsets[i] = baseOffset + elementsSize * 12 + previousOffset;
            if (tag.getNumber() == 34665) {
                tag.setValue(valueOffsets[i]);
            } else if (tag.getContent() != null) {
                tag.setValue(valueOffsets[i]);
                previousOffset += tag.getCount();
                sizes[i] = tag.getCount();
            } else {
                sizes[i] = 0;
            }
            ++i;
        }
    }

    public static final byte[] intToBytes(int value, boolean isBigEndian) {
        if (isBigEndian) {
            return new byte[]{(byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
        }
        return new byte[]{(byte)(value & 0xFF), (byte)(value >> 8 & 0xFF)};
    }

    public static final byte[] intToBytes(int value) {
        return EXIFUtilities.intToBytes(value, true);
    }

    public static final int bytes2ToInt(byte[] buff, int start, boolean isBigEndian) {
        int intValue = 0;
        intValue |= buff[start + (isBigEndian ? 0 : 1)] & 0xFF;
        intValue <<= 8;
        return intValue |= buff[start + (isBigEndian ? 1 : 0)] & 0xFF;
    }

    public static final int bytes4ToInt(byte[] buff, int start, boolean isBigEndian) {
        int intValue = 0;
        intValue |= buff[start + (isBigEndian ? 0 : 3)] & 0xFF;
        intValue <<= 8;
        intValue |= buff[start + (isBigEndian ? 1 : 2)] & 0xFF;
        intValue <<= 8;
        intValue |= buff[start + (isBigEndian ? 2 : 1)] & 0xFF;
        intValue <<= 8;
        return intValue |= buff[start + (isBigEndian ? 3 : 0)] & 0xFF;
    }

    private static byte[] tagAsBytes(TIFFTagWrapper tag, boolean isBigEndian) {
        byte[] output = new byte[12];
        int number = tag.getNumber();
        int type = tag.getType();
        int count = tag.getCount();
        int offset = tag.getValue();
        output[isBigEndian ? 1 : 0] = (byte)(number & 0xFF);
        output[isBigEndian ? 0 : 1] = (byte)(number >> 8 & 0xFF);
        output[isBigEndian ? 3 : 2] = (byte)(type & 0xFF);
        output[isBigEndian ? 2 : 3] = (byte)(type >> 8 & 0xFF);
        output[isBigEndian ? 7 : 4] = (byte)(count & 0xFF);
        output[isBigEndian ? 6 : 5] = (byte)(count >> 8 & 0xFF);
        output[isBigEndian ? 5 : 6] = (byte)(count >> 16 & 0xFF);
        output[isBigEndian ? 4 : 7] = (byte)(count >> 24 & 0xFF);
        output[isBigEndian ? 11 : 8] = (byte)(offset & 0xFF);
        output[isBigEndian ? 10 : 9] = (byte)(offset >> 8 & 0xFF);
        output[isBigEndian ? 9 : 10] = (byte)(offset >> 16 & 0xFF);
        output[isBigEndian ? 8 : 11] = (byte)(offset >> 24 & 0xFF);
        return output;
    }

    public static int locateFirst(byte[] buffer, byte[] candidate) {
        if (EXIFUtilities.IsEmptyLocate(buffer, candidate)) {
            return -1;
        }
        for (int i = 0; i < buffer.length; ++i) {
            if (!EXIFUtilities.IsMatch(buffer, i, candidate)) continue;
            return i;
        }
        return -1;
    }

    static final boolean IsMatch(byte[] buffer, int start, byte[] candidate) {
        if (candidate.length > buffer.length - start) {
            return false;
        }
        for (int i = 0; i < candidate.length; ++i) {
            if (buffer[start + i] == candidate[i]) continue;
            return false;
        }
        return true;
    }

    static boolean IsEmptyLocate(byte[] toBeScan, byte[] candidate) {
        return toBeScan == null || candidate == null || toBeScan.length == 0 || candidate.length == 0 || candidate.length > toBeScan.length;
    }

    public static void replaceEXIFs(ImageInputStream inputStream, EXIFMetadata exif) throws IOException {
        EXIFMetadataWrapper exifMarker = EXIFUtilities.parseExifMetadata(inputStream, exif);
        EXIFMetadata updatedExif = exifMarker.getExif();
        int app1Length = exifMarker.getLength();
        if (updatedExif != null) {
            File file = File.createTempFile("replacingExif", ".exif");
            FileOutputStream fos = new FileOutputStream(file);
            EXIFUtilities.updateStream(fos, inputStream, updatedExif, app1Length);
            File previousFile = (File)((AccessibleStream)inputStream).getTarget();
            FileUtils.deleteQuietly((File)previousFile);
            FileUtils.moveFile((File)file, (File)previousFile);
        }
    }

    private static EXIFMetadataWrapper parseExifMetadata(ImageInputStream inputStream, EXIFMetadata exif) throws IOException {
        List<TIFFTagWrapper> baselineTags = null;
        List<TIFFTagWrapper> exifTags = null;
        int app1Length = -1;
        if (exif != null) {
            baselineTags = exif.getList(EXIFTags.Type.BASELINE);
            exifTags = exif.getList(EXIFTags.Type.EXIF);
        }
        inputStream.mark();
        TreeMap<Integer, TIFFTagWrapper> foundBaseLineTags = new TreeMap<Integer, TIFFTagWrapper>();
        TreeMap<Integer, TIFFTagWrapper> foundExifTags = new TreeMap<Integer, TIFFTagWrapper>();
        EXIFMetadata updatedExif = null;
        byte[] buff = new byte[32768];
        boolean contains_EXIF_IFD = false;
        boolean found = false;
        while (inputStream.read(buff) != -1) {
            int exifTagPos = found ? -1 : EXIFUtilities.locateFirst(buff, APP1_MARKER);
            int pos = 0;
            if (exifTagPos == -1) continue;
            found = true;
            pos = exifTagPos;
            app1Length = EXIFUtilities.bytes2ToInt(buff, pos + APP1_MARKER.length, true);
            boolean isBigEndian = buff[pos + APP1_MARKER.length + 2 + EXIF_MARKER.length] == 77 && buff[pos + APP1_MARKER.length + 2 + 1 + EXIF_MARKER.length] == 77;
            int numBaselineTags = EXIFUtilities.bytes2ToInt(buff, pos + APP1_MARKER.length + 2 + EXIF_MARKER.length + TIFF_HEADER.length, isBigEndian);
            int skip = 0;
            int start = pos + APP1_MARKER.length + 2 + EXIF_MARKER.length;
            int globalContentLength = 0;
            for (int i = 0; i < numBaselineTags; ++i) {
                skip = start + TIFF_HEADER.length + 2 + i * 12;
                int number = EXIFUtilities.bytes2ToInt(buff, skip, isBigEndian);
                int type = EXIFUtilities.bytes2ToInt(buff, skip + 2, isBigEndian);
                int count = EXIFUtilities.bytes4ToInt(buff, skip + 4, isBigEndian);
                int offsetValue = EXIFUtilities.bytes4ToInt(buff, skip + 8, isBigEndian);
                byte[] content = null;
                if (number == 34665) {
                    contains_EXIF_IFD = true;
                }
                if (type == 2 || type == 7) {
                    content = new byte[count];
                    System.arraycopy(buff, offsetValue + start, content, 0, count);
                    globalContentLength += count;
                }
                TIFFTagWrapper updatedTag = null;
                for (TIFFTagWrapper tag : baselineTags) {
                    if (tag.getNumber() != number) continue;
                    updatedTag = tag;
                    break;
                }
                if (updatedTag == null) {
                    updatedTag = new TIFFTagWrapper(number, type, content, offsetValue, count, null, null);
                }
                foundBaseLineTags.put(number, updatedTag);
            }
            if (contains_EXIF_IFD) {
                start = skip + globalContentLength + 12 + 4;
                int numExifFields = EXIFUtilities.bytes2ToInt(buff, start, isBigEndian);
                for (int i = 0; i < numExifFields; ++i) {
                    skip = start + 2 + i * 12;
                    int number = EXIFUtilities.bytes2ToInt(buff, skip, isBigEndian);
                    int type = EXIFUtilities.bytes2ToInt(buff, skip + 2, isBigEndian);
                    int count = EXIFUtilities.bytes4ToInt(buff, skip + 4, isBigEndian);
                    int offsetValue = EXIFUtilities.bytes4ToInt(buff, skip + 8, isBigEndian);
                    byte[] content = null;
                    if (type == 2 || type == 7) {
                        content = new byte[count];
                        System.arraycopy(buff, offsetValue + start, content, 0, count);
                        globalContentLength += count;
                    }
                    TIFFTagWrapper updatedTag = null;
                    for (TIFFTagWrapper tag : exifTags) {
                        if (tag.getNumber() != number) continue;
                        updatedTag = tag;
                        break;
                    }
                    if (updatedTag == null) {
                        updatedTag = new TIFFTagWrapper(number, type, content, offsetValue, count, null, null);
                    }
                    foundExifTags.put(number, updatedTag);
                }
            }
            ArrayList<TIFFTagWrapper> mergedBaselineTags = null;
            ArrayList mergedExifTags = null;
            if (!foundBaseLineTags.isEmpty()) {
                mergedBaselineTags = new ArrayList<TIFFTagWrapper>(foundBaseLineTags.values());
            }
            if (!foundExifTags.isEmpty()) {
                mergedExifTags = new ArrayList(foundExifTags.values());
            }
            updatedExif = new EXIFMetadata(mergedBaselineTags, mergedExifTags);
        }
        inputStream.reset();
        return new EXIFMetadataWrapper(updatedExif, app1Length);
    }

    public static TIFFTagWrapper createTag(int tagNumber) {
        switch (tagNumber) {
            case 37510: {
                return new TIFFTagWrapper(37510, 7, null, -1, 0, USER_COMMENT_ASCII_CHAR_CODE, null);
            }
            case 33432: {
                return new TIFFTagWrapper(33432, 2, null, 0, 0, null, NULL_STRING);
            }
            case 34665: {
                return new TIFFTagWrapper(34665, 4, null, -1, 1);
            }
        }
        return null;
    }

    static class EXIFMetadataWrapper {
        EXIFMetadata exif;
        int length;

        public EXIFMetadata getExif() {
            return this.exif;
        }

        public void setExif(EXIFMetadata exif) {
            this.exif = exif;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public EXIFMetadataWrapper(EXIFMetadata exif, int length) {
            this.exif = exif;
            this.length = length;
        }
    }

    public static enum EXIFTagType {
        BASELINE,
        EXIF;

    }
}

